/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pkcs11;

import com.ibm.pkcs11.PKCS11;
import com.ibm.pkcs11.PKCS11Exception;
import com.ibm.pkcs11.PKCS11Session;
import java.math.BigInteger;
import java.util.Date;

public abstract class PKCS11Object {
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Integer;
    static final String[] pinflagNames;
    private static final int[] pinflagList;
    private static final String[] keytypeNames;
    private static final Integer[] keytypeList;
    private static final Class[] attrValueClasses;
    private static final String[] attrtypeNames;
    private static final int[] attrtypeList;
    private static final String[] objclassNames;
    public static final Boolean FALSE;
    public static final Boolean TRUE;
    public static final Integer X_509_ATTR_CERT;
    public static final Integer X_509;
    public static final Integer CDMF;
    public static final Integer JUNIPER;
    public static final Integer BATON;
    public static final Integer SKIPJACK;
    public static final Integer IDEA;
    public static final Integer RC5;
    public static final Integer CAST128;
    public static final Integer CAST5;
    public static final Integer CAST3;
    public static final Integer CAST;
    public static final Integer DES3;
    public static final Integer DES2;
    public static final Integer DES;
    public static final Integer RC4;
    public static final Integer RC2;
    public static final Integer GENERIC_SECRET;
    public static final Integer KEA;
    public static final Integer MAYFLY;
    public static final Integer ECDSA;
    public static final Integer DH;
    public static final Integer DSA;
    public static final Integer RSA;
    public static final Integer CLOCK;
    public static final Integer MONOTONIC_COUNTER;
    public static final Integer HW_FEATURE;
    public static final Integer SECRET_KEY;
    public static final Integer PRIVATE_KEY;
    public static final Integer PUBLIC_KEY;
    public static final Integer CERTIFICATE;
    public static final Integer DATA;
    public static final int INVALID = -1;
    public static final int VENDOR_DEFINED = Integer.MIN_VALUE;
    public static final int HAS_RESET = 770;
    public static final int RESET_ON_INIT = 769;
    public static final int HW_FEATURE_TYPE = 768;
    public static final int AUTH_PIN_FLAGS = 513;
    public static final int SECONDARY_AUTH = 512;
    public static final int EC_POINT = 385;
    public static final int ECDSA_PARAMS = 384;
    public static final int MODIFIABLE = 368;
    public static final int ALWAYS_SENSITIVE = 357;
    public static final int NEVER_EXTRACTABLE = 356;
    public static final int LOCAL = 355;
    public static final int EXTRACTABLE = 354;
    public static final int VALUE_LEN = 353;
    public static final int VALUE_BITS = 352;
    public static final int BASE = 306;
    public static final int SUBPRIME = 305;
    public static final int PRIME = 304;
    public static final int COEFFICIENT = 296;
    public static final int EXPONENT_2 = 295;
    public static final int EXPONENT_1 = 294;
    public static final int PRIME_2 = 293;
    public static final int PRIME_1 = 292;
    public static final int PRIVATE_EXPONENT = 291;
    public static final int PUBLIC_EXPONENT = 290;
    public static final int MODULUS_BITS = 289;
    public static final int MODULUS = 288;
    public static final int END_DATE = 273;
    public static final int START_DATE = 272;
    public static final int DERIVE = 268;
    public static final int VERIFY_RECOVER = 267;
    public static final int VERIFY = 266;
    public static final int SIGN_RECOVER = 265;
    public static final int SIGN = 264;
    public static final int UNWRAP = 263;
    public static final int WRAP = 262;
    public static final int DECRYPT = 261;
    public static final int ENCRYPT = 260;
    public static final int SENSITIVE = 259;
    public static final int ID = 258;
    public static final int SUBJECT = 257;
    public static final int KEY_TYPE = 256;
    public static final int ATTR_TYPES = 133;
    public static final int OWNER = 132;
    public static final int AC_ISSUER = 131;
    public static final int SERIAL_NUMBER = 130;
    public static final int ISSUER = 129;
    public static final int CERTIFICATE_TYPE = 128;
    public static final int OBJECT_ID = 18;
    public static final int VALUE = 17;
    public static final int APPLICATION = 16;
    public static final int LABEL = 3;
    public static final int PRIVATE = 2;
    public static final int TOKEN = 1;
    public static final int CLASS = 0;

    public static Class valueClass(int n2) {
        int n3 = 0;
        while (n3 < attrtypeList.length) {
            if (attrtypeList[n3] == n2) {
                return attrValueClasses[n3];
            }
            ++n3;
        }
        return null;
    }

    public static String typeToString(int n2) {
        int n3 = 0;
        while (n3 < attrtypeList.length) {
            if (attrtypeList[n3] == n2) {
                return attrtypeNames[n3];
            }
            ++n3;
        }
        return "0x" + Integer.toString(n2, 16);
    }

    public String toString() {
        int n2;
        StringBuffer stringBuffer = new StringBuffer(512);
        String string = "                    ";
        stringBuffer.append("object:\n");
        int n3 = 0;
        while (n3 < attrtypeList.length) {
            String string2;
            String string3;
            block6: {
                n2 = attrtypeList[n3];
                string3 = PKCS11Object.typeToString(n2);
                string2 = null;
                try {
                    Object object = this.getAttributeValue(n2);
                    string2 = PKCS11Object.attrToString(n2, object);
                }
                catch (PKCS11Exception pKCS11Exception) {
                    if (pKCS11Exception.getCode() != 17) break block6;
                    string2 = "(ATTRIBUTE_SENSITIVE)";
                }
            }
            if (string2 != null) {
                stringBuffer.append("\t").append(string3).append(":");
                stringBuffer.append(string.substring(string3.length()));
                stringBuffer.append(string2).append("\n");
            }
            ++n3;
        }
        try {
            n2 = this.size();
            stringBuffer.append("\tSIZE:").append(string.substring(4)).append(n2).append("\n");
        }
        catch (PKCS11Exception pKCS11Exception) {}
        return stringBuffer.toString();
    }

    public abstract int size() throws PKCS11Exception;

    public void setIntAttributeValue(int n2, int n3) throws PKCS11Exception {
        if (PKCS11Object.valueClass(n2) != (class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = PKCS11Object.class$("java.lang.Integer")))) {
            throw new PKCS11Exception(18);
        }
        this.setAttributeValue(n2, new Integer(n3));
    }

    public void setBoolAttributeValue(int n2, boolean bl) throws PKCS11Exception {
        if (PKCS11Object.valueClass(n2) != (class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = PKCS11Object.class$("java.lang.Boolean")))) {
            throw new PKCS11Exception(18);
        }
        this.setAttributeValue(n2, new Boolean(bl));
    }

    public abstract void setAttributeValues(int[] var1, Object[] var2) throws PKCS11Exception;

    public abstract void setAttributeValue(int var1, Object var2) throws PKCS11Exception;

    public static String pinflagsToString(Integer n2) {
        return PKCS11.flagsToString(n2, pinflagList, pinflagNames, " | ");
    }

    public static void main(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append("  * <TABLE BORDER RULES=ALL CELLPADDING=3>\n");
        stringBuffer.append("  * <TR> <TH> attribute type     <TH> object type\n");
        int n2 = 0;
        while (n2 < attrtypeList.length) {
            String string = attrValueClasses[n2].getName();
            string = string.endsWith("[B") ? "byte[]" : string.substring(string.lastIndexOf(46) + 1);
            stringBuffer.append("  * <TR> <TD> <TT>").append(attrtypeNames[n2]);
            stringBuffer.append("</TT> <TD> <TT>").append(string).append("</TT>\n");
            ++n2;
        }
        stringBuffer.append("  * </TABLE> <P>\n");
        System.out.println(stringBuffer.toString());
    }

    public static String keyToString(Integer n2) {
        int n3 = n2;
        int n4 = 0;
        while (n4 < keytypeList.length) {
            if (keytypeList[n4] == n3) {
                return keytypeNames[n4];
            }
            ++n4;
        }
        return "0x" + Integer.toHexString(n3);
    }

    public static String hwfeatureToString(Integer n2) {
        if (n2.equals(MONOTONIC_COUNTER)) {
            return "MONOTONIC_COUNTER";
        }
        if (n2.equals(CLOCK)) {
            return "CLOCK";
        }
        return "0x" + Integer.toHexString(n2);
    }

    public String getStringAttributeValue(int n2) throws PKCS11Exception {
        if (PKCS11Object.valueClass(n2) != (class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = PKCS11Object.class$("java.lang.String")))) {
            throw new PKCS11Exception(18);
        }
        return (String)this.getAttributeValue(n2);
    }

    public abstract PKCS11Session getSession() throws PKCS11Exception;

    public int getIntAttributeValue(int n2) throws PKCS11Exception {
        if (PKCS11Object.valueClass(n2) != (class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = PKCS11Object.class$("java.lang.Integer")))) {
            throw new PKCS11Exception(18);
        }
        return (Integer)this.getAttributeValue(n2);
    }

    public Date getDateAttributeValue(int n2) throws PKCS11Exception {
        if (PKCS11Object.valueClass(n2) != (class$java$util$Date != null ? class$java$util$Date : (class$java$util$Date = PKCS11Object.class$("java.util.Date")))) {
            throw new PKCS11Exception(18);
        }
        return (Date)this.getAttributeValue(n2);
    }

    public byte[] getByteArrayAttributeValue(int n2) throws PKCS11Exception {
        if (PKCS11Object.valueClass(n2) != (array$B != null ? array$B : (array$B = PKCS11Object.class$("[B")))) {
            throw new PKCS11Exception(18);
        }
        return (byte[])this.getAttributeValue(n2);
    }

    public boolean getBoolAttributeValue(int n2) throws PKCS11Exception {
        if (PKCS11Object.valueClass(n2) != (class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = PKCS11Object.class$("java.lang.Boolean")))) {
            throw new PKCS11Exception(18);
        }
        return (Boolean)this.getAttributeValue(n2);
    }

    public BigInteger getBigIntegerAttributeValue(int n2) throws PKCS11Exception {
        if (PKCS11Object.valueClass(n2) != (class$java$math$BigInteger != null ? class$java$math$BigInteger : (class$java$math$BigInteger = PKCS11Object.class$("java.math.BigInteger")))) {
            throw new PKCS11Exception(18);
        }
        return (BigInteger)this.getAttributeValue(n2);
    }

    public Object[] getAttributeValues(int[] nArray) throws PKCS11Exception {
        Object[] objectArray = new Object[nArray.length];
        int n2 = 0;
        while (n2 < nArray.length) {
            objectArray[n2] = this.getAttributeValue(nArray[n2]);
            ++n2;
        }
        return objectArray;
    }

    public abstract Object getAttributeValue(int var1) throws PKCS11Exception;

    public abstract void destroy() throws PKCS11Exception;

    public abstract PKCS11Object copy(int[] var1, Object[] var2) throws PKCS11Exception;

    public static String classToString(Integer n2) {
        int n3 = n2;
        if (n3 >= 0 && n3 < objclassNames.length) {
            return objclassNames[n3];
        }
        return "0x" + Integer.toString(n3, 16);
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static String certToString(Integer n2) {
        if (n2.equals(X_509)) {
            return "X_509";
        }
        if (n2.equals(X_509_ATTR_CERT)) {
            return "X_509_ATTR_CERT";
        }
        return "0x" + Integer.toHexString(n2);
    }

    public static String bytesToString(byte[] byArray, int n2) {
        if (byArray == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer(256);
        int n3 = 0;
        int n4 = 0;
        while (n4 < byArray.length) {
            if (n2 != 0 && n4 > n2) {
                stringBuffer.append(" ... (").append(byArray.length).append(" bytes)");
                break;
            }
            if (n3 == 16) {
                stringBuffer.append('\n');
                n3 = 0;
            }
            if (n3 > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append("0123456789abcdef".charAt(byArray[n4] >> 4 & 0xF));
            stringBuffer.append("0123456789abcdef".charAt(byArray[n4] & 0xF));
            ++n4;
            ++n3;
        }
        return stringBuffer.toString();
    }

    public static String attrToString(int n2, Object object) {
        if (object == null) {
            return "null";
        }
        switch (n2) {
            case 0: {
                return PKCS11Object.classToString((Integer)object);
            }
            case 256: {
                return PKCS11Object.keyToString((Integer)object);
            }
            case 128: {
                return PKCS11Object.certToString((Integer)object);
            }
            case 513: {
                return PKCS11Object.pinflagsToString((Integer)object);
            }
            case 768: {
                return PKCS11Object.hwfeatureToString((Integer)object);
            }
            case 17: 
            case 18: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 257: 
            case 258: {
                return PKCS11Object.bytesToString((byte[])object, 10);
            }
            case 288: 
            case 290: 
            case 291: 
            case 292: 
            case 293: 
            case 294: 
            case 295: 
            case 296: 
            case 304: 
            case 305: 
            case 306: {
                return "0x" + ((BigInteger)object).toString(16);
            }
        }
        return object.toString();
    }

    protected PKCS11Object() {
    }

    static {
        DATA = new Integer(0);
        CERTIFICATE = new Integer(1);
        PUBLIC_KEY = new Integer(2);
        PRIVATE_KEY = new Integer(3);
        SECRET_KEY = new Integer(4);
        HW_FEATURE = new Integer(5);
        MONOTONIC_COUNTER = new Integer(1);
        CLOCK = new Integer(2);
        RSA = new Integer(0);
        DSA = new Integer(1);
        DH = new Integer(2);
        ECDSA = new Integer(3);
        MAYFLY = new Integer(4);
        KEA = new Integer(5);
        GENERIC_SECRET = new Integer(16);
        RC2 = new Integer(17);
        RC4 = new Integer(18);
        DES = new Integer(19);
        DES2 = new Integer(20);
        DES3 = new Integer(21);
        CAST = new Integer(22);
        CAST3 = new Integer(23);
        CAST5 = new Integer(24);
        CAST128 = new Integer(24);
        RC5 = new Integer(25);
        IDEA = new Integer(26);
        SKIPJACK = new Integer(27);
        BATON = new Integer(28);
        JUNIPER = new Integer(29);
        CDMF = new Integer(30);
        X_509 = new Integer(0);
        X_509_ATTR_CERT = new Integer(1);
        TRUE = Boolean.TRUE;
        FALSE = Boolean.FALSE;
        objclassNames = new String[]{"DATA", "CERTIFICATE", "PUBLIC_KEY", "PRIVATE_KEY", "SECRET_KEY", "HW_FEATURE"};
        int[] nArray = new int[54];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 16;
        nArray[5] = 768;
        nArray[6] = 18;
        nArray[7] = 17;
        nArray[8] = 128;
        nArray[9] = 129;
        nArray[10] = 130;
        nArray[11] = 131;
        nArray[12] = 132;
        nArray[13] = 133;
        nArray[14] = 256;
        nArray[15] = 257;
        nArray[16] = 258;
        nArray[17] = 259;
        nArray[18] = 260;
        nArray[19] = 261;
        nArray[20] = 262;
        nArray[21] = 263;
        nArray[22] = 264;
        nArray[23] = 265;
        nArray[24] = 266;
        nArray[25] = 267;
        nArray[26] = 268;
        nArray[27] = 272;
        nArray[28] = 273;
        nArray[29] = 288;
        nArray[30] = 289;
        nArray[31] = 290;
        nArray[32] = 291;
        nArray[33] = 292;
        nArray[34] = 293;
        nArray[35] = 294;
        nArray[36] = 295;
        nArray[37] = 296;
        nArray[38] = 304;
        nArray[39] = 305;
        nArray[40] = 306;
        nArray[41] = 352;
        nArray[42] = 353;
        nArray[43] = 354;
        nArray[44] = 355;
        nArray[45] = 356;
        nArray[46] = 357;
        nArray[47] = 368;
        nArray[48] = 384;
        nArray[49] = 385;
        nArray[50] = 512;
        nArray[51] = 513;
        nArray[52] = 769;
        nArray[53] = 770;
        attrtypeList = nArray;
        attrtypeNames = new String[]{"CLASS", "TOKEN", "PRIVATE", "LABEL", "APPLICATION", "HW_FEATURE_TYPE", "OBJECT_ID", "VALUE", "CERTIFICATE_TYPE", "ISSUER", "SERIAL_NUMBER", "AC_ISSUER", "OWNER", "ATTR_TYPES", "KEY_TYPE", "SUBJECT", "ID", "SENSITIVE", "ENCRYPT", "DECRYPT", "WRAP", "UNWRAP", "SIGN", "SIGN_RECOVER", "VERIFY", "VERIFY_RECOVER", "DERIVE", "START_DATE", "END_DATE", "MODULUS", "MODULUS_BITS", "PUBLIC_EXPONENT", "PRIVATE_EXPONENT", "PRIME_1", "PRIME_2", "EXPONENT_1", "EXPONENT_2", "COEFFICIENT", "PRIME", "SUBPRIME", "BASE", "VALUE_BITS", "VALUE_LEN", "EXTRACTABLE", "LOCAL", "NEVER_EXTRACTABLE", "ALWAYS_SENSITIVE", "MODIFIABLE", "ECDSA_PARAMS", "EC_POINT", "SECONDARY_AUTH", "AUTH_PIN_FLAGS", "RESET_ON_INIT", "HAS_RESET"};
        attrValueClasses = new Class[]{class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = PKCS11Object.class$("java.lang.Integer")), class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = PKCS11Object.class$("java.lang.Boolean")), class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = PKCS11Object.class$("java.lang.Boolean")), class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = PKCS11Object.class$("java.lang.String")), class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = PKCS11Object.class$("java.lang.String")), class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = PKCS11Object.class$("java.lang.Integer")), array$B != null ? array$B : (array$B = PKCS11Object.class$("[B")), array$B != null ? array$B : (array$B = PKCS11Object.class$("[B")), class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = PKCS11Object.class$("java.lang.Integer")), array$B != null ? array$B : (array$B = PKCS11Object.class$("[B")), array$B != null ? array$B : (array$B = PKCS11Object.class$("[B")), array$B != null ? array$B : (array$B = PKCS11Object.class$("[B")), array$B != null ? array$B : (array$B = PKCS11Object.class$("[B")), array$B != null ? array$B : (array$B = PKCS11Object.class$("[B")), class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = PKCS11Object.class$("java.lang.Integer")), array$B != null ? array$B : (array$B = PKCS11Object.class$("[B")), array$B != null ? array$B : (array$B = PKCS11Object.class$("[B")), class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = PKCS11Object.class$("java.lang.Boolean")), class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = PKCS11Object.class$("java.lang.Boolean")), class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = PKCS11Object.class$("java.lang.Boolean")), class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = PKCS11Object.class$("java.lang.Boolean")), class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = PKCS11Object.class$("java.lang.Boolean")), class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = PKCS11Object.class$("java.lang.Boolean")), class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = PKCS11Object.class$("java.lang.Boolean")), class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = PKCS11Object.class$("java.lang.Boolean")), class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = PKCS11Object.class$("java.lang.Boolean")), class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = PKCS11Object.class$("java.lang.Boolean")), class$java$util$Date != null ? class$java$util$Date : (class$java$util$Date = PKCS11Object.class$("java.util.Date")), class$java$util$Date != null ? class$java$util$Date : (class$java$util$Date = PKCS11Object.class$("java.util.Date")), class$java$math$BigInteger != null ? class$java$math$BigInteger : (class$java$math$BigInteger = PKCS11Object.class$("java.math.BigInteger")), class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = PKCS11Object.class$("java.lang.Integer")), class$java$math$BigInteger != null ? class$java$math$BigInteger : (class$java$math$BigInteger = PKCS11Object.class$("java.math.BigInteger")), class$java$math$BigInteger != null ? class$java$math$BigInteger : (class$java$math$BigInteger = PKCS11Object.class$("java.math.BigInteger")), class$java$math$BigInteger != null ? class$java$math$BigInteger : (class$java$math$BigInteger = PKCS11Object.class$("java.math.BigInteger")), class$java$math$BigInteger != null ? class$java$math$BigInteger : (class$java$math$BigInteger = PKCS11Object.class$("java.math.BigInteger")), class$java$math$BigInteger != null ? class$java$math$BigInteger : (class$java$math$BigInteger = PKCS11Object.class$("java.math.BigInteger")), class$java$math$BigInteger != null ? class$java$math$BigInteger : (class$java$math$BigInteger = PKCS11Object.class$("java.math.BigInteger")), class$java$math$BigInteger != null ? class$java$math$BigInteger : (class$java$math$BigInteger = PKCS11Object.class$("java.math.BigInteger")), class$java$math$BigInteger != null ? class$java$math$BigInteger : (class$java$math$BigInteger = PKCS11Object.class$("java.math.BigInteger")), class$java$math$BigInteger != null ? class$java$math$BigInteger : (class$java$math$BigInteger = PKCS11Object.class$("java.math.BigInteger")), class$java$math$BigInteger != null ? class$java$math$BigInteger : (class$java$math$BigInteger = PKCS11Object.class$("java.math.BigInteger")), class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = PKCS11Object.class$("java.lang.Integer")), class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = PKCS11Object.class$("java.lang.Integer")), class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = PKCS11Object.class$("java.lang.Boolean")), class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = PKCS11Object.class$("java.lang.Boolean")), class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = PKCS11Object.class$("java.lang.Boolean")), class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = PKCS11Object.class$("java.lang.Boolean")), class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = PKCS11Object.class$("java.lang.Boolean")), array$B != null ? array$B : (array$B = PKCS11Object.class$("[B")), array$B != null ? array$B : (array$B = PKCS11Object.class$("[B")), class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = PKCS11Object.class$("java.lang.Boolean")), class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = PKCS11Object.class$("java.lang.Integer")), class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = PKCS11Object.class$("java.lang.Boolean")), class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = PKCS11Object.class$("java.lang.Boolean"))};
        keytypeList = new Integer[]{RSA, DSA, DH, ECDSA, MAYFLY, KEA, GENERIC_SECRET, RC2, RC4, DES, DES2, DES3, CAST, CAST3, CAST5, RC5, IDEA, SKIPJACK, BATON, JUNIPER, CDMF};
        keytypeNames = new String[]{"RSA", "DSA", "DH", "ECDSA", "MAYFLY", "KEA", "GENERIC_SECRET", "RC2", "RC4", "DES", "DES2", "DES3", "CAST", "CAST3", "CAST5", "RC5", "IDEA", "SKIPJACK", "BATON", "JUNIPER", "CDMF"};
        pinflagList = new int[]{65536, 131072, 262144, 524288};
        pinflagNames = new String[]{"USER_PIN_COUNT_LOW", "USER_PIN_FINAL_TRY", "USER_PIN_LOCKED", "USER_PIN_TO_BE_CHANGED"};
    }
}

