/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pkcs11;

import com.ibm.pkcs11.PKCS11;

public class PKCS11MechanismInfo {
    private int flags;
    private int maxKeySize;
    private int minKeySize;
    static final String[] flagNames;
    static final int[] flagList;
    public static final int EXTENSION = Integer.MIN_VALUE;
    public static final int DERIVE = 524288;
    public static final int UNWRAP = 262144;
    public static final int WRAP = 131072;
    public static final int GENERATE_KEY_PAIR = 65536;
    public static final int GENERATE = 32768;
    public static final int VERIFY_RECOVER = 16384;
    public static final int VERIFY = 8192;
    public static final int SIGN_RECOVER = 4096;
    public static final int SIGN = 2048;
    public static final int DIGEST = 1024;
    public static final int DECRYPT = 512;
    public static final int ENCRYPT = 256;
    public static final int HW = 1;

    public String toString() {
        return "minKeySize=" + this.minKeySize + ", maxKeySize=" + this.maxKeySize + ", flags=" + this.flagsToString("|");
    }

    public int minKeySize() {
        return this.minKeySize;
    }

    public int maxKeySize() {
        return this.maxKeySize;
    }

    public String flagsToString(String string) {
        return PKCS11.flagsToString(this.flags, flagList, flagNames, string);
    }

    public int flags() {
        return this.flags;
    }

    public PKCS11MechanismInfo(int n2, int n3, int n4) {
        this.minKeySize = n2;
        this.maxKeySize = n3;
        this.flags = n4;
    }

    static {
        flagList = new int[]{1, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768, 65536, 131072, 262144, 524288, Integer.MIN_VALUE};
        flagNames = new String[]{"HW", "ENCRYPT", "DECRYPT", "DIGEST", "SIGN", "SIGN_RECOVER", "VERIFY", "VERIFY_RECOVER", "GENERATE", "GENERATE_KEY_PAIR", "WRAP", "UNWRAP", "DERIVE", "EXTENSION"};
    }
}

