/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pkcs11;

import com.ibm.pkcs11.PKCS11Exception;
import com.ibm.pkcs11.PKCS11Info;
import com.ibm.pkcs11.PKCS11Slot;

public abstract class PKCS11 {
    public abstract PKCS11Slot waitForSlotEvent(boolean var1) throws PKCS11Exception;

    static String versionString(int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = n2 >> 8;
        int n4 = n2 & 0xFF;
        stringBuffer.append(n3);
        stringBuffer.append(".");
        stringBuffer.append(n4 / 10);
        if (n4 % 10 != 0) {
            stringBuffer.append(n4 % 10);
        }
        return stringBuffer.toString();
    }

    public String toString() {
        try {
            return this.getInfo().toString();
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new RuntimeException(pKCS11Exception.toString());
        }
    }

    public void libInitialize() throws PKCS11Exception {
    }

    public void libFinalize() throws PKCS11Exception {
    }

    public abstract PKCS11Slot[] getSlotList(boolean var1) throws PKCS11Exception;

    public abstract PKCS11Info getInfo() throws PKCS11Exception;

    public PKCS11Slot getFirstTokenSlot() throws PKCS11Exception {
        PKCS11Slot[] pKCS11SlotArray = this.getSlotList(true);
        return pKCS11SlotArray.length > 0 ? pKCS11SlotArray[0] : null;
    }

    static String flagsToString(int n2, int[] nArray, String[] stringArray, String string) {
        if (n2 == 0) {
            return "0x0";
        }
        StringBuffer stringBuffer = new StringBuffer(64);
        String string2 = "";
        int n3 = 0;
        while (n3 < nArray.length) {
            if ((nArray[n3] & n2) != 0) {
                stringBuffer.append(string2);
                stringBuffer.append(stringArray[n3]);
                n2 &= ~nArray[n3];
                string2 = string;
            }
            ++n3;
        }
        if (n2 != 0) {
            stringBuffer.append(string2);
            stringBuffer.append("0x");
            stringBuffer.append(Integer.toString(n2, 16));
        }
        return stringBuffer.toString();
    }

    protected void finalize() {
        this.libFinalize();
    }

    protected PKCS11() {
    }
}

