/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jsse;

import com.ibm.jsse.X509TrustManagerImpl;
import com.ibm.net.ssl.TrustManager;
import com.ibm.net.ssl.TrustManagerFactorySpi;
import com.ibm.net.ssl.X509TrustManager;
import java.io.File;
import java.io.FileInputStream;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.KeyStoreException;
import sun.security.action.GetPropertyAction;

public final class TrustManagerFactoryImpl
extends TrustManagerFactorySpi {
    private static boolean DEBUG;
    private X509TrustManager trustManager;

    protected void engineInit(KeyStore keyStore) throws KeyStoreException {
        if (keyStore == null) {
            String string = File.separator;
            FileInputStream fileInputStream = null;
            try {
                Object object;
                String string2 = System.getProperty("javax.net.ssl.trustStore", "");
                if (string2.length() == 0) {
                    string2 = "";
                    object = new File(String.valueOf(System.getProperty("java.home")) + string + "lib" + string + "security" + string + "jssecacerts");
                    if (((File)object).exists()) {
                        string2 = ((File)object).getPath();
                    } else {
                        object = new File(String.valueOf(System.getProperty("java.home")) + string + "lib" + string + "security" + string + "cacerts");
                        if (((File)object).exists()) {
                            string2 = ((File)object).getPath();
                        }
                    }
                }
                String string3 = System.getProperty("javax.net.ssl.trustStoreType", KeyStore.getDefaultType());
                String string4 = System.getProperty("javax.net.ssl.trustStorePassword", "");
                if (DEBUG) {
                    System.out.println("TrustManagerFactoryImpl: trustStore is : " + string2);
                    System.out.println("TrustManagerFactoryImpl: trustStore type is : " + string3);
                }
                if (string2.length() == 0) {
                    return;
                }
                fileInputStream = new FileInputStream(string2);
                if (string3.length() != 0) {
                    if (DEBUG) {
                        System.out.println("TrustManagerFactoryImpl: init truststore");
                    }
                    keyStore = KeyStore.getInstance(string3);
                    object = null;
                    if (string4.length() != 0) {
                        object = string4.toCharArray();
                    }
                    keyStore.load(fileInputStream, (char[])object);
                } else {
                    keyStore = KeyStore.getInstance("jks");
                    keyStore.load(fileInputStream, null);
                }
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (Exception exception) {
                if (DEBUG) {
                    System.out.println("TrustManagerFactoryImpl: " + exception.getMessage());
                }
                throw new RuntimeException(exception.getMessage());
            }
        }
        this.trustManager = new X509TrustManagerImpl(keyStore);
    }

    protected TrustManager[] engineGetTrustManagers() {
        return new TrustManager[]{this.trustManager};
    }

    static {
        String string = AccessController.doPrivileged(new GetPropertyAction("javax.net.debug"));
        if (string != null) {
            DEBUG = string.equalsIgnoreCase("true");
        }
    }
}

