/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.u2.jdbcx;

import com.ibm.u2.jdbc.UniJDBCConnectionImpl;
import com.ibm.u2.jdbcx.UniJDBCConnectionPoolDataSource;
import com.ibm.u2.jdbcx.UniJDBCPooledConnection;
import com.ibm.u2.jdbcx.UniJDBCReUsableConnection;
import java.sql.SQLException;
import java.util.Properties;

public class UniJDBCSqliConnReUsableConnection
extends UniJDBCConnectionImpl
implements UniJDBCReUsableConnection {
    UniJDBCPooledConnection parentPoolConn;
    Properties connProperties;
    String ldbName;
    private UniJDBCConnectionPoolDataSource cpds;

    public UniJDBCSqliConnReUsableConnection(UniJDBCPooledConnection fromWhom, String url, Properties prop, String dbname) throws SQLException {
        super(url, prop);
        this.parentPoolConn = fromWhom;
        this.connProperties = prop;
        this.cpds = this.parentPoolConn.getCPDS();
    }

    public void close() throws SQLException {
        int refreshMode;
        int coreMode = refreshMode = this.cpds.getUniJDBCCPMPCRefreshMode();
        try {
            this.restoreDefaultProperties();
        }
        catch (SQLException e) {
            this.parentPoolConn.notifyListenersOfErrors(e);
            throw e;
        }
        if (refreshMode == 11) {
            coreMode = 3;
            RefreshingThread refreshThread = new RefreshingThread(this, this, coreMode);
            refreshThread.start();
            return;
        }
        this.refreshConnection(coreMode);
    }

    void refreshConnection(int method) throws SQLException {
        try {
            this.cpds.incRefreshConnectionCount(1);
            this.refresh(method);
        }
        catch (SQLException e) {
            this.parentPoolConn.notifyListenersOfErrors(e);
            this.cpds.incRefreshConnectionCount(-1);
            throw e;
        }
        this.parentPoolConn.notifyListeners();
        this.cpds.incRefreshConnectionCount(-1);
    }

    public void hardClose() throws SQLException {
        super.close();
    }

    private class RefreshingThread
    extends Thread {
        private UniJDBCSqliConnReUsableConnection mConnection;
        private int mRefreshMethod;

        public RefreshingThread(UniJDBCSqliConnReUsableConnection this$0, UniJDBCSqliConnReUsableConnection conn, int refreshMode) {
            this.mConnection = conn;
            this.mRefreshMethod = refreshMode;
        }

        public void run() {
            try {
                this.mConnection.refreshConnection(this.mRefreshMethod);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
}

