/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.u2.jdbcx;

import com.ibm.u2.jdbc.UniJDBCConnection;
import com.ibm.u2.jdbc.UniJDBCMsgFactory;
import com.ibm.u2.jdbc.UniJDBCTrace;
import com.ibm.u2.jdbcx.UniJDBCConnectionPoolDataSource;
import com.ibm.u2.jdbcx.UniJDBCReUsableConnection;
import com.ibm.u2.jdbcx.UniJDBCSqliConnReUsableConnection;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.Vector;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;

public class UniJDBCPooledConnection
implements PooledConnection {
    private Vector listeners = null;
    private Properties DSProp = null;
    private UniJDBCReUsableConnection conn = null;
    private UniJDBCConnectionPoolDataSource cpds = null;
    protected long timeInPool = 0L;
    private UniJDBCTrace trace = null;
    private UniJDBCMsgFactory mMsgFactory = null;

    public UniJDBCPooledConnection() throws SQLException {
        this.listeners = new Vector();
        this.DSProp = null;
        this.conn = null;
    }

    public UniJDBCPooledConnection(UniJDBCConnectionPoolDataSource tcpds) throws SQLException {
        this.cpds = tcpds;
        this.conn = null;
        this.listeners = new Vector();
        UniJDBCConnectionPoolDataSource uniJDBCConnectionPoolDataSource = this.cpds;
        synchronized (uniJDBCConnectionPoolDataSource) {
            this.DSProp = this.cpds.getDsProperties();
            this.mMsgFactory = this.cpds.getMsgFactory();
            this.cpds.checkMaxConnections();
            this.establishConnection();
            this.cpds.incConnectionCount(1);
        }
        if (this.trace != null && this.trace.mLevel >= 1) {
            this.trace.writeTrace("UniJDBCPooledConnection.java:UniJDBCPooledConnection() got pooled conn.");
        }
    }

    public Connection getConnection() throws SQLException {
        if (this.trace != null && this.trace.mLevel >= 1) {
            this.trace.writeTrace("UniJDBCPooledConnection.java:getConnection() callled");
        }
        return (Connection)((Object)this.conn);
    }

    public void close() throws SQLException {
        if (this.conn == null) {
            return;
        }
        if (this.trace != null && this.trace.mLevel >= 1) {
            this.trace.writeTrace("UniJDBCPooledConnection.java:close() callled");
        }
        UniJDBCConnectionPoolDataSource uniJDBCConnectionPoolDataSource = this.cpds;
        synchronized (uniJDBCConnectionPoolDataSource) {
            this.conn.hardClose();
            this.cpds.incConnectionCount(-1);
        }
        this.conn = null;
        if (this.trace != null && this.trace.mLevel >= 1) {
            this.trace.writeTrace("UniJDBCPooledConnection.java:close() exited");
        }
    }

    public synchronized void addConnectionEventListener(ConnectionEventListener listener) {
        this.listeners.addElement(listener);
    }

    public synchronized void removeConnectionEventListener(ConnectionEventListener listener) {
        if (this.trace != null && this.trace.mLevel >= 1) {
            this.trace.writeTrace("UniJDBCPooledConnection.java:removeConnectionEventListener() called");
        }
        this.listeners.removeElement(listener);
    }

    void notifyListeners() throws SQLException {
        if (this.trace != null && this.trace.mLevel >= 1) {
            this.trace.writeTrace("UniJDBCPooledConnection.java:notifyListeners() callled");
        }
        this.notifyListenersOfErrors(null);
        if (this.trace != null && this.trace.mLevel >= 1) {
            this.trace.writeTrace("UniJDBCPooledConnection.java:notifyListeners() exited.");
        }
    }

    void notifyListenersOfErrors(SQLException e) throws SQLException {
        if (this.trace != null && this.trace.mLevel >= 1) {
            this.trace.writeTrace("UniJDBCPooledConnection.java:notifyListenersOfErrors() callled");
        }
        int numListeners = 0;
        int i = 0;
        ConnectionEventListener eventListener = null;
        Vector clonedListener = null;
        Vector vector = this.listeners;
        synchronized (vector) {
            clonedListener = (Vector)this.listeners.clone();
        }
        numListeners = clonedListener.size();
        for (i = 0; i < numListeners; ++i) {
            eventListener = (ConnectionEventListener)clonedListener.elementAt(i);
            if (e != null) {
                eventListener.connectionErrorOccurred(new ConnectionEvent(this, e));
                throw e;
            }
            eventListener.connectionClosed(new ConnectionEvent(this));
        }
        if (this.trace != null && this.trace.mLevel >= 1) {
            this.trace.writeTrace("UniJDBCPooledConnection.java:notifyListenersOfErrors() exited.");
        }
    }

    private void establishConnection() throws SQLException {
        String urlString = null;
        String uciDsName = this.DSProp.getProperty("odbcdsn");
        String hostName = this.DSProp.getProperty("host");
        String uciAcctPath = this.DSProp.getProperty("account");
        if (hostName != null && uciAcctPath != null) {
            urlString = String.valueOf(String.valueOf(new StringBuffer("jdbc:ibm-u2:").append(uciDsName).append(":").append(uciAcctPath)));
        } else if (uciDsName != null && uciAcctPath != null) {
            urlString = String.valueOf(String.valueOf(new StringBuffer("jdbc:ibm-u2://").append(hostName).append(":").append(uciAcctPath)));
        }
        try {
            this.conn = this.getClientServerReUsable(urlString, null);
        }
        catch (SQLException sqlex) {
            throw sqlex;
        }
        catch (Exception ex) {
            throw this.mMsgFactory.createException(951101, new Object[]{ex.toString()});
        }
        if (this.conn != null) {
            this.trace = ((UniJDBCConnection)((Object)this.conn)).getTrace();
            if (this.trace.mLevel >= 1) {
                this.trace.writeTrace("UniJDBCPooledConnection:establishConnection() go a conn.");
            }
        }
    }

    public void setTimeInPool() {
        this.timeInPool = System.currentTimeMillis();
    }

    private UniJDBCReUsableConnection getClientServerReUsable(String urlString, String dbName) throws SQLException {
        UniJDBCSqliConnReUsableConnection scrc = new UniJDBCSqliConnReUsableConnection(this, urlString, this.DSProp, dbName);
        return scrc;
    }

    UniJDBCConnectionPoolDataSource getCPDS() {
        return this.cpds;
    }
}

