/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.u2.jdbcx;

import com.ibm.u2.jdbc.UniJDBCConnectionImpl;
import com.ibm.u2.jdbc.UniJDBCTrace;
import com.ibm.u2.jdbcx.UniJDBCConnectionPoolDataSource;
import com.ibm.u2.jdbcx.UniJDBCConnectionPoolManager;
import com.ibm.u2.jdbcx.UniJDBCCoreDataSource;
import java.io.ByteArrayOutputStream;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.DataSource;

public class UniJDBCDataSource
extends UniJDBCCoreDataSource
implements DataSource,
Referenceable {
    private UniJDBCConnectionPoolManager cpm;
    private Connection conn = null;
    private Context initCtx = null;
    private String cpdsName;
    private String tuser;
    private String tpassword;
    private Constructor cons = null;
    private UniJDBCTrace trace = null;
    static Class class$com$ibm$u2$jdbcx$UniJDBCDataSource;
    static Class class$com$ibm$u2$jdbcx$UniJDBCDataSourceFactory;

    public UniJDBCDataSource() throws SQLException {
        this.cpm = null;
        this.cpdsName = null;
        try {
            this.initCtx = new InitialContext();
        }
        catch (Exception e) {
            throw this.mMsgFactory.createException(951101, new Object[]{e.toString()});
        }
    }

    public UniJDBCDataSource(UniJDBCConnectionPoolDataSource lcpds) throws SQLException {
        this.cpdsName = null;
        this.cpm = null;
    }

    public Connection getConnection() throws SQLException {
        if (this.cpm == null) {
            if (this.user == null || this.password == null) {
                throw this.mMsgFactory.createException(951033);
            }
            return this.getSqliConnection();
        }
        return this.cpm.getConnection();
    }

    public Connection getConnection(String luser, String lpassword) throws SQLException {
        if (this.cpm == null) {
            this.checkUserAndPasswd(luser, lpassword);
            return this.getSqliConnection();
        }
        return this.cpm.getConnection(luser, lpassword);
    }

    private Connection getSqliConnection() throws SQLException {
        UniJDBCConnectionImpl conn;
        String urlString = "";
        Object host = null;
        Object port = null;
        Object connType = null;
        Properties prop = this.getDsProperties();
        try {
            conn = new UniJDBCConnectionImpl(urlString, prop);
        }
        catch (Exception e) {
            throw this.mMsgFactory.createException(951104, new Object[]{e.toString()});
        }
        this.trace = conn.getTrace();
        if (this.trace.mLevel >= 1) {
            this.trace.writeTrace("UniJDBCDataSource: This has NO Connection Pool");
            this.trace.writeTrace("UniJDBCDataSource: getSqliConnection() exited");
        }
        return conn;
    }

    void getCPM() throws SQLException {
        try {
            this.cpdsName = this.getDataSourceName();
            if (this.cpdsName != null) {
                this.cpm = new UniJDBCConnectionPoolManager(this.cpdsName);
                this.cpm.startPoolService();
            } else {
                this.cpm = null;
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.mMsgFactory.createException(951101, new Object[]{e.toString()});
        }
    }

    public Reference getReference() throws NamingException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.writeProperties(out);
            Reference reference = new Reference((class$com$ibm$u2$jdbcx$UniJDBCDataSource == null ? (class$com$ibm$u2$jdbcx$UniJDBCDataSource = UniJDBCDataSource.class$("com.ibm.u2.jdbcx.UniJDBCDataSource")) : class$com$ibm$u2$jdbcx$UniJDBCDataSource).getName(), new StringRefAddr("DSProperties", ((Object)out).toString()), (class$com$ibm$u2$jdbcx$UniJDBCDataSourceFactory == null ? (class$com$ibm$u2$jdbcx$UniJDBCDataSourceFactory = UniJDBCDataSource.class$("com.ibm.u2.jdbcx.UniJDBCDataSourceFactory")) : class$com$ibm$u2$jdbcx$UniJDBCDataSourceFactory).getName(), null);
            return reference;
        }
        catch (Exception e) {
            Reference reference = null;
            return reference;
        }
    }

    public int getCPMFreeCount() {
        if (this.cpm != null) {
            return this.cpm.getFreeCount();
        }
        return 0;
    }

    public UniJDBCConnectionPoolDataSource getCPDS() {
        if (this.cpm != null) {
            return this.cpm.getCPDS();
        }
        return null;
    }

    static Class class$(String x$0) {
        try {
            return Class.forName(x$0);
        }
        catch (ClassNotFoundException x$02) {
            throw new NoClassDefFoundError(x$02.getMessage());
        }
    }
}

