/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.u2.jdbcx;

import com.ibm.u2.jdbc.UniJDBCMsgFactory;
import com.ibm.u2.jdbc.UniJDBCProperties;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;

public abstract class UniJDBCCoreDataSource
implements Serializable {
    private PrintWriter logWriter = null;
    protected Properties DSProperties = new UniJDBCProperties();
    protected String value = null;
    protected transient String user = null;
    protected transient String password = null;
    private static Properties defProp = null;
    private transient boolean mLocaleChanged = true;
    protected transient UniJDBCMsgFactory mMsgFactory = null;

    public int getLoginTimeout() {
        String value = this.DSProperties.getProperty("logintimeout");
        if (value == null) {
            value = defProp.getProperty("logintimeout");
            return Integer.parseInt(value);
        }
        return Integer.parseInt(value);
    }

    public void setLoginTimeout(int seconds) {
        this.DSProperties.setProperty("logintimeout", new Integer(seconds).toString());
    }

    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    public void setLogWriter(PrintWriter out) {
        this.logWriter = out;
    }

    public Properties getDsProperties() {
        return this.DSProperties;
    }

    public void addProp(String key, Object value) {
        ((Hashtable)this.DSProperties).remove(key);
        this.DSProperties.setProperty(key, value.toString());
    }

    public Object getProp(String key) {
        return this.DSProperties.getProperty(key);
    }

    public void writeProperties(OutputStream out) throws IOException {
        this.DSProperties.store(out, "Properties for DS");
    }

    public void readProperties(InputStream in) throws IOException {
        this.DSProperties.load(in);
    }

    public void removeProperty(String key) {
        if (this.DSProperties.getProperty(key) != null) {
            ((Hashtable)this.DSProperties).remove(key);
        }
    }

    public String getDataSourceName() {
        return this.DSProperties.getProperty("dsname");
    }

    public void setDataSourceName(String dsName) {
        this.DSProperties.setProperty("dsname", dsName);
    }

    public String getDescription() {
        return this.DSProperties.getProperty("dsdesc");
    }

    public void setDescription(String descrip) {
        this.DSProperties.setProperty("dsdesc", descrip);
    }

    public String getServerHost() {
        return this.DSProperties.getProperty("host");
    }

    public void setServerHost(String hostname) {
        this.DSProperties.setProperty("host", hostname);
    }

    public int getServerPort() {
        String value = this.DSProperties.getProperty("port");
        if (value == null) {
            value = defProp.getProperty("port");
            return Integer.parseInt(value);
        }
        return Integer.parseInt(value);
    }

    public void setServerPort(int port) {
        this.DSProperties.setProperty("port", new Integer(port).toString());
    }

    public String getAccount() {
        return this.DSProperties.getProperty("account");
    }

    public void setAccount(String account) {
        this.DSProperties.setProperty("account", account);
    }

    protected String getODBCDSName() {
        return this.DSProperties.getProperty("odbcdsn");
    }

    protected void setODBCDSName(String odsn) {
        this.DSProperties.setProperty("odbcdsn", odsn);
    }

    protected String getODBCConfigURL() {
        return this.DSProperties.getProperty("configurl");
    }

    protected void setODBCConfigURL(String url) {
        this.DSProperties.setProperty("configurl", url);
    }

    public String getDBMSType() {
        String value = this.DSProperties.getProperty("dbmstype");
        if (value == null) {
            return defProp.getProperty("dbmstype");
        }
        return value;
    }

    public void setDBMSType(String dbtype) {
        this.DSProperties.setProperty("dbmstype", dbtype);
    }

    public String getNetworkType() {
        String value = this.DSProperties.getProperty("network");
        if (value == null) {
            return defProp.getProperty("network");
        }
        return value;
    }

    public void setNetworkType(String network) {
        this.DSProperties.setProperty("network", network);
    }

    public String getService() {
        String value = this.DSProperties.getProperty("service");
        if (value == null) {
            return defProp.getProperty("service");
        }
        return value;
    }

    public void setService(String service) {
        this.DSProperties.setProperty("service", service);
    }

    protected String getLanguage() {
        return this.DSProperties.getProperty("language");
    }

    protected void setLanguage(String language) {
        this.mLocaleChanged = true;
        this.DSProperties.setProperty("language", language);
    }

    protected String getCountry() {
        return this.DSProperties.getProperty("country");
    }

    protected void setCountry(String country) {
        this.mLocaleChanged = true;
        this.DSProperties.setProperty("country", country);
    }

    public String getPassword() {
        return this.DSProperties.getProperty("password");
    }

    public void setPassword(String passwd) {
        this.password = passwd;
        this.DSProperties.setProperty("password", passwd);
    }

    public String getUser() {
        return this.DSProperties.getProperty("user");
    }

    public void setUser(String iuser) {
        this.user = iuser;
        this.DSProperties.setProperty("user", iuser);
    }

    protected int getTraceLevel() {
        String value = this.DSProperties.getProperty("tracelevel");
        if (value == null) {
            value = defProp.getProperty("tracelevel");
        }
        return Integer.parseInt(value);
    }

    protected void setTraceLevel(int level) {
        this.DSProperties.setProperty("tracelevel", new Integer(level).toString());
    }

    protected String getTraceFile() {
        return this.DSProperties.getProperty("tracefile");
    }

    protected void setTraceFile(String ifile) {
        this.DSProperties.setProperty("tracefile", ifile);
    }

    void checkUserAndPasswd(String luser, String lpassword) throws SQLException {
        if (luser == null || lpassword == null) {
            throw this.mMsgFactory.createException(951033);
        }
        if (this.user != null && this.password == null || this.user == null && this.password != null) {
            throw this.mMsgFactory.createException(951033);
        }
        if (luser != null && lpassword != null && this.user != null && this.password != null && (this.user.compareTo(luser) != 0 || this.password.compareTo(lpassword) != 0)) {
            throw this.mMsgFactory.createException(951103);
        }
        if (this.user == null && this.password == null) {
            this.setUser(luser);
            this.setPassword(lpassword);
        }
    }

    void initLocals() {
        this.user = this.getUser();
        this.password = this.getPassword();
        this.getMsgFactory();
    }

    protected UniJDBCMsgFactory getMsgFactory() {
        if (!this.mLocaleChanged) {
            return this.mMsgFactory;
        }
        String language = this.getLanguage();
        String country = this.getCountry();
        this.mMsgFactory = language == null || country == null ? new UniJDBCMsgFactory() : new UniJDBCMsgFactory(new Locale(language, country));
        this.mLocaleChanged = false;
        return this.mMsgFactory;
    }

    static {
        defProp = new UniJDBCProperties();
        defProp.setProperty("logintimeout", "0");
        defProp.setProperty("port", "31438");
        defProp.setProperty("tracelevel", "0");
        defProp.setProperty("dbmstype", "UNIVERSE");
        defProp.setProperty("network", "TCP/IP");
        defProp.setProperty("service", "uvserver");
    }
}

