/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.u2.jdbcx;

import com.ibm.u2.jdbc.UniJDBCMsgFactory;
import com.ibm.u2.jdbc.UniJDBCTrace;
import com.ibm.u2.jdbcx.UniJDBCConnectionEventListener;
import com.ibm.u2.jdbcx.UniJDBCConnectionPoolDataSource;
import com.ibm.u2.jdbcx.UniJDBCPooledConnection;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import javax.naming.InitialContext;

public class UniJDBCConnectionPoolManager {
    private UniJDBCConnectionPoolDataSource cpds;
    private UniJDBCConnectionEventListener connectionListener = null;
    private UniJDBCTrace cpmTrace = null;
    private UniJDBCMsgFactory mMsgFactory = null;
    private String cpdsName = null;
    private Pool pool = new Pool(this);
    private PoolServiceThread poolService = null;
    private long serviceInterval = 100L;
    private long ageLimit = -1L;
    private long minAgeLimit = -1L;
    private int initialPoolSize = 0;
    private int maxConnections = -1;
    private int maxPoolSize = 50;
    private int minPoolSize = 0;
    private String DSuser;
    private String DSpassword;
    private boolean isDirectConnect = false;

    public UniJDBCConnectionPoolManager(String dsName) throws SQLException {
        this.cpdsName = dsName;
        InitialContext initCtx = null;
        this.cpds = null;
        try {
            initCtx = new InitialContext();
            this.cpds = (UniJDBCConnectionPoolDataSource)initCtx.lookup(this.cpdsName);
            this.cpmTrace = this.getCPMTrace();
            this.mMsgFactory = this.cpds.getMsgFactory();
        }
        catch (Exception e) {
            throw this.mMsgFactory.createException(951101, new Object[]{e.toString()});
        }
        this.getNcheckProperties();
        this.connectionListener = new UniJDBCConnectionEventListener();
        this.connectionListener.setParent(this);
        Method addShutdownHook = null;
        this.isDirectConnect = this.cpds.checkIsDirect();
        if (this.isDirectConnect) {
            if (this.cpmTrace != null && this.cpmTrace.mLevel >= 1) {
                this.cpmTrace.writeTrace("UniJDBCConnectionPoolManager: cpdds MinAge ".concat(String.valueOf(String.valueOf(this.cpds.getUniJDBCCPMMinAgeLimit()))));
            }
            if (this.cpmTrace != null && this.cpmTrace.mLevel >= 1) {
                this.cpmTrace.writeTrace("UniJDBCConnectionPoolManager: cpds age ".concat(String.valueOf(String.valueOf(this.cpds.getUniJDBCCPMAgeLimit()))));
            }
        }
        try {
            Class<?> runtime = Class.forName("java.lang.Runtime");
            Class[] param = new Class[]{Class.forName("java.lang.Thread")};
            addShutdownHook = runtime.getMethod("addShutdownHook", param);
            Object[] arg = new Object[]{new PoolShutdownThread(this)};
            addShutdownHook.invoke((Object)Runtime.getRuntime(), arg);
        }
        catch (NoSuchMethodException e) {
            if (this.cpmTrace != null && this.cpmTrace.mLevel >= 1) {
                this.cpmTrace.writeTrace("UniJDBCConnectionPoolManager: NO shutdownThread() registered");
            }
        }
        catch (Exception e) {
            throw this.mMsgFactory.createException(951101, new Object[]{e.toString()});
        }
        if (this.minPoolSize > 0 || this.ageLimit > (long)0) {
            this.poolService = new PoolServiceThread(this, this.ageLimit);
        }
    }

    private void getNcheckProperties() throws SQLException {
        this.DSuser = this.cpds.getUser();
        this.DSpassword = this.cpds.getPassword();
        this.maxConnections = this.cpds.getUniJDBCCPMMaxConnections();
        this.initialPoolSize = this.cpds.getUniJDBCCPMInitPoolSize();
        this.maxPoolSize = this.cpds.getUniJDBCCPMMaxPoolSize();
        this.minPoolSize = this.cpds.getUniJDBCCPMMinPoolSize();
        this.minAgeLimit = this.cpds.getUniJDBCCPMMinAgeLimit();
        this.ageLimit = this.cpds.getUniJDBCCPMAgeLimit();
        this.serviceInterval = this.cpds.getUniJDBCCPMServiceInterval();
        if (this.ageLimit > (long)0) {
            this.ageLimit *= (long)1000;
        }
        if (this.minAgeLimit > (long)0) {
            this.minAgeLimit *= (long)1000;
        }
        if (this.maxConnections < -1 || this.maxPoolSize < -1 || this.minPoolSize < 0 || this.initialPoolSize < 0 || this.ageLimit < (long)-1 || this.minAgeLimit < (long)-1 || this.serviceInterval < (long)0 || this.maxPoolSize != -1 && this.maxPoolSize < this.minPoolSize || this.maxConnections != -1 && this.maxConnections < this.initialPoolSize) {
            throw this.mMsgFactory.createException(951102);
        }
    }

    private UniJDBCTrace getCPMTrace() {
        try {
            String traceFile = this.cpds.getTraceFile();
            int traceLevel = this.cpds.getTraceLevel();
            UniJDBCTrace atrace = new UniJDBCTrace();
            atrace.setLevel(traceLevel);
            atrace.setTraceFile(traceFile);
            UniJDBCTrace uniJDBCTrace = atrace;
            return uniJDBCTrace;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Connection getConnection() throws SQLException {
        if (this.DSuser == null || this.DSpassword == null) {
            throw this.mMsgFactory.createException(951033);
        }
        return this.getConnection(this.DSuser, this.DSpassword);
    }

    public Connection getConnection(String luser, String lpassword) throws SQLException {
        UniJDBCPooledConnection pc;
        this.cpds.checkUserAndPasswd(luser, lpassword);
        while ((pc = this.pool.remove()) == null) {
            block10: {
                try {
                    pc = (UniJDBCPooledConnection)this.cpds.getPooledConnection(luser, lpassword, this.connectionListener);
                }
                catch (SQLException ie) {
                    if (ie.getErrorCode() == 951100) {
                        try {
                            if (this.cpds.getRefreshConnectionCount() == 0) {
                                Thread.currentThread();
                                Thread.sleep(this.serviceInterval * (long)10);
                            } else {
                                Thread.currentThread();
                                Thread.sleep(this.serviceInterval);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        pc = this.pool.remove();
                    }
                    if (pc != null || this.cpds.getRefreshConnectionCount() != 0) break block10;
                    throw ie;
                }
            }
            if (pc == null) continue;
        }
        if (this.poolService != null) {
            this.notifyPoolService();
        }
        Connection conn = pc.getConnection();
        if (this.cpmTrace != null && this.cpmTrace.mLevel >= 1) {
            this.cpmTrace.writeTrace("UniJDBCConnectionPoolManager: getConnection() exited");
        }
        return conn;
    }

    void recycleConnection(UniJDBCPooledConnection pc, int errorCode) {
        if (this.cpmTrace != null && this.cpmTrace.mLevel >= 1) {
            this.cpmTrace.writeTrace("UniJDBCConnectionPoolManager: recycleConnection() called");
        }
        if (errorCode > 0 || this.pool.add(pc)) {
            if (this.cpmTrace != null && this.cpmTrace.mLevel >= 1) {
                this.cpmTrace.writeTrace("UniJDBCConnectionPoolManager: pool full, hardclose");
            }
            try {
                pc.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (this.poolService != null) {
            this.notifyPoolService();
        }
    }

    void startPoolService() throws SQLException {
        if (this.initialPoolSize > 0) {
            this.pool.fillThePool(this.initialPoolSize, 0L);
        }
        if (this.poolService != null) {
            this.poolService.start();
        }
    }

    private void notifyPoolService() {
        if (this.pool.roughCount() < this.minPoolSize) {
            if (this.poolService.isAlive()) {
                if (!this.pool.fillingInProgress) {
                    this.poolService.interrupt();
                }
            } else {
                UniJDBCConnectionPoolManager uniJDBCConnectionPoolManager = this;
                synchronized (uniJDBCConnectionPoolManager) {
                    if (!this.poolService.isAlive()) {
                        this.poolService = new PoolServiceThread(this, this.ageLimit);
                        this.poolService.start();
                        this.pool.fillingInProgress = false;
                    }
                    this.poolService.interrupt();
                }
            }
        }
    }

    protected int getFreeCount() {
        return this.pool.roughCount();
    }

    protected UniJDBCConnectionPoolDataSource getCPDS() {
        return this.cpds;
    }

    static /* synthetic */ long access$9(UniJDBCConnectionPoolManager x$0) {
        return x$0.serviceInterval;
    }

    private class PoolShutdownThread
    extends Thread {
        private UniJDBCConnectionPoolManager cpm;

        PoolShutdownThread(UniJDBCConnectionPoolManager owner) {
            this.cpm = owner;
        }

        public void run() {
            if (UniJDBCConnectionPoolManager.this.cpmTrace != null && ((UniJDBCConnectionPoolManager)UniJDBCConnectionPoolManager.this).cpmTrace.mLevel >= 1) {
                UniJDBCConnectionPoolManager.this.cpmTrace.writeTrace("UniJDBCConnectionPoolManager: Pool shutdown...");
            }
            this.cpm.pool.flushThePool();
            if (UniJDBCConnectionPoolManager.this.cpmTrace != null && ((UniJDBCConnectionPoolManager)UniJDBCConnectionPoolManager.this).cpmTrace.mLevel >= 1) {
                UniJDBCConnectionPoolManager.this.cpmTrace.writeTrace("UniJDBCConnectionPoolManager: Pool shutdown completed");
            }
        }
    }

    private class Pool {
        private UniJDBCConnectionPoolManager cpm;
        private LinkedList poolList;
        private boolean fillingInProgress = false;
        private boolean shutdownFlag = false;

        Pool(UniJDBCConnectionPoolManager owner) {
            this.cpm = owner;
            this.poolList = new LinkedList();
        }

        synchronized boolean add(UniJDBCPooledConnection pc) {
            if (UniJDBCConnectionPoolManager.this.maxPoolSize > -1 && this.poolList.size() >= UniJDBCConnectionPoolManager.this.maxPoolSize || this.shutdownFlag) {
                return true;
            }
            pc.setTimeInPool();
            this.poolList.addLast(pc);
            return false;
        }

        synchronized UniJDBCPooledConnection remove() throws SQLException {
            UniJDBCPooledConnection pc;
            if (this.shutdownFlag) {
                throw UniJDBCConnectionPoolManager.this.mMsgFactory.createException(951101, new Object[]{"shutdown in progress"});
            }
            try {
                pc = (UniJDBCPooledConnection)this.poolList.removeLast();
            }
            catch (NoSuchElementException e) {
                pc = null;
            }
            return pc;
        }

        public int roughCount() {
            return this.poolList.size();
        }

        private void fillThePool(int upTo, long pause) throws SQLException {
            this.fillingInProgress = true;
            int i = 0;
            while (this.roughCount() < upTo) {
                try {
                    UniJDBCPooledConnection pc = (UniJDBCPooledConnection)UniJDBCConnectionPoolManager.this.cpds.getPooledConnection(UniJDBCConnectionPoolManager.this.DSuser, UniJDBCConnectionPoolManager.this.DSpassword, UniJDBCConnectionPoolManager.this.connectionListener);
                    if (this.add(pc)) {
                        if (UniJDBCConnectionPoolManager.this.cpmTrace != null && ((UniJDBCConnectionPoolManager)UniJDBCConnectionPoolManager.this).cpmTrace.mLevel >= 1) {
                            UniJDBCConnectionPoolManager.this.cpmTrace.writeTrace("UniJDBCConnectionPoolManager: fillThePool(), full, hardclose");
                        }
                        pc.close();
                        break;
                    }
                    ++i;
                    if (pause <= (long)0) continue;
                    Thread.currentThread();
                    Thread.sleep(pause);
                }
                catch (InterruptedException interruptedException) {
                }
                catch (SQLException ie2) {
                    break;
                }
                catch (Exception e) {
                    // empty catch block
                    break;
                }
            }
            this.fillingInProgress = false;
        }

        private void skimThePool(long now) {
            if (UniJDBCConnectionPoolManager.this.ageLimit < (long)0) {
                return;
            }
            int i = Integer.MAX_VALUE;
            while (i-- > 0 && !this.shutdownFlag) {
                UniJDBCPooledConnection pc;
                try {
                    LinkedList linkedList = this.poolList;
                    synchronized (linkedList) {
                        pc = (UniJDBCPooledConnection)this.poolList.removeFirst();
                    }
                }
                catch (NoSuchElementException e) {
                    break;
                }
                long age = now - pc.timeInPool;
                if (!(age >= UniJDBCConnectionPoolManager.this.ageLimit && (UniJDBCConnectionPoolManager.this.minAgeLimit != (long)-1 && age >= UniJDBCConnectionPoolManager.this.minAgeLimit + UniJDBCConnectionPoolManager.this.ageLimit || this.poolList.size() >= UniJDBCConnectionPoolManager.this.minPoolSize) || this.shutdownFlag)) {
                    LinkedList linkedList = this.poolList;
                    synchronized (linkedList) {
                        this.poolList.addFirst(pc);
                        break;
                    }
                }
                if (UniJDBCConnectionPoolManager.this.cpmTrace != null && ((UniJDBCConnectionPoolManager)UniJDBCConnectionPoolManager.this).cpmTrace.mLevel >= 1) {
                    UniJDBCConnectionPoolManager.this.cpmTrace.writeTrace("UniJDBCConnectionPoolManager: skimThePool(), conn expired, hardclose");
                }
                try {
                    pc.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                Thread.currentThread();
                Thread.yield();
            }
        }

        protected void flushThePool() {
            this.shutdownFlag = true;
            LinkedList linkedList = this.poolList;
            synchronized (linkedList) {
                while (true) {
                    try {
                        while (true) {
                            UniJDBCPooledConnection pc = (UniJDBCPooledConnection)this.poolList.removeFirst();
                            pc.close();
                        }
                    }
                    catch (NoSuchElementException e) {
                    }
                    catch (Exception exception) {
                        continue;
                    }
                    break;
                }
            }
        }

        static /* synthetic */ void access$5(Pool x$0, long x$1) {
            x$0.skimThePool(x$1);
        }
    }

    private class PoolServiceThread
    extends Thread {
        private UniJDBCConnectionPoolManager cpm;
        private long sleepTime;

        PoolServiceThread(UniJDBCConnectionPoolManager cpm, long sleepInterval) {
            this.cpm = cpm;
            this.sleepTime = sleepInterval > (long)0 ? sleepInterval : Long.MAX_VALUE;
            this.setName("CPMservice");
            if (cpm.isDirectConnect) {
                return;
            }
            this.setDaemon(true);
        }

        /*
         * Unable to fully structure code
         */
        public void run() {
            while (true) {
                try {
                    while (true) lbl-1000:
                    // 3 sources

                    {
                        Thread.sleep(this.sleepTime);
                        Pool.access$5(UniJDBCConnectionPoolManager.access$4(UniJDBCConnectionPoolManager.this), System.currentTimeMillis());
                        if (!UniJDBCConnectionPoolManager.access$3(this.cpm) || UniJDBCConnectionPoolManager.access$4(UniJDBCConnectionPoolManager.this).roughCount() != 0) continue;
                        var1_1 = UniJDBCConnectionPoolManager.access$6(UniJDBCConnectionPoolManager.this);
                        synchronized (var1_1) {
                            if (UniJDBCConnectionPoolManager.access$6(UniJDBCConnectionPoolManager.this).getConnectionCount() == 0) {
                                if (UniJDBCConnectionPoolManager.access$7(this.cpm) != null && UniJDBCConnectionPoolManager.access$7((UniJDBCConnectionPoolManager)UniJDBCConnectionPoolManager.this).mLevel >= 1) {
                                    UniJDBCConnectionPoolManager.access$7(this.cpm).writeTrace("UniJDBCConnectionPoolManager: PoolServiceThread exits");
                                }
                                return;
                            }
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException ie) {
                    try {
                        Pool.access$0(UniJDBCConnectionPoolManager.access$4(UniJDBCConnectionPoolManager.this), UniJDBCConnectionPoolManager.access$8(UniJDBCConnectionPoolManager.this), UniJDBCConnectionPoolManager.access$9(UniJDBCConnectionPoolManager.this));
                    }
                    catch (SQLException var2_3) {}
                    {
                    }
                    continue;
                }
                {
                    ** while (true)
                }
                break;
            }
        }
    }
}

