/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.u2.jdbcx;

import com.ibm.u2.jdbc.UniJDBCProperties;
import com.ibm.u2.jdbcx.UniJDBCConnectionEventListener;
import com.ibm.u2.jdbcx.UniJDBCCoreDataSource;
import com.ibm.u2.jdbcx.UniJDBCPooledConnection;
import java.io.ByteArrayOutputStream;
import java.lang.reflect.Constructor;
import java.sql.SQLException;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;

public class UniJDBCConnectionPoolDataSource
extends UniJDBCCoreDataSource
implements ConnectionPoolDataSource,
Referenceable {
    public static final int REFRESH_MODE_REUSE = 1;
    public static final int REFRESH_MODE_RECONNECT = 3;
    public static final int REFRESH_MODE_THREAD_RECONNECT = 11;
    private static final int REFRESH_MODE_DEFAULT = 11;
    private static Properties defProp;
    private int connectionsFromServer = 0;
    private int connectionsBeingRefreshed = 0;
    private Constructor directReUsableCons = null;
    private boolean isDirect = false;
    private boolean isDirectChecked = false;
    static Class class$com$ibm$u2$jdbcx$UniJDBCConnectionPoolDataSource;
    static Class class$com$ibm$u2$jdbcx$UniJDBCConnectionPoolDataSourceFactory;

    protected void setReUsableCons(Constructor cons) {
        this.directReUsableCons = cons;
    }

    protected Constructor getReUsableCons() {
        return this.directReUsableCons;
    }

    public PooledConnection getPooledConnection() throws SQLException {
        if (this.user == null || this.password == null) {
            throw this.mMsgFactory.createException(951033);
        }
        return new UniJDBCPooledConnection(this);
    }

    public PooledConnection getPooledConnection(String luser, String lpassword) throws SQLException {
        this.checkUserAndPasswd(luser, lpassword);
        return new UniJDBCPooledConnection(this);
    }

    public PooledConnection getPooledConnection(String luser, String lpassword, UniJDBCConnectionEventListener listener) throws SQLException {
        this.checkUserAndPasswd(luser, lpassword);
        UniJDBCPooledConnection pc = new UniJDBCPooledConnection(this);
        pc.addConnectionEventListener(listener);
        return pc;
    }

    protected void checkMaxConnections() throws SQLException {
        int limit = this.getUniJDBCCPMMaxConnections();
        if (limit != -1 && this.connectionsFromServer >= limit) {
            throw this.mMsgFactory.createException(951100);
        }
    }

    protected void incConnectionCount(int amount) {
        this.connectionsFromServer += amount;
    }

    protected int getConnectionCount() {
        return this.connectionsFromServer;
    }

    protected synchronized void incRefreshConnectionCount(int amount) {
        this.connectionsBeingRefreshed += amount;
    }

    protected synchronized int getRefreshConnectionCount() {
        return this.connectionsBeingRefreshed;
    }

    public Reference getReference() throws NamingException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.writeProperties(out);
            Reference reference = new Reference((class$com$ibm$u2$jdbcx$UniJDBCConnectionPoolDataSource == null ? (class$com$ibm$u2$jdbcx$UniJDBCConnectionPoolDataSource = UniJDBCConnectionPoolDataSource.class$("com.ibm.u2.jdbcx.UniJDBCConnectionPoolDataSource")) : class$com$ibm$u2$jdbcx$UniJDBCConnectionPoolDataSource).getName(), new StringRefAddr("CPDSProperties", ((Object)out).toString()), (class$com$ibm$u2$jdbcx$UniJDBCConnectionPoolDataSourceFactory == null ? (class$com$ibm$u2$jdbcx$UniJDBCConnectionPoolDataSourceFactory = UniJDBCConnectionPoolDataSource.class$("com.ibm.u2.jdbcx.UniJDBCConnectionPoolDataSourceFactory")) : class$com$ibm$u2$jdbcx$UniJDBCConnectionPoolDataSourceFactory).getName(), null);
            return reference;
        }
        catch (Exception e) {
            Reference reference = null;
            return reference;
        }
    }

    public void setUniJDBCCPMMaxConnections(int limit) {
        this.DSProperties.setProperty("IBM_CPM_MAX_CONNECTIONS", new Integer(limit).toString());
    }

    public void setMaxStatements(int limit) throws SQLException {
        throw this.mMsgFactory.createException(951014, new Object[]{"setMaxStatements(int)"});
    }

    public int getUniJDBCCPMMaxConnections() {
        this.value = this.DSProperties.getProperty("IBM_CPM_MAX_CONNECTIONS");
        if (this.value == null) {
            this.value = defProp.getProperty("IBM_CPM_MAX_CONNECTIONS");
        }
        return Integer.parseInt(this.value);
    }

    public int getMaxStatements() throws SQLException {
        throw this.mMsgFactory.createException(951014, new Object[]{"getMaxStatements(int)"});
    }

    public void setUniJDBCCPMInitPoolSize(int init) {
        this.DSProperties.setProperty("IBM_CPM_INIT_POOLSIZE", new Integer(init).toString());
    }

    public void setInitialPoolSize(int init) {
        this.setUniJDBCCPMInitPoolSize(init);
    }

    public int getUniJDBCCPMInitPoolSize() {
        this.value = this.DSProperties.getProperty("IBM_CPM_INIT_POOLSIZE");
        if (this.value == null) {
            this.value = defProp.getProperty("IBM_CPM_INIT_POOLSIZE");
        }
        return Integer.parseInt(this.value);
    }

    public int getInitialPoolSize() {
        return this.getUniJDBCCPMInitPoolSize();
    }

    public void setUniJDBCCPMMaxPoolSize(int max) {
        this.DSProperties.setProperty("IBM_CPM_MAX_POOLSIZE", new Integer(max).toString());
    }

    public void setMaxPoolSize(int max) {
        if (max == 0) {
            this.setUniJDBCCPMMaxPoolSize(-1);
        } else {
            this.setUniJDBCCPMMaxPoolSize(max);
        }
    }

    public int getUniJDBCCPMMaxPoolSize() {
        this.value = this.DSProperties.getProperty("IBM_CPM_MAX_POOLSIZE");
        if (this.value == null) {
            this.value = defProp.getProperty("IBM_CPM_MAX_POOLSIZE");
        }
        return Integer.parseInt(this.value);
    }

    public int getMaxPoolSize() {
        int maxPoolSize = this.getUniJDBCCPMMaxPoolSize();
        if (maxPoolSize == -1) {
            return 0;
        }
        return maxPoolSize;
    }

    public void setUniJDBCCPMMinPoolSize(int min) {
        this.DSProperties.setProperty("IBM_CPM_MIN_POOLSIZE", new Integer(min).toString());
    }

    public void setMinPoolSize(int min) {
        this.setUniJDBCCPMMinPoolSize(min);
    }

    public int getUniJDBCCPMMinPoolSize() {
        this.value = this.DSProperties.getProperty("IBM_CPM_MIN_POOLSIZE");
        if (this.value == null) {
            this.value = defProp.getProperty("IBM_CPM_MIN_POOLSIZE");
        }
        return Integer.parseInt(this.value);
    }

    public int getMinPoolSize() {
        return this.getUniJDBCCPMMinPoolSize();
    }

    public void setUniJDBCCPMMinAgeLimit(long ageLimit) {
        this.DSProperties.setProperty("IBM_CPM_MIN_AGELIMIT", new Long(ageLimit).toString());
    }

    public long getUniJDBCCPMMinAgeLimit() {
        this.value = this.DSProperties.getProperty("IBM_CPM_MIN_AGELIMIT");
        if (this.value == null) {
            this.value = defProp.getProperty("IBM_CPM_MIN_AGELIMIT");
        }
        return Long.parseLong(this.value);
    }

    public void setUniJDBCCPMAgeLimit(long ageLimit) {
        this.DSProperties.setProperty("IBM_CPM_AGELIMIT", new Long(ageLimit).toString());
    }

    public void setMaxIdleTime(int ageLimit) {
        if (ageLimit == 0) {
            this.setUniJDBCCPMAgeLimit(-1L);
        } else {
            this.setUniJDBCCPMAgeLimit(ageLimit);
        }
    }

    public long getUniJDBCCPMAgeLimit() {
        this.value = this.DSProperties.getProperty("IBM_CPM_AGELIMIT");
        if (this.value == null) {
            this.value = defProp.getProperty("IBM_CPM_AGELIMIT");
        }
        return Long.parseLong(this.value);
    }

    public int getMaxIdleTime() {
        int ageLimit = (int)this.getUniJDBCCPMAgeLimit();
        if (ageLimit == -1) {
            return 0;
        }
        return ageLimit;
    }

    public void setUniJDBCCCPMPCRefreshMode(int method) {
        this.DSProperties.setProperty("IBM_CPM_PC_REFRESH_MODE", new Integer(method).toString());
    }

    public int getUniJDBCCPMPCRefreshMode() {
        this.value = this.DSProperties.getProperty("IBM_CPM_PC_REFRESH_MODE");
        if (this.value == null) {
            this.value = defProp.getProperty("IBM_CPM_PC_REFRESH_MODE");
        }
        return Integer.parseInt(this.value);
    }

    public void setPropertyCycle(int cyc) throws SQLException {
        throw this.mMsgFactory.createException(951014, new Object[]{"setPropertyCycle(int)"});
    }

    public int getPropertyCycle() throws SQLException {
        throw this.mMsgFactory.createException(951014, new Object[]{"getMaxStatements()"});
    }

    public void setUniJDBCCPMServiceInterval(long interval) {
        this.DSProperties.setProperty("IBM_CPM_SERVICE_INTERVAL", new Long(interval).toString());
    }

    public long getUniJDBCCPMServiceInterval() {
        this.value = this.DSProperties.getProperty("IBM_CPM_SERVICE_INTERVAL");
        if (this.value == null) {
            this.value = defProp.getProperty("IBM_CPM_SERVICE_INTERVAL");
        }
        return Long.parseLong(this.value);
    }

    protected boolean checkIsDirect() {
        if (this.isDirectChecked) {
            return this.isDirect;
        }
        String proto = this.DSProperties.getProperty("PROTOCOLCLASS");
        if (proto != null && proto.equalsIgnoreCase("com.informix.jdbc.UniJDBCDirectProtocol")) {
            this.isDirect = true;
        }
        this.isDirectChecked = true;
        return this.isDirect;
    }

    static Class class$(String x$0) {
        try {
            return Class.forName(x$0);
        }
        catch (ClassNotFoundException x$02) {
            throw new NoClassDefFoundError(x$02.getMessage());
        }
    }

    static {
        REFRESH_MODE_REUSE = 1;
        REFRESH_MODE_RECONNECT = 3;
        REFRESH_MODE_THREAD_RECONNECT = 11;
        REFRESH_MODE_DEFAULT = 11;
        defProp = null;
        defProp = new UniJDBCProperties();
        defProp.setProperty("IBM_CPM_MAX_CONNECTIONS", "-1");
        defProp.setProperty("IBM_CPM_INIT_POOLSIZE", "0");
        defProp.setProperty("IBM_CPM_MAX_POOLSIZE", "50");
        defProp.setProperty("IBM_CPM_MIN_POOLSIZE", "0");
        defProp.setProperty("IBM_CPM_MIN_AGELIMIT", "-1");
        defProp.setProperty("IBM_CPM_AGELIMIT", "-1");
        defProp.setProperty("IBM_CPM_SERVICE_INTERVAL", "50");
        defProp.setProperty("IBM_CPM_PC_REFRESH_MODE", new Integer(11).toString());
    }
}

