/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.u2.jdbcx;

import com.ibm.u2.jdbc.UniJDBCConnection;
import com.ibm.u2.jdbc.UniJDBCTrace;
import com.ibm.u2.jdbcx.UniJDBCConnectionPoolManager;
import com.ibm.u2.jdbcx.UniJDBCPooledConnection;
import java.sql.Connection;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;

public class UniJDBCConnectionEventListener
implements ConnectionEventListener {
    private UniJDBCConnectionPoolManager UniJDBCCPM = null;
    private UniJDBCTrace trace = null;

    public void UniJDBCConnectionEventListener() {
        this.UniJDBCCPM = null;
    }

    public void connectionClosed(ConnectionEvent event) {
        UniJDBCPooledConnection pc = (UniJDBCPooledConnection)event.getSource();
        try {
            Connection conn = pc.getConnection();
            this.trace = ((UniJDBCConnection)conn).getTrace();
            if (this.trace.mLevel >= 1) {
                this.trace.writeTrace("UniJDBCConnectionEventListener:connectionClosed(): called.");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.UniJDBCCPM != null) {
            this.UniJDBCCPM.recycleConnection(pc, 0);
        }
        if (this.trace.mLevel >= 1) {
            this.trace.writeTrace("ConnectionEventListener:connectionClosed() exited.");
        }
    }

    public void connectionErrorOccurred(ConnectionEvent event) {
        UniJDBCPooledConnection pc = (UniJDBCPooledConnection)event.getSource();
        try {
            Connection conn = pc.getConnection();
            this.trace = ((UniJDBCConnection)conn).getTrace();
            if (this.trace.mLevel >= 1) {
                this.trace.writeTrace("UniJDBCConnectionEventListener:connectionErrorOccurred(): called.");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.UniJDBCCPM != null) {
            this.UniJDBCCPM.recycleConnection(pc, 1);
        }
        if (this.trace.mLevel >= 1) {
            this.trace.writeTrace("ConnectionEventListener:connectionErrorOccurred() exited.");
        }
    }

    void setParent(UniJDBCConnectionPoolManager cpm) {
        this.UniJDBCCPM = cpm;
    }
}

