/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.u2.jdbc;

import com.ibm.u2.jdbc.UniJDBCConnection;
import com.ibm.u2.jdbc.UniJDBCDATE;
import com.ibm.u2.jdbc.UniJDBCFLOAT;
import com.ibm.u2.jdbc.UniJDBCObject;
import com.ibm.u2.jdbc.UniJDBCObjectBuilder;
import com.ibm.u2.jdbc.UniJDBCTIME;
import com.ibm.u2.jdbc.UniJDBCVARCHAR;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;

public class UnidataObjectBuilder
extends UniJDBCObjectBuilder {
    public UnidataObjectBuilder(UniJDBCConnection connection) {
        super(connection);
    }

    public int toLocalType(int jdbcType) throws SQLException {
        int u2SqlType;
        switch (jdbcType) {
            case -5: 
            case -4: 
            case -3: 
            case -2: 
            case 0: 
            case 93: 
            case 2000: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2005: 
            case 2006: {
                throw this.mMsgFactory.createException(950006);
            }
            case -7: 
            case -6: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                u2SqlType = 6;
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                u2SqlType = 12;
                break;
            }
            case 91: {
                u2SqlType = 9;
                break;
            }
            case 92: {
                u2SqlType = 10;
                break;
            }
            default: {
                u2SqlType = 12;
            }
        }
        return u2SqlType;
    }

    public UniJDBCObject createObject(int localType) {
        UniJDBCObject object;
        switch (localType) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                object = new UniJDBCFLOAT(this.mConnection);
                break;
            }
            case 9: {
                object = new UniJDBCDATE(this.mConnection);
                break;
            }
            case 10: {
                object = new UniJDBCTIME(this.mConnection);
                break;
            }
            default: {
                object = new UniJDBCVARCHAR(this.mConnection);
            }
        }
        return object;
    }

    public UniJDBCObject toJDBCObject(Object x) throws SQLException {
        UniJDBCObject value;
        if (x instanceof String) {
            UniJDBCVARCHAR varchar = new UniJDBCVARCHAR(this.mConnection);
            varchar.fromString((String)x);
            value = varchar;
        } else if (x instanceof Date) {
            UniJDBCDATE date = new UniJDBCDATE(this.mConnection);
            date.fromDate((Date)x);
            value = date;
        } else if (x instanceof Time) {
            UniJDBCTIME time = new UniJDBCTIME(this.mConnection);
            time.fromTime((Time)x);
            value = time;
        } else if (x instanceof BigDecimal) {
            UniJDBCFLOAT dec = new UniJDBCFLOAT(this.mConnection);
            dec.fromDecimal((BigDecimal)x);
            value = dec;
        } else if (x instanceof Long) {
            UniJDBCFLOAT i = new UniJDBCFLOAT(this.mConnection);
            i.fromLong((Long)x);
            value = i;
        } else if (x instanceof Double) {
            UniJDBCFLOAT d = new UniJDBCFLOAT(this.mConnection);
            d.fromDouble((Double)x);
            value = d;
        } else if (x instanceof Float) {
            UniJDBCFLOAT f = new UniJDBCFLOAT(this.mConnection);
            f.fromFloat((Float)x);
            value = f;
        } else if (x instanceof Integer) {
            UniJDBCFLOAT i = new UniJDBCFLOAT(this.mConnection);
            i.fromInt((Integer)x);
            value = i;
        } else if (x instanceof Short) {
            UniJDBCFLOAT i = new UniJDBCFLOAT(this.mConnection);
            i.fromShort((Short)x);
            value = i;
        } else if (x instanceof Byte) {
            UniJDBCFLOAT i = new UniJDBCFLOAT(this.mConnection);
            i.fromByte((Byte)x);
            value = i;
        } else {
            UniJDBCVARCHAR varchar = new UniJDBCVARCHAR(this.mConnection);
            varchar.fromString(x.toString());
            value = varchar;
        }
        return value;
    }

    public UniJDBCObject toJDBCObject(Object object, int u2type) throws SQLException {
        return this.toJDBCObject(object, u2type, -1);
    }

    public UniJDBCObject toJDBCObject(Object object, int u2type, int scale) throws SQLException {
        String str = object.toString();
        UniJDBCObject value = this.createObject(u2type);
        if (scale >= 0) {
            value.setScale(scale);
        }
        value.fromString(str);
        return value;
    }

    public Object toJAVAObject(UniJDBCObject jdbcObject, int targetU2Type, int scale) throws SQLException {
        Object object = null;
        switch (targetU2Type) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                if (jdbcObject.isNull()) break;
                object = new Double(jdbcObject.toDouble());
                break;
            }
            case 9: {
                object = jdbcObject.toDate();
                break;
            }
            case 10: {
                object = jdbcObject.toTime();
                break;
            }
            default: {
                object = jdbcObject.toString();
            }
        }
        return object;
    }
}

