/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.u2.jdbc;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class UniJDBCTrace {
    public static final int LEVEL_NOTRACE = 0;
    public static final int LEVEL_GENERAL = 1;
    public static final int LEVEL_VARIABLE = 2;
    public static final int LEVEL_SVRMSG = 3;
    public static final int LEVEL_SVRDATA = 4;
    public static final int LEVEL_METHOD = 5;
    public int mLevel = 0;
    private String mTraceFileName = null;
    private PrintStream mPrinter = System.out;
    private final int HEX_SIZE = 22;
    private final int HEX_ASCII_SIZE = 16;

    public int setLevel(int newLevel) {
        int oldLevel = this.mLevel;
        this.mLevel = newLevel;
        return oldLevel;
    }

    public int getLevel() {
        return this.mLevel;
    }

    public boolean setTraceFile(String fileName) {
        PrintStream oldPrinter = this.mPrinter;
        try {
            this.mPrinter = new PrintStream(new BufferedOutputStream(new FileOutputStream(fileName, true)), true);
        }
        catch (IOException ioe) {
            this.mPrinter = oldPrinter;
            boolean bl = false;
            return bl;
        }
        if (oldPrinter != System.out) {
            oldPrinter.close();
        }
        this.mTraceFileName = fileName;
        return true;
    }

    public String getTraceFile() {
        return this.mTraceFileName;
    }

    public void writeTrace(String message) {
        if (this.mLevel > 0) {
            this.mPrinter.println(message);
        }
    }

    public void writeTrace(byte[] byteData, char format) {
        this.writeTrace(byteData, 0, format, byteData.length);
    }

    public void writeTrace(byte[] byteData, char format, int size) {
        this.writeTrace(byteData, 0, format, size);
    }

    public void writeTrace(byte[] byteData, int offset, char format, int size) {
        if (this.mLevel <= 0) {
            return;
        }
        int j = 0;
        boolean hexOnly = true;
        StringBuffer strAscii = null;
        StringBuffer strHex = null;
        int bytesDisplayed = 22;
        if (format == 'b' || format == 'B') {
            hexOnly = false;
            bytesDisplayed = 16;
            strAscii = new StringBuffer(bytesDisplayed);
        }
        strHex = new StringBuffer(bytesDisplayed * 4);
        try {
            if (hexOnly) {
                this.mPrinter.println("=================================-========================================");
                this.mPrinter.println("Index:   Hex:");
            } else {
                this.mPrinter.println("========================================================      ================");
                this.mPrinter.println("Index:   Hex:                                                 Ascii:\n");
            }
            if (byteData == null) {
                this.mPrinter.println("   ***** NULL data *****  ");
                return;
            }
            int i = 0;
            while (i < size) {
                Byte byteValue = new Byte(byteData[i + offset]);
                int intValue = byteValue.intValue();
                if (j == 0) {
                    strHex.append("0x");
                    if (i < 16) {
                        strHex.append("000");
                    } else if (i < 256) {
                        strHex.append("00");
                    } else if (i < 4096) {
                        strHex.append("0");
                    }
                    strHex.append(Integer.toHexString(i));
                    strHex.append(":  ");
                }
                if ((intValue &= 0xFF) < 16) {
                    strHex.append("0");
                }
                strHex.append(Integer.toHexString(intValue));
                strHex.append(" ");
                if (!hexOnly) {
                    if ((intValue &= 0xFF) >= 32 && intValue <= 126) {
                        Character charValue = new Character((char)intValue);
                        strAscii.append(charValue.toString());
                    } else {
                        strAscii.append(".");
                    }
                }
                if (j == bytesDisplayed - 1) {
                    this.mPrinter.print(strHex.toString());
                    strHex = new StringBuffer(bytesDisplayed * 4);
                    if (!hexOnly) {
                        this.mPrinter.print("     ");
                        this.mPrinter.print(strAscii.toString());
                        strAscii = new StringBuffer(bytesDisplayed);
                    }
                    this.mPrinter.println("");
                    j = -1;
                }
                ++i;
                ++j;
            }
            if (j > -1) {
                this.mPrinter.print(strHex.toString());
                if (!hexOnly) {
                    while (j < bytesDisplayed) {
                        this.mPrinter.print("   ");
                        ++j;
                    }
                    this.mPrinter.print("     ");
                    this.mPrinter.print(strAscii.toString());
                }
            }
            this.mPrinter.println("");
            if (hexOnly) {
                this.mPrinter.println("==========================================================================");
            } else {
                this.mPrinter.println("==============================================================================");
            }
            this.mPrinter.println("");
        }
        catch (Exception e) {
            System.out.println("Exception in writeTrace...:".concat(String.valueOf(String.valueOf(e))));
        }
    }

    static {
        LEVEL_NOTRACE = 0;
        LEVEL_GENERAL = 1;
        LEVEL_VARIABLE = 2;
        LEVEL_SVRMSG = 3;
        LEVEL_SVRDATA = 4;
        LEVEL_METHOD = 5;
    }
}

