/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.u2.jdbc;

import com.ibm.u2.jdbc.UniJDBCConnection;
import com.ibm.u2.jdbc.UniJDBCObject;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.util.Calendar;

public class UniJDBCTIME
extends UniJDBCObject {
    private Time mValue;

    public UniJDBCTIME(UniJDBCConnection conn) {
        this.initialize(conn, 10);
        this.mValue = null;
    }

    public void fromDatabase(byte[] dbValue) {
        String s;
        if (!this.mConnection.isNullValue(dbValue) && (s = this.mConnection.decodeBytes(dbValue)) != null) {
            try {
                int time = Integer.parseInt(s);
                int hour = time / 3600;
                int minute = time % 3600 / 60;
                int second = time % 3600 % 60;
                String ts = this.timeToString(hour, minute, second);
                this.mValue = Time.valueOf(ts);
                this.unnullify();
                return;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.nullify();
        this.mValue = null;
    }

    public byte[] toDatabase() {
        if (this.isNull()) {
            return this.mConnection.getNullDatabaseValue();
        }
        String ts = this.toString();
        if (!this.mConnection.isUniverse()) {
            return this.mConnection.encodeString(ts);
        }
        int hour = Integer.parseInt(ts.substring(0, 2));
        int minute = Integer.parseInt(ts.substring(3, 5));
        int second = Integer.parseInt(ts.substring(6, 8));
        int tm = hour * 3600 + minute * 60 + second;
        String dbStr = new Integer(tm).toString();
        return this.mConnection.encodeString(dbStr);
    }

    public String toString() {
        if (this.isNull()) {
            return this.mConnection.getNullDisplay();
        }
        return this.mValue.toString();
    }

    private String timeToString(int hour, int minute, int second) {
        StringBuffer sb = new StringBuffer(16);
        if (hour < 10) {
            sb.append("0").append(hour);
        } else {
            sb.append(hour);
        }
        sb.append(":");
        if (minute < 10) {
            sb.append("0").append(minute);
        } else {
            sb.append(minute);
        }
        sb.append(":");
        if (second < 10) {
            sb.append("0").append(second);
        } else {
            sb.append(second);
        }
        return sb.toString();
    }

    public Date toDate() {
        return new Date(this.mValue.getTime());
    }

    public Time toTime() {
        return this.mValue;
    }

    public Object toObject() {
        return this.toTime();
    }

    public void fromString(String s) {
        this.mValue = Time.valueOf(s);
        this.unnullify();
    }

    public void fromLong(long l) throws SQLException {
        this.mValue = new Time(l);
        this.unnullify();
    }

    public void fromLong(Long l) throws SQLException {
        this.mValue = new Time(l);
        this.unnullify();
    }

    public void fromTime(Time time) throws SQLException {
        this.mValue = (Time)time.clone();
        this.unnullify();
    }

    public void fromTime(Time time, Calendar c) throws SQLException {
        this.mValue = (Time)time.clone();
        this.unnullify();
    }
}

