/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.u2.jdbc;

import com.ibm.u2.jdbc.UniJDBCConnection;
import com.ibm.u2.jdbc.UniJDBCMsgFactory;
import com.ibm.u2.jdbc.UniJDBCParameter;
import com.ibm.u2.jdbc.UniJDBCProtocol;
import com.ibm.u2.jdbc.UniJDBCResultSet;
import com.ibm.u2.jdbc.UniJDBCResultSetImpl;
import com.ibm.u2.jdbc.UniJDBCStatement;
import com.ibm.u2.jdbc.UniJDBCTrace;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;

public class UniJDBCStatementImpl
implements UniJDBCStatement {
    protected UniJDBCConnection mConnection;
    protected UniJDBCProtocol mProtocol;
    private SQLWarning mStmtWarnings = null;
    private boolean mInternalStmtFlag = false;
    protected int mStatementType;
    protected UniJDBCParameter[] mParameters;
    protected boolean mCursorOpen = false;
    protected String mCursorName = null;
    protected String mCommandString = null;
    protected boolean mEscapeProcessing = true;
    protected UniJDBCResultSet mSavedResult = null;
    protected int mNumQMarks = 0;
    protected int mUpdateCount = -1;
    protected boolean mResultSetReturned = true;
    protected boolean mClosed = false;
    protected UniJDBCMsgFactory mMsgFactory;
    protected UniJDBCTrace mTrace;
    private int mMaxFileds = 0;
    private int mMaxRows = 0;

    protected void notSupport() throws SQLException {
        throw this.mMsgFactory.createException(951007);
    }

    public UniJDBCStatementImpl(UniJDBCConnection parentConnection) throws SQLException {
        this.mConnection = parentConnection;
        this.mProtocol = parentConnection.createProtocol();
        this.mMsgFactory = parentConnection.getMsgFactory();
        this.mTrace = parentConnection.getTrace();
        this.mSavedResult = new UniJDBCResultSetImpl(this);
    }

    public String getCommandString() {
        return this.mCommandString;
    }

    public UniJDBCConnection getUniJDBCConnection() {
        return this.mConnection;
    }

    public void markInternalStatement(boolean flag) {
        this.mInternalStmtFlag = flag;
    }

    public boolean isInternalStatement() {
        return this.mInternalStmtFlag;
    }

    public UniJDBCProtocol getUniJDBCProtocol() {
        return this.mProtocol;
    }

    public int getqmarks() {
        return this.mNumQMarks;
    }

    public void setqmarks(int count) {
        this.mNumQMarks = count;
        this.mParameters = count == 0 ? null : new UniJDBCParameter[count];
    }

    public int getStatementType() {
        return this.mStatementType;
    }

    public String getCursorName() {
        return this.mCursorName;
    }

    public boolean isCursorOpen() {
        return this.mCursorOpen;
    }

    public synchronized void closeCursor() throws SQLException {
        if (this.mTrace.mLevel >= 5) {
            this.mTrace.writeTrace("UniJDBCStatement#closeCursor():enter".concat(String.valueOf(String.valueOf(this))));
        }
        if (this.mClosed) {
            throw this.mMsgFactory.createException(951000);
        }
        if (this.mCursorOpen) {
            if (this.mTrace.mLevel >= 5) {
                this.mTrace.writeTrace(String.valueOf(String.valueOf(new StringBuffer("UniJDBCStatement#closeCursor():to executeClose() on protocol").append(this).append(", and set mCursorOpen to false."))));
            }
            this.mProtocol.executeClose(this);
            this.mCursorOpen = false;
        }
        if (this.mTrace.mLevel >= 5) {
            this.mTrace.writeTrace("UniJDBCStatement#closeCursor():leave".concat(String.valueOf(String.valueOf(this))));
        }
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        if (this.mClosed) {
            throw this.mMsgFactory.createException(951000);
        }
        if (this.mCursorOpen) {
            this.mProtocol.executeClose(this);
            this.mCursorOpen = false;
        }
        this.mCommandString = this.mEscapeProcessing ? this.mConnection.nativeSQL(sql) : sql;
        this.mProtocol.executeStatementQuery(this);
        this.mCursorOpen = true;
        this.mSavedResult.reset();
        return this.mSavedResult;
    }

    public int executeUpdate(String sql) throws SQLException {
        if (this.mClosed) {
            throw this.mMsgFactory.createException(951000);
        }
        if (this.mCursorOpen) {
            this.mProtocol.executeClose(this);
            this.mCursorOpen = false;
        }
        this.mCommandString = this.mEscapeProcessing ? this.mConnection.nativeSQL(sql) : sql;
        this.mProtocol.executeStatementQuery(this);
        this.mCursorOpen = true;
        this.mSavedResult.reset();
        if (this.mProtocol.getStatementType() == 3) {
            return this.mProtocol.getUpdateCount();
        }
        return -1;
    }

    public void close() throws SQLException {
        if (this.mTrace.mLevel >= 5) {
            this.mTrace.writeTrace("UniJDBCStatement#close():enter".concat(String.valueOf(String.valueOf(this))));
        }
        if (this.mClosed) {
            throw this.mMsgFactory.createException(951000);
        }
        if (this.mCursorOpen) {
            this.mProtocol.executeClose(this);
            this.mCursorOpen = false;
        }
        this.mSavedResult.markClosed();
        this.mConnection.removeFromStmtList(this);
        this.mClosed = true;
        if (this.mTrace.mLevel >= 5) {
            this.mTrace.writeTrace("UniJDBCStatement#close():leave");
        }
    }

    public int getMaxFieldSize() throws SQLException {
        return this.mMaxFileds;
    }

    public void setMaxFieldSize(int max) throws SQLException {
        this.mMaxFileds = max;
    }

    public int getMaxRows() throws SQLException {
        return this.mMaxRows;
    }

    public void setMaxRows(int max) throws SQLException {
        this.mMaxRows = max;
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.mEscapeProcessing = enable;
    }

    public int getQueryTimeout() throws SQLException {
        return 0;
    }

    public void setQueryTimeout(int seconds) throws SQLException {
    }

    public void cancel() throws SQLException {
        if (this.mClosed) {
            throw this.mMsgFactory.createException(951000);
        }
        if (this.mCursorOpen) {
            this.mProtocol.executeCancel();
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        SQLWarning resultWarn;
        if (this.mSavedResult != null && (resultWarn = this.mSavedResult.getWarnings()) != null) {
            this.addWarning(resultWarn);
            this.mSavedResult.clearWarnings();
        }
        return this.mStmtWarnings;
    }

    public void clearWarnings() throws SQLException {
        if (this.mSavedResult != null) {
            this.mSavedResult.clearWarnings();
        }
        this.mStmtWarnings = null;
    }

    private void addWarning(SQLWarning warn) {
        if (this.mStmtWarnings == null) {
            this.mStmtWarnings = warn;
        } else {
            SQLWarning prev = this.mStmtWarnings;
            while (prev.getNextWarning() != null) {
                prev = prev.getNextWarning();
            }
            prev.setNextWarning(warn);
        }
    }

    public void setCursorName(String name) throws SQLException {
        this.mCursorName = name;
    }

    public boolean execute(String sql) throws SQLException {
        if (this.mClosed) {
            throw this.mMsgFactory.createException(951000);
        }
        if (this.mCursorOpen) {
            this.mProtocol.executeClose(this);
            this.mCursorOpen = false;
        }
        this.mCommandString = this.mEscapeProcessing ? this.mConnection.nativeSQL(sql) : sql;
        this.mProtocol.executeStatementQuery(this);
        int stmtType = this.mProtocol.getStatementType();
        if (stmtType == 2) {
            this.mResultSetReturned = false;
            this.mCursorOpen = true;
            return true;
        }
        if (stmtType == 3) {
            this.mUpdateCount = this.mProtocol.getUpdateCount();
            this.mCursorOpen = true;
        } else if (stmtType == 1 && this.mConnection.isUniverse()) {
            this.mResultSetReturned = false;
            this.mCursorOpen = true;
            return true;
        }
        return false;
    }

    public ResultSet getResultSet() throws SQLException {
        if (this.mClosed) {
            throw this.mMsgFactory.createException(951000);
        }
        if (!this.mCursorOpen) {
            throw this.mMsgFactory.createException(951001);
        }
        if (!this.mResultSetReturned) {
            this.mResultSetReturned = true;
            return this.mSavedResult;
        }
        return null;
    }

    public int getUpdateCount() throws SQLException {
        if (this.mClosed) {
            throw this.mMsgFactory.createException(951000);
        }
        int tmp = this.mUpdateCount;
        return tmp;
    }

    public boolean getMoreResults() throws SQLException {
        if (this.mClosed) {
            throw this.mMsgFactory.createException(951000);
        }
        if (this.mCursorOpen && !this.mResultSetReturned) {
            this.mResultSetReturned = true;
            return true;
        }
        return false;
    }

    public void setFetchDirection(int direction) throws SQLException {
        if (direction != 1000) {
            throw this.mMsgFactory.createException(950002);
        }
    }

    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    public int getFetchSize() throws SQLException {
        return 0;
    }

    public void setFetchSize(int size) throws SQLException {
    }

    public int getResultSetConcurrency() throws SQLException {
        if (this.mClosed) {
            throw this.mMsgFactory.createException(951000);
        }
        if (!this.mCursorOpen) {
            throw this.mMsgFactory.createException(951001);
        }
        return 1007;
    }

    public int getResultSetType() throws SQLException {
        if (this.mClosed) {
            throw this.mMsgFactory.createException(951000);
        }
        if (!this.mCursorOpen) {
            throw this.mMsgFactory.createException(951001);
        }
        return 1003;
    }

    public void addBatch(String sql) throws SQLException {
        this.notSupport();
    }

    public void clearBatch() throws SQLException {
        this.notSupport();
    }

    public int[] executeBatch() throws SQLException {
        this.notSupport();
        return null;
    }

    public Connection getConnection() throws SQLException {
        if (this.mClosed) {
            throw this.mMsgFactory.createException(951000);
        }
        return this.mConnection;
    }
}

