/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.u2.jdbc;

import com.ibm.u2.jdbc.UniJDBCConnection;
import com.ibm.u2.jdbc.UniJDBCObject;
import java.math.BigDecimal;
import java.sql.SQLException;

public class UniJDBCSMALLINT
extends UniJDBCObject {
    private short mValue;

    public UniJDBCSMALLINT(UniJDBCConnection conn) {
        this.initialize(conn, 5);
        this.mValue = 0;
    }

    public UniJDBCSMALLINT(UniJDBCConnection conn, short value) {
        this.initialize(conn, 5);
        this.mValue = value;
        this.unnullify();
    }

    public void fromDatabase(byte[] dbValue) {
        String s;
        if (!this.mConnection.isNullValue(dbValue) && (s = this.mConnection.decodeBytes(dbValue)) != null) {
            try {
                this.mValue = Short.parseShort(s);
                this.unnullify();
                return;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.mValue = 0;
        this.nullify();
    }

    public byte[] toDatabase() {
        if (this.isNull()) {
            return this.mConnection.getNullDatabaseValue();
        }
        return this.mConnection.encodeString(new Short(this.mValue).toString());
    }

    public String toString() {
        if (this.isNull()) {
            return this.mConnection.getNullDisplay();
        }
        return new Short(this.mValue).toString();
    }

    public int toInt() throws SQLException {
        return this.mValue;
    }

    public boolean toBoolean() throws SQLException {
        return this.mValue != 0;
    }

    public float toFloat() throws SQLException {
        return this.mValue;
    }

    public short toShort() throws SQLException {
        return this.mValue;
    }

    public long toLong() throws SQLException {
        return this.mValue;
    }

    public double toDouble() throws SQLException {
        return this.mValue;
    }

    public BigDecimal toDecimal() {
        if (this.isNull()) {
            return null;
        }
        BigDecimal d = new BigDecimal((double)this.mValue);
        return d;
    }

    public BigDecimal toDecimal(int scale) {
        if (this.isNull()) {
            return null;
        }
        BigDecimal d = new BigDecimal((double)this.mValue);
        d.setScale(scale, 4);
        return d;
    }

    public Object toObject() {
        if (this.isNull()) {
            return null;
        }
        return new Integer(this.mValue);
    }

    public void fromInt(int i) throws SQLException {
        this.mValue = (short)i;
        this.unnullify();
    }

    public void fromInt(Integer I) throws SQLException {
        if (I == null) {
            this.mValue = 0;
            this.nullify();
        } else {
            this.mValue = (short)I.intValue();
            this.unnullify();
        }
    }

    public void fromString(String S) throws SQLException {
        if (S == null) {
            this.mValue = 0;
            this.nullify();
        } else {
            try {
                this.mValue = Short.parseShort(S);
            }
            catch (NumberFormatException nfe) {
                throw this.mMsgFactory.createException(951025);
            }
            this.unnullify();
        }
    }

    public void fromDecimal(BigDecimal B) throws SQLException {
        if (B == null) {
            this.mValue = 0;
            this.nullify();
        } else {
            this.mValue = B.shortValue();
            this.unnullify();
        }
    }

    public void fromDecimal(BigDecimal B, int scale) throws SQLException {
        if (B == null) {
            this.mValue = 0;
            this.nullify();
        } else {
            this.mValue = B.shortValue();
            this.unnullify();
        }
    }

    public void fromByte(byte b) throws SQLException {
        this.mValue = b;
        this.unnullify();
    }

    public void fromByte(Byte B) throws SQLException {
        if (B == null) {
            this.mValue = 0;
            this.nullify();
        } else {
            this.mValue = B.byteValue();
            this.unnullify();
        }
    }

    public void fromBoolean(boolean b) throws SQLException {
        this.mValue = b ? (short)0 : 1;
        this.unnullify();
    }

    public void fromBoolean(Boolean B) throws SQLException {
        if (B == null) {
            this.mValue = 0;
            this.nullify();
        } else {
            this.mValue = B != false ? (short)0 : 1;
            this.unnullify();
        }
    }

    public void fromFloat(float f) throws SQLException {
        this.mValue = (short)f;
        this.unnullify();
    }

    public void fromFloat(Float F) throws SQLException {
        if (F == null) {
            this.mValue = 0;
            this.nullify();
        } else {
            this.mValue = (short)F.floatValue();
            this.unnullify();
        }
    }

    public void fromLong(long l) throws SQLException {
        this.mValue = (short)l;
        this.unnullify();
    }

    public void fromLong(Long L) throws SQLException {
        if (L == null) {
            this.mValue = 0;
            this.nullify();
        } else {
            this.mValue = (short)L.longValue();
            this.unnullify();
        }
    }

    public void fromShort(short s) throws SQLException {
        this.mValue = s;
        this.unnullify();
    }

    public void fromShort(Short S) throws SQLException {
        if (S == null) {
            this.mValue = 0;
            this.nullify();
        } else {
            this.mValue = S;
            this.unnullify();
        }
    }

    public void fromDouble(double d) throws SQLException {
        this.mValue = (short)d;
        this.unnullify();
    }

    public void fromShort(Double D) throws SQLException {
        if (D == null) {
            this.mValue = 0;
            this.nullify();
        } else {
            this.mValue = (short)D.doubleValue();
            this.unnullify();
        }
    }
}

