/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.u2.jdbc;

import com.ibm.u2.jdbc.UniJDBCColumnDesc;
import com.ibm.u2.jdbc.UniJDBCConnection;
import com.ibm.u2.jdbc.UniJDBCMsgFactory;
import com.ibm.u2.jdbc.UniJDBCObjectBuilder;
import com.ibm.u2.jdbc.UniJDBCResultSetMetaData;
import java.sql.SQLException;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public class UniJDBCResultSetMetaDataImpl
implements UniJDBCResultSetMetaData {
    private Vector mColumnList;
    private int mNumberOfColumns;
    private UniJDBCConnection mConnection;
    private UniJDBCMsgFactory mMsgFactory;
    private UniJDBCObjectBuilder mObjectBuilder;

    public UniJDBCResultSetMetaDataImpl(UniJDBCConnection connection, Vector columnDescList) {
        this.mConnection = connection;
        this.mMsgFactory = connection.getMsgFactory();
        this.mObjectBuilder = connection.getObjectBuilder();
        this.mColumnList = columnDescList;
        this.mNumberOfColumns = columnDescList.size();
    }

    public UniJDBCResultSetMetaDataImpl(UniJDBCConnection connection, String resourceName) throws SQLException {
        this.mConnection = connection;
        this.mMsgFactory = connection.getMsgFactory();
        try {
            ResourceBundle rb = ResourceBundle.getBundle(resourceName);
            this.loadColumns(rb);
        }
        catch (MissingResourceException mre) {
            throw this.mMsgFactory.createException(951072, new Object[]{resourceName});
        }
    }

    private void loadColumns(ResourceBundle rb) throws SQLException {
        Vector<UniJDBCColumnDesc> vec = new Vector<UniJDBCColumnDesc>();
        try {
            String cols = rb.getString("columns");
            StringTokenizer tok = new StringTokenizer(cols, ", ;");
            while (tok.hasMoreTokens()) {
                String columnName = tok.nextToken();
                UniJDBCColumnDesc cdesc = new UniJDBCColumnDesc(rb, columnName);
                vec.addElement(cdesc);
            }
        }
        catch (MissingResourceException mre) {
            throw this.mMsgFactory.createException(951073);
        }
        this.mColumnList = vec;
        this.mNumberOfColumns = vec.size();
    }

    public UniJDBCColumnDesc getColumnInfo(int columnIndex) throws SQLException {
        if (columnIndex < 1 || columnIndex > this.mNumberOfColumns) {
            throw this.mMsgFactory.createException(951054, new Object[]{new Integer(columnIndex)});
        }
        return (UniJDBCColumnDesc)this.mColumnList.elementAt(columnIndex - 1);
    }

    public UniJDBCColumnDesc getColumnInfo(String aName) throws SQLException {
        for (int i = 0; i < this.mNumberOfColumns; ++i) {
            UniJDBCColumnDesc column = (UniJDBCColumnDesc)this.mColumnList.elementAt(i);
            if (!column.name.equals(aName)) continue;
            return column;
        }
        throw this.mMsgFactory.createException(951055, new Object[]{aName});
    }

    public int getColumnIndex(String aName) throws SQLException {
        for (int i = 0; i < this.mNumberOfColumns; ++i) {
            UniJDBCColumnDesc column = (UniJDBCColumnDesc)this.mColumnList.elementAt(i);
            if (!column.name.equals(aName)) continue;
            return i + 1;
        }
        throw this.mMsgFactory.createException(951055, new Object[]{aName});
    }

    public int getColumnCount() throws SQLException {
        return this.mNumberOfColumns;
    }

    public boolean isAutoIncrement(int columnIndex) throws SQLException {
        UniJDBCColumnDesc column = this.getColumnInfo(columnIndex);
        return column.autoInc != 0;
    }

    public boolean isCaseSensitive(int columnIndex) throws SQLException {
        UniJDBCColumnDesc column = this.getColumnInfo(columnIndex);
        return this.mObjectBuilder.isLocalTypeCaseSensitive(column.sqlType);
    }

    public boolean isSearchable(int columnIndex) throws SQLException {
        UniJDBCColumnDesc column = this.getColumnInfo(columnIndex);
        return column.searchable != 0;
    }

    public boolean isCurrency(int columnIndex) throws SQLException {
        UniJDBCColumnDesc column = this.getColumnInfo(columnIndex);
        return false;
    }

    public int isNullable(int columnIndex) throws SQLException {
        UniJDBCColumnDesc column = this.getColumnInfo(columnIndex);
        return column.nullable;
    }

    public boolean isSigned(int columnIndex) throws SQLException {
        UniJDBCColumnDesc column = this.getColumnInfo(columnIndex);
        return this.mObjectBuilder.isLocalTypeSigned(column.sqlType);
    }

    public int getColumnDisplaySize(int columnIndex) throws SQLException {
        UniJDBCColumnDesc column = this.getColumnInfo(columnIndex);
        return column.displaySize;
    }

    public String getColumnLabel(int columnIndex) throws SQLException {
        UniJDBCColumnDesc column = this.getColumnInfo(columnIndex);
        return column.label;
    }

    public String getColumnName(int columnIndex) throws SQLException {
        UniJDBCColumnDesc column = this.getColumnInfo(columnIndex);
        if (column.label != "") {
            return column.label;
        }
        return column.name;
    }

    public String getSchemaName(int columnIndex) throws SQLException {
        UniJDBCColumnDesc column = this.getColumnInfo(columnIndex);
        return "SCHEM";
    }

    public int getPrecision(int columnIndex) throws SQLException {
        UniJDBCColumnDesc column = this.getColumnInfo(columnIndex);
        return column.precision;
    }

    public int getScale(int columnIndex) throws SQLException {
        UniJDBCColumnDesc column = this.getColumnInfo(columnIndex);
        int scale = this.mObjectBuilder.getLocalTypeScale(column.sqlType);
        if (scale > 0) {
            return scale;
        }
        return column.scale;
    }

    public String getTableName(int columnIndex) throws SQLException {
        UniJDBCColumnDesc column = this.getColumnInfo(columnIndex);
        return column.table;
    }

    public String getCatalogName(int columnIndex) throws SQLException {
        UniJDBCColumnDesc column = this.getColumnInfo(columnIndex);
        return "";
    }

    public int getColumnType(int columnIndex) throws SQLException {
        UniJDBCColumnDesc column = this.getColumnInfo(columnIndex);
        return this.mObjectBuilder.toSQLType(column.sqlType);
    }

    public String getColumnTypeName(int columnIndex) throws SQLException {
        UniJDBCColumnDesc column = this.getColumnInfo(columnIndex);
        return this.mObjectBuilder.getLocalTypeName(column.sqlType);
    }

    public boolean isReadOnly(int columnIndex) throws SQLException {
        UniJDBCColumnDesc column = this.getColumnInfo(columnIndex);
        return column.updatable == 0;
    }

    public boolean isWritable(int columnIndex) throws SQLException {
        UniJDBCColumnDesc column = this.getColumnInfo(columnIndex);
        return column.updatable != 0;
    }

    public boolean isDefinitelyWritable(int columnIndex) throws SQLException {
        UniJDBCColumnDesc column = this.getColumnInfo(columnIndex);
        return column.updatable != 0;
    }

    public String getColumnClassName(int columnIndex) throws SQLException {
        UniJDBCColumnDesc column = this.getColumnInfo(columnIndex);
        throw this.mMsgFactory.createException(930014);
    }
}

