/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.u2.jdbc;

import com.ibm.u2.jdbc.UniJDBCConnection;
import com.ibm.u2.jdbc.UniJDBCMsgFactory;
import com.ibm.u2.jdbc.UniJDBCObject;
import com.ibm.u2.jdbc.UniJDBCProtocol;
import com.ibm.u2.jdbc.UniJDBCResultSet;
import com.ibm.u2.jdbc.UniJDBCStatement;
import com.ibm.u2.jdbc.UniJDBCTrace;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class UniJDBCResultSetImpl
implements UniJDBCResultSet {
    protected UniJDBCConnection mConnection;
    protected UniJDBCObject mLastColumn = null;
    protected UniJDBCTrace mTrace;
    protected UniJDBCMsgFactory mMsgFactory;
    private UniJDBCStatement mStatement;
    private UniJDBCProtocol mProtocol;
    private SQLWarning mResultWarnings;
    private boolean mIsOpen;
    private boolean mHasNextRow;
    private int mRowCount;

    public UniJDBCResultSetImpl(UniJDBCStatement statement) throws SQLException {
        this.mConnection = statement.getUniJDBCConnection();
        this.mStatement = statement;
        this.mProtocol = statement.getUniJDBCProtocol();
        this.mIsOpen = true;
        this.mHasNextRow = false;
        this.mRowCount = 0;
        this.mTrace = this.mConnection.getTrace();
        this.mMsgFactory = this.mConnection.getMsgFactory();
    }

    public UniJDBCResultSetImpl(UniJDBCConnection connection) {
        this.mConnection = connection;
        this.mStatement = null;
        this.mProtocol = null;
        this.mIsOpen = true;
        this.mHasNextRow = false;
        this.mRowCount = 0;
        this.mTrace = connection.getTrace();
    }

    public UniJDBCStatement getUniJDBCStatement() {
        return this.mStatement;
    }

    public synchronized void reset() {
        this.mIsOpen = true;
        this.mHasNextRow = false;
        this.mRowCount = 0;
    }

    public synchronized void markClosed() {
        this.mIsOpen = false;
    }

    private void notSupport() throws SQLException {
        throw this.mMsgFactory.createException(951016);
    }

    protected void getColumnValue(int columnIndex) throws SQLException {
        if (!this.mIsOpen) {
            throw this.mMsgFactory.createException(951053);
        }
        if (!this.mHasNextRow) {
            throw this.mMsgFactory.createException(951051);
        }
        this.mLastColumn = this.mProtocol.getColumnValue(columnIndex);
    }

    protected void getColumnValue(String columnName) throws SQLException {
        if (!this.mIsOpen) {
            throw this.mMsgFactory.createException(951053);
        }
        if (!this.mHasNextRow) {
            throw this.mMsgFactory.createException(951051);
        }
        int columnIndex = this.mProtocol.getColumnIndex(columnName);
        this.mLastColumn = this.mProtocol.getColumnValue(columnIndex);
    }

    public boolean next() throws SQLException {
        if (!this.mIsOpen) {
            if (this.mTrace.mLevel >= 1) {
                this.mTrace.writeTrace("ResultSet is closed. return false.");
            }
            throw this.mMsgFactory.createException(951053);
        }
        int max = this.mStatement.getMaxRows();
        if (max > 0 && this.mRowCount >= max) {
            if (this.mTrace.mLevel >= 2) {
                this.mTrace.writeTrace("ResultSet:over-maximum rows. return false.");
            }
            return false;
        }
        this.mHasNextRow = this.mProtocol.nextRow();
        if (this.mHasNextRow) {
            ++this.mRowCount;
        }
        if (this.mTrace.mLevel >= 2) {
            this.mTrace.writeTrace(String.valueOf(String.valueOf(new StringBuffer("mHasNextRow=").append(this.mHasNextRow).append(",mRowCount=").append(this.mRowCount))));
        }
        return this.mHasNextRow;
    }

    public void close() throws SQLException {
        if (this.mTrace.mLevel >= 5) {
            this.mTrace.writeTrace("UniJDBCResultSetImpl#close():enter".concat(String.valueOf(String.valueOf(this))));
        }
        if (!this.mIsOpen) {
            throw this.mMsgFactory.createException(951053);
        }
        if (this.mStatement != null && this.mStatement.isInternalStatement()) {
            if (this.mTrace.mLevel >= 2) {
                this.mTrace.writeTrace("UniJDBCResultSetImpl#Internal-statement-detected:call mStatement.close():".concat(String.valueOf(String.valueOf(this))));
            }
            this.mStatement.close();
        } else {
            if (this.mTrace.mLevel >= 2) {
                this.mTrace.writeTrace("UniJDBCResultSetImpl#close():set mIsOpen to flase for rs:".concat(String.valueOf(String.valueOf(this))));
            }
            this.mIsOpen = false;
        }
        if (this.mTrace.mLevel >= 5) {
            this.mTrace.writeTrace("UniJDBCResultSetImpl#close():leave".concat(String.valueOf(String.valueOf(this))));
        }
    }

    public boolean wasNull() throws SQLException {
        if (!this.mIsOpen) {
            throw this.mMsgFactory.createException(951053);
        }
        if (this.mLastColumn == null) {
            return false;
        }
        return this.mLastColumn.isNull();
    }

    public String getString(int columnIndex) throws SQLException {
        this.getColumnValue(columnIndex);
        String ret = this.mLastColumn.toString();
        if (this.mTrace.mLevel >= 2) {
            this.mTrace.writeTrace(String.valueOf(String.valueOf(new StringBuffer("getString(").append(columnIndex).append(") returns '").append(ret).append("'"))));
        }
        return ret;
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        this.getColumnValue(columnIndex);
        return this.mLastColumn.toBoolean();
    }

    public byte getByte(int columnIndex) throws SQLException {
        this.getColumnValue(columnIndex);
        return this.mLastColumn.toByte();
    }

    public short getShort(int columnIndex) throws SQLException {
        this.getColumnValue(columnIndex);
        return this.mLastColumn.toShort();
    }

    public int getInt(int columnIndex) throws SQLException {
        this.getColumnValue(columnIndex);
        return this.mLastColumn.toInt();
    }

    public long getLong(int columnIndex) throws SQLException {
        this.getColumnValue(columnIndex);
        return this.mLastColumn.toLong();
    }

    public float getFloat(int columnIndex) throws SQLException {
        this.getColumnValue(columnIndex);
        return this.mLastColumn.toFloat();
    }

    public double getDouble(int columnIndex) throws SQLException {
        this.getColumnValue(columnIndex);
        return this.mLastColumn.toDouble();
    }

    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        this.getColumnValue(columnIndex);
        return this.mLastColumn.toDecimal(scale);
    }

    public byte[] getBytes(int columnIndex) throws SQLException {
        this.getColumnValue(columnIndex);
        return this.mLastColumn.toBytes();
    }

    public Date getDate(int columnIndex) throws SQLException {
        this.getColumnValue(columnIndex);
        return this.mLastColumn.toDate();
    }

    public Time getTime(int columnIndex) throws SQLException {
        this.getColumnValue(columnIndex);
        return this.mLastColumn.toTime();
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        this.getColumnValue(columnIndex);
        return this.mLastColumn.toTimestamp();
    }

    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        this.getColumnValue(columnIndex);
        return this.mLastColumn.toAsciiStream();
    }

    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        this.getColumnValue(columnIndex);
        return this.mLastColumn.toUnicodeStream();
    }

    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        this.getColumnValue(columnIndex);
        return this.mLastColumn.toBinaryStream();
    }

    public Statement getStatement() throws SQLException {
        return this.mStatement;
    }

    public String getString(String columnName) throws SQLException {
        this.getColumnValue(columnName);
        String ret = this.mLastColumn.toString();
        if (this.mTrace.mLevel >= 2) {
            this.mTrace.writeTrace(String.valueOf(String.valueOf(new StringBuffer("getString('").append(columnName).append("') returns '").append(ret).append("'"))));
        }
        return ret;
    }

    public boolean getBoolean(String columnName) throws SQLException {
        this.getColumnValue(columnName);
        return this.mLastColumn.toBoolean();
    }

    public byte getByte(String columnName) throws SQLException {
        this.getColumnValue(columnName);
        return this.mLastColumn.toByte();
    }

    public short getShort(String columnName) throws SQLException {
        this.getColumnValue(columnName);
        return this.mLastColumn.toShort();
    }

    public int getInt(String columnName) throws SQLException {
        this.getColumnValue(columnName);
        return this.mLastColumn.toInt();
    }

    public long getLong(String columnName) throws SQLException {
        this.getColumnValue(columnName);
        return this.mLastColumn.toLong();
    }

    public float getFloat(String columnName) throws SQLException {
        this.getColumnValue(columnName);
        return this.mLastColumn.toFloat();
    }

    public double getDouble(String columnName) throws SQLException {
        this.getColumnValue(columnName);
        return this.mLastColumn.toDouble();
    }

    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        this.getColumnValue(columnName);
        return this.mLastColumn.toDecimal(scale);
    }

    public byte[] getBytes(String columnName) throws SQLException {
        this.getColumnValue(columnName);
        return this.mLastColumn.toBytes();
    }

    public Date getDate(String columnName) throws SQLException {
        this.getColumnValue(columnName);
        return this.mLastColumn.toDate();
    }

    public Time getTime(String columnName) throws SQLException {
        this.getColumnValue(columnName);
        return this.mLastColumn.toTime();
    }

    public Timestamp getTimestamp(String columnName) throws SQLException {
        this.getColumnValue(columnName);
        return this.mLastColumn.toTimestamp();
    }

    public InputStream getAsciiStream(String columnName) throws SQLException {
        this.getColumnValue(columnName);
        return this.mLastColumn.toAsciiStream();
    }

    public InputStream getUnicodeStream(String columnName) throws SQLException {
        this.getColumnValue(columnName);
        return this.mLastColumn.toUnicodeStream();
    }

    public InputStream getBinaryStream(String columnName) throws SQLException {
        this.getColumnValue(columnName);
        return this.mLastColumn.toBinaryStream();
    }

    public SQLWarning getWarnings() throws SQLException {
        SQLWarning protWarn;
        if (!this.mIsOpen) {
            throw this.mMsgFactory.createException(951053);
        }
        if (this.mProtocol != null && (protWarn = this.mProtocol.getWarnings()) != null) {
            this.addWarning(protWarn);
            this.mProtocol.clearWarnings();
        }
        return this.mResultWarnings;
    }

    public void clearWarnings() throws SQLException {
        if (!this.mIsOpen) {
            throw this.mMsgFactory.createException(951053);
        }
        this.mResultWarnings = null;
    }

    private void addWarning(SQLWarning warn) {
        if (this.mResultWarnings == null) {
            this.mResultWarnings = warn;
        } else {
            SQLWarning prev = this.mResultWarnings;
            while (prev.getNextWarning() != null) {
                prev = prev.getNextWarning();
            }
            prev.setNextWarning(warn);
        }
    }

    public String getCursorName() throws SQLException {
        if (!this.mIsOpen) {
            throw this.mMsgFactory.createException(951053);
        }
        return null;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        if (!this.mIsOpen) {
            throw this.mMsgFactory.createException(951053);
        }
        return this.mProtocol.getResultSetMetaData();
    }

    public Object getObject(int columnIndex) throws SQLException {
        this.getColumnValue(columnIndex);
        return this.mLastColumn.toObject();
    }

    public int findColumn(String columnName) throws SQLException {
        if (!this.mIsOpen) {
            throw this.mMsgFactory.createException(951053);
        }
        return this.mProtocol.getColumnIndex(columnName);
    }

    public Object getObject(String columnName) throws SQLException {
        this.getColumnValue(columnName);
        return this.mLastColumn.toObject();
    }

    public Reader getCharacterStream(int columnIndex) throws SQLException {
        this.notSupport();
        return null;
    }

    public Reader getCharacterStream(String columnName) throws SQLException {
        this.notSupport();
        return null;
    }

    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.getColumnValue(columnIndex);
        return this.mLastColumn.toDecimal();
    }

    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        this.getColumnValue(columnName);
        return this.mLastColumn.toDecimal();
    }

    public boolean isBeforeFirst() throws SQLException {
        this.notSupport();
        return false;
    }

    public boolean isAfterLast() throws SQLException {
        this.notSupport();
        return false;
    }

    public boolean isFirst() throws SQLException {
        this.notSupport();
        return false;
    }

    public boolean isLast() throws SQLException {
        this.notSupport();
        return false;
    }

    public void beforeFirst() throws SQLException {
        this.notSupport();
    }

    public void afterLast() throws SQLException {
        this.notSupport();
    }

    public boolean first() throws SQLException {
        this.notSupport();
        return false;
    }

    public boolean last() throws SQLException {
        this.notSupport();
        return false;
    }

    public int getRow() throws SQLException {
        this.notSupport();
        return 0;
    }

    public boolean absolute(int row) throws SQLException {
        this.notSupport();
        return false;
    }

    public boolean relative(int rows) throws SQLException {
        this.notSupport();
        return false;
    }

    public boolean previous() throws SQLException {
        this.notSupport();
        return false;
    }

    public void setFetchDirection(int direction) throws SQLException {
        if (direction != 1003) {
            this.notSupport();
        }
    }

    public int getFetchDirection() throws SQLException {
        if (!this.mIsOpen) {
            throw this.mMsgFactory.createException(951053);
        }
        return 1003;
    }

    public void setFetchSize(int rows) throws SQLException {
        if (!this.mIsOpen) {
            throw this.mMsgFactory.createException(951053);
        }
    }

    public int getFetchSize() throws SQLException {
        if (!this.mIsOpen) {
            throw this.mMsgFactory.createException(951053);
        }
        return 0;
    }

    public int getType() throws SQLException {
        if (!this.mIsOpen) {
            throw this.mMsgFactory.createException(951053);
        }
        return 1003;
    }

    public int getConcurrency() throws SQLException {
        if (!this.mIsOpen) {
            throw this.mMsgFactory.createException(951053);
        }
        return 1007;
    }

    public boolean rowUpdated() throws SQLException {
        this.notSupport();
        return false;
    }

    public boolean rowInserted() throws SQLException {
        this.notSupport();
        return false;
    }

    public boolean rowDeleted() throws SQLException {
        this.notSupport();
        return false;
    }

    public void updateNull(int columnIndex) throws SQLException {
        this.notSupport();
    }

    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.notSupport();
    }

    public void updateByte(int columnIndex, byte x) throws SQLException {
        this.notSupport();
    }

    public void updateShort(int columnIndex, short x) throws SQLException {
        this.notSupport();
    }

    public void updateInt(int columnIndex, int x) throws SQLException {
        this.notSupport();
    }

    public void updateLong(int columnIndex, long x) throws SQLException {
        this.notSupport();
    }

    public void updateFloat(int columnIndex, float x) throws SQLException {
        this.notSupport();
    }

    public void updateDouble(int columnIndex, double x) throws SQLException {
        this.notSupport();
    }

    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.notSupport();
    }

    public void updateString(int columnIndex, String x) throws SQLException {
        this.notSupport();
    }

    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.notSupport();
    }

    public void updateDate(int columnIndex, Date x) throws SQLException {
        this.notSupport();
    }

    public void updateTime(int columnIndex, Time x) throws SQLException {
        this.notSupport();
    }

    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.notSupport();
    }

    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.notSupport();
    }

    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.notSupport();
    }

    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        this.notSupport();
    }

    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        this.notSupport();
    }

    public void updateObject(int columnIndex, Object x) throws SQLException {
        this.notSupport();
    }

    public void updateNull(String columnName) throws SQLException {
        this.notSupport();
    }

    public void updateBoolean(String columnName, boolean x) throws SQLException {
        this.notSupport();
    }

    public void updateByte(String columnName, byte x) throws SQLException {
        this.notSupport();
    }

    public void updateShort(String columnName, short x) throws SQLException {
        this.notSupport();
    }

    public void updateInt(String columnName, int x) throws SQLException {
        this.notSupport();
    }

    public void updateLong(String columnName, long x) throws SQLException {
        this.notSupport();
    }

    public void updateFloat(String columnName, float x) throws SQLException {
        this.notSupport();
    }

    public void updateDouble(String columnName, double x) throws SQLException {
        this.notSupport();
    }

    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        this.notSupport();
    }

    public void updateString(String columnName, String x) throws SQLException {
        this.notSupport();
    }

    public void updateBytes(String columnName, byte[] x) throws SQLException {
        this.notSupport();
    }

    public void updateDate(String columnName, Date x) throws SQLException {
        this.notSupport();
    }

    public void updateTime(String columnName, Time x) throws SQLException {
        this.notSupport();
    }

    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        this.notSupport();
    }

    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        this.notSupport();
    }

    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        this.notSupport();
    }

    public void updateCharacterStream(String columnName, Reader x, int length) throws SQLException {
        this.notSupport();
    }

    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        this.notSupport();
    }

    public void updateObject(String columnName, Object x) throws SQLException {
        this.notSupport();
    }

    public void insertRow() throws SQLException {
        this.notSupport();
    }

    public void updateRow() throws SQLException {
        this.notSupport();
    }

    public void deleteRow() throws SQLException {
        this.notSupport();
    }

    public void refreshRow() throws SQLException {
        this.notSupport();
    }

    public void cancelRowUpdates() throws SQLException {
        this.notSupport();
    }

    public void moveToInsertRow() throws SQLException {
        this.notSupport();
    }

    public void moveToCurrentRow() throws SQLException {
        this.notSupport();
    }

    public Object getObject(int columnIndex, Map map) throws SQLException {
        this.notSupport();
        return null;
    }

    public Ref getRef(int i) throws SQLException {
        this.notSupport();
        return null;
    }

    public Blob getBlob(int i) throws SQLException {
        this.notSupport();
        return null;
    }

    public Clob getClob(int i) throws SQLException {
        this.notSupport();
        return null;
    }

    public Array getArray(int i) throws SQLException {
        this.notSupport();
        return null;
    }

    public Object getObject(String columnName, Map map) throws SQLException {
        this.notSupport();
        return null;
    }

    public Ref getRef(String colname) throws SQLException {
        this.notSupport();
        return null;
    }

    public Blob getBlob(String colname) throws SQLException {
        this.notSupport();
        return null;
    }

    public Clob getClob(String colname) throws SQLException {
        this.notSupport();
        return null;
    }

    public Array getArray(String colname) throws SQLException {
        this.notSupport();
        return null;
    }

    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        this.getColumnValue(columnIndex);
        return this.mLastColumn.toDate(cal);
    }

    public Date getDate(String columnName, Calendar cal) throws SQLException {
        this.getColumnValue(columnName);
        return this.mLastColumn.toDate(cal);
    }

    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        this.getColumnValue(columnIndex);
        return this.mLastColumn.toTime(cal);
    }

    public Time getTime(String columnName, Calendar cal) throws SQLException {
        this.getColumnValue(columnName);
        return this.mLastColumn.toTime(cal);
    }

    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        this.getColumnValue(columnIndex);
        return this.mLastColumn.toTimestamp(cal);
    }

    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        this.getColumnValue(columnName);
        return this.mLastColumn.toTimestamp(cal);
    }
}

