/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.u2.jdbc;

import asjava.uniclientlibs.UniTokens;
import asjava.unirpc.UniRPCConnection;
import asjava.unirpc.UniRPCConnectionException;
import asjava.unirpc.UniRPCException;
import asjava.unirpc.UniRPCPacket;
import com.ibm.u2.jdbc.UniJDBCColumnDesc;
import com.ibm.u2.jdbc.UniJDBCConnection;
import com.ibm.u2.jdbc.UniJDBCConnectionCfg;
import com.ibm.u2.jdbc.UniJDBCErrorTokens;
import com.ibm.u2.jdbc.UniJDBCExceptionSupport;
import com.ibm.u2.jdbc.UniJDBCObject;
import com.ibm.u2.jdbc.UniJDBCObjectBuilder;
import com.ibm.u2.jdbc.UniJDBCParaMarker;
import com.ibm.u2.jdbc.UniJDBCPreparedStatement;
import com.ibm.u2.jdbc.UniJDBCProperties;
import com.ibm.u2.jdbc.UniJDBCProtocol;
import com.ibm.u2.jdbc.UniJDBCResultSetMetaData;
import com.ibm.u2.jdbc.UniJDBCResultSetMetaDataImpl;
import com.ibm.u2.jdbc.UniJDBCStatement;
import com.ibm.u2.jdbc.UniJDBCTrace;
import com.ibm.u2.jdbc.UniJDBCVARCHAR;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Vector;

public class UniJDBCProtocolU2Impl
extends UniJDBCExceptionSupport
implements UniJDBCProtocol {
    private static final String EMPTY_STRING = new String();
    private static final byte[] EMPTY_BYTES = new byte[0];
    UniJDBCStatement mStatement = null;
    private SQLWarning mProtoWarnings = null;
    private boolean mConnected;
    private boolean isConnected;
    private boolean mClosed;
    private boolean txStarted = false;
    private UniRPCConnection rpcConnection;
    private UniRPCPacket rpcInPacket;
    private UniRPCPacket rpcOutPacket;
    protected int jciReturnCode;
    protected int jciServerCode;
    protected String jciServerMessage;
    private UniJDBCConnectionCfg mConfig;
    private int timeOut = 0;
    private int encryptionType = 0;
    private int ardtUciClt = 0;
    private int logNum;
    private int srvUVVersion;
    private int cltMwVersion = 4;
    private int srvMwVersion;
    private int srvPid;
    protected String devSubkey = "";
    boolean sendDevInfo;
    protected String[] markCharacters;
    private final String DEVICE_NAME = "unknown_host";
    private final String MAC_ADDRESS = "JAVAUCI";
    private UniJDBCConnection mConnection;
    private UniJDBCTrace mTrace;
    int cursorRefNum;
    int parseOffset;
    int updCount;
    int colNum;
    int rowWidth;
    int rowCount;
    int rowsFetched;
    int fetchIsoLevel;
    int fetchNestLevel;
    boolean mwCursorOpen;
    boolean pmarkDefined;
    boolean sqExec;
    boolean reassociate;
    boolean cancelled;
    boolean execInProg;
    boolean isPrepared = false;
    boolean isExecuted = false;
    boolean isExecInProg = false;
    boolean isFetchInProg = false;
    String inSql;
    String outSql;
    String cursorName = "";
    int maxUserBind;
    int bindColCnt;
    int fetchPtr;
    int paraNum = 0;
    int execNestLevel;
    int execIsoLevel;
    boolean badType;
    boolean fetching;
    boolean destroy;
    boolean prepared;
    int execType;
    boolean cursorOpen;
    boolean isCall = false;
    boolean isSelect = false;
    boolean isDatam = false;
    int callFlag;
    Vector descVector = new Vector();
    private UniJDBCObject[] mColumnCache;
    UniJDBCParaMarker[] paraMarkerVector = null;
    int fetchedRows;
    int serverIsoLevel;
    byte[] fetchHeader;
    byte[] fetchData;
    int fetchColinfoStart;
    int rowsOfData;
    int dataSize;
    boolean moreData = true;
    int colEntries;
    private static final int[] m_code = new int[]{1, 36, 1296, 46656, 1679616};

    public UniJDBCProtocolU2Impl(UniJDBCConnection connection) {
        super(connection);
        this.mConnection = connection;
        this.mTrace = this.mConnection.getTrace();
    }

    private void initializeFetchControlParameters() {
        this.fetchedRows = 0;
        this.fetchHeader = null;
        this.fetchData = null;
        this.rowsOfData = 0;
        this.dataSize = -1;
        this.moreData = true;
        this.colEntries = -1;
    }

    public synchronized SQLWarning getWarnings() {
        return this.mProtoWarnings;
    }

    public synchronized void clearWarnings() {
        this.mProtoWarnings = null;
    }

    private synchronized void addWarning(SQLWarning warn) {
        if (this.mProtoWarnings == null) {
            this.mProtoWarnings = warn;
        } else {
            SQLWarning prev = this.mProtoWarnings;
            while (prev.getNextWarning() != null) {
                prev = prev.getNextWarning();
            }
            prev.setNextWarning(warn);
        }
    }

    public synchronized void executeOpenDatabase(UniJDBCProperties properties) throws SQLException {
        if (this.mTrace.mLevel >= 5) {
            this.mTrace.writeTrace("UniJDBCProtocolU2Impl#executeOpenDatabase()#start");
        }
        if (!this.mConnection.lockSession()) {
            throw this.mMsgFactory.createException(951041);
        }
        try {
            if (this.mConnected) {
                throw this.mMsgFactory.createException(930002);
            }
            if (this.mTrace.mLevel >= 2) {
                this.mTrace.writeTrace("properties:".concat(String.valueOf(String.valueOf(properties))));
            }
            String username = properties.getProperty("user");
            String password = properties.getProperty("password");
            this.rpcConnection = new UniRPCConnection();
            this.mConfig = new UniJDBCConnectionCfg(this.mConnection, properties);
            this.setConnectOption(996, username);
            this.setConnectOption(995, password);
            this.connect(0);
            this.setConnectOption(1003, true);
            this.mConnection.setDBMSType(this.mConfig.dbmsType);
            Object var5_4 = null;
            this.mConnection.unlockSession();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.mConnection.unlockSession();
            throw throwable;
        }
        if (this.mTrace.mLevel >= 5) {
            this.mTrace.writeTrace("UniJDBCProtocolU2Impl#executeOpenDatabase()#end");
        }
    }

    public synchronized void executeReopenDatabase(UniJDBCProperties properties, int mode) throws SQLException {
        long t1 = 0L;
        long t2 = 0L;
        if (this.mTrace.mLevel >= 5) {
            this.mTrace.writeTrace("UniJDBCProtocolU2Impl#executeReopenDatabase()#start");
            t1 = System.currentTimeMillis();
        }
        if (!this.mConnection.lockSession()) {
            throw this.mMsgFactory.createException(951041);
        }
        try {
            this.connect(mode);
            Object var8_5 = null;
            this.mConnection.unlockSession();
        }
        catch (Throwable throwable) {
            Object var8_6 = null;
            this.mConnection.unlockSession();
            throw throwable;
        }
        if (this.mTrace.mLevel >= 5) {
            t2 = System.currentTimeMillis();
            this.mTrace.writeTrace(String.valueOf(String.valueOf(new StringBuffer("UniJDBCProtocolU2Impl#executeReopenDatabase()#end:").append(t2 - t1).append("ms"))));
        }
    }

    public synchronized UniJDBCResultSetMetaData getResultSetMetaData() {
        if (this.mTrace.mLevel >= 5) {
            this.mTrace.writeTrace("UniJDBCProtocolU2Impl#getResultSetMetaData()#start");
            this.mTrace.writeTrace("UniJDBCProtocolU2Impl#getResultSetMetaData()#end");
        }
        return new UniJDBCResultSetMetaDataImpl(this.mConnection, this.descVector);
    }

    public synchronized UniJDBCProtocol duplicate() throws SQLException {
        if (this.mTrace.mLevel >= 5) {
            this.mTrace.writeTrace("UniJDBCProtocolU2Impl#duplicate()#start");
        }
        UniJDBCProtocolU2Impl newProt = new UniJDBCProtocolU2Impl(this.mConnection);
        try {
            newProt.mConfig = this.mConfig;
            newProt.rpcConnection = this.rpcConnection;
            newProt.rpcOutPacket = new UniRPCPacket(this.rpcConnection);
            newProt.rpcInPacket = new UniRPCPacket(this.rpcConnection);
        }
        catch (UniRPCException e) {
            this.addAndThrowException(930021, (Exception)((Object)e));
        }
        if (this.mTrace.mLevel >= 5) {
            this.mTrace.writeTrace("UniJDBCProtocolU2Impl#duplicate()#end");
        }
        return newProt;
    }

    public synchronized int getStatementType() {
        if (this.callFlag == 1) {
            return 1;
        }
        if (this.callFlag == 2) {
            return 2;
        }
        return 3;
    }

    public synchronized UniJDBCParaMarker[] getParameters() {
        return this.paraMarkerVector;
    }

    public synchronized boolean getAutoCommit() throws SQLException {
        return this.mConfig.autoCommit;
    }

    public synchronized void setAutoCommit(boolean autoMode) throws SQLException {
        if (!this.mConnection.lockSession()) {
            throw this.mMsgFactory.createException(951041);
        }
        try {
            this.setConnectOption(102, autoMode);
            Object var3_2 = null;
            this.mConnection.unlockSession();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.mConnection.unlockSession();
            throw throwable;
        }
    }

    public synchronized int getIsoLevel() throws SQLException {
        switch (this.mConfig.actIsoLevel) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 4: {
                return 4;
            }
            case 8: {
                return 8;
            }
        }
        return 1;
    }

    public synchronized void setIsoLevel(int newLevel) throws SQLException {
        if (!this.mConnection.lockSession()) {
            throw this.mMsgFactory.createException(951041);
        }
        try {
            int isoLevel = 0;
            switch (newLevel) {
                case 1: {
                    isoLevel = 1;
                    break;
                }
                case 2: {
                    isoLevel = 2;
                    break;
                }
                case 4: {
                    isoLevel = 3;
                    break;
                }
                case 8: {
                    isoLevel = 4;
                    break;
                }
                case 0: {
                    isoLevel = 0;
                    break;
                }
                default: {
                    throw this.mMsgFactory.createException(951044, new Object[]{new Integer(newLevel)});
                }
            }
            this.setConnectOption(108, isoLevel);
            Object var4_3 = null;
            this.mConnection.unlockSession();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.mConnection.unlockSession();
            throw throwable;
        }
    }

    public synchronized void executeCommit() throws SQLException {
        if (!this.mConnection.lockSession()) {
            throw this.mMsgFactory.createException(951041);
        }
        try {
            if (!this.getAutoCommit()) {
                if (this.commitTransaction() != 0) {
                    this.addAndThrowException(951045);
                }
            } else {
                throw this.mMsgFactory.createException(951048);
            }
            this.txStarted = false;
            if (this.startTransaction() != 0) {
                this.addAndThrowException(951045);
            }
            this.mConfig.autoCommit = false;
            this.txStarted = true;
            Object var2_1 = null;
            this.mConnection.unlockSession();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.mConnection.unlockSession();
            throw throwable;
        }
    }

    public synchronized void executeRollback() throws SQLException {
        if (!this.mConnection.lockSession()) {
            throw this.mMsgFactory.createException(951041);
        }
        try {
            if (!this.getAutoCommit()) {
                if (this.rollbackTransaction() != 0) {
                    this.throwException();
                }
            } else {
                throw this.mMsgFactory.createException(951049);
            }
            this.txStarted = false;
            if (this.startTransaction() != 0) {
                this.throwException();
            }
            this.mConfig.autoCommit = false;
            this.txStarted = true;
            Object var2_1 = null;
            this.mConnection.unlockSession();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.mConnection.unlockSession();
            throw throwable;
        }
    }

    public synchronized void executeCloseDatabase() throws SQLException {
        if (!this.mConnection.lockSession()) {
            throw this.mMsgFactory.createException(951041);
        }
        try {
            if (this.disconnectServer(false) != 0) {
                this.throwException();
            }
            Object var2_1 = null;
            this.mConnection.unlockSession();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.mConnection.unlockSession();
            throw throwable;
        }
    }

    public void executeCommand(UniJDBCStatement stmt) throws SQLException {
    }

    public synchronized void executePrepare(UniJDBCStatement stmt) throws SQLException {
        if (!this.mConnection.lockSession()) {
            throw this.mMsgFactory.createException(951041);
        }
        try {
            this.mStatement = stmt;
            this.preExecute();
            this.prepare();
            Object var3_2 = null;
            this.mConnection.unlockSession();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.mConnection.unlockSession();
            throw throwable;
        }
    }

    public synchronized void executeStatementQuery(UniJDBCStatement stmt) throws SQLException {
        if (!this.mConnection.lockSession()) {
            throw this.mMsgFactory.createException(951041);
        }
        try {
            this.mStatement = stmt;
            if (this.mStatement instanceof UniJDBCPreparedStatement) {
                if (this.mTrace.mLevel >= 2) {
                    this.mTrace.writeTrace("Prepared: only doExecute()");
                }
                this.initializeFetchControlParameters();
                this.doExecute();
            } else {
                if (this.mTrace.mLevel >= 2) {
                    this.mTrace.writeTrace("Prepared: doExecuteAll()");
                }
                this.doExecuteAll();
            }
            Object var3_2 = null;
            this.mConnection.unlockSession();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.mConnection.unlockSession();
            throw throwable;
        }
    }

    public synchronized void executeStatementQuery(UniJDBCStatement stmt, UniJDBCResultSetMetaData outputMetaData) throws SQLException {
    }

    public synchronized int getUpdateCount() throws SQLException {
        return this.updCount;
    }

    public synchronized void executeClose(UniJDBCStatement stmt) throws SQLException {
        if (!this.mConnection.lockSession()) {
            throw this.mMsgFactory.createException(951041);
        }
        try {
            this.closeCursor();
            Object var3_2 = null;
            this.mConnection.unlockSession();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.mConnection.unlockSession();
            throw throwable;
        }
    }

    public synchronized void executeRelease(UniJDBCStatement stmt) throws SQLException {
    }

    public synchronized void executeExecute(UniJDBCStatement stmt) throws SQLException {
    }

    public synchronized void executeExecute(UniJDBCStatement stmt, UniJDBCResultSetMetaData outputMetaData) throws SQLException {
    }

    private void connect(int mode) throws SQLException {
        long tmstart = 0L;
        long t1 = 0L;
        long t2 = 0L;
        if (this.mTrace.mLevel >= 5) {
            tmstart = System.currentTimeMillis();
            this.mTrace.writeTrace("UniJDBCProtocolU2Impl#connect():enter");
        }
        UniJDBCProtocolU2Impl uniJDBCProtocolU2Impl = this;
        synchronized (uniJDBCProtocolU2Impl) {
            int opt;
            try {
                if (mode == 2 || mode == 3) {
                    boolean keepConnection;
                    boolean bl = keepConnection = mode == 2;
                    if (this.mTrace.mLevel >= 5) {
                        this.mTrace.writeTrace(String.valueOf(String.valueOf(new StringBuffer("disconnectServer(").append(keepConnection).append(")"))));
                        t1 = System.currentTimeMillis();
                    }
                    if (this.disconnectServer(false) != 0) {
                        this.throwException();
                    }
                    if (this.mTrace.mLevel >= 5) {
                        t2 = System.currentTimeMillis();
                        this.mTrace.writeTrace(String.valueOf(String.valueOf(new StringBuffer("disconnectServer(").append(keepConnection).append(")--time:").append(t2 - t1).append(" ms"))));
                    }
                }
                if (mode == 0 || mode == 3) {
                    if (this.mTrace.mLevel >= 5) {
                        t1 = System.currentTimeMillis();
                    }
                    this.rpcConnection.setHost(this.mConfig.hostName);
                    this.rpcConnection.setPort(this.mConfig.hostPort);
                    if (this.mConfig.proxyHost != null) {
                        this.rpcConnection.setProxyHost(this.mConfig.proxyHost);
                        this.rpcConnection.setProxyPort(this.mConfig.proxyPort);
                    }
                    this.rpcConnection.setService(this.mConfig.service);
                    this.rpcConnection.setTimeoutSeconds(this.timeOut);
                    this.rpcConnection.setTransportType(1);
                    try {
                        this.rpcConnection.connect();
                    }
                    catch (UniRPCConnectionException e) {
                        this.addAndThrowException(930021, (Exception)((Object)e));
                    }
                    if (this.mTrace.mLevel >= 5) {
                        t2 = System.currentTimeMillis();
                        this.mTrace.writeTrace(String.valueOf(String.valueOf(new StringBuffer("making rpc connection-time:").append(t2 - t1).append(" ms"))));
                    }
                }
                if (this.mTrace.mLevel >= 5) {
                    t1 = System.currentTimeMillis();
                }
                this.rpcOutPacket = new UniRPCPacket(this.rpcConnection);
                this.rpcInPacket = new UniRPCPacket(this.rpcConnection);
                if (this.mTrace.mLevel >= 2) {
                    this.mTrace.writeTrace(String.valueOf(String.valueOf(new StringBuffer("password=").append(this.mConfig.password).append(",username=").append(this.mConfig.userName))));
                }
                this.rpcOutPacket.write(0, this.mConfig.userName.toCharArray());
                this.rpcOutPacket.write(1, this.encrypt(this.mConfig.password));
                this.rpcOutPacket.write(2, this.mConfig.accountPath.toCharArray());
                this.rpcOutPacket.write(3, this.mConfig.isNF1);
                this.rpcOutPacket.write(4, 4);
                this.rpcOutPacket.write(5, 8);
                this.rpcOutPacket.write(6, this.getIPaddress());
                this.rpcOutPacket.write(7, this.getMacAddress().toCharArray());
                this.rpcOutPacket.write(8, this.getdeviceName().toCharArray());
                this.rpcOutPacket.write(9, this.devSubkey.toCharArray());
                this.rpcOutPacket.write(10, this.ardtUciClt);
                this.rpcOutPacket.write(11, 12);
                this.rpcOutPacket.write(12, 0);
                this.rpcConnection.call(this.rpcOutPacket, this.rpcInPacket);
                this.jciReturnCode = this.rpcInPacket.readInteger(0);
                if (this.jciReturnCode == 0) {
                    this.jciServerCode = this.rpcInPacket.readInteger(1);
                    if (this.jciServerCode != 0) {
                        this.jciServerMessage = this.getServerErrorMessage(0, 0);
                        this.rpcConnection.close();
                        if (this.jciServerMessage == null) {
                            this.jciServerMessage = UniJDBCErrorTokens.NOERRTXT;
                        }
                        this.addAndThrowException(930027, this.jciServerMessage);
                    }
                    this.logNum = this.rpcInPacket.readInteger(2);
                    this.srvUVVersion = this.rpcInPacket.readInteger(4);
                    this.cltMwVersion = 4;
                    this.srvMwVersion = this.rpcInPacket.readInteger(5);
                    this.srvPid = this.rpcInPacket.readInteger(6);
                    if (this.mTrace.mLevel >= 2) {
                        this.mTrace.writeTrace("logon-argument number:".concat(String.valueOf(String.valueOf(this.rpcInPacket.getArgumentCount()))));
                    }
                    if (this.rpcInPacket.getArgumentCount() > 8) {
                        this.mConfig.euroEnabled = true;
                        int nullCode = this.rpcInPacket.readInteger(7);
                        byte[] nullValue = new byte[]{(byte)nullCode};
                        this.mConnection.setNullDatabaseValue(nullValue);
                        if (this.mTrace.mLevel >= 2) {
                            this.mTrace.writeTrace(String.valueOf(String.valueOf(new StringBuffer("euroEnabled==true, new NULL value:'").append(nullCode).append("'"))));
                        }
                    }
                } else {
                    this.rpcConnection.close();
                    this.addAndThrowException(930021);
                }
                if (this.mTrace.mLevel >= 5) {
                    t2 = System.currentTimeMillis();
                    this.mTrace.writeTrace(String.valueOf(String.valueOf(new StringBuffer("logon to the account--time:").append(t2 - t1).append(" ms"))));
                }
            }
            catch (UniRPCException e) {
                this.addAndThrowException(930021, (Exception)((Object)e));
            }
            this.isConnected = true;
            if (this.mTrace.mLevel >= 5) {
                t1 = System.currentTimeMillis();
            }
            if (this.setServerConnectOption(1003, opt = this.mConfig.emptyNull ? 1 : 0, "") != 0) {
                this.addAndThrowException(930059);
            }
            if (this.mConfig.NLSMap != null && this.setServerConnectOption(1005, 0, this.mConfig.NLSMap) != 0 && this.jciServerCode == 930077 && (this.mConfig.NLSMap.equals("ISO8859-1+MARKS") || this.mConfig.NLSMap.equals("WIN:850") || this.mConfig.NLSMap.equals("WIN:1252"))) {
                this.jciServerCode = 0;
                this.clearExceptions();
            }
            if (this.jciServerCode == 0 && this.mConfig.NLSLCTime != null && this.setServerConnectOption(1007, 0, this.mConfig.NLSLCTime) != 0 && this.mConfig.NLSLCTime.equals("WIN:0409")) {
                this.jciServerCode = 0;
                this.clearExceptions();
            }
            if (this.jciServerCode == 0 && this.mConfig.NLSLCNumeric != null && this.setServerConnectOption(1008, 0, this.mConfig.NLSLCNumeric) != 0 && this.mConfig.NLSLCTime.equals("WIN:0409")) {
                this.jciServerCode = 0;
                this.clearExceptions();
            }
            if (this.jciServerCode == 0 && this.mConfig.NLSLCMonetary != null && this.setServerConnectOption(1009, 0, this.mConfig.NLSLCMonetary) != 0 && this.mConfig.NLSLCMonetary.equals("WIN:0409")) {
                this.jciServerCode = 0;
                this.clearExceptions();
            }
            if (this.jciServerCode == 0 && this.mConfig.NLSLCCtype != null && this.setServerConnectOption(1010, 0, this.mConfig.NLSLCCtype) != 0 && this.mConfig.NLSLCCtype.equals("WIN:0409")) {
                this.jciServerCode = 0;
                this.clearExceptions();
            }
            if (this.jciServerCode == 0 && this.mConfig.NLSLCCollate != null && this.setServerConnectOption(1011, 0, this.mConfig.NLSLCCollate) != 0 && this.mConfig.NLSLCTime.equals("WIN:0409")) {
                this.jciServerCode = 0;
                this.clearExceptions();
            }
            if (this.jciServerCode == 0 && this.mConfig.euroEnabled && this.mConfig.euroCode != -1) {
                this.setServerConnectOption(1022, this.mConfig.euroCode, EMPTY_STRING);
            }
            if (this.jciServerCode == 0 && this.mConfig.isToUDT) {
                this.setServerConnectOption(1002, this.mConfig.isNF1, EMPTY_STRING);
            }
            if (this.jciServerCode != 0) {
                switch (this.jciServerCode) {
                    case 930077: {
                        this.addAndThrowException(930077);
                    }
                    case 930078: {
                        this.addAndThrowException(930078);
                    }
                    case 930079: {
                        this.addAndThrowException(930079);
                    }
                    case 930089: {
                        this.addAndThrowException(930089);
                    }
                }
                this.addAndThrowException(930084);
            }
            if (this.mTrace.mLevel >= 5) {
                t2 = System.currentTimeMillis();
                this.mTrace.writeTrace(String.valueOf(String.valueOf(new StringBuffer("setup-options--time:").append(t2 - t1).append(" ms"))));
            }
        }
        this.isConnected = true;
        if (this.mTrace.mLevel >= 5) {
            t2 = System.currentTimeMillis();
            this.mTrace.writeTrace(String.valueOf(String.valueOf(new StringBuffer("UniJDBCProtocolU2Impl#connect():leave:whole connect():").append(t2 - tmstart).append(" ms"))));
        }
    }

    private int setServerConnectOption(int option, int intOptVal, String stringOptVal) {
        this.jciReturnCode = 0;
        this.jciServerCode = 0;
        if (!this.isConnected) {
            this.addException(930003);
            return -1;
        }
        try {
            this.rpcOutPacket.write(0, option);
            this.rpcOutPacket.write(1, intOptVal);
            this.rpcOutPacket.write(2, stringOptVal.toCharArray());
            this.rpcOutPacket.write(3, 18);
            this.rpcOutPacket.write(4, 0);
            this.rpcConnection.call(this.rpcOutPacket, this.rpcInPacket);
            this.jciReturnCode = this.rpcInPacket.readInteger(0);
            this.jciServerCode = this.rpcInPacket.readInteger(1);
            if (this.jciReturnCode != 0) {
                if (this.jciServerCode != 930187 && this.jciServerCode != 930079 && this.jciServerCode != 930078 && this.jciServerCode != 930077 && this.jciServerCode != 930089) {
                    this.addException(930059);
                }
                int n = -1;
                return n;
            }
        }
        catch (UniRPCException e) {
            this.addException(930059, (Exception)((Object)e));
            int n = -1;
            return n;
        }
        return 0;
    }

    private int disconnectServer(boolean keepConnection) {
        this.jciReturnCode = 0;
        this.jciServerCode = 0;
        try {
            if (keepConnection) {
                this.rpcOutPacket.write(0, this.logNum + 20000);
            } else {
                this.rpcOutPacket.write(0, this.logNum);
            }
            this.rpcOutPacket.write(1, 11);
            this.rpcOutPacket.write(2, 0);
            this.rpcConnection.call(this.rpcOutPacket, this.rpcInPacket);
            this.jciReturnCode = this.rpcInPacket.readInteger(0);
            this.jciServerCode = this.rpcInPacket.readInteger(1);
            if (this.jciReturnCode != 0) {
                this.addException(930001);
                int n = -1;
                return n;
            }
            if (this.jciServerCode != 0) {
                this.addServerError(this.jciServerCode);
                int n = -1;
                return n;
            }
            if (!keepConnection) {
                this.rpcConnection.close();
            }
        }
        catch (UniRPCException e) {
            this.addException(930059, (Exception)((Object)e));
            int n = -1;
            return n;
        }
        return 0;
    }

    private char[] encrypt(String aString) {
        if (aString == null) {
            return new String().toCharArray();
        }
        char[] charArray = aString.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            charArray[i] = (char)(~((byte)charArray[i]));
        }
        return charArray;
    }

    private int getIPaddress() {
        try {
            int n = InetAddress.getLocalHost().hashCode();
            return n;
        }
        catch (UnknownHostException e) {
            int n = 0;
            return n;
        }
    }

    private String getMacAddress() {
        return "JAVAUCI";
    }

    private String getdeviceName() {
        if (this.sendDevInfo) {
            try {
                String string = InetAddress.getLocalHost().getHostName();
                return string;
            }
            catch (UnknownHostException e) {
                String string = "unknown_host";
                return string;
            }
        }
        return "";
    }

    private String getdeviceSubkey() {
        return this.devSubkey;
    }

    private void setdeviceSubkey(Object subkey) {
        if (subkey != null) {
            this.devSubkey = subkey.toString();
        }
    }

    private void initDefaultValues() {
        this.markCharacters = UniTokens.defaultMarkArray;
    }

    private void setConnectOption(int option, boolean value) throws SQLException {
        switch (option) {
            case 1020: {
                this.sendDevInfo = value;
                break;
            }
            case 1003: {
                int opt;
                this.mConfig.emptyNull = value;
                if (!this.isConnected || this.setServerConnectOption(option, opt = value ? 1 : 0, "") == 0 || this.jciServerCode == 0) break;
                this.addAndThrowServerError(this.jciServerCode);
                break;
            }
            case 102: {
                if (!this.isConnected) {
                    this.addAndThrowException(930003);
                }
                if (!value) {
                    if (!this.mConfig.autoCommit) {
                        return;
                    }
                    if (this.txStarted) {
                        if (this.commitTransaction() != 0) {
                            this.throwException();
                        }
                        this.txStarted = false;
                    }
                    this.mConfig.actIsoLevel = this.mConfig.procIsoLevel;
                    if (this.startTransaction() != 0) {
                        this.throwException();
                    }
                    this.mConfig.autoCommit = false;
                    this.txStarted = true;
                    break;
                }
                if (this.mConfig.autoCommit) break;
                if (this.txStarted) {
                    if (this.commitTransaction() != 0) {
                        this.throwException();
                    }
                    this.txStarted = false;
                }
                this.mConfig.autoCommit = true;
                break;
            }
            default: {
                this.addAndThrowException(930033);
            }
        }
    }

    private void setConnectOption(int option, int value) throws SQLException {
        switch (option) {
            case 1002: {
                if (value != 1 && value != 0) {
                    this.addAndThrowException(930033);
                }
                this.mConfig.isNF1 = value;
                break;
            }
            case 108: {
                this.mConfig.procIsoLevel = value;
                break;
            }
            default: {
                this.addAndThrowException(930033);
            }
        }
    }

    private void setConnectOption(int option, String value) throws SQLException {
        if (value == null) {
            return;
        }
        block0 : switch (option) {
            case 996: {
                this.mConfig.userName = value;
                break;
            }
            case 995: {
                this.mConfig.password = value;
                break;
            }
            case 1005: {
                this.mConfig.NLSMap = value;
            }
            case 1007: {
                this.mConfig.NLSLCTime = value;
                this.mConfig.sconTime = true;
            }
            case 1008: {
                this.mConfig.NLSLCNumeric = value;
                this.mConfig.sconNumeric = true;
            }
            case 1009: {
                this.mConfig.NLSLCMonetary = value;
                this.mConfig.sconMonetary = true;
            }
            case 1010: {
                this.mConfig.NLSLCCtype = value;
                this.mConfig.sconCtype = true;
            }
            case 1011: {
                this.mConfig.NLSLCCollate = value;
                this.mConfig.sconCollate = true;
                if (!this.isConnected) {
                    return;
                }
                if (this.setServerConnectOption(option, 0, value) == 0 || this.jciServerCode == 0) break;
                switch (this.jciServerCode) {
                    case 930077: {
                        this.addAndThrowException(930077);
                        break block0;
                    }
                    case 930078: {
                        this.addAndThrowException(930078);
                        break block0;
                    }
                    case 930079: {
                        this.addAndThrowException(930079);
                        break block0;
                    }
                }
                this.addAndThrowServerError(this.jciServerCode);
                break;
            }
            case 1006: 
            case 1012: {
                this.mConfig.NLSLCTime = value;
                this.mConfig.sconTime = true;
                this.mConfig.NLSLCNumeric = value;
                this.mConfig.sconNumeric = true;
                this.mConfig.NLSLCMonetary = value;
                this.mConfig.sconMonetary = true;
                this.mConfig.NLSLCCtype = value;
                this.mConfig.sconCtype = true;
                this.mConfig.NLSLCCollate = value;
                this.mConfig.sconCollate = true;
                if (!this.isConnected) {
                    return;
                }
                if (this.setServerConnectOption(option, 0, value) == 0 || this.jciServerCode == 0) break;
                switch (this.jciServerCode) {
                    case 930077: {
                        this.addAndThrowException(930077);
                        break block0;
                    }
                    case 930078: {
                        this.addAndThrowException(930078);
                        break block0;
                    }
                    case 930079: {
                        this.addAndThrowException(930079);
                        break block0;
                    }
                }
                this.addAndThrowServerError(this.jciServerCode);
                break;
            }
            case 1019: {
                this.devSubkey = value;
                break;
            }
            case 1021: {
                break;
            }
            default: {
                this.addAndThrowException(930033);
            }
        }
    }

    private String getServerErrorMessage(int cursorNum, int nativeCode) {
        int returnCode = 0;
        int serverCode = 0;
        try {
            this.rpcOutPacket.write(0, cursorNum);
            this.rpcOutPacket.write(1, nativeCode);
            this.rpcOutPacket.write(2, 8);
            this.rpcOutPacket.write(3, 0);
            this.rpcConnection.call(this.rpcOutPacket, this.rpcInPacket);
            returnCode = this.rpcInPacket.readInteger(0);
            if (returnCode != 0) {
                String string = null;
                return string;
            }
            serverCode = this.rpcInPacket.readInteger(1);
            int nextReturnCode = this.rpcInPacket.readInteger(3);
            if (serverCode == 100) {
                String string = "Server error message not available.";
                return string;
            }
            String string = this.mConnection.decodeBytes(this.rpcInPacket.readBytes(2));
            return string;
        }
        catch (UniRPCException e) {
            String string = null;
            return string;
        }
    }

    private int getInt(byte[] bArray, int index) {
        int itemValue = ((bArray[index++] & 0xFF) << 24) + ((bArray[index++] & 0xFF) << 16) + ((bArray[index++] & 0xFF) << 8) + ((bArray[index++] & 0xFF) << 0);
        return itemValue;
    }

    private int openServerCursor() {
        try {
            this.rpcOutPacket.write(0, this.logNum);
            this.rpcOutPacket.write(1, this.cursorName.toCharArray());
            this.rpcOutPacket.write(2, 13);
            this.rpcOutPacket.write(3, 0);
            this.rpcConnection.call(this.rpcOutPacket, this.rpcInPacket);
            this.jciReturnCode = this.rpcInPacket.readInteger(0);
            this.jciServerCode = this.rpcInPacket.readInteger(1);
            this.cursorRefNum = this.rpcInPacket.readInteger(2);
            if (this.jciReturnCode != 0) {
                this.addException(930059);
                int n = -1;
                return n;
            }
            if (this.jciServerCode != 0) {
                this.addServerError(this.jciServerCode);
                int n = -1;
                return n;
            }
        }
        catch (UniRPCException e) {
            this.addException(930059);
            int n = -1;
            return n;
        }
        return 0;
    }

    private synchronized void openCursor() throws SQLException {
        if (this.openServerCursor() != 0) {
            this.throwException();
        }
        this.mwCursorOpen = true;
        this.cursorOpen = false;
        this.pmarkDefined = false;
    }

    private int closeServerCursor() {
        try {
            this.rpcOutPacket.write(0, this.cursorRefNum);
            this.rpcOutPacket.write(1, 3);
            this.rpcOutPacket.write(2, 0);
            this.rpcConnection.call(this.rpcOutPacket, this.rpcInPacket);
            this.jciReturnCode = this.rpcInPacket.readInteger(0);
            this.jciServerCode = this.rpcInPacket.readInteger(1);
            if (this.jciReturnCode != 0) {
                this.addException(930059);
                int n = -1;
                return n;
            }
            if (this.jciServerCode != 0) {
                this.addServerError(this.jciServerCode);
                int n = -1;
                return n;
            }
        }
        catch (UniRPCException e) {
            this.addException(930059, (Exception)((Object)e));
            int n = -1;
            return n;
        }
        return 0;
    }

    private void closeCursor() throws SQLException {
        if (this.closeServerCursor() != 0) {
            this.throwException();
        }
        this.mwCursorOpen = false;
        this.pmarkDefined = false;
        this.sqExec = false;
        this.isPrepared = false;
        this.isExecuted = false;
        this.isExecInProg = false;
        this.isFetchInProg = false;
    }

    private int associateServerCursor() {
        this.jciReturnCode = 0;
        this.jciServerCode = 0;
        this.paraNum = 0;
        this.callFlag = 0;
        try {
            this.rpcOutPacket.write(0, this.cursorRefNum);
            this.rpcOutPacket.write(1, this.outSql.toCharArray());
            this.rpcOutPacket.write(2, 0);
            this.rpcOutPacket.write(3, 0);
            this.rpcConnection.call(this.rpcOutPacket, this.rpcInPacket);
            this.jciReturnCode = this.rpcInPacket.readInteger(0);
            if (this.jciReturnCode != 0) {
                this.addException(930059);
                int n = -1;
                return n;
            }
            this.jciServerCode = this.rpcInPacket.readInteger(1);
            if (this.jciServerCode != 0) {
                this.addServerError(this.jciServerCode);
                int n = -1;
                return n;
            }
            this.paraNum = this.rpcInPacket.readInteger(2);
            this.callFlag = this.rpcInPacket.readInteger(3);
            if (this.mTrace.mLevel >= 2) {
                this.mTrace.writeTrace("callFlag received:".concat(String.valueOf(String.valueOf(this.callFlag))));
            }
        }
        catch (UniRPCException e) {
            this.addException(930059, (Exception)((Object)e));
            int n = -1;
            return n;
        }
        return 0;
    }

    private UniJDBCParaMarker findParaMarker(int index) {
        UniJDBCParaMarker jciParaMarker;
        if (this.paraMarkerVector == null) {
            return null;
        }
        try {
            jciParaMarker = this.paraMarkerVector[index];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            UniJDBCParaMarker uniJDBCParaMarker = null;
            return uniJDBCParaMarker;
        }
        return jciParaMarker;
    }

    private void associateCursor() throws SQLException {
        block3: {
            if (this.associateServerCursor() != 0) {
                this.throwException();
            }
            if (this.paraNum > 0) {
                this.paraMarkerVector = new UniJDBCParaMarker[this.paraNum];
            }
            for (int i = 0; i < this.paraNum; ++i) {
                this.paraMarkerVector[i] = new UniJDBCParaMarker();
            }
            this.isCall = this.callFlag == 1;
            this.isSelect = this.callFlag == 2;
            boolean bl = this.isDatam = this.callFlag == 3;
            if (this.mTrace.mLevel < 2) break block3;
            this.mTrace.writeTrace("callFlag is ".concat(String.valueOf(String.valueOf(this.callFlag))));
        }
    }

    private UniJDBCColumnDesc createColDesc(byte[] bArray, int numItems) {
        UniJDBCColumnDesc jciColDesc = new UniJDBCColumnDesc();
        int i = 0;
        jciColDesc.descListInt = this.getInt(bArray, i);
        jciColDesc.sqlType = this.getInt(bArray, i += 4);
        jciColDesc.precision = this.getInt(bArray, i += 4);
        jciColDesc.scale = this.getInt(bArray, i += 4);
        jciColDesc.displaySize = this.getInt(bArray, i += 4);
        jciColDesc.nullable = this.getInt(bArray, i += 4);
        jciColDesc.dbType = this.getInt(bArray, i += 4);
        jciColDesc.sqlnkType = this.getInt(bArray, i += 4);
        jciColDesc.size = this.getInt(bArray, i += 4);
        jciColDesc.updatable = this.getInt(bArray, i += 4);
        i += 4;
        if (!this.mConfig.isToUDT) {
            jciColDesc.autoInc = this.getInt(bArray, i);
            i += 4;
        } else {
            jciColDesc.autoInc = 0;
        }
        jciColDesc.labelLen = this.getInt(bArray, i);
        jciColDesc.nameLen = this.getInt(bArray, i += 4);
        jciColDesc.tableLen = this.getInt(bArray, i += 4);
        jciColDesc.formatLen = this.getInt(bArray, i += 4);
        jciColDesc.convLen = this.getInt(bArray, i += 4);
        i += 4;
        if (bArray.length != numItems * 4 + jciColDesc.labelLen + jciColDesc.nameLen + jciColDesc.tableLen + jciColDesc.formatLen + jciColDesc.convLen + 1) {
            return null;
        }
        jciColDesc.label = new String(bArray, i, jciColDesc.labelLen);
        jciColDesc.name = new String(bArray, i += jciColDesc.labelLen, jciColDesc.nameLen);
        jciColDesc.table = new String(bArray, i += jciColDesc.nameLen, jciColDesc.tableLen);
        jciColDesc.format = new String(bArray, i += jciColDesc.tableLen, jciColDesc.formatLen);
        jciColDesc.conv = new String(bArray, i += jciColDesc.formatLen, jciColDesc.convLen);
        i += jciColDesc.convLen;
        if (jciColDesc.name.length() > 0) {
            jciColDesc.searchable = 1;
        }
        return jciColDesc;
    }

    private int serverColDescribe() {
        if (this.isDatam) {
            return 0;
        }
        this.jciReturnCode = 0;
        this.jciServerCode = 0;
        try {
            this.rpcOutPacket.write(0, this.cursorRefNum);
            this.rpcOutPacket.write(1, 16);
            this.rpcOutPacket.write(2, 0);
            this.rpcConnection.call(this.rpcOutPacket, this.rpcInPacket);
            this.jciServerCode = this.rpcInPacket.readInteger(0);
            if (this.jciServerCode != 0 && this.jciServerCode != this.mConfig.eodCode) {
                int n = -1;
                return n;
            }
            this.colNum = this.rpcInPacket.readInteger(2);
            if (this.rpcInPacket.getArgumentCount() != this.colNum + 4) {
                this.addException(930059);
                int n = -1;
                return n;
            }
            int numItems = 15;
            if (!this.mConfig.isToUDT) {
                ++numItems;
            }
            if (this.descVector == null) {
                this.descVector = new Vector();
            } else {
                this.descVector.removeAllElements();
            }
            for (int i = 0; i < this.colNum; ++i) {
                UniJDBCColumnDesc jciColDesc = this.createColDesc(this.rpcInPacket.readBytes(i + 3), numItems);
                if (jciColDesc == null) {
                    this.addException(930059);
                    int n = -1;
                    return n;
                }
                this.descVector.addElement(jciColDesc);
            }
            this.mColumnCache = new UniJDBCObject[this.colNum];
        }
        catch (UniRPCException e) {
            this.addException(930059, (Exception)((Object)e));
            int jciColDesc = -1;
            return jciColDesc;
        }
        return 0;
    }

    private synchronized void describeSql() throws SQLException {
        if (this.serverColDescribe() != 0) {
            this.throwException();
        }
        this.cursorOpen = false;
        this.badType = false;
        this.fetchPtr = -1;
        this.rowWidth = 0;
        if (this.colNum > 0) {
            this.cursorOpen = true;
        }
    }

    private void prepare() throws SQLException {
        if (this.mwCursorOpen) {
            this.mwCursorOpen = false;
            this.closeCursor();
        }
        this.initializeFetchControlParameters();
        this.openCursor();
        this.associateCursor();
        if (!this.mConfig.descB4Exec || this.isCall) {
            return;
        }
        if (!this.cancelled) {
            this.describeSql();
        } else {
            this.cursorOpen = true;
        }
        this.mStatement.setqmarks(this.paraNum);
    }

    private void checkPara() throws SQLException {
        if (this.isCall) {
            for (int i = 0; i < this.paraNum; ++i) {
                UniJDBCParaMarker jciParaMarker = this.paraMarkerVector[i];
                if (!jciParaMarker.isInput() || jciParaMarker.hasBeenSet()) continue;
                this.addAndThrowException(930010);
            }
        } else {
            for (int i = 0; i < this.paraNum; ++i) {
                UniJDBCParaMarker jciParaMarker = this.paraMarkerVector[i];
                if (jciParaMarker.isOutput()) {
                    this.addAndThrowException(930074);
                }
                if (jciParaMarker.hasBeenSet()) continue;
                this.addAndThrowException(930010);
            }
        }
    }

    private void paraMarkerDefine() throws SQLException {
        if (this.serverParaMarkerDefine() != 0) {
            this.throwException();
        }
    }

    private int serverParaMarkerDefine() {
        for (int i = 0; i < this.paraNum; ++i) {
            try {
                UniJDBCParaMarker jciParaMarker = this.findParaMarker(i);
                if (jciParaMarker == null) {
                    this.addException(930010);
                    int n = -1;
                    return n;
                }
                this.rpcOutPacket.write(0, this.cursorRefNum);
                this.rpcOutPacket.write(1, i + 1);
                this.rpcOutPacket.write(2, jciParaMarker.getDataType());
                this.rpcOutPacket.write(3, jciParaMarker.getSQLType());
                this.rpcOutPacket.write(4, jciParaMarker.getPrec());
                this.rpcOutPacket.write(5, jciParaMarker.getScale());
                this.rpcOutPacket.write(6, jciParaMarker.getParaType());
                this.rpcOutPacket.write(7, 6);
                this.rpcOutPacket.write(8, 0);
                this.rpcConnection.call(this.rpcOutPacket, this.rpcInPacket);
                this.jciReturnCode = this.rpcInPacket.readInteger(0);
                this.jciServerCode = this.rpcInPacket.readInteger(1);
                if (this.jciReturnCode != 0) {
                    this.addException(930059);
                    int n = -1;
                    return n;
                }
                if (this.jciServerCode == 0) continue;
                this.addServerError(this.jciServerCode);
                int n = -1;
                return n;
            }
            catch (UniRPCException e) {
                this.addException(930059, (Exception)((Object)e));
                int n = -1;
                return n;
            }
        }
        return 0;
    }

    private void paraMarkerBind() throws SQLException {
        if (this.serverParaMarkerBind() != 0) {
            this.throwException();
        }
    }

    private int serverParaMarkerBind() {
        if (this.mTrace.mLevel >= 5) {
            this.mTrace.writeTrace("UniJDBCProtocolU2Impl#serverParaMarkerBind:enter");
        }
        try {
            int i;
            this.rpcOutPacket.write(0, this.cursorRefNum);
            this.rpcOutPacket.write(1, this.paraNum);
            for (i = 0; i < this.paraNum; ++i) {
                UniJDBCObject value;
                UniJDBCParaMarker jciParaMarker = this.findParaMarker(i);
                if (jciParaMarker == null) {
                    this.addException(930010);
                    int n = -1;
                    return n;
                }
                byte[] bindValue = this.isCall ? ((value = jciParaMarker.getValue()) == null ? EMPTY_BYTES : (value.isNull() ? this.mConnection.getNullDatabaseValue() : value.toDatabase())) : jciParaMarker.getDatabaseValue();
                this.rpcOutPacket.write(i + 2, bindValue);
            }
            this.rpcOutPacket.write(i + 2, 1);
            this.rpcOutPacket.write(i + 3, 0);
            this.rpcConnection.call(this.rpcOutPacket, this.rpcInPacket);
            this.jciReturnCode = this.rpcInPacket.readInteger(0);
            this.jciServerCode = this.rpcInPacket.readInteger(1);
            if (this.jciReturnCode != 0) {
                this.addException(930059);
                int n = -1;
                return n;
            }
            if (this.jciServerCode != 0) {
                this.addServerError(this.jciServerCode);
                int n = -1;
                return n;
            }
        }
        catch (UniRPCException e) {
            this.addException(930059, (Exception)((Object)e));
            int n = -1;
            return n;
        }
        if (this.mTrace.mLevel >= 5) {
            this.mTrace.writeTrace("UniJDBCProtocolU2Impl#serverParaMarkerBind:leave-success");
        }
        return 0;
    }

    private int serverExecuteSql() {
        if (this.mTrace.mLevel >= 5) {
            this.mTrace.writeTrace("UniJDBCProtocolU2Impl#serverExecuteSql:enter");
        }
        try {
            this.rpcOutPacket.write(0, this.cursorRefNum);
            if (this.mConfig.autoCommit) {
                this.rpcOutPacket.write(1, this.execIsoLevel);
            } else {
                if (this.mTrace.mLevel >= 2) {
                    this.mTrace.writeTrace("serverExecuteSql:Using TX_CURRENT_ISOLATION level for nested transaction.");
                }
                this.rpcOutPacket.write(1, 42);
            }
            this.rpcOutPacket.write(2, 9);
            this.rpcOutPacket.write(3, 0);
            this.rpcConnection.call(this.rpcOutPacket, this.rpcInPacket);
            this.jciReturnCode = this.rpcInPacket.readInteger(0);
            this.jciServerCode = this.rpcInPacket.readInteger(1);
            this.updCount += this.rpcInPacket.readInteger(2);
            this.execIsoLevel = this.rpcInPacket.readInteger(3);
            if (this.mTrace.mLevel >= 2) {
                this.mTrace.writeTrace("exeIsoLevel(after-call):".concat(String.valueOf(String.valueOf(this.execIsoLevel))));
            }
            if (this.jciReturnCode != 0) {
                this.addException(930059);
                if (this.mTrace.mLevel >= 1) {
                    this.mTrace.writeTrace("UniJDBCProtocolU2Impl#serverExecuteSql:leave-RPC-error:".concat(String.valueOf(String.valueOf(this.jciReturnCode))));
                }
                int n = -1;
                return n;
            }
            if (this.jciServerCode == 930993) {
                this.cancelled = false;
            } else if (this.jciServerCode == 930991) {
                this.cancelled = false;
            } else if (this.jciServerCode == 930992) {
                this.cancelled = true;
            } else if (this.jciServerCode != 0) {
                this.cancelled = true;
                this.addServerError(this.jciServerCode);
                if (this.mTrace.mLevel >= 1) {
                    this.mTrace.writeTrace("UniJDBCProtocolU2Impl#serverExecuteSql:leave-error:".concat(String.valueOf(String.valueOf(this.jciServerCode))));
                }
                int n = -1;
                return n;
            }
        }
        catch (UniRPCException e) {
            this.addException(930059, (Exception)((Object)e));
            if (this.mTrace.mLevel >= 1) {
                this.mTrace.writeTrace("UniJDBCProtocolU2Impl#serverExecuteSql:leave-RPC-exeception");
            }
            int n = -1;
            return n;
        }
        if (this.mTrace.mLevel >= 5) {
            this.mTrace.writeTrace("UniJDBCProtocolU2Impl#serverExecuteSql:leave-success");
        }
        return 0;
    }

    private void executeSql() throws SQLException {
        if (this.mTrace.mLevel >= 5) {
            this.mTrace.writeTrace("UniJDBCProtocolU2Impl#executeSql:enter");
        }
        this.execIsoLevel = this.mConfig.procIsoLevel;
        this.execInProg = true;
        int ret = this.serverExecuteSql();
        if (ret == 0 && this.isCall && (ret = this.serverColDescribe()) == 0) {
            ret = this.serverFetchOutputParameters();
        }
        if (ret != 0) {
            this.throwException();
        }
        this.execInProg = false;
        if (this.mTrace.mLevel >= 5) {
            this.mTrace.writeTrace("UniJDBCProtocolU2Impl#executeSql:leave");
        }
    }

    private void doExecute() throws SQLException {
        if (this.mTrace.mLevel >= 5) {
            this.mTrace.writeTrace("UniJDBCProtocolU2Impl#doExecute:enter");
        }
        this.updCount = 0;
        if (this.paraNum > 0) {
            this.checkPara();
            if (!this.pmarkDefined) {
                this.paraMarkerDefine();
                this.pmarkDefined = true;
            }
            this.paraMarkerBind();
        }
        this.execNestLevel = this.mConfig.txNestLevel;
        this.executeSql();
        if (this.mTrace.mLevel >= 5) {
            this.mTrace.writeTrace("UniJDBCProtocolU2Impl#doExecute:leave");
        }
    }

    private void preExecute() throws SQLException {
        String sql;
        if (this.mTrace.mLevel >= 5) {
            this.mTrace.writeTrace("UniJDBCProtocolU2Impl#preExecute:enter");
        }
        if ((sql = this.mStatement.getCommandString()) == null) {
            return;
        }
        if (this.isExecInProg) {
            this.addAndThrowException(930011);
        }
        this.clearExceptions();
        if (this.mTrace.mLevel >= 2) {
            this.mTrace.writeTrace(String.valueOf(String.valueOf(new StringBuffer("isExecuted:").append(this.isExecuted).append(", isSelect:").append(this.isSelect).append(", isFetchInProg:").append(this.isFetchInProg))));
        }
        if (this.isExecuted && this.isSelect || this.isFetchInProg) {
            this.addAndThrowException(930007);
        }
        this.inSql = new String(sql);
        this.outSql = sql.charAt(sql.length() - 1) != ';' ? String.valueOf(String.valueOf(sql)).concat(String.valueOf(String.valueOf(';'))) : new String(sql);
        if (this.mTrace.mLevel >= 2) {
            this.mTrace.writeTrace("UniJDBCProtocolU2Impl#preExecute:outSql:".concat(String.valueOf(String.valueOf(this.outSql))));
        }
        if (this.mTrace.mLevel >= 5) {
            this.mTrace.writeTrace("UniJDBCProtocolU2Impl#preExecute:leave");
        }
    }

    private void doExecuteAll() throws SQLException {
        if (this.mTrace.mLevel >= 5) {
            this.mTrace.writeTrace("UniJDBCProtocolU2Impl#doExecuteAll:enter");
        }
        this.preExecute();
        this.cancelled = false;
        this.prepare();
        this.doExecute();
        this.isExecuted = true;
        this.execType = 1;
        if (this.mTrace.mLevel >= 5) {
            this.mTrace.writeTrace("UniJDBCProtocolU2Impl#doExecuteAll:leave");
        }
    }

    private int serverFetch() {
        if (this.mTrace.mLevel >= 5) {
            this.mTrace.writeTrace("UniJDBCProtocolU2Impl#serverFetch:enter");
        }
        try {
            this.rpcOutPacket.write(0, this.cursorRefNum);
            this.rpcOutPacket.write(1, this.mConfig.maxFetchBuff);
            this.rpcOutPacket.write(2, this.mConfig.maxFetchCols);
            this.rpcOutPacket.write(3, 10);
            this.rpcOutPacket.write(4, 0);
            this.rpcConnection.call(this.rpcOutPacket, this.rpcInPacket);
            this.jciReturnCode = this.rpcInPacket.readInteger(0);
            this.jciServerCode = this.rpcInPacket.readInteger(1);
            this.fetchedRows = this.rpcInPacket.readInteger(2);
            if (this.mTrace.mLevel >= 2) {
                this.mTrace.writeTrace(String.valueOf(String.valueOf(new StringBuffer("cursor:").append(this.cursorRefNum).append(",fetchedRows=").append(this.fetchedRows).append(",rc=").append(this.jciReturnCode).append(",sc=").append(this.jciServerCode))));
            }
            this.serverIsoLevel = this.rpcInPacket.readInteger(5);
            this.fetchHeader = this.rpcInPacket.readBytes(3);
            this.fetchData = this.rpcInPacket.readBytes(4);
            if (this.jciReturnCode != 0) {
                this.addException(930059);
                int n = -1;
                return n;
            }
            if (this.jciServerCode != 0) {
                this.addServerError(this.jciServerCode);
                int n = -1;
                return n;
            }
        }
        catch (UniRPCException e) {
            this.addException(930059, (Exception)((Object)e));
        }
        if (this.mTrace.mLevel >= 5) {
            this.mTrace.writeTrace("UniJDBCProtocolU2Impl#serverFetch:leave-success");
        }
        return 0;
    }

    private int serverCancel() {
        if (this.mTrace.mLevel >= 5) {
            this.mTrace.writeTrace("UniJDBCProtocolU2Impl#serverCancel:enter");
        }
        try {
            this.rpcOutPacket.write(0, this.cursorRefNum);
            this.rpcOutPacket.write(1, 2);
            this.rpcOutPacket.write(2, 0);
            this.rpcConnection.call(this.rpcOutPacket, this.rpcInPacket);
            this.jciReturnCode = this.rpcInPacket.readInteger(0);
            this.jciServerCode = this.rpcInPacket.readInteger(1);
            if (this.jciReturnCode != 0) {
                this.addException(930059);
                int n = -1;
                return n;
            }
            if (this.jciServerCode != 0) {
                this.addServerError(this.jciServerCode);
                int n = -1;
                return n;
            }
            this.cancelled = true;
        }
        catch (UniRPCException e) {
            this.addException(930059, (Exception)((Object)e));
        }
        if (this.mTrace.mLevel >= 5) {
            this.mTrace.writeTrace("UniJDBCProtocolU2Impl#serverCancel:leave-success");
        }
        return 0;
    }

    public void executeCancel() throws SQLException {
        if (this.mTrace.mLevel >= 5) {
            this.mTrace.writeTrace("UniJDBCProtocolU2Impl#executeCancel()#start");
        }
        if (!this.mConnection.lockSession()) {
            throw this.mMsgFactory.createException(951041);
        }
        try {
            if (this.serverCancel() != 0) {
                this.throwException();
            }
            Object var2_1 = null;
            this.mConnection.unlockSession();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.mConnection.unlockSession();
            throw throwable;
        }
        if (this.mTrace.mLevel >= 5) {
            this.mTrace.writeTrace("UniJDBCProtocolU2Impl#executeCancel()#end");
        }
    }

    public boolean nextRow() throws SQLException {
        if (this.mTrace.mLevel >= 5) {
            this.mTrace.writeTrace("UniJDBCProtocolU2Impl#nextRow:enter");
        }
        if (this.rowsOfData == 0) {
            if (!this.moreData) {
                return false;
            }
            if (this.serverFetch() != 0) {
                this.throwException();
            }
            if (this.fetchedRows == 0) {
                return false;
            }
        } else {
            if (this.mTrace.mLevel >= 5) {
                this.mTrace.writeTrace("UniJDBCProtocolU2Impl#nextRow:leave-1");
            }
            return this.fetchNext();
        }
        this.fetchColinfoStart = 16;
        this.rowsOfData = this.getInt(this.fetchHeader, 0);
        this.dataSize = this.getInt(this.fetchHeader, 4);
        this.moreData = this.getInt(this.fetchHeader, 8) != 0;
        this.colEntries = this.getInt(this.fetchHeader, 12);
        if (this.mTrace.mLevel >= 5) {
            this.mTrace.writeTrace("UniJDBCProtocolU2Impl#nextRow:leave-2");
        }
        return this.fetchNext();
    }

    private boolean fetchNext() throws SQLException {
        int i;
        for (i = 0; i < this.descVector.size(); ++i) {
            UniJDBCColumnDesc jciColDesc = (UniJDBCColumnDesc)this.descVector.elementAt(i);
            jciColDesc.offset = this.getInt(this.fetchHeader, this.fetchColinfoStart);
            jciColDesc.width = this.getInt(this.fetchHeader, this.fetchColinfoStart + 4);
            jciColDesc.valCount = this.getInt(this.fetchHeader, this.fetchColinfoStart + 8);
            this.fetchColinfoStart += 12;
        }
        --this.rowsOfData;
        for (i = 0; i < this.mColumnCache.length; ++i) {
            this.mColumnCache[i] = null;
        }
        return true;
    }

    private int serverFetchOutputParameters() {
        if (this.mTrace.mLevel >= 5) {
            this.mTrace.writeTrace("UniJDBCProtocolU2Impl#serverFetchOutputParameters:enter");
        }
        try {
            int numParams = this.paraMarkerVector == null ? 0 : this.paraMarkerVector.length;
            this.rpcOutPacket.write(0, this.cursorRefNum);
            this.rpcOutPacket.write(1, numParams);
            this.rpcOutPacket.write(2, 17);
            this.rpcOutPacket.write(3, 0);
            this.rpcConnection.call(this.rpcOutPacket, this.rpcInPacket);
            this.jciReturnCode = this.rpcInPacket.readInteger(0);
            this.jciServerCode = this.rpcInPacket.readInteger(1);
            if (this.jciReturnCode != 0) {
                this.addException(930059);
                int n = -1;
                return n;
            }
            if (this.jciServerCode != 0) {
                this.addServerError(this.jciServerCode);
                int n = -1;
                return n;
            }
            int numOutParams = this.rpcInPacket.readInteger(2);
            int j = 0;
            block2: for (int i = 0; i < numOutParams; ++i) {
                while (j < numParams) {
                    UniJDBCParaMarker param = this.paraMarkerVector[j];
                    if (param.isOutput()) {
                        UniJDBCVARCHAR object = new UniJDBCVARCHAR(this.mStatement.getUniJDBCConnection());
                        ((UniJDBCObject)object).fromDatabase(this.rpcInPacket.readBytes(i + 3));
                        param.setValue(object);
                        ++j;
                        continue block2;
                    }
                    ++j;
                }
            }
        }
        catch (UniRPCException e) {
            this.addException(930059, (Exception)((Object)e));
        }
        if (this.mTrace.mLevel >= 5) {
            this.mTrace.writeTrace("UniJDBCProtocolU2Impl#serverFetchOutputParameters:leave");
        }
        return 0;
    }

    private int startTransaction() {
        if (this.mTrace.mLevel >= 5) {
            this.mTrace.writeTrace("UniJDBCProtocolU2Impl#startTransaction:enter");
        }
        try {
            this.rpcOutPacket.write(0, this.logNum);
            this.rpcOutPacket.write(1, this.mConfig.procIsoLevel);
            this.rpcOutPacket.write(2, 15);
            this.rpcOutPacket.write(3, 0);
            this.rpcConnection.call(this.rpcOutPacket, this.rpcInPacket);
            this.jciReturnCode = this.rpcInPacket.readInteger(0);
            this.jciServerCode = this.rpcInPacket.readInteger(1);
            if (this.jciReturnCode != 0) {
                this.addException(930059);
                int n = -1;
                return n;
            }
            if (this.jciServerCode != 0) {
                this.addServerError(this.jciServerCode);
                int n = -1;
                return n;
            }
            this.mConfig.actIsoLevel = this.rpcInPacket.readInteger(2);
            if (this.mTrace.mLevel >= 2) {
                this.mTrace.writeTrace("new iso-level:".concat(String.valueOf(String.valueOf(this.mConfig.actIsoLevel))));
            }
            this.txStarted = true;
        }
        catch (UniRPCException e) {
            this.addException(930059, (Exception)((Object)e));
        }
        if (this.mTrace.mLevel >= 5) {
            this.mTrace.writeTrace("UniJDBCProtocolU2Impl#startTransaction:leave");
        }
        return 0;
    }

    private int commitTransaction() {
        if (this.mTrace.mLevel >= 5) {
            this.mTrace.writeTrace("UniJDBCProtocolU2Impl#commitTransaction:enter");
        }
        try {
            if (this.mTrace.mLevel >= 2) {
                this.mTrace.writeTrace("commitTransaction iso-level:".concat(String.valueOf(String.valueOf(this.mConfig.procIsoLevel))));
            }
            this.rpcOutPacket.write(0, this.logNum);
            this.rpcOutPacket.write(1, 4);
            this.rpcOutPacket.write(2, 0);
            this.rpcConnection.call(this.rpcOutPacket, this.rpcInPacket);
            this.jciReturnCode = this.rpcInPacket.readInteger(0);
            this.jciServerCode = this.rpcInPacket.readInteger(1);
            if (this.jciReturnCode != 0) {
                this.addException(930059);
                int n = -1;
                return n;
            }
            if (this.jciServerCode != 0) {
                this.addServerError(this.jciServerCode);
                int n = -1;
                return n;
            }
            this.mConfig.procIsoLevel = this.rpcInPacket.readInteger(2);
            if (this.mTrace.mLevel >= 2) {
                this.mTrace.writeTrace("commitTransaction new-iso-level:".concat(String.valueOf(String.valueOf(this.mConfig.procIsoLevel))));
            }
        }
        catch (UniRPCException e) {
            this.addException(930059, (Exception)((Object)e));
        }
        if (this.mTrace.mLevel >= 5) {
            this.mTrace.writeTrace("UniJDBCProtocolU2Impl#commitTransaction:leave");
        }
        return 0;
    }

    private int rollbackTransaction() {
        if (this.mTrace.mLevel >= 5) {
            this.mTrace.writeTrace("UniJDBCProtocolU2Impl#rollbackTransaction:enter");
        }
        try {
            if (this.mTrace.mLevel >= 2) {
                this.mTrace.writeTrace("rollbackTransaction iso-level:".concat(String.valueOf(String.valueOf(this.mConfig.procIsoLevel))));
            }
            this.rpcOutPacket.write(0, this.logNum);
            this.rpcOutPacket.write(1, 14);
            this.rpcOutPacket.write(2, 0);
            this.rpcConnection.call(this.rpcOutPacket, this.rpcInPacket);
            this.jciReturnCode = this.rpcInPacket.readInteger(0);
            this.jciServerCode = this.rpcInPacket.readInteger(1);
            if (this.jciReturnCode != 0) {
                this.addException(930059);
                int n = -1;
                return n;
            }
            if (this.jciServerCode != 0) {
                this.addServerError(this.jciServerCode);
                int n = -1;
                return n;
            }
            this.mConfig.actIsoLevel = this.rpcInPacket.readInteger(2);
            if (this.mTrace.mLevel >= 2) {
                this.mTrace.writeTrace("rollbackTransaction new-iso-level:".concat(String.valueOf(String.valueOf(this.mConfig.actIsoLevel))));
            }
        }
        catch (UniRPCException e) {
            this.addException(930059, (Exception)((Object)e));
        }
        if (this.mTrace.mLevel >= 5) {
            this.mTrace.writeTrace("UniJDBCProtocolU2Impl#rollbackTransaction:leave");
        }
        return 0;
    }

    public synchronized UniJDBCObject getColumnValue(int columnIndex) throws SQLException {
        int index = columnIndex - 1;
        if (index < 0 || index >= this.mColumnCache.length) {
            throw this.mMsgFactory.createException(951054, new Object[]{new Integer(columnIndex)});
        }
        if (this.mColumnCache[index] == null) {
            UniJDBCColumnDesc jciColDesc = (UniJDBCColumnDesc)this.descVector.elementAt(index);
            byte[] value = new byte[jciColDesc.width];
            System.arraycopy(this.fetchData, jciColDesc.offset, value, 0, jciColDesc.width);
            UniJDBCObjectBuilder builder = this.mConnection.getObjectBuilder();
            UniJDBCObject object = builder.createObject(jciColDesc.sqlType);
            object.setPrecision(jciColDesc.precision);
            object.setScale(jciColDesc.scale);
            object.fromDatabase(value);
            this.mColumnCache[index] = object;
        }
        return this.mColumnCache[index];
    }

    private String decodeSqlState(int t) {
        char[] buf = new char[5];
        int m = 0;
        int n = 4;
        int i = 0;
        while (n >= 0) {
            m = t / m_code[n];
            t %= m_code[n];
            buf[i] = m < 10 ? (char)(m + 48) : (char)(m - 10 + 65);
            --n;
            ++i;
        }
        buf[4] = m < 10 ? (char)(m + 48) : (char)(m - 10 + 65);
        return new String(buf);
    }

    private void addServerError(int jciServerCode) {
        this.addException(this.getServerErrorMessage(this.cursorRefNum, jciServerCode), this.decodeSqlState(jciServerCode), 930027);
    }

    private void addAndThrowServerError(int jciServerCode) throws SQLException {
        this.addAndThrowException(this.getServerErrorMessage(this.cursorRefNum, jciServerCode), this.decodeSqlState(jciServerCode), 930027);
    }

    public synchronized int getColumnIndex(String columnName) throws SQLException {
        for (int i = 0; i < this.descVector.size(); ++i) {
            UniJDBCColumnDesc columnDesc = (UniJDBCColumnDesc)this.descVector.elementAt(i);
            if (!columnDesc.name.equalsIgnoreCase(columnName)) continue;
            return i + 1;
        }
        throw this.mMsgFactory.createException(951055, new Object[]{columnName});
    }
}

