/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.u2.jdbc;

import com.ibm.u2.jdbc.UniJDBCBaseDouble;
import com.ibm.u2.jdbc.UniJDBCConnection;
import com.ibm.u2.jdbc.UniJDBCDATE;
import com.ibm.u2.jdbc.UniJDBCDECIMAL;
import com.ibm.u2.jdbc.UniJDBCDOUBLE;
import com.ibm.u2.jdbc.UniJDBCFLOAT;
import com.ibm.u2.jdbc.UniJDBCINTEGER;
import com.ibm.u2.jdbc.UniJDBCObject;
import com.ibm.u2.jdbc.UniJDBCObjectBuilder;
import com.ibm.u2.jdbc.UniJDBCParaMarker;
import com.ibm.u2.jdbc.UniJDBCPreparedStatement;
import com.ibm.u2.jdbc.UniJDBCSMALLINT;
import com.ibm.u2.jdbc.UniJDBCStatementImpl;
import com.ibm.u2.jdbc.UniJDBCTIME;
import com.ibm.u2.jdbc.UniJDBCVARCHAR;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class UniJDBCPreparedStatementImpl
extends UniJDBCStatementImpl
implements UniJDBCPreparedStatement {
    protected UniJDBCParaMarker[] mParameters;
    private boolean mExecuted = false;

    public UniJDBCPreparedStatementImpl(UniJDBCConnection conn, String sql) throws SQLException {
        super(conn);
        this.mCommandString = this.mEscapeProcessing ? this.mConnection.nativeSQL(sql) : sql;
        this.mProtocol.executePrepare(this);
        this.mParameters = this.mProtocol.getParameters();
        this.mCursorOpen = true;
        this.mExecuted = false;
    }

    public void setInput(int index, UniJDBCObject value) throws SQLException {
        if (this.mParameters == null || index < 0 || index > this.mParameters.length) {
            throw this.mMsgFactory.createException(930009);
        }
    }

    protected UniJDBCParaMarker getParaMarker(int paraIndex) throws SQLException {
        if (this.mParameters == null || --paraIndex < 0 || paraIndex >= this.mParameters.length) {
            throw this.mMsgFactory.createException(930009);
        }
        return this.mParameters[paraIndex];
    }

    public ResultSet executeQuery() throws SQLException {
        if (this.mTrace.mLevel >= 5) {
            this.mTrace.writeTrace("executeQuery() on statement:enter:".concat(String.valueOf(String.valueOf(this))));
        }
        if (this.mClosed) {
            throw this.mMsgFactory.createException(951071);
        }
        if (this.mExecuted) {
            this.mProtocol.executeCancel();
            this.mExecuted = false;
        }
        this.mProtocol.executeStatementQuery(this);
        if (this.mTrace.mLevel >= 5) {
            this.mTrace.writeTrace("executeQuery() on statement:leave:".concat(String.valueOf(String.valueOf(this))));
        }
        this.mSavedResult.reset();
        this.mExecuted = true;
        return this.mSavedResult;
    }

    public int executeUpdate() throws SQLException {
        if (this.mClosed) {
            throw this.mMsgFactory.createException(951071);
        }
        if (this.mExecuted) {
            this.mProtocol.executeCancel();
            this.mExecuted = false;
        }
        this.mProtocol.executeStatementQuery(this);
        this.mSavedResult.reset();
        this.mExecuted = true;
        return this.mProtocol.getUpdateCount();
    }

    public void setNull(int paraIndex, int sqlType) throws SQLException {
        UniJDBCParaMarker jciParaMarker = this.getParaMarker(paraIndex);
        UniJDBCObjectBuilder builder = this.mConnection.getObjectBuilder();
        int u2type = builder.toLocalType(sqlType);
        UniJDBCObject value = builder.createObject(u2type);
        jciParaMarker.setValue(value);
    }

    public void setBoolean(int paraIndex, boolean x) throws SQLException {
        UniJDBCParaMarker jciParaMarker = this.getParaMarker(paraIndex);
        UniJDBCObject value = this.mConnection.isUniverse() ? new UniJDBCINTEGER(this.mConnection) : new UniJDBCFLOAT(this.mConnection);
        value.fromBoolean(x);
        jciParaMarker.setValue(value);
    }

    public void setByte(int paraIndex, byte x) throws SQLException {
        UniJDBCParaMarker jciParaMarker = this.getParaMarker(paraIndex);
        UniJDBCObject value = this.mConnection.isUniverse() ? new UniJDBCSMALLINT(this.mConnection) : new UniJDBCFLOAT(this.mConnection);
        value.fromByte(x);
        jciParaMarker.setValue(value);
    }

    public void setShort(int paraIndex, short x) throws SQLException {
        UniJDBCParaMarker jciParaMarker = this.getParaMarker(paraIndex);
        UniJDBCObject value = this.mConnection.isUniverse() ? new UniJDBCSMALLINT(this.mConnection) : new UniJDBCFLOAT(this.mConnection);
        value.fromShort(x);
        jciParaMarker.setValue(value);
    }

    public void setInt(int paraIndex, int x) throws SQLException {
        UniJDBCParaMarker jciParaMarker = this.getParaMarker(paraIndex);
        UniJDBCObject value = this.mConnection.isUniverse() ? new UniJDBCINTEGER(this.mConnection) : new UniJDBCFLOAT(this.mConnection);
        value.fromInt(x);
        jciParaMarker.setValue(value);
    }

    public void setLong(int paraIndex, long x) throws SQLException {
        UniJDBCParaMarker jciParaMarker = this.getParaMarker(paraIndex);
        UniJDBCObject value = this.mConnection.isUniverse() ? new UniJDBCDECIMAL(this.mConnection) : new UniJDBCFLOAT(this.mConnection);
        value.fromLong(x);
        jciParaMarker.setValue(value);
    }

    public void setFloat(int paraIndex, float x) throws SQLException {
        UniJDBCParaMarker jciParaMarker = this.getParaMarker(paraIndex);
        UniJDBCFLOAT value = new UniJDBCFLOAT(this.mConnection);
        value.fromFloat(x);
        jciParaMarker.setValue(value);
    }

    public void setDouble(int paraIndex, double x) throws SQLException {
        UniJDBCParaMarker jciParaMarker = this.getParaMarker(paraIndex);
        UniJDBCBaseDouble value = this.mConnection.isUniverse() ? new UniJDBCDOUBLE(this.mConnection) : new UniJDBCFLOAT(this.mConnection);
        ((UniJDBCObject)value).fromDouble(x);
        jciParaMarker.setValue(value);
    }

    public void setBigDecimal(int paraIndex, BigDecimal x) throws SQLException {
        UniJDBCParaMarker jciParaMarker = this.getParaMarker(paraIndex);
        UniJDBCObject value = this.mConnection.isUniverse() ? new UniJDBCDECIMAL(this.mConnection) : new UniJDBCFLOAT(this.mConnection);
        value.fromDecimal(x);
        jciParaMarker.setValue(value);
    }

    public void setString(int paraIndex, String x) throws SQLException {
        UniJDBCParaMarker jciParaMarker = this.getParaMarker(paraIndex);
        UniJDBCVARCHAR value = new UniJDBCVARCHAR(this.mConnection);
        value.fromString(x);
        jciParaMarker.setValue(value);
    }

    public void setBytes(int paraIndex, byte[] x) throws SQLException {
        UniJDBCParaMarker jciParaMarker = this.getParaMarker(paraIndex);
        UniJDBCVARCHAR value = new UniJDBCVARCHAR(this.mConnection);
        value.fromBytes(x);
        jciParaMarker.setValue(value);
    }

    public void setDate(int paraIndex, Date x) throws SQLException {
        UniJDBCParaMarker jciParaMarker = this.getParaMarker(paraIndex);
        UniJDBCDATE value = new UniJDBCDATE(this.mConnection);
        value.fromDate(x);
        jciParaMarker.setValue(value);
    }

    public void setTime(int paraIndex, Time x) throws SQLException {
        UniJDBCParaMarker jciParaMarker = this.getParaMarker(paraIndex);
        UniJDBCTIME value = new UniJDBCTIME(this.mConnection);
        value.fromTime(x);
        jciParaMarker.setValue(value);
    }

    public void setTimestamp(int paraIndex, Timestamp x) throws SQLException {
        UniJDBCParaMarker jciParaMarker = this.getParaMarker(paraIndex);
        UniJDBCVARCHAR value = new UniJDBCVARCHAR(this.mConnection);
        value.fromTimestamp(x);
        jciParaMarker.setValue(value);
    }

    public void setAsciiStream(int paraIndex, InputStream fin, int length) throws SQLException {
        UniJDBCParaMarker jciParaMarker = this.getParaMarker(paraIndex);
        UniJDBCVARCHAR value = new UniJDBCVARCHAR(this.mConnection);
        value.fromAsciiStream(fin, length);
        jciParaMarker.setValue(value);
    }

    public void setUnicodeStream(int paraIndex, InputStream fin, int length) throws SQLException {
        UniJDBCParaMarker jciParaMarker = this.getParaMarker(paraIndex);
        UniJDBCVARCHAR value = new UniJDBCVARCHAR(this.mConnection);
        value.fromUnicodeStream(fin, length);
        jciParaMarker.setValue(value);
    }

    public void setBinaryStream(int paraIndex, InputStream fin, int length) throws SQLException {
        UniJDBCParaMarker jciParaMarker = this.getParaMarker(paraIndex);
        UniJDBCVARCHAR value = new UniJDBCVARCHAR(this.mConnection);
        value.fromAsciiStream(fin, length);
        jciParaMarker.setValue(value);
    }

    public void clearParameters() throws SQLException {
        if (this.mParameters != null) {
            for (int i = 0; i < this.mParameters.length; ++i) {
                this.mParameters[i].clear();
            }
        }
    }

    public void setObject(int paraIndex, Object x) throws SQLException {
        UniJDBCParaMarker jciParaMarker = this.getParaMarker(paraIndex);
        UniJDBCObjectBuilder builder = this.mConnection.getObjectBuilder();
        UniJDBCObject value = builder.toJDBCObject(x);
        jciParaMarker.setValue(value);
    }

    public void setObject(int paraIndex, Object x, int sqlType, int scale) throws SQLException {
        UniJDBCParaMarker jciParaMarker = this.getParaMarker(paraIndex);
        UniJDBCObjectBuilder builder = this.mConnection.getObjectBuilder();
        int u2type = builder.toLocalType(sqlType);
        UniJDBCObject value = builder.toJDBCObject(x, u2type, scale);
        jciParaMarker.setValue(value);
    }

    public void setObject(int paraIndex, Object x, int sqlType) throws SQLException {
        this.setObject(paraIndex, x, sqlType, 0);
    }

    public boolean execute() throws SQLException {
        if (this.mClosed) {
            throw this.mMsgFactory.createException(951071);
        }
        this.mProtocol.executeStatementQuery(this);
        int stmtType = this.mProtocol.getStatementType();
        if (stmtType == 2) {
            this.mResultSetReturned = false;
            this.mCursorOpen = true;
            return true;
        }
        if (stmtType == 3) {
            this.mUpdateCount = this.mProtocol.getUpdateCount();
            this.mCursorOpen = true;
        } else if (stmtType == 1 && this.mConnection.isUniverse()) {
            this.mResultSetReturned = false;
            this.mCursorOpen = true;
            return true;
        }
        return false;
    }

    public void addBatch() throws SQLException {
        this.notSupport();
    }

    public void setCharacterStream(int index, Reader reader, int length) throws SQLException {
        this.notSupport();
    }

    public void setRef(int index, Ref ref) throws SQLException {
        this.notSupport();
    }

    public void setBlob(int index, Blob blob) throws SQLException {
        this.notSupport();
    }

    public void setClob(int index, Clob clob) throws SQLException {
        this.notSupport();
    }

    public void setArray(int index, Array array) throws SQLException {
        this.notSupport();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.mProtocol.getResultSetMetaData();
    }

    public void setDate(int paraIndex, Date x, Calendar c) throws SQLException {
        UniJDBCParaMarker jciParaMarker = this.getParaMarker(paraIndex);
        UniJDBCDATE value = new UniJDBCDATE(this.mConnection);
        value.fromDate(x, c);
        jciParaMarker.setValue(value);
    }

    public void setTime(int paraIndex, Time x, Calendar c) throws SQLException {
        UniJDBCParaMarker jciParaMarker = this.getParaMarker(paraIndex);
        UniJDBCTIME value = new UniJDBCTIME(this.mConnection);
        value.fromTime(x, c);
        jciParaMarker.setValue(value);
    }

    public void setTimestamp(int paraIndex, Timestamp x, Calendar c) throws SQLException {
        UniJDBCParaMarker jciParaMarker = this.getParaMarker(paraIndex);
        UniJDBCVARCHAR value = new UniJDBCVARCHAR(this.mConnection);
        value.fromTimestamp(x, c);
        jciParaMarker.setValue(value);
    }

    public void setNull(int paraIndex, int jdbcType, String typeName) throws SQLException {
        UniJDBCParaMarker jciParaMarker = this.getParaMarker(paraIndex);
        UniJDBCVARCHAR value = new UniJDBCVARCHAR(this.mConnection);
        value.nullify();
        jciParaMarker.setValue(value);
    }
}

