/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.u2.jdbc;

import com.ibm.u2.jdbc.UniJDBCObject;

public class UniJDBCParaMarker {
    private static final String EMPTY_STRING = new String();
    private static final byte[] EMPTY_BYTES = new byte[0];
    private boolean truncated = false;
    private boolean bindMvCol = false;
    private boolean bindMvPara = false;
    private int sqlType;
    private int dataType;
    private int paraType;
    private int prec = 0;
    private int scale = 0;
    private int regSqlType;
    private int regScale;
    private UniJDBCObject mValue;

    public UniJDBCParaMarker() {
        this.clear();
    }

    public void clear() {
        this.dataType = 99;
        this.prec = 0;
        this.scale = 0;
        this.paraType = 1;
        this.regSqlType = -9999999;
        this.regScale = -1;
        this.mValue = null;
    }

    public void setValue(UniJDBCObject value) {
        this.mValue = value;
        this.dataType = value.getDataType();
        this.sqlType = value.getUniJDBCType();
    }

    public UniJDBCObject getValue() {
        return this.mValue;
    }

    public boolean hasBeenSet() {
        if (this.isInput()) {
            return this.mValue != null;
        }
        return true;
    }

    public boolean isInput() {
        return this.paraType == 1 || this.paraType == 2;
    }

    public boolean isOutput() {
        return this.paraType == 4 || this.paraType == 2;
    }

    public int getSQLType() {
        return this.sqlType;
    }

    public void setSQLType(int type) {
        this.sqlType = type;
    }

    public int getDataType() {
        return this.dataType;
    }

    public void setDataType(int type) {
        this.dataType = type;
    }

    public int getParaType() {
        return this.paraType;
    }

    public void setParaType(int type) {
        this.paraType = type;
    }

    public String getString() {
        if (this.mValue != null) {
            return this.mValue.toString();
        }
        return EMPTY_STRING;
    }

    public byte[] getDatabaseValue() {
        if (this.mValue != null) {
            return this.mValue.toDatabase();
        }
        return EMPTY_BYTES;
    }

    public int getPrec() {
        return this.prec;
    }

    public int getScale() {
        return this.scale;
    }

    public void setRegSQLType(int type) {
        this.regSqlType = type;
    }

    public int getRegSQLType() {
        return this.regSqlType;
    }

    public void setRegScale(int scale) {
        this.regScale = scale;
    }

    public int getRegScale() {
        return this.regScale;
    }
}

