/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.u2.jdbc;

import com.ibm.u2.jdbc.UniJDBCConnection;
import com.ibm.u2.jdbc.UniJDBCMsgFactory;
import com.ibm.u2.jdbc.UniJDBCObject;
import java.sql.SQLException;

public abstract class UniJDBCObjectBuilder {
    protected UniJDBCConnection mConnection;
    protected UniJDBCMsgFactory mMsgFactory;

    protected UniJDBCObjectBuilder(UniJDBCConnection connection) {
        this.mConnection = connection;
        this.mMsgFactory = connection.getMsgFactory();
    }

    protected int toSQLType(int u2type) {
        switch (u2type) {
            case 3: {
                return 3;
            }
            case 2: {
                return 2;
            }
            case 8: {
                return 8;
            }
            case 6: {
                return 6;
            }
            case 7: {
                return 7;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 9: {
                return 91;
            }
            case 10: {
                return 92;
            }
            case 12: {
                return 12;
            }
            case 1: {
                return 1;
            }
        }
        return 1111;
    }

    protected String getLocalTypeName(int u2type) {
        switch (u2type) {
            case 3: {
                return "DECIMAL";
            }
            case 2: {
                return "NUMERIC";
            }
            case 8: {
                return "DOUBLE PRECISION";
            }
            case 6: {
                return "FLOAT";
            }
            case 7: {
                return "REAL";
            }
            case 4: {
                return "INTEGER";
            }
            case 5: {
                return "SMALLINT";
            }
            case 9: {
                return "DATE";
            }
            case 10: {
                return "TIME";
            }
            case 12: {
                return "VARCHAR";
            }
            case 1: {
                return "CHAR";
            }
        }
        return "unknown";
    }

    protected boolean isLocalTypeCaseSensitive(int u2type) {
        switch (u2type) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return false;
            }
        }
        return true;
    }

    protected boolean isLocalTypeSigned(int u2type) {
        switch (u2type) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    protected int getLocalTypeScale(int u2type) {
        switch (u2type) {
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                return 16;
            }
        }
        return -1;
    }

    public abstract int toLocalType(int var1) throws SQLException;

    public abstract UniJDBCObject createObject(int var1);

    public abstract UniJDBCObject toJDBCObject(Object var1) throws SQLException;

    public abstract UniJDBCObject toJDBCObject(Object var1, int var2) throws SQLException;

    public abstract UniJDBCObject toJDBCObject(Object var1, int var2, int var3) throws SQLException;

    public abstract Object toJAVAObject(UniJDBCObject var1, int var2, int var3) throws SQLException;
}

