/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.u2.jdbc;

import com.ibm.u2.jdbc.UniJDBCConnection;
import com.ibm.u2.jdbc.UniJDBCMsgFactory;
import com.ibm.u2.jdbc.UniJDBCTrace;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public abstract class UniJDBCObject {
    protected UniJDBCConnection mConnection;
    protected boolean mIsNull = true;
    protected UniJDBCTrace mTrace = null;
    protected int mUniJDBCType;
    protected int mPrecision;
    protected int mScale;
    protected UniJDBCMsgFactory mMsgFactory;

    public void initialize(UniJDBCConnection connection, int sqlType) {
        this.mConnection = connection;
        this.mIsNull = true;
        this.mUniJDBCType = sqlType;
        this.mPrecision = 0;
        this.mScale = 0;
        this.mMsgFactory = connection.getMsgFactory();
    }

    public abstract void fromDatabase(byte[] var1);

    public abstract byte[] toDatabase();

    public void setPrecision(int prec) {
        this.mPrecision = prec;
    }

    public int getPrecision() {
        return this.mPrecision;
    }

    public void setScale(int scale) {
        this.mScale = scale;
    }

    public int getScale() {
        return this.mScale;
    }

    public final boolean isNull() {
        return this.mIsNull;
    }

    public final void nullify() {
        this.mIsNull = true;
    }

    public final void unnullify() {
        this.mIsNull = false;
    }

    int getUniJDBCType() {
        return this.mUniJDBCType;
    }

    public int getDataType() {
        return this.mUniJDBCType;
    }

    public void clear() {
        this.nullify();
    }

    public void clearWarning() {
    }

    public BigDecimal cloneBigDecimal(BigDecimal value) {
        return value.movePointLeft(0);
    }

    public String toString() {
        if (this.isNull()) {
            return this.mConnection.getNullDisplay();
        }
        return super.toString();
    }

    public int toInt() throws SQLException {
        throw this.mMsgFactory.createException(951020, new Object[]{"int"});
    }

    public BigDecimal toDecimal() throws SQLException {
        throw this.mMsgFactory.createException(951020, new Object[]{"BigDecimal"});
    }

    public BigDecimal toDecimal(int scale) throws SQLException {
        throw this.mMsgFactory.createException(951020, new Object[]{"BigDecimal"});
    }

    public byte toByte() throws SQLException {
        throw this.mMsgFactory.createException(951020, new Object[]{"byte"});
    }

    public byte[] toBytes() throws SQLException {
        throw this.mMsgFactory.createException(951020, new Object[]{"byte array"});
    }

    public boolean toBoolean() throws SQLException {
        throw this.mMsgFactory.createException(951020, new Object[]{"boolean"});
    }

    public Date toDate() throws SQLException {
        throw this.mMsgFactory.createException(951020, new Object[]{"Date object"});
    }

    public Date toDate(Calendar calendar) throws SQLException {
        throw this.mMsgFactory.createException(951020, new Object[]{"Date object"});
    }

    public float toFloat() throws SQLException {
        throw this.mMsgFactory.createException(951020, new Object[]{"float"});
    }

    public long toLong() throws SQLException {
        throw this.mMsgFactory.createException(951020, new Object[]{"long"});
    }

    public short toShort() throws SQLException {
        throw this.mMsgFactory.createException(951020, new Object[]{"short"});
    }

    public Time toTime() throws SQLException {
        throw this.mMsgFactory.createException(951020, new Object[]{"Time object"});
    }

    public Time toTime(Calendar calendar) throws SQLException {
        throw this.mMsgFactory.createException(951020, new Object[]{"Time object"});
    }

    public double toDouble() throws SQLException {
        throw this.mMsgFactory.createException(951020, new Object[]{"double"});
    }

    public Timestamp toTimestamp() throws SQLException {
        throw this.mMsgFactory.createException(951020, new Object[]{"Timestamp object"});
    }

    public Timestamp toTimestamp(Calendar calendar) throws SQLException {
        throw this.mMsgFactory.createException(951020, new Object[]{"Timestamp object"});
    }

    public Object toObject() throws SQLException {
        throw this.mMsgFactory.createException(951020, new Object[]{"Object"});
    }

    public InputStream toUnicodeStream() throws SQLException {
        throw this.mMsgFactory.createException(951020, new Object[]{"Unicode stream"});
    }

    public InputStream toAsciiStream() throws SQLException {
        throw this.mMsgFactory.createException(951020, new Object[]{"Ascii stream"});
    }

    public InputStream toBinaryStream() throws SQLException {
        throw this.mMsgFactory.createException(951020, new Object[]{"Binary stream"});
    }

    public void fromInt(int i) throws SQLException {
        throw this.mMsgFactory.createException(951021, new Object[]{"int"});
    }

    public void fromInt(Integer I) throws SQLException {
        throw this.mMsgFactory.createException(951021, new Object[]{"Integer object"});
    }

    public void fromString(String newval) throws SQLException {
        throw this.mMsgFactory.createException(951021, new Object[]{"String object"});
    }

    public void fromDecimal(BigDecimal B) throws SQLException {
        throw this.mMsgFactory.createException(951021, new Object[]{"BigDecimal"});
    }

    public void fromDecimal(BigDecimal B, int scale) throws SQLException {
        throw this.mMsgFactory.createException(951021, new Object[]{"BigDecimal"});
    }

    public void fromByte(byte b) throws SQLException {
        throw this.mMsgFactory.createException(951021, new Object[]{"byte"});
    }

    public void fromByte(Byte B) throws SQLException {
        throw this.mMsgFactory.createException(951021, new Object[]{"Byte object"});
    }

    public void fromBytes(byte[] b) throws SQLException {
        throw this.mMsgFactory.createException(951021, new Object[]{"byte array"});
    }

    public void fromBoolean(boolean b) throws SQLException {
        throw this.mMsgFactory.createException(951021, new Object[]{"boolean"});
    }

    public void fromBoolean(Boolean b) throws SQLException {
        throw this.mMsgFactory.createException(951021, new Object[]{"Boolean object"});
    }

    public void fromDate(Date D) throws SQLException {
        throw this.mMsgFactory.createException(951021, new Object[]{"Date object"});
    }

    public void fromDate(Date D, Calendar c) throws SQLException {
        throw this.mMsgFactory.createException(951021, new Object[]{"Date object"});
    }

    public void fromFloat(float f) throws SQLException {
        throw this.mMsgFactory.createException(951021, new Object[]{"float"});
    }

    public void fromFloat(Float F) throws SQLException {
        throw this.mMsgFactory.createException(951021, new Object[]{"Float object"});
    }

    public void fromLong(long l) throws SQLException {
        throw this.mMsgFactory.createException(951021, new Object[]{"long"});
    }

    public void fromLong(Long L) throws SQLException {
        throw this.mMsgFactory.createException(951021, new Object[]{"Long object"});
    }

    public void fromShort(short s) throws SQLException {
        throw this.mMsgFactory.createException(951021, new Object[]{"short"});
    }

    public void fromShort(Short S) throws SQLException {
        throw this.mMsgFactory.createException(951021, new Object[]{"Short object"});
    }

    public void fromTime(Time T) throws SQLException {
        throw this.mMsgFactory.createException(951021, new Object[]{"Time object"});
    }

    public void fromTime(Time T, Calendar c) throws SQLException {
        throw this.mMsgFactory.createException(951021, new Object[]{"Time object"});
    }

    public void fromDouble(double d) throws SQLException {
        throw this.mMsgFactory.createException(951021, new Object[]{"double"});
    }

    public void fromDouble(Double D) throws SQLException {
        throw this.mMsgFactory.createException(951021, new Object[]{"Double object"});
    }

    public void fromTimestamp(Timestamp t) throws SQLException {
        throw this.mMsgFactory.createException(951021, new Object[]{"Timestamp object"});
    }

    public void fromTimestamp(Timestamp t, Calendar c) throws SQLException {
        throw this.mMsgFactory.createException(951021, new Object[]{"Timestamp object"});
    }

    public void fromObject(Object o) throws SQLException {
        throw this.mMsgFactory.createException(951021, new Object[]{"Object"});
    }

    public void fromUnicodeStream(InputStream fin, int length) throws SQLException {
        throw this.mMsgFactory.createException(951021, new Object[]{"Unicode stream"});
    }

    public void fromAsciiStream(InputStream fin, int length) throws SQLException {
        throw this.mMsgFactory.createException(951021, new Object[]{"Ascii stream"});
    }

    public void fromBinaryStream(InputStream fin, int length) throws SQLException {
        throw this.mMsgFactory.createException(951021, new Object[]{"Binary stream"});
    }
}

