/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.u2.jdbc;

import com.ibm.u2.jdbc.UniJDBCConnection;
import com.ibm.u2.jdbc.UniJDBCMsgFactory;
import com.ibm.u2.jdbc.UniJDBCTrace;
import com.ibm.u2.jdbc.stringUtil;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class UniJDBCNativeSQL {
    private final char LBRACE = (char)123;
    private final char RBRACE = (char)123;
    private final String SLBRACE = "{";
    private final String SRBRACE = "}";
    private final String SLPAREN = "(";
    private final String SRPAREN = ")";
    private final String SBPAREN = "()";
    private final char DQUOTE = (char)34;
    private final String SDQUOTE = "\"";
    private final String SQUOTE = "'";
    private final char LBRACK = (char)91;
    private final char RBRACK = (char)93;
    private final String SLBRACK = "[";
    private final String SRBRACK = "]";
    private final char COMMA = (char)44;
    private final String SCOMMA = ",";
    private final char SPACE = (char)32;
    private final String SSPACE = " ";
    private final char TAB = (char)9;
    private final String STAB = "\t";
    private String oldString = null;
    private String newString = null;
    private UniJDBCConnection conn = null;
    private UniJDBCTrace trace = null;
    private UniJDBCMsgFactory mMsgFactory;
    private static Hashtable funcTable = null;

    public UniJDBCNativeSQL(String sql, UniJDBCConnection jconn) throws SQLException {
        if (sql == null) {
            this.oldString = null;
            this.newString = null;
            throw this.mMsgFactory.createException(951034);
        }
        this.oldString = sql;
        this.conn = jconn;
        this.trace = this.conn.getTrace();
        this.mMsgFactory = this.conn.getMsgFactory();
        this.newString = this.parseSQLString(sql);
    }

    public String getNewString() {
        if (this.trace.mLevel >= 5) {
            this.trace.writeTrace("UniJDBCNativeSQL: getNewString() called:".concat(String.valueOf(String.valueOf(this.newString))));
        }
        return this.newString;
    }

    String parseSQLString(String sql) throws SQLException {
        String searchCond = "";
        boolean ansiJoinSupp = this.conn.isANSIJoin();
        String resStr = "";
        int isAStoredProcCall = 0;
        boolean validSequence = true;
        if (this.trace.mLevel >= 5) {
            this.trace.writeTrace("UniJDBCNativeSQL:parseSQLString(): entered");
        }
        if (sql.indexOf(123) == -1 || sql.indexOf(123) == -1) {
            return sql;
        }
        String markers = "{} \t";
        StringTokenizer strT = new StringTokenizer(sql, markers, true);
        String oldToken = "";
        String token = "";
        while (strT.hasMoreTokens()) {
            String lastChar;
            String firstChar;
            String f;
            if (token.trim().length() > 0) {
                oldToken = token.toLowerCase();
            }
            token = strT.nextToken();
            String nativeString = "";
            if (!token.equals("{")) {
                if (!ansiJoinSupp && token.equalsIgnoreCase("WHERE")) {
                    if (searchCond.length() > 0) {
                        resStr = String.valueOf(String.valueOf(resStr)).concat("and");
                        continue;
                    }
                    resStr = String.valueOf(String.valueOf(resStr)).concat(String.valueOf(String.valueOf(token)));
                    continue;
                }
                resStr = String.valueOf(String.valueOf(resStr)).concat(String.valueOf(String.valueOf(token)));
                continue;
            }
            if (oldToken.indexOf("list") >= 0 || oldToken.indexOf("set") >= 0 || oldToken.indexOf("multiset") >= 0) {
                if (this.trace.mLevel >= 2) {
                    this.trace.writeTrace("UniJDBCNativeSQL():'{' was a 9.x bracket");
                }
                resStr = String.valueOf(String.valueOf(resStr)).concat(String.valueOf(String.valueOf(token)));
                continue;
            }
            while (strT.hasMoreTokens() && !token.equals("}")) {
                oldToken = token;
                token = strT.nextToken();
                if (token.equals("}")) continue;
                nativeString = String.valueOf(String.valueOf(nativeString)).concat(String.valueOf(String.valueOf(token)));
            }
            StringTokenizer str = new StringTokenizer(nativeString);
            String kw = str.hasMoreTokens() ? str.nextToken() : "";
            if (this.trace.mLevel >= 2) {
                this.trace.writeTrace(String.valueOf(String.valueOf(new StringBuffer("UniJDBCNativeSQL(): keyword = '").append(kw).append("'"))));
            }
            if (kw.equals("call")) {
                isAStoredProcCall = 1;
            } else {
                StringTokenizer checkT = new StringTokenizer(nativeString);
                if (checkT.countTokens() < 4) {
                    isAStoredProcCall = 0;
                } else {
                    checkT.nextToken();
                    isAStoredProcCall = !checkT.nextToken().equals("=") ? 0 : (!checkT.nextToken().equalsIgnoreCase("call") ? 0 : 2);
                }
            }
            if (isAStoredProcCall > 0) {
                if (!str.hasMoreTokens()) {
                    throw this.mMsgFactory.createException(951075, new Object[]{String.valueOf(String.valueOf(new StringBuffer("{").append(nativeString).append("}")))});
                }
                if (isAStoredProcCall == 1) {
                    f = str.nextToken("}").trim();
                    if (f.indexOf("(") == -1) {
                        resStr = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(resStr))).append("call ").append(f).append("()")));
                        continue;
                    }
                    resStr = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(resStr))).append("call ").append(f)));
                    continue;
                }
                str.nextToken();
                str.nextToken();
                f = str.nextToken("}").trim();
                String exe = this.conn.isUSVER() ? "execute function " : "call ";
                resStr = String.valueOf(String.valueOf(resStr)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(exe)).concat(String.valueOf(String.valueOf(f))))));
                if (f.indexOf("(") != -1) continue;
                resStr = String.valueOf(String.valueOf(resStr)).concat("()");
                continue;
            }
            if (kw.equals("d") && str.hasMoreTokens()) {
                String d = str.nextToken("}").trim();
                String locdateStr = null;
                firstChar = d.substring(0, 1);
                lastChar = d.substring(d.length() - 1, d.length());
                String nativedateStr = d.substring(1, d.length() - 1);
                if (!firstChar.equals("'") || !lastChar.equals("'")) {
                    throw this.mMsgFactory.createException(951075, new Object[]{String.valueOf(String.valueOf(new StringBuffer("\"").append(sql).append("\"")))});
                }
                locdateStr = nativedateStr;
                if (this.trace.mLevel >= 2) {
                    this.trace.writeTrace("nativedateStr:".concat(String.valueOf(String.valueOf(nativedateStr))));
                }
                resStr = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(resStr))).append("'").append(locdateStr).append("'")));
                continue;
            }
            if (kw.equals("t") && str.hasMoreTokens()) {
                String t = str.nextToken("}").trim();
                String loctimeStr = null;
                boolean isTime = true;
                firstChar = t.substring(0, 1);
                lastChar = t.substring(t.length() - 1, t.length());
                String nativetimeStr = t.substring(1, t.length() - 1);
                if (!firstChar.equals("'") || !lastChar.equals("'")) {
                    throw this.mMsgFactory.createException(951075, new Object[]{String.valueOf(String.valueOf(new StringBuffer("\"").append(sql).append("\"")))});
                }
                loctimeStr = nativetimeStr;
                if (this.trace.mLevel >= 2) {
                    this.trace.writeTrace(String.valueOf(String.valueOf(new StringBuffer("dateUtil.convertNativeSQLDateTime('").append(nativetimeStr).append("')"))));
                }
                resStr = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(resStr))).append("'").append(loctimeStr).append("'")));
                continue;
            }
            if (kw.equals("ts") && str.hasMoreTokens()) {
                String ts = str.nextToken("}").trim();
                String locdatetimeStr = null;
                boolean isTime = false;
                firstChar = ts.substring(0, 1);
                lastChar = ts.substring(ts.length() - 1, ts.length());
                String nativedatetimeStr = ts.substring(1, ts.length() - 1);
                if (!firstChar.equals("'") || !lastChar.equals("'")) {
                    throw this.mMsgFactory.createException(951075, new Object[]{String.valueOf(String.valueOf(new StringBuffer("\"").append(sql).append("\"")))});
                }
                locdatetimeStr = nativedatetimeStr;
                if (this.trace.mLevel >= 2) {
                    this.trace.writeTrace(String.valueOf(String.valueOf(new StringBuffer("convertNativeSQLDateTime('").append(nativedatetimeStr).append("')"))));
                }
                resStr = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(resStr))).append("'").append(locdatetimeStr).append("'")));
                continue;
            }
            if (kw.equals("fn") && str.hasMoreTokens()) {
                String countStr;
                int cnt2;
                String count1Str;
                String arg1;
                StringTokenizer argsT;
                f = str.nextToken("}");
                StringTokenizer fT = new StringTokenizer(f, "()");
                if (!fT.hasMoreTokens()) {
                    throw this.mMsgFactory.createException(951075, new Object[]{String.valueOf(String.valueOf(new StringBuffer("\"").append(str).append("\"")))});
                }
                String func = fT.nextToken().trim();
                String args = fT.hasMoreTokens() ? fT.nextToken("()") : "";
                if (func.equalsIgnoreCase("degrees")) {
                    resStr = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(resStr))).append("(").append(args).append(" * 180 / ").append(Math.PI).append(")")));
                    continue;
                }
                if (func.equalsIgnoreCase("pi")) {
                    resStr = String.valueOf(String.valueOf(resStr)).concat(String.valueOf(String.valueOf(Math.PI)));
                    continue;
                }
                if (func.equalsIgnoreCase("radians")) {
                    resStr = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(resStr))).append("(").append(args).append(" * ").append(Math.PI).append(" / 180").append(")").append(" ")));
                    continue;
                }
                if (func.equalsIgnoreCase("concat")) {
                    argsT = new StringTokenizer(args, ",");
                    String arglist = "";
                    while (argsT.hasMoreTokens()) {
                        arglist = String.valueOf(String.valueOf(arglist)).concat(String.valueOf(String.valueOf(argsT.nextToken())));
                        if (!argsT.hasMoreTokens()) continue;
                        arglist = String.valueOf(String.valueOf(arglist)).concat(" || ");
                    }
                    resStr = String.valueOf(String.valueOf(resStr)).concat(String.valueOf(String.valueOf(arglist)));
                    continue;
                }
                if (func.equalsIgnoreCase("insert")) {
                    StringTokenizer insertT = new StringTokenizer(args, ",");
                    if (insertT.countTokens() != 4) continue;
                    arg1 = insertT.nextToken().trim();
                    count1Str = insertT.nextToken().trim();
                    int cnt1 = stringUtil.stringToInt(count1Str);
                    String count2Str = insertT.nextToken().trim();
                    cnt2 = stringUtil.stringToInt(count2Str);
                    String arg4 = insertT.nextToken().trim();
                    resStr = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(resStr))).append("SUBSTRING ").append("(").append(arg1).append(" FROM 1 FOR ").append(cnt1).append(" - 1 ").append(")").append(" || ").append(arg4).append(" || ").append(" SUBSTRING ").append("(").append(arg1).append(" FROM ").append(cnt1).append("+").append(cnt2).append(" FOR CHAR_LENGTH ").append("(").append(arg1).append(")").append(")")));
                    continue;
                }
                if (func.equalsIgnoreCase("left")) {
                    StringTokenizer leftT = new StringTokenizer(args, ",");
                    if (leftT.countTokens() != 2) continue;
                    arg1 = leftT.nextToken().trim();
                    countStr = leftT.nextToken().trim();
                    int cnt = stringUtil.stringToInt(countStr);
                    resStr = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(resStr))).append(" SUBSTRING ").append("(").append(arg1).append(" FROM 1 FOR ").append(cnt).append(")")));
                    continue;
                }
                if (func.equalsIgnoreCase("right")) {
                    StringTokenizer rightT = new StringTokenizer(args, ",");
                    if (rightT.countTokens() != 2) continue;
                    arg1 = rightT.nextToken().trim();
                    countStr = rightT.nextToken().trim();
                    int cnt = stringUtil.stringToInt(countStr);
                    resStr = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(resStr))).append(" SUBSTRING ").append("(").append(arg1).append(" FROM ").append("(").append("CHAR_LENGTH ").append("(").append(arg1).append(")").append(" + 1 ").append(" - ").append(cnt).append(")").append(" FOR ").append(cnt).append(")")));
                    continue;
                }
                if (func.equalsIgnoreCase("ltrim")) {
                    resStr = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(resStr))).append("trim ").append("(").append("LEADING FROM ").append(args).append(")")));
                    continue;
                }
                if (func.equalsIgnoreCase("rtrim")) {
                    resStr = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(resStr))).append("trim ").append("(").append("TRAILING FROM ").append(args).append(")")));
                    continue;
                }
                if (func.equalsIgnoreCase("lcase")) {
                    resStr = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(resStr))).append("LOWER ").append("(").append(args).append(")")));
                    continue;
                }
                if (func.equalsIgnoreCase("ucase")) {
                    resStr = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(resStr))).append("UPPER ").append("(").append(args).append(")")));
                    continue;
                }
                if (func.equalsIgnoreCase("length")) {
                    resStr = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(resStr))).append("CHAR_LENGTH ").append("(").append("TRIM").append("(").append("TRAILING FROM ").append(args).append(")").append(")")));
                    continue;
                }
                if (func.equalsIgnoreCase("substring")) {
                    StringTokenizer substrT = new StringTokenizer(args, ",");
                    if (substrT.countTokens() != 3) continue;
                    arg1 = substrT.nextToken().trim();
                    count1Str = substrT.nextToken().trim();
                    int cnt1 = stringUtil.stringToInt(count1Str);
                    String count2Str = substrT.nextToken().trim();
                    cnt2 = stringUtil.stringToInt(count2Str);
                    resStr = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(resStr))).append("SUBSTRING ").append("(").append(arg1).append(" FROM ").append(cnt1).append(" FOR ").append(cnt2).append(")")));
                    continue;
                }
                if (func.equalsIgnoreCase("database")) {
                    String sqlcmd = "call *HS.SCHEMA(?)";
                    CallableStatement stmt = this.conn.prepareCall(sqlcmd);
                    stmt.registerOutParameter(1, -1);
                    ResultSet rs = stmt.executeQuery();
                    String db = stmt.getString(1);
                    rs.close();
                    stmt.close();
                    if (db == null) continue;
                    resStr = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(resStr))).append("'").append(db).append("'")));
                    continue;
                }
                if (func.equalsIgnoreCase("user")) {
                    resStr = String.valueOf(String.valueOf(resStr)).concat(" USER ");
                    continue;
                }
                if (func.equalsIgnoreCase("convert")) {
                    String nType;
                    argsT = new StringTokenizer(args, ",");
                    if (argsT.countTokens() != 2) {
                        throw this.mMsgFactory.createException(951070);
                    }
                    String val = argsT.nextToken().trim();
                    String type = argsT.nextToken().trim();
                    if (type.equalsIgnoreCase("time")) {
                        nType = "TIME";
                    } else if (type.equalsIgnoreCase("date")) {
                        nType = "DATE";
                    } else if (type.equalsIgnoreCase("char")) {
                        nType = "CHAR";
                    } else if (type.equalsIgnoreCase("varchar")) {
                        nType = "VARCHAR";
                    } else if (type.equalsIgnoreCase("integer")) {
                        nType = "INTEGER";
                    } else if (type.equalsIgnoreCase("smallint")) {
                        nType = "INTEGER";
                    } else if (type.equalsIgnoreCase("float")) {
                        nType = "FLOAT";
                    } else if (type.equalsIgnoreCase("real")) {
                        nType = "REAL";
                    } else if (type.equalsIgnoreCase("decimal")) {
                        nType = "DECIMAL(38, 9)";
                    } else if (type.equalsIgnoreCase("numeric")) {
                        nType = "NUMERIC(38, 9)";
                    } else if (type.equalsIgnoreCase("double")) {
                        nType = "DOUBLE PRECISION";
                    } else {
                        throw this.mMsgFactory.createException(951015);
                    }
                    resStr = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(resStr))).append("CAST ").append("(").append(val).append(" AS ").append(nType).append(")")));
                    continue;
                }
                throw this.mMsgFactory.createException(951015);
            }
            if (kw.equals("escape") && str.hasMoreTokens()) {
                String f2 = str.nextToken("}");
                StringTokenizer fT = new StringTokenizer(f2, " ");
                if (!fT.hasMoreTokens()) continue;
                resStr = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(resStr))).append("escape ").append(fT.nextToken())));
                continue;
            }
            if (kw.equals("oj") && str.hasMoreTokens()) {
                String ojS = str.nextToken("}");
                StringTokenizer ojT = new StringTokenizer(ojS, " ", true);
                Vector<String> tabList = new Vector<String>();
                String tmp = "";
                String tab = "";
                while (ojT.hasMoreTokens()) {
                    tmp = ojT.nextToken();
                    tab = "";
                    if (tmp.equalsIgnoreCase("ON") || tmp.equalsIgnoreCase("LEFT")) {
                        throw this.mMsgFactory.createException(951076, new Object[]{String.valueOf(String.valueOf(new StringBuffer("\"").append(ojS).append("\"")))});
                    }
                    while (!(!ojT.hasMoreTokens() || tmp.equalsIgnoreCase("LEFT") || tmp.equalsIgnoreCase("OUTER") || tmp.equalsIgnoreCase("JOIN") || tmp.equalsIgnoreCase("ON"))) {
                        tab = String.valueOf(String.valueOf(tab)).concat(String.valueOf(String.valueOf(tmp)));
                        tmp = ojT.nextToken();
                    }
                    if (ansiJoinSupp) {
                        resStr = String.valueOf(String.valueOf(resStr)).concat(String.valueOf(String.valueOf(tab.trim())));
                    } else {
                        tabList.add(tab.trim());
                    }
                    if (!ojT.hasMoreTokens()) {
                        throw this.mMsgFactory.createException(951076, new Object[]{String.valueOf(String.valueOf(new StringBuffer("\"").append(ojS).append("\"")))});
                    }
                    String tok = tmp;
                    if (tok.equalsIgnoreCase("ON")) {
                        String tempCond = "";
                        while (ojT.hasMoreTokens()) {
                            tok = ojT.nextToken();
                            if (ansiJoinSupp) {
                                tempCond = String.valueOf(String.valueOf(tempCond)).concat(String.valueOf(String.valueOf(tok)));
                                continue;
                            }
                            if (tok.equalsIgnoreCase("ON")) {
                                tempCond = String.valueOf(String.valueOf(tempCond)).concat(" and ");
                                continue;
                            }
                            tempCond = String.valueOf(String.valueOf(tempCond)).concat(String.valueOf(String.valueOf(tok)));
                        }
                        if (ansiJoinSupp) {
                            searchCond = " on".concat(String.valueOf(String.valueOf(tempCond)));
                            continue;
                        }
                        searchCond = " where ".concat(String.valueOf(String.valueOf(tempCond)));
                        continue;
                    }
                    if (tok.equalsIgnoreCase("LEFT")) {
                        if (ojT.countTokens() < 3) {
                            throw this.mMsgFactory.createException(951076, new Object[]{String.valueOf(String.valueOf(new StringBuffer("\"").append(ojS).append("\"")))});
                        }
                        if (!(ojT.nextToken().equals(" ") && ojT.nextToken().equalsIgnoreCase("OUTER") && ojT.nextToken().equals(" ") && ojT.nextToken().equalsIgnoreCase("JOIN"))) {
                            throw this.mMsgFactory.createException(951076, new Object[]{String.valueOf(String.valueOf(new StringBuffer("\"").append(ojS).append("\"")))});
                        }
                        if (!ansiJoinSupp) continue;
                        resStr = String.valueOf(String.valueOf(resStr)).concat(" left outer join ");
                        continue;
                    }
                    throw this.mMsgFactory.createException(951076, new Object[]{String.valueOf(String.valueOf(new StringBuffer("\"").append(ojS).append("\"")))});
                }
                if (!ansiJoinSupp) {
                    String newJoin = "";
                    int i = 0;
                    int listSize = tabList.size();
                    for (i = 0; i < listSize; ++i) {
                        newJoin = i > 0 ? String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(newJoin))).append(", outer(").append(tabList.elementAt(i)))) : String.valueOf(String.valueOf(newJoin)).concat(String.valueOf(String.valueOf(tabList.elementAt(i))));
                    }
                    for (i = 1; i <= listSize - 1; ++i) {
                        newJoin = String.valueOf(String.valueOf(newJoin)).concat(")");
                    }
                    resStr = String.valueOf(String.valueOf(resStr)).concat(String.valueOf(String.valueOf(newJoin)));
                }
                if (searchCond.length() <= 0) continue;
                resStr = String.valueOf(String.valueOf(resStr)).concat(String.valueOf(String.valueOf(searchCond)));
                continue;
            }
            validSequence = false;
        }
        if (validSequence) {
            return resStr;
        }
        return sql;
    }

    static {
        if (funcTable == null) {
            funcTable = new Hashtable();
            funcTable.put("abs", "abs");
            funcTable.put("acos", "acos");
            funcTable.put("asin", "asin");
            funcTable.put("atan", "atan");
            funcTable.put("atan2", "atan2");
            funcTable.put("ceiling", "round");
            funcTable.put("exp", "exp");
            funcTable.put("floor", "trunc");
            funcTable.put("log", "logn");
            funcTable.put("log10", "log10");
            funcTable.put("mod", "mod");
            funcTable.put("power", "pow");
            funcTable.put("round", "round");
            funcTable.put("sin", "sin");
            funcTable.put("sign", "sign");
            funcTable.put("sqrt", "sqrt");
            funcTable.put("tan", "tan");
            funcTable.put("truncate", "trunc");
            funcTable.put("length", "length");
            funcTable.put("dayofmonth", "day");
            funcTable.put("month", "month");
            funcTable.put("year", "year");
            funcTable.put("CURDATE", "today");
            funcTable.put("CURTIME", "current");
            funcTable.put("NOW", "current");
            funcTable.put("USER", "user");
        }
    }
}

