/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.u2.jdbc;

import java.sql.SQLException;
import java.sql.SQLWarning;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;

public class UniJDBCMsgFactory {
    private static String MESSAGE_PROPERTY = "com.ibm.u2.jdbc.UniJDBCErrorMessage";
    private static String SQLSTATE_PROPERTY = "com.ibm.u2.jdbc.UniJDBCSQLState";
    private ResourceBundle mMessageResource;
    private static ResourceBundle mStateResource = ResourceBundle.getBundle(SQLSTATE_PROPERTY);
    private Locale mLocale;

    public UniJDBCMsgFactory() {
        this.mMessageResource = ResourceBundle.getBundle(MESSAGE_PROPERTY);
        this.mLocale = null;
    }

    public UniJDBCMsgFactory(Locale locale) {
        try {
            this.mMessageResource = locale != null ? ResourceBundle.getBundle(MESSAGE_PROPERTY, locale) : ResourceBundle.getBundle(MESSAGE_PROPERTY);
            this.mLocale = locale;
        }
        catch (Exception e) {
            this.mMessageResource = ResourceBundle.getBundle(MESSAGE_PROPERTY);
            this.mLocale = null;
        }
    }

    public Locale getLocale() {
        return this.mLocale;
    }

    private String getLocalString(int code) {
        String codeString = new Integer(code).toString();
        try {
            String string = this.mMessageResource.getString(codeString);
            return string;
        }
        catch (Throwable t) {
            String string = String.valueOf(String.valueOf(new StringBuffer("'").append(code).append("':unable to localize the message.")));
            return string;
        }
    }

    private String getSQLState(int code) {
        String codeString = new Integer(code).toString();
        try {
            String string = mStateResource.getString(codeString);
            return string;
        }
        catch (Throwable t) {
            String string = "10000";
            return string;
        }
    }

    public SQLException createException(String reason, String sqlState, int vendorCode) {
        return new SQLException(reason, sqlState, vendorCode);
    }

    public SQLException createException(int error) {
        return new SQLException(this.getLocalString(error), this.getSQLState(error), error);
    }

    public SQLException createException(int error, Exception e) {
        return new SQLException(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.getLocalString(error)))).append(":").append(e.getMessage()))), this.getSQLState(error), error);
    }

    public SQLException createException(int error, String serverError) {
        return new SQLException(serverError, this.getSQLState(error), error);
    }

    public SQLException createException(int error, Object[] args) {
        String reason = MessageFormat.format(this.getLocalString(error), args);
        return new SQLException(reason, this.getSQLState(error), error);
    }

    public SQLWarning createWarning(String reason) {
        return new SQLWarning(reason);
    }

    public SQLWarning createWarning(String reason, String sqlState, int vendorCode) {
        return new SQLWarning(reason, sqlState, vendorCode);
    }

    public SQLWarning createWarning(int error, Exception e) {
        return new SQLWarning(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.getLocalString(error)))).append(":").append(e.getMessage()))), this.getSQLState(error), error);
    }

    public SQLWarning createWarning(int error, Object[] args) {
        String reason = MessageFormat.format(this.getLocalString(error), args);
        return new SQLWarning(reason, this.getSQLState(error), error);
    }
}

