/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.u2.jdbc;

import com.ibm.u2.jdbc.UniJDBCConnection;
import com.ibm.u2.jdbc.UniJDBCMsgFactory;
import java.sql.SQLException;

public class UniJDBCExceptionSupport {
    private UniJDBCConnection mConnection;
    protected UniJDBCMsgFactory mMsgFactory;
    private SQLException mCurrent;
    private SQLException mFirst;

    public UniJDBCExceptionSupport(UniJDBCConnection connection) {
        this.mConnection = connection;
        this.mMsgFactory = this.mConnection.getMsgFactory();
        this.mFirst = null;
        this.mCurrent = null;
    }

    void clearExceptions() {
        this.mFirst = null;
        this.mCurrent = null;
    }

    void throwException() throws SQLException {
        SQLException sqlEx = this.mFirst;
        this.mCurrent = null;
        this.mFirst = null;
        if (sqlEx != null) {
            throw sqlEx;
        }
        throw this.mMsgFactory.createException(951101, new Exception("no exception to throw."));
    }

    private void linkExceptions(SQLException exception) {
        if (this.mFirst == null) {
            this.mFirst = this.mCurrent = exception;
        } else {
            this.mCurrent.setNextException(exception);
            this.mCurrent = exception;
        }
        this.mCurrent.setNextException(null);
    }

    private void linkExceptionsThrow(SQLException exception) throws SQLException {
        this.linkExceptions(exception);
        this.throwException();
    }

    void addAndThrowException(int errCode, Exception e) throws SQLException {
        this.linkExceptionsThrow(this.mMsgFactory.createException(errCode, e));
    }

    void addException(int errCode, Exception e) {
        this.linkExceptions(this.mMsgFactory.createException(errCode, e));
    }

    void addAndThrowException(int errCode) throws SQLException {
        this.linkExceptionsThrow(this.mMsgFactory.createException(errCode));
    }

    void addException(int errCode) {
        this.linkExceptions(this.mMsgFactory.createException(errCode));
    }

    void addAndThrowException(String reason, String sqlState, int vendorCode) throws SQLException {
        this.linkExceptionsThrow(this.mMsgFactory.createException(reason, sqlState, vendorCode));
    }

    void addException(String reason, String sqlState, int vendorCode) {
        this.linkExceptions(this.mMsgFactory.createException(reason, sqlState, vendorCode));
    }

    void addAndThrowException(int errCode, String serverErrorText) throws SQLException {
        this.linkExceptionsThrow(this.mMsgFactory.createException(errCode, serverErrorText));
    }

    void addException(int errCode, String serverErrorText) {
        this.linkExceptions(this.mMsgFactory.createException(errCode, serverErrorText));
    }
}

