/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.u2.jdbc;

import com.ibm.u2.jdbc.UniJDBCConnectionImpl;
import com.ibm.u2.jdbc.UniJDBCMsgFactory;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

public class UniJDBCDriver
implements Driver {
    private static final int majorVersion = 1;
    private static final int minorVersion = 0;
    private static UniJDBCMsgFactory mMsgFactory;

    public Connection connect(String url, Properties prop) throws SQLException {
        Properties urlProp = this.checkURL(url);
        if (urlProp != null) {
            Properties newProp = new Properties();
            ((Hashtable)newProp).putAll(urlProp);
            ((Hashtable)newProp).putAll(prop);
            String userName = newProp.getProperty("user");
            String password = newProp.getProperty("password");
            if (userName == null || password == null) {
                throw mMsgFactory.createException(951033);
            }
            UniJDBCConnectionImpl conn = new UniJDBCConnectionImpl(url, newProp);
            return conn;
        }
        throw mMsgFactory.createException(951032);
    }

    public boolean acceptsURL(String url) throws SQLException {
        return this.checkURL(url) != null;
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties prop) throws SQLException {
        String[] RequiredProperty = new String[]{"user", "password"};
        DriverPropertyInfo[] inf = new DriverPropertyInfo[RequiredProperty.length];
        for (int i = 0; i < RequiredProperty.length; ++i) {
            inf[i++] = new DriverPropertyInfo(RequiredProperty[i].toLowerCase(), null);
        }
        return inf;
    }

    public int getMajorVersion() {
        return 1;
    }

    public int getMinorVersion() {
        return 0;
    }

    public static int getMajorMinorVersion() {
        return 100;
    }

    public boolean jdbcCompliant() {
        return true;
    }

    private Properties checkURL(String url) throws SQLException {
        StringTokenizer tok;
        String jdbc;
        if (url.indexOf(58) == -1) {
            return null;
        }
        int propStart = url.indexOf(63);
        if (propStart < 0) {
            propStart = url.indexOf(59);
        }
        if (!(jdbc = (tok = propStart > 0 ? new StringTokenizer(url.substring(0, propStart), ":") : new StringTokenizer(url, ":")).nextToken()).equalsIgnoreCase("jdbc")) {
            return null;
        }
        if (!tok.hasMoreTokens()) {
            return null;
        }
        String protocol = tok.nextToken();
        if (!protocol.equalsIgnoreCase("ibm-u2")) {
            return null;
        }
        if (!tok.hasMoreTokens()) {
            throw mMsgFactory.createException(951036);
        }
        String odbcdsn = null;
        String hostname = null;
        int hostport = -1;
        String account = null;
        String elem = tok.nextToken();
        if (elem.startsWith("//")) {
            elem = hostname = elem.substring(2);
        } else {
            odbcdsn = elem;
        }
        int acctStart = elem.indexOf(47);
        if (acctStart < 0) {
            if (!tok.hasMoreTokens()) {
                throw mMsgFactory.createException(951037);
            }
            elem = tok.nextToken();
            acctStart = elem.indexOf(47);
            if (acctStart < 0) {
                throw mMsgFactory.createException(951038);
            }
            String portStr = elem.substring(0, acctStart);
            try {
                hostport = Integer.parseInt(portStr);
            }
            catch (NumberFormatException ex) {
                throw mMsgFactory.createException(951039);
            }
            account = elem.substring(acctStart + 1);
        } else {
            if (hostname != null) {
                hostname = elem.substring(0, acctStart);
            } else {
                odbcdsn = elem.substring(0, acctStart);
            }
            account = elem.substring(acctStart + 1);
        }
        while (tok.hasMoreTokens()) {
            account = String.valueOf(String.valueOf(account)).concat(String.valueOf(String.valueOf(":".concat(String.valueOf(String.valueOf(tok.nextToken()))))));
        }
        Properties props = new Properties();
        if (hostname != null) {
            ((Hashtable)props).put("host", hostname);
        } else {
            ((Hashtable)props).put("odbcdsn", odbcdsn);
        }
        if (hostport >= 0) {
            ((Hashtable)props).put("port", new Integer(hostport).toString());
        }
        ((Hashtable)props).put("account", account);
        if (propStart < 0) {
            return props;
        }
        tok = new StringTokenizer(url.substring(propStart + 1), ";");
        while (tok.hasMoreTokens()) {
            String propPair = tok.nextToken();
            int posiEqual = propPair.indexOf(61);
            if (posiEqual <= 0) continue;
            String key = propPair.substring(0, posiEqual);
            String value = propPair.substring(posiEqual + 1);
            ((Hashtable)props).put(key.toLowerCase(), value);
        }
        return props;
    }

    static {
        majorVersion = 1;
        minorVersion = 0;
        try {
            DriverManager.registerDriver(new UniJDBCDriver());
            mMsgFactory = new UniJDBCMsgFactory();
        }
        catch (SQLException e) {
            System.out.println(e.getMessage());
        }
    }
}

