/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.u2.jdbc;

import com.ibm.u2.jdbc.UniJDBCClientResultSet;
import com.ibm.u2.jdbc.UniJDBCConnection;
import com.ibm.u2.jdbc.UniJDBCINTEGER;
import com.ibm.u2.jdbc.UniJDBCMsgFactory;
import com.ibm.u2.jdbc.UniJDBCObject;
import com.ibm.u2.jdbc.UniJDBCResultSetMetaDataImpl;
import com.ibm.u2.jdbc.UniJDBCStatement;
import com.ibm.u2.jdbc.UniJDBCTrace;
import com.ibm.u2.jdbc.UniJDBCVARCHAR;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;

public class UniJDBCDatabaseMetaData
implements DatabaseMetaData {
    protected static String DRIVER_NAME = "IBM Universe/Unidata JDBC Driver";
    protected static String DRIVER_VERSION = "1.0";
    protected static int DRIVER_MAJOR_VERSION = 1;
    protected static int DRIVER_MINOR_VERSION = 0;
    protected static String SELFDEFINED_KEYWORDS = "UNIVERSE,UNIDATA";
    private UniJDBCConnection mConnection;
    private UniJDBCMsgFactory mMsgFactory;
    private boolean is_unidata;
    private UniJDBCTrace mTrace;

    public UniJDBCDatabaseMetaData(UniJDBCConnection connection) {
        this.mConnection = connection;
        this.mMsgFactory = connection.getMsgFactory();
        this.mTrace = connection.getTrace();
        this.is_unidata = !connection.isUniverse();
    }

    public boolean allProceduresAreCallable() throws SQLException {
        return true;
    }

    public boolean allTablesAreSelectable() throws SQLException {
        return true;
    }

    public String getURL() throws SQLException {
        return this.mConnection.getURL();
    }

    public String getUserName() throws SQLException {
        return null;
    }

    public boolean isReadOnly() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedLow() throws SQLException {
        return true;
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    public String getDatabaseProductName() throws SQLException {
        if (this.is_unidata) {
            return "Unidata";
        }
        return "Universe";
    }

    public String getDatabaseProductVersion() throws SQLException {
        if (this.is_unidata) {
            return "6.0.0";
        }
        return "10.0.0";
    }

    public String getDriverName() throws SQLException {
        return DRIVER_NAME;
    }

    public String getDriverVersion() throws SQLException {
        return DRIVER_VERSION;
    }

    public int getDriverMajorVersion() {
        return DRIVER_MAJOR_VERSION;
    }

    public int getDriverMinorVersion() {
        return DRIVER_MINOR_VERSION;
    }

    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return true;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    public String getIdentifierQuoteString() throws SQLException {
        return "\"";
    }

    public String getSQLKeywords() throws SQLException {
        return SELFDEFINED_KEYWORDS;
    }

    public String getNumericFunctions() throws SQLException {
        return "ABS,ACOS,ASIN,ATAN,COS,INT,ISNULL,LN,MOD,NVL,POWER,REUSE,ROUND,SIGN,SIN,SQRT,TAN,TRUNC";
    }

    public String getStringFunctions() throws SQLException {
        return "LENGTH,TO_NUMBER,ISNULL,NVL,||";
    }

    public String getSystemFunctions() throws SQLException {
        return "";
    }

    public String getTimeDateFunctions() throws SQLException {
        return "ADD_MONTHS,LAST_DAY,NEXT_DAY,DATEADD,MONTH_BETWEEN,DATEDIFF,DATEPART,GETDATE";
    }

    public String getSearchStringEscape() throws SQLException {
        return "";
    }

    public String getExtraNameCharacters() throws SQLException {
        return "";
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return !this.is_unidata;
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return !this.is_unidata;
    }

    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    public boolean supportsConvert() throws SQLException {
        return true;
    }

    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        return true;
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return false;
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return false;
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        return true;
    }

    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        return true;
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return false;
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return false;
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return false;
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return true;
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return false;
    }

    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        return false;
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    public String getSchemaTerm() throws SQLException {
        return "SCHEMA";
    }

    public String getProcedureTerm() throws SQLException {
        return "Cataloged-Basic-Program";
    }

    public String getCatalogTerm() throws SQLException {
        return "Catalog";
    }

    public boolean isCatalogAtStart() throws SQLException {
        return false;
    }

    public String getCatalogSeparator() throws SQLException {
        return "";
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        return false;
    }

    public boolean supportsStoredProcedures() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return true;
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return true;
    }

    public boolean supportsUnion() throws SQLException {
        return true;
    }

    public boolean supportsUnionAll() throws SQLException {
        return !this.is_unidata;
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return false;
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return false;
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return false;
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0;
    }

    public int getMaxCharLiteralLength() throws SQLException {
        return 1;
    }

    public int getMaxColumnNameLength() throws SQLException {
        return 128;
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        return 9;
    }

    public int getMaxColumnsInIndex() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        return 21;
    }

    public int getMaxColumnsInSelect() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInTable() throws SQLException {
        return 1000;
    }

    public int getMaxConnections() throws SQLException {
        return 0;
    }

    public int getMaxCursorNameLength() throws SQLException {
        return 0;
    }

    public int getMaxIndexLength() throws SQLException {
        return 0;
    }

    public int getMaxSchemaNameLength() throws SQLException {
        return 128;
    }

    public int getMaxProcedureNameLength() throws SQLException {
        return 128;
    }

    public int getMaxCatalogNameLength() throws SQLException {
        return 0;
    }

    public int getMaxRowSize() throws SQLException {
        return 0;
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return false;
    }

    public int getMaxStatementLength() throws SQLException {
        return 10000;
    }

    public int getMaxStatements() throws SQLException {
        if (this.is_unidata) {
            return 8;
        }
        return 10;
    }

    public int getMaxTableNameLength() throws SQLException {
        return 48;
    }

    public int getMaxTablesInSelect() throws SQLException {
        return 8;
    }

    public int getMaxUserNameLength() throws SQLException {
        return 0;
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        return 2;
    }

    public boolean supportsTransactions() throws SQLException {
        return true;
    }

    public boolean supportsTransactionIsolationLevel() throws SQLException {
        return true;
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return false;
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return true;
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return false;
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    private ResultSet execute(String stmt) throws SQLException {
        if (this.mConnection == null) {
            return null;
        }
        if (this.mConnection.isClosed()) {
            return null;
        }
        UniJDBCStatement dbmetadataStatement = (UniJDBCStatement)this.mConnection.createStatement();
        dbmetadataStatement.markInternalStatement(true);
        ResultSet results = dbmetadataStatement.executeQuery(stmt);
        return results;
    }

    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        throw this.mMsgFactory.createException(930014, new Object[]{"getProcedures"});
    }

    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        throw this.mMsgFactory.createException(930014, new Object[]{"getprocedureColumns"});
    }

    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        String stype = "";
        String sqlstmt = "call *HS.OLEDBINFO('TABS', ?, ?, '', ?, '1', '', 0, 1)";
        StringBuffer sb = new StringBuffer(512);
        if (this.mConnection == null) {
            return null;
        }
        if (this.mConnection.isClosed()) {
            return null;
        }
        if (this.is_unidata) {
            if (schemaPattern == "%") {
                schemaPattern = null;
            }
            sb.append("SELECT '' TABLE_CAT, TABLE_QUALIFIER TABLE_SCHEM, TABLE_NAME, ");
            sb.append("TABLE_TYPE, REMARKS FROM SQLTables ");
            sb.append("WHERE 1 = 1 ");
            if (schemaPattern != null) {
                sb.append("AND TABLE_QUALIFIER LIKE '").append(schemaPattern).append("' ");
            }
            if (tableNamePattern != null) {
                sb.append(" AND TABLE_NAME like '").append(tableNamePattern).append("' ");
            }
            if (types != null) {
                sb.append("AND TABLE_TYPE IN ( ");
                for (int i = 0; i < types.length; ++i) {
                    if (i != 0) {
                        sb.append(", ");
                    }
                    sb.append("'").append(types[i]).append("'");
                }
                sb.append(") ");
            }
            sb.append("ORDER BY 4, 1, 2, 3;");
            String stmt = sb.toString();
            if (this.mTrace.mLevel > 2) {
                this.mTrace.writeTrace(String.valueOf(String.valueOf(new StringBuffer("UniJDBCDatabaseMetaData#getTable():stmt:'").append(stmt).append("'"))));
            }
            return this.execute(stmt);
        }
        if (schemaPattern == null) {
            schemaPattern = "";
        } else if (schemaPattern == "") {
            schemaPattern = null;
        }
        if (tableNamePattern == null) {
            tableNamePattern = "";
        }
        CallableStatement stmt = this.mConnection.prepareCall(sqlstmt);
        ((UniJDBCStatement)((Object)stmt)).markInternalStatement(true);
        stmt.registerOutParameter(1, -1);
        stmt.registerOutParameter(2, -1);
        stmt.registerOutParameter(3, -1);
        stmt.setString(1, schemaPattern);
        stmt.setString(2, tableNamePattern);
        if (types == null) {
            stmt.setString(3, "ALL");
        } else {
            for (int i = 0; i < types.length; ++i) {
                if (i != 0) {
                    stype = String.valueOf(String.valueOf(stype)).concat(", ");
                }
                stype = String.valueOf(String.valueOf(stype)).concat(String.valueOf(String.valueOf(types[i])));
            }
            stmt.setString(3, stype);
        }
        ResultSet results = stmt.executeQuery();
        return results;
    }

    public ResultSet getSchemas() throws SQLException {
        if (this.is_unidata) {
            throw this.mMsgFactory.createException(930014, new Object[]{"getSchemas"});
        }
        String sqlstmt = "call *HS.OLEDBINFO('ACCTS', '', '','','','1','', 0, 1)";
        if (this.mConnection == null) {
            return null;
        }
        if (this.mConnection.isClosed()) {
            return null;
        }
        CallableStatement stmt = this.mConnection.prepareCall(sqlstmt);
        ((UniJDBCStatement)((Object)stmt)).markInternalStatement(true);
        ResultSet results = stmt.executeQuery();
        return results;
    }

    public ResultSet getCatalogs() throws SQLException {
        throw this.mMsgFactory.createException(930014, new Object[]{"getCatalogs"});
    }

    public ResultSet getTableTypes() throws SQLException {
        UniJDBCResultSetMetaDataImpl rsMD = new UniJDBCResultSetMetaDataImpl(this.mConnection, "com.ibm.u2.jdbc.UniJDBCTableType");
        UniJDBCClientResultSet rs = new UniJDBCClientResultSet(this.mConnection, rsMD);
        if (this.is_unidata) {
            UniJDBCObject[] row = rs.createRow();
            row[0] = new UniJDBCVARCHAR(this.mConnection, "TABLE");
            row = rs.createRow();
            row[0] = new UniJDBCVARCHAR(this.mConnection, "VIEW");
        } else {
            UniJDBCObject[] row = rs.createRow();
            row[0] = new UniJDBCVARCHAR(this.mConnection, "BASE TABLE");
            row = rs.createRow();
            row[0] = new UniJDBCVARCHAR(this.mConnection, "SYSTEM TABLE");
            row = rs.createRow();
            row[0] = new UniJDBCVARCHAR(this.mConnection, "VIEW");
        }
        return rs;
    }

    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        String sqlstmt = "call *HS.OLEDBINFO('COLS', ?, ?, ?, '', '1', '', 0, 1)";
        if (this.mConnection == null) {
            return null;
        }
        if (this.mConnection.isClosed()) {
            return null;
        }
        if (this.is_unidata) {
            if (schemaPattern == "%") {
                schemaPattern = null;
            }
            String udstmt = "SELECT '' TABLE_CAT, TABLE_QUALIFIER TABLE_SCHEM, TABLE_NAME,  COLUMN_NAME, DATA_TYPE, TYPE_NAME, LENGTH COLUMN_SIZE,  0 BUFFER_LENGTH, SCALE DECIMAL_DIGITS, RADIX NUM_PREC_RADIX,  NULLABLE, REMARKS, COLUMN_DEFAULT COLUMN_DEF, 0 SQL_DATA_TYPE,  0 SQL_DATETIME_SUB, CHAR_OCTET_LENGTH, COLUMN_POSITION ORDINAL_POSITION,  DECODE(NULLABLE, 0, 'NO', 1, 'YES', '') IS_NULLABLE  FROM SQLColumns  WHERE 1 = 1 ";
            if (schemaPattern != null) {
                udstmt = String.valueOf(String.valueOf(udstmt)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer(" AND TABLE_QUALIFIER LIKE '").append(schemaPattern).append("' "))))));
            }
            if (tableNamePattern != null) {
                udstmt = String.valueOf(String.valueOf(udstmt)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer(" AND TABLE_NAME LIKE '").append(tableNamePattern).append("' "))))));
            }
            if (columnNamePattern != null) {
                udstmt = String.valueOf(String.valueOf(udstmt)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer(" AND COLUMN_NAME LIKE '").append(columnNamePattern).append("' "))))));
            }
            udstmt = String.valueOf(String.valueOf(udstmt)).concat(" ORDER BY 3, 17;");
            return this.execute(udstmt);
        }
        if (schemaPattern == null) {
            schemaPattern = "";
        } else if (schemaPattern == "") {
            schemaPattern = null;
        }
        if (tableNamePattern == null) {
            tableNamePattern = "";
        }
        if (columnNamePattern == null) {
            columnNamePattern = "";
        }
        CallableStatement stmt = this.mConnection.prepareCall(sqlstmt);
        ((UniJDBCStatement)((Object)stmt)).markInternalStatement(true);
        stmt.registerOutParameter(1, -1);
        stmt.registerOutParameter(2, -1);
        stmt.registerOutParameter(3, -1);
        stmt.setString(1, schemaPattern);
        stmt.setString(2, tableNamePattern);
        stmt.setString(3, columnNamePattern);
        ResultSet results = stmt.executeQuery();
        return results;
    }

    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        throw this.mMsgFactory.createException(930014, new Object[]{"getColumnPrivileges"});
    }

    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        throw this.mMsgFactory.createException(930014, new Object[]{"getTablePrivileges"});
    }

    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        throw this.mMsgFactory.createException(930014, new Object[]{"getBestRowIdentifier"});
    }

    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        throw this.mMsgFactory.createException(930014, new Object[]{"getVersionColumns"});
    }

    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        String sqlstmt = "call *HS.OLEDBINFO('KEYS', ?, ?, '', '', '1', '', 0, 1)";
        if (this.mConnection == null) {
            return null;
        }
        if (this.mConnection.isClosed()) {
            return null;
        }
        if (this.is_unidata) {
            if (schema == "%") {
                schema = null;
            }
            String udstmt = "SELECT '' TABLE_CAT, TABLE_QUALIFIER TABLE_SCHEM, TABLE_NAME,  COLUMN_NAME, KEY_SEQ, '' PK_NAME  FROM SQLSpecialColumns  WHERE 1 = 1 ";
            if (schema != null) {
                udstmt = String.valueOf(String.valueOf(udstmt)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer(" AND TABLE_QUALIFIER LIKE '").append(schema).append("' "))))));
            }
            if (table != null) {
                udstmt = String.valueOf(String.valueOf(udstmt)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer(" AND TABLE_NAME LIKE '").append(table).append("' "))))));
            }
            udstmt = String.valueOf(String.valueOf(udstmt)).concat(" ORDER BY TABLE_NAME, KEY_SEQ;");
            return this.execute(udstmt);
        }
        if (schema == null) {
            schema = "";
        } else if (schema == "") {
            schema = null;
        }
        if (table == null) {
            table = "";
        }
        CallableStatement stmt = this.mConnection.prepareCall(sqlstmt);
        ((UniJDBCStatement)((Object)stmt)).markInternalStatement(true);
        stmt.registerOutParameter(1, -1);
        stmt.registerOutParameter(2, -1);
        stmt.setString(1, schema);
        stmt.setString(2, table);
        ResultSet results = stmt.executeQuery();
        return results;
    }

    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        throw this.mMsgFactory.createException(930014, new Object[]{"getImportedKeys"});
    }

    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        throw this.mMsgFactory.createException(930014, new Object[]{"getExportedKeys"});
    }

    public ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        throw this.mMsgFactory.createException(930014, new Object[]{"getCrossReferences"});
    }

    public ResultSet getTypeInfo() throws SQLException {
        UniJDBCResultSetMetaDataImpl rsMD = new UniJDBCResultSetMetaDataImpl(this.mConnection, "com.ibm.u2.jdbc.UniJDBCTypeInfo");
        UniJDBCClientResultSet rs = new UniJDBCClientResultSet(this.mConnection, rsMD);
        UniJDBCObject[] row = rs.createRow();
        row[0] = new UniJDBCVARCHAR(this.mConnection, "DATE");
        row[1] = new UniJDBCINTEGER(this.mConnection, 91);
        row[2] = new UniJDBCINTEGER(this.mConnection, 10);
        row[3] = new UniJDBCVARCHAR(this.mConnection, "");
        row[4] = new UniJDBCVARCHAR(this.mConnection, "");
        row[5] = new UniJDBCVARCHAR(this.mConnection, "");
        row[6] = new UniJDBCINTEGER(this.mConnection, 1);
        row[7] = new UniJDBCINTEGER(this.mConnection, 0);
        row[8] = new UniJDBCINTEGER(this.mConnection, 3);
        row[9] = new UniJDBCINTEGER(this.mConnection, 1);
        row[10] = new UniJDBCINTEGER(this.mConnection, 0);
        row[11] = new UniJDBCINTEGER(this.mConnection, 0);
        row[12] = new UniJDBCVARCHAR(this.mConnection, "DATE");
        row[13] = new UniJDBCINTEGER(this.mConnection, 0);
        row[14] = new UniJDBCINTEGER(this.mConnection, 0);
        row[15] = new UniJDBCINTEGER(this.mConnection, 0);
        row[16] = new UniJDBCINTEGER(this.mConnection, 0);
        row[17] = new UniJDBCINTEGER(this.mConnection, 0);
        row = rs.createRow();
        row[0] = new UniJDBCVARCHAR(this.mConnection, "CHAR");
        row[1] = new UniJDBCINTEGER(this.mConnection, 1);
        row[2] = new UniJDBCINTEGER(this.mConnection, 254);
        row[3] = new UniJDBCVARCHAR(this.mConnection, "'");
        row[4] = new UniJDBCVARCHAR(this.mConnection, "'");
        row[5] = new UniJDBCVARCHAR(this.mConnection, "");
        row[6] = new UniJDBCINTEGER(this.mConnection, 1);
        row[7] = new UniJDBCINTEGER(this.mConnection, 1);
        row[8] = new UniJDBCINTEGER(this.mConnection, 3);
        row[9] = new UniJDBCINTEGER(this.mConnection, 1);
        row[10] = new UniJDBCINTEGER(this.mConnection, 0);
        row[11] = new UniJDBCINTEGER(this.mConnection, 0);
        row[12] = new UniJDBCVARCHAR(this.mConnection, "CHAR");
        row[13] = new UniJDBCINTEGER(this.mConnection, 0);
        row[14] = new UniJDBCINTEGER(this.mConnection, 0);
        row[15] = new UniJDBCINTEGER(this.mConnection, 0);
        row[16] = new UniJDBCINTEGER(this.mConnection, 0);
        row[17] = new UniJDBCINTEGER(this.mConnection, 0);
        row = rs.createRow();
        row[0] = new UniJDBCVARCHAR(this.mConnection, "SMALLINT");
        row[1] = new UniJDBCINTEGER(this.mConnection, 5);
        row[2] = new UniJDBCINTEGER(this.mConnection, 5);
        row[3] = new UniJDBCVARCHAR(this.mConnection, "");
        row[4] = new UniJDBCVARCHAR(this.mConnection, "");
        row[5] = new UniJDBCVARCHAR(this.mConnection, "");
        row[6] = new UniJDBCINTEGER(this.mConnection, 1);
        row[7] = new UniJDBCINTEGER(this.mConnection, 0);
        row[8] = new UniJDBCINTEGER(this.mConnection, 3);
        row[9] = new UniJDBCINTEGER(this.mConnection, 0);
        row[10] = new UniJDBCINTEGER(this.mConnection, 0);
        row[11] = new UniJDBCINTEGER(this.mConnection, 0);
        row[12] = new UniJDBCVARCHAR(this.mConnection, "SMALLINT");
        row[13] = new UniJDBCINTEGER(this.mConnection, 0);
        row[14] = new UniJDBCINTEGER(this.mConnection, 0);
        row[15] = new UniJDBCINTEGER(this.mConnection, 0);
        row[16] = new UniJDBCINTEGER(this.mConnection, 0);
        row[17] = new UniJDBCINTEGER(this.mConnection, 0);
        row = rs.createRow();
        row[0] = new UniJDBCVARCHAR(this.mConnection, "INTEGER");
        row[1] = new UniJDBCINTEGER(this.mConnection, 4);
        row[2] = new UniJDBCINTEGER(this.mConnection, 10);
        row[3] = new UniJDBCVARCHAR(this.mConnection, "");
        row[4] = new UniJDBCVARCHAR(this.mConnection, "");
        row[5] = new UniJDBCVARCHAR(this.mConnection, "");
        row[6] = new UniJDBCINTEGER(this.mConnection, 1);
        row[7] = new UniJDBCINTEGER(this.mConnection, 0);
        row[8] = new UniJDBCINTEGER(this.mConnection, 3);
        row[9] = new UniJDBCINTEGER(this.mConnection, 0);
        row[10] = new UniJDBCINTEGER(this.mConnection, 0);
        row[11] = new UniJDBCINTEGER(this.mConnection, 0);
        row[12] = new UniJDBCVARCHAR(this.mConnection, "INTEGER");
        row[13] = new UniJDBCINTEGER(this.mConnection, 0);
        row[14] = new UniJDBCINTEGER(this.mConnection, 0);
        row[15] = new UniJDBCINTEGER(this.mConnection, 0);
        row[16] = new UniJDBCINTEGER(this.mConnection, 0);
        row[17] = new UniJDBCINTEGER(this.mConnection, 0);
        row = rs.createRow();
        row[0] = new UniJDBCVARCHAR(this.mConnection, "FLOAT");
        row[1] = new UniJDBCINTEGER(this.mConnection, 6);
        row[2] = new UniJDBCINTEGER(this.mConnection, 15);
        row[3] = new UniJDBCVARCHAR(this.mConnection, "");
        row[4] = new UniJDBCVARCHAR(this.mConnection, "");
        row[5] = new UniJDBCVARCHAR(this.mConnection, "");
        row[6] = new UniJDBCINTEGER(this.mConnection, 1);
        row[7] = new UniJDBCINTEGER(this.mConnection, 0);
        row[8] = new UniJDBCINTEGER(this.mConnection, 3);
        row[9] = new UniJDBCINTEGER(this.mConnection, 0);
        row[10] = new UniJDBCINTEGER(this.mConnection, 0);
        row[11] = new UniJDBCINTEGER(this.mConnection, 0);
        row[12] = new UniJDBCVARCHAR(this.mConnection, "FLOAT");
        row[13] = new UniJDBCINTEGER(this.mConnection, 0);
        row[14] = new UniJDBCINTEGER(this.mConnection, 18);
        row[15] = new UniJDBCINTEGER(this.mConnection, 0);
        row[16] = new UniJDBCINTEGER(this.mConnection, 0);
        row[17] = new UniJDBCINTEGER(this.mConnection, 0);
        row = rs.createRow();
        row[0] = new UniJDBCVARCHAR(this.mConnection, "DOUBLE PRECISION");
        row[1] = new UniJDBCINTEGER(this.mConnection, 8);
        row[2] = new UniJDBCINTEGER(this.mConnection, 15);
        row[3] = new UniJDBCVARCHAR(this.mConnection, "");
        row[4] = new UniJDBCVARCHAR(this.mConnection, "");
        row[5] = new UniJDBCVARCHAR(this.mConnection, "");
        row[6] = new UniJDBCINTEGER(this.mConnection, 1);
        row[7] = new UniJDBCINTEGER(this.mConnection, 0);
        row[8] = new UniJDBCINTEGER(this.mConnection, 3);
        row[9] = new UniJDBCINTEGER(this.mConnection, 0);
        row[10] = new UniJDBCINTEGER(this.mConnection, 0);
        row[11] = new UniJDBCINTEGER(this.mConnection, 0);
        row[12] = new UniJDBCVARCHAR(this.mConnection, "DOUBLE PRECISION");
        row[13] = new UniJDBCINTEGER(this.mConnection, 0);
        row[14] = new UniJDBCINTEGER(this.mConnection, 9);
        row[15] = new UniJDBCINTEGER(this.mConnection, 0);
        row[16] = new UniJDBCINTEGER(this.mConnection, 0);
        row[17] = new UniJDBCINTEGER(this.mConnection, 0);
        row = rs.createRow();
        row[0] = new UniJDBCVARCHAR(this.mConnection, "DECIMAL");
        row[1] = new UniJDBCINTEGER(this.mConnection, 3);
        row[2] = new UniJDBCINTEGER(this.mConnection, 15);
        row[3] = new UniJDBCVARCHAR(this.mConnection, "");
        row[4] = new UniJDBCVARCHAR(this.mConnection, "");
        row[5] = new UniJDBCVARCHAR(this.mConnection, "");
        row[6] = new UniJDBCINTEGER(this.mConnection, 1);
        row[7] = new UniJDBCINTEGER(this.mConnection, 0);
        row[8] = new UniJDBCINTEGER(this.mConnection, 3);
        row[9] = new UniJDBCINTEGER(this.mConnection, 0);
        row[10] = new UniJDBCINTEGER(this.mConnection, 0);
        row[11] = new UniJDBCINTEGER(this.mConnection, 0);
        row[12] = new UniJDBCVARCHAR(this.mConnection, "DECIMAL");
        row[13] = new UniJDBCINTEGER(this.mConnection, 0);
        row[14] = new UniJDBCINTEGER(this.mConnection, 9);
        row[15] = new UniJDBCINTEGER(this.mConnection, 0);
        row[16] = new UniJDBCINTEGER(this.mConnection, 0);
        row[17] = new UniJDBCINTEGER(this.mConnection, 0);
        row = rs.createRow();
        row[0] = new UniJDBCVARCHAR(this.mConnection, "NUMERIC");
        row[1] = new UniJDBCINTEGER(this.mConnection, 2);
        row[2] = new UniJDBCINTEGER(this.mConnection, 15);
        row[3] = new UniJDBCVARCHAR(this.mConnection, "");
        row[4] = new UniJDBCVARCHAR(this.mConnection, "");
        row[5] = new UniJDBCVARCHAR(this.mConnection, "");
        row[6] = new UniJDBCINTEGER(this.mConnection, 1);
        row[7] = new UniJDBCINTEGER(this.mConnection, 0);
        row[8] = new UniJDBCINTEGER(this.mConnection, 3);
        row[9] = new UniJDBCINTEGER(this.mConnection, 0);
        row[10] = new UniJDBCINTEGER(this.mConnection, 0);
        row[11] = new UniJDBCINTEGER(this.mConnection, 0);
        row[12] = new UniJDBCVARCHAR(this.mConnection, "NUMERIC");
        row[13] = new UniJDBCINTEGER(this.mConnection, 0);
        row[14] = new UniJDBCINTEGER(this.mConnection, 9);
        row[15] = new UniJDBCINTEGER(this.mConnection, 0);
        row[16] = new UniJDBCINTEGER(this.mConnection, 0);
        row[17] = new UniJDBCINTEGER(this.mConnection, 0);
        row = rs.createRow();
        row[0] = new UniJDBCVARCHAR(this.mConnection, "TIME");
        row[1] = new UniJDBCINTEGER(this.mConnection, 92);
        row[2] = new UniJDBCINTEGER(this.mConnection, 8);
        row[3] = new UniJDBCVARCHAR(this.mConnection, "");
        row[4] = new UniJDBCVARCHAR(this.mConnection, "");
        row[5] = new UniJDBCVARCHAR(this.mConnection, "");
        row[6] = new UniJDBCINTEGER(this.mConnection, 1);
        row[7] = new UniJDBCINTEGER(this.mConnection, 0);
        row[8] = new UniJDBCINTEGER(this.mConnection, 3);
        row[9] = new UniJDBCINTEGER(this.mConnection, 1);
        row[10] = new UniJDBCINTEGER(this.mConnection, 0);
        row[11] = new UniJDBCINTEGER(this.mConnection, 0);
        row[12] = new UniJDBCVARCHAR(this.mConnection, "TIME");
        row[13] = new UniJDBCINTEGER(this.mConnection, 0);
        row[14] = new UniJDBCINTEGER(this.mConnection, 0);
        row[15] = new UniJDBCINTEGER(this.mConnection, 0);
        row[16] = new UniJDBCINTEGER(this.mConnection, 0);
        row[17] = new UniJDBCINTEGER(this.mConnection, 0);
        row = rs.createRow();
        row[0] = new UniJDBCVARCHAR(this.mConnection, "VARCHAR");
        row[1] = new UniJDBCINTEGER(this.mConnection, 12);
        row[2] = new UniJDBCINTEGER(this.mConnection, 256);
        row[3] = new UniJDBCVARCHAR(this.mConnection, "'");
        row[4] = new UniJDBCVARCHAR(this.mConnection, "'");
        row[5] = new UniJDBCVARCHAR(this.mConnection, "");
        row[6] = new UniJDBCINTEGER(this.mConnection, 1);
        row[7] = new UniJDBCINTEGER(this.mConnection, 1);
        row[8] = new UniJDBCINTEGER(this.mConnection, 3);
        row[9] = new UniJDBCINTEGER(this.mConnection, 1);
        row[10] = new UniJDBCINTEGER(this.mConnection, 0);
        row[11] = new UniJDBCINTEGER(this.mConnection, 0);
        row[12] = new UniJDBCVARCHAR(this.mConnection, "VARCHAR");
        row[13] = new UniJDBCINTEGER(this.mConnection, 0);
        row[14] = new UniJDBCINTEGER(this.mConnection, 0);
        row[15] = new UniJDBCINTEGER(this.mConnection, 0);
        row[16] = new UniJDBCINTEGER(this.mConnection, 0);
        row[17] = new UniJDBCINTEGER(this.mConnection, 0);
        return rs;
    }

    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        throw this.mMsgFactory.createException(930014, new Object[]{"getIndexInfo"});
    }

    public boolean supportsResultSetType(int type) throws SQLException {
        return false;
    }

    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        return false;
    }

    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean othersDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean othersInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean updatesAreDetected(int type) throws SQLException {
        return false;
    }

    public boolean deletesAreDetected(int type) throws SQLException {
        return false;
    }

    public boolean insertsAreDetected(int type) throws SQLException {
        return false;
    }

    public boolean supportsBatchUpdates() throws SQLException {
        return false;
    }

    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        throw this.mMsgFactory.createException(930014, new Object[]{"getUDTs"});
    }

    public Connection getConnection() throws SQLException {
        return this.mConnection;
    }

    public boolean othersUpdatesAreVisible(int i) throws SQLException {
        return false;
    }

    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        return false;
    }

    public boolean supportsSchemasInProcedureCalls() {
        return false;
    }
}

