/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.u2.jdbc;

import com.ibm.u2.jdbc.UniJDBCConnection;
import com.ibm.u2.jdbc.UniJDBCObject;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.util.Calendar;

public class UniJDBCDATE
extends UniJDBCObject {
    private Date mValue;
    private static final int U_BASE_DATE = 718796;
    private static final int[] dmsize1;
    private static final int[] dmsize;

    public UniJDBCDATE(UniJDBCConnection conn) {
        this.initialize(conn, 9);
        this.mValue = null;
    }

    public void fromDatabase(byte[] dbValue) {
        String s;
        if (!this.mConnection.isNullValue(dbValue) && (s = this.mConnection.decodeBytes(dbValue)) != null) {
            try {
                int d = Integer.parseInt(s);
                this.mValue = this.convertFromInternal(d);
                this.unnullify();
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.nullify();
        this.mValue = null;
    }

    public byte[] toDatabase() {
        if (this.isNull()) {
            return this.mConnection.getNullDatabaseValue();
        }
        if (!this.mConnection.isUniverse()) {
            return this.mConnection.encodeString(this.toString());
        }
        int days = this.convertToInternal(this.mValue);
        return this.mConnection.encodeString(new Long(days).toString());
    }

    public String toString() {
        if (this.isNull()) {
            return this.mConnection.getNullDisplay();
        }
        return this.mValue.toString();
    }

    public Date toDate() {
        return this.mValue;
    }

    public Time toTime() {
        return new Time(this.mValue.getTime());
    }

    public Object toObject() {
        return this.toDate();
    }

    public void fromString(String s) {
        this.mValue = Date.valueOf(s);
        this.unnullify();
    }

    public void fromLong(long l) throws SQLException {
        this.mValue = new Date(l);
        this.unnullify();
    }

    public void fromLong(Long l) throws SQLException {
        this.mValue = new Date(l);
        this.unnullify();
    }

    public void fromDate(Date date) throws SQLException {
        this.mValue = date;
        this.unnullify();
    }

    public void fromDate(Date date, Calendar c) throws SQLException {
    }

    private Date convertFromInternal(int interdate) throws Exception {
        int day;
        int mon;
        int year;
        block8: {
            int diff;
            block7: {
                year = 0;
                mon = 0;
                day = 0;
                int i = interdate + 718796;
                int year_adj = i / 365;
                int year_adj1 = year_adj - 1;
                int k = year_adj1 / 100;
                year = year_adj - ((year_adj1 >> 2) - k + (k >> 2)) / 365;
                int j = this.DateToInternal(year, 1, 1);
                if (j > i) {
                    j -= 365 + this.leapyear(--year);
                } else if (j + 365 + this.leapyear(year) < i) {
                    throw new Exception("Bad internal date");
                }
                diff = i - j;
                if (this.leapyear(year) != 1) break block7;
                for (mon = 2; mon < 14; ++mon) {
                    if (mon == 3) {
                        --diff;
                    }
                    if (diff >= dmsize1[mon]) continue;
                    day = diff - dmsize1[--mon] + 1;
                    break;
                }
                if (mon != 2) break block8;
                ++day;
                break block8;
            }
            for (mon = 2; mon < 14; ++mon) {
                if (diff >= dmsize1[mon]) continue;
                day = diff - dmsize1[--mon] + 1;
                break;
            }
        }
        if (mon >= 14) {
            throw new Exception("Bad internal date.");
        }
        return Date.valueOf(this.toDateString(year, mon, day));
    }

    private String toDateString(int year, int month, int day) {
        StringBuffer sb = new StringBuffer();
        sb.append(year).append("-");
        if (month < 10) {
            sb.append("0").append(month);
        } else {
            sb.append(month);
        }
        sb.append("-");
        if (day < 10) {
            sb.append("0").append(day);
        } else {
            sb.append(day);
        }
        return sb.toString();
    }

    private int DateToInternal(int year, int month, int day) {
        int internal_date;
        block0: {
            int year1 = year - 1;
            int k = year1 / 100;
            internal_date = year * 365 + (year1 >> 2) - k + (k >> 2) + day;
            internal_date += dmsize1[month];
            if (this.leapyear(year) != 1 || month <= 2) break block0;
            ++internal_date;
        }
        return internal_date;
    }

    private int leapyear(int year) {
        return year % 4 == 0 && year % 100 != 0 || year % 400 == 0 ? 1 : 0;
    }

    private int convertToInternal(Date date) {
        String ds = date.toString();
        int year = Integer.parseInt(ds.substring(0, 4));
        int month = Integer.parseInt(ds.substring(5, 7));
        int day = Integer.parseInt(ds.substring(8, 10));
        int days = dmsize[month - 1];
        if (this.leapyear(year) == 1 && month == 2) {
            ++days;
        }
        int n = this.DateToInternal(year, month, day);
        int elpdays = n - 718796;
        return elpdays;
    }

    static {
        U_BASE_DATE = 718796;
        dmsize1 = new int[]{0, 0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365};
        dmsize = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    }
}

