/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.u2.jdbc;

import com.ibm.u2.jdbc.UniJDBCCallableStatementImpl;
import com.ibm.u2.jdbc.UniJDBCConnection;
import com.ibm.u2.jdbc.UniJDBCDatabaseMetaData;
import com.ibm.u2.jdbc.UniJDBCMsgFactory;
import com.ibm.u2.jdbc.UniJDBCNativeSQL;
import com.ibm.u2.jdbc.UniJDBCObjectBuilder;
import com.ibm.u2.jdbc.UniJDBCPreparedStatementImpl;
import com.ibm.u2.jdbc.UniJDBCProperties;
import com.ibm.u2.jdbc.UniJDBCProtocol;
import com.ibm.u2.jdbc.UniJDBCProtocolU2Impl;
import com.ibm.u2.jdbc.UniJDBCStatement;
import com.ibm.u2.jdbc.UniJDBCStatementImpl;
import com.ibm.u2.jdbc.UniJDBCTrace;
import com.ibm.u2.jdbc.UniverseObjectBuilder;
import java.io.UnsupportedEncodingException;
import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public class UniJDBCConnectionImpl
implements UniJDBCConnection {
    private UniJDBCProtocol mProtocol;
    private String mURL;
    private UniJDBCProperties mProps;
    private Vector mStmtList;
    private boolean mIsOpen = false;
    private boolean mReadOnly = false;
    private SQLWarning mConnWarnings = null;
    private UniJDBCMsgFactory mMsgFactory;
    private boolean mIsUniverse = true;
    private UniJDBCObjectBuilder mObjectBuilder = null;
    private boolean mSessionMutexLocked = false;
    private Thread mLockThread = null;
    private UniJDBCTrace mTrace;
    private final String U2NullValue = new String(new char[]{'\u20ac'});
    private String mNullDisplay = null;
    private byte[] mDatabaseNullValue = new byte[]{-128};
    private String mClientEncoding = null;
    private static final byte[] _encodingTestData = new byte[]{1, 2, 3, 65, 66, 48, 49};

    public UniJDBCConnectionImpl(String url, Properties propIn) throws SQLException {
        String traceFile;
        UniJDBCProperties prop;
        this.mProps = prop = new UniJDBCProperties(propIn);
        this.mStmtList = new Vector();
        this.mTrace = new UniJDBCTrace();
        String traceLevel = prop.getProperty("tracelevel");
        if (traceLevel != null) {
            try {
                int level = Integer.parseInt(traceLevel);
                this.mTrace.setLevel(level);
            }
            catch (NumberFormatException level) {
                // empty catch block
            }
        }
        if ((traceFile = prop.getProperty("tracefile")) != null) {
            this.mTrace.setTraceFile(traceFile);
        }
        if (this.mTrace.mLevel >= 5) {
            this.mTrace.writeTrace("UniJDBCConnectionImpl#constructor#enter");
        }
        String language = prop.getProperty("language");
        String country = prop.getProperty("country");
        if (language != null && country != null) {
            if (this.mTrace.mLevel >= 2) {
                this.mTrace.writeTrace(String.valueOf(String.valueOf(new StringBuffer("Using language:").append(language).append(",country:").append(country))));
            }
            this.mMsgFactory = new UniJDBCMsgFactory(new Locale(language, country));
        } else {
            if (this.mTrace.mLevel >= 2) {
                this.mTrace.writeTrace("Using default language");
            }
            this.mMsgFactory = new UniJDBCMsgFactory();
        }
        this.mURL = url;
        this.mProtocol = new UniJDBCProtocolU2Impl(this);
        this.mProtocol.executeOpenDatabase(prop);
        this.mIsOpen = true;
        if (!this.isUniverse()) {
            Statement stmt = this.createStatement();
            stmt.execute("SET QUOTED_IDENTIFIER ON;");
            stmt.close();
        }
        if (this.mTrace.mLevel >= 5) {
            this.mTrace.writeTrace("UniJDBCConnectionImpl#constructor#leave");
        }
    }

    private void thowNotSupported() throws SQLException {
        SQLException ex = new SQLException("Not supported.");
        throw ex;
    }

    public UniJDBCTrace getTrace() {
        return this.mTrace;
    }

    public String getclLocale() {
        return null;
    }

    public String getURL() {
        return this.mURL;
    }

    public UniJDBCMsgFactory getMsgFactory() {
        return this.mMsgFactory;
    }

    public void setDBMSType(String type) {
        if (type.equalsIgnoreCase("UNIDATA")) {
            this.mIsUniverse = false;
            this.mObjectBuilder = new UniverseObjectBuilder(this);
        } else {
            this.mIsUniverse = true;
            this.mObjectBuilder = new UniverseObjectBuilder(this);
        }
    }

    public boolean isUniverse() {
        return this.mIsUniverse;
    }

    public UniJDBCObjectBuilder getObjectBuilder() {
        return this.mObjectBuilder;
    }

    public UniJDBCProtocol createProtocol() throws SQLException {
        return this.mProtocol.duplicate();
    }

    public void restoreDefaultProperties() throws SQLException {
        this.closeAllStatements();
        this.setAutoCommit(true);
    }

    public String getNullDisplay() {
        return this.mNullDisplay;
    }

    public byte[] getNullDatabaseValue() {
        return this.mDatabaseNullValue;
    }

    public void setNullDatabaseValue(byte[] newValue) {
        if (newValue != null) {
            this.mDatabaseNullValue = newValue;
        }
    }

    public boolean isNullValue(byte[] bytes) {
        if (bytes == null) {
            return false;
        }
        if (bytes.length != this.mDatabaseNullValue.length) {
            return false;
        }
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] == this.mDatabaseNullValue[i]) continue;
            return false;
        }
        return true;
    }

    public void setClientEncoding(String encoding) throws SQLException {
        try {
            String string = new String(_encodingTestData, encoding);
        }
        catch (UnsupportedEncodingException usee) {
            throw this.mMsgFactory.createException(951010, new Object[]{encoding});
        }
        this.mClientEncoding = encoding;
    }

    public String decodeBytes(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        if (this.mClientEncoding == null) {
            return new String(bytes);
        }
        try {
            String string = new String(bytes, this.mClientEncoding);
            return string;
        }
        catch (Exception ex) {
            String string = null;
            return string;
        }
    }

    public byte[] encodeString(String value) {
        if (value == null) {
            return null;
        }
        if (this.mClientEncoding == null) {
            return value.getBytes();
        }
        try {
            byte[] byArray = value.getBytes(this.mClientEncoding);
            return byArray;
        }
        catch (Exception ex) {
            byte[] byArray = null;
            return byArray;
        }
    }

    public boolean lockSession() {
        return this.lockSession(-1L);
    }

    public synchronized boolean lockSession(long timeOut) {
        if (this.mTrace.mLevel >= 5) {
            this.mTrace.writeTrace(String.valueOf(String.valueOf(new StringBuffer("UniJDBCConnectionImpl#lockSession():Thread:").append(Thread.currentThread().getName()).append(":enter"))));
        }
        try {
            while (this.mSessionMutexLocked) {
                if (timeOut <= (long)0) {
                    Thread.yield();
                    this.wait();
                    continue;
                }
                Thread.yield();
                this.wait(timeOut);
            }
            this.mLockThread = Thread.currentThread();
            this.mSessionMutexLocked = true;
            if (this.mTrace.mLevel >= 5) {
                this.mTrace.writeTrace(String.valueOf(String.valueOf(new StringBuffer("UniJDBCConnectionImpl#lockSession():Thread:").append(Thread.currentThread().getName()).append(":leave:locked"))));
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            if (this.mTrace.mLevel >= 5) {
                this.mTrace.writeTrace(String.valueOf(String.valueOf(new StringBuffer("UniJDBCConnectionImpl#lockSession():Thread:").append(Thread.currentThread().getName()).append(":leave:error:").append(e))));
            }
            boolean bl = false;
            return bl;
        }
    }

    public synchronized void unlockSession() {
        if (this.mTrace.mLevel >= 5) {
            this.mTrace.writeTrace(String.valueOf(String.valueOf(new StringBuffer("UniJDBCConnectionImpl#unlockSession():Thread:").append(Thread.currentThread().getName()).append(":enter"))));
        }
        if (this.mSessionMutexLocked) {
            if (this.mTrace.mLevel >= 5) {
                this.mTrace.writeTrace(String.valueOf(String.valueOf(new StringBuffer("UniJDBCConnectionImpl#unlockSession():Thread:").append(Thread.currentThread().getName()).append(":lock-released"))));
            }
            this.mSessionMutexLocked = false;
        }
        if (this.mTrace.mLevel >= 5) {
            this.mTrace.writeTrace(String.valueOf(String.valueOf(new StringBuffer("UniJDBCConnectionImpl#unlockSession():Thread:").append(Thread.currentThread().getName()).append(":leave"))));
        }
        this.notify();
    }

    public synchronized void markCursorsToClosed(boolean checkStmtType) {
    }

    private synchronized void addToStmtList(UniJDBCStatement stmt) {
        if (this.mStmtList == null) {
            this.mStmtList = new Vector();
        }
        this.mStmtList.addElement(stmt);
    }

    public synchronized void removeFromStmtList(UniJDBCStatement stmt) {
        if (this.mTrace.mLevel >= 5) {
            this.mTrace.writeTrace("UniJDBCConnectionImpl#removeFromStmtList():enter");
        }
        if (stmt == null) {
            if (this.mTrace.mLevel >= 1) {
                this.mTrace.writeTrace("UniJDBCConnectionImpl#removeFromStmtList():leave:try to remove a null statment.");
            }
            return;
        }
        boolean removed = false;
        if (this.mStmtList != null) {
            removed = this.mStmtList.removeElement(stmt);
            if (this.mTrace.mLevel >= 1) {
                this.mTrace.writeTrace(String.valueOf(String.valueOf(new StringBuffer("UniJDBCConnectionImpl#removeFromStmtList():removed-flag:").append(removed).append(",number of statement left:").append(this.mStmtList.size()))));
            }
        }
        if (this.mTrace.mLevel >= 5) {
            this.mTrace.writeTrace("UniJDBCConnectionImpl#removeFromStmtList():leave");
        }
    }

    public boolean isANSIJoin() {
        return true;
    }

    public boolean isUSVER() {
        return false;
    }

    public String getDbName() {
        return this.mProps.getProperty("account");
    }

    public String getCurrency() {
        return "$";
    }

    public String getdbCentury() {
        return "$";
    }

    public String getdbTime() {
        return null;
    }

    public boolean getdbLocaleProp() {
        return false;
    }

    public String getglDate() {
        return null;
    }

    public String getglDateTime() {
        return null;
    }

    public long getdbTodayStart() {
        return 0L;
    }

    public long getdbTodayDate() {
        return 0L;
    }

    public boolean getuseDtenv() {
        return false;
    }

    public boolean getclLocaleProp() {
        return false;
    }

    public String getdbDate() {
        return null;
    }

    protected void finalize() throws Throwable {
        if (this.mTrace.mLevel >= 5) {
            this.mTrace.writeTrace("UniJDBCConnectionImpl#finalize():enter");
        }
        if (this.mIsOpen) {
            try {
                this.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (this.mTrace.mLevel >= 5) {
            this.mTrace.writeTrace("UniJDBCConnectionImpl#finalize():leave");
        }
    }

    public void clearWarnings() throws SQLException {
        this.mConnWarnings = null;
    }

    public synchronized void close() throws SQLException {
        if (this.mTrace.mLevel >= 5) {
            this.mTrace.writeTrace("UniJDBCConnectionImpl#close():enter");
        }
        if (!this.mIsOpen) {
            throw this.mMsgFactory.createException(930003);
        }
        while (this.mStmtList.size() > 0) {
            UniJDBCStatement stmt = (UniJDBCStatement)this.mStmtList.elementAt(0);
            stmt.close();
        }
        this.mProtocol.executeCloseDatabase();
        this.mIsOpen = false;
        if (this.mTrace.mLevel >= 5) {
            this.mTrace.writeTrace("UniJDBCConnectionImpl#close():leave");
        }
    }

    public synchronized void closeAllStatements() {
        if (this.mIsOpen) {
            while (this.mStmtList.size() > 0) {
                UniJDBCStatement stmt = (UniJDBCStatement)this.mStmtList.elementAt(0);
                try {
                    stmt.close();
                }
                catch (SQLException ex) {
                    if (this.mTrace.mLevel < 1) continue;
                    this.mTrace.writeTrace("UniJDBCConnectionImpl#closeAllStatements():error:".concat(String.valueOf(String.valueOf(ex))));
                }
            }
        }
    }

    public void refresh(int mode) throws SQLException {
        if (mode == 2 || mode == 3) {
            this.mProtocol.executeReopenDatabase(this.mProps, mode);
        }
    }

    public void commit() throws SQLException {
        if (this.mTrace.mLevel >= 5) {
            this.mTrace.writeTrace("UniJDBCConnectionImpl#commit():enter");
        }
        this.mProtocol.executeCommit();
        if (this.mTrace.mLevel >= 5) {
            this.mTrace.writeTrace("UniJDBCConnectionImpl#commit():leave");
        }
    }

    public synchronized Statement createStatement() throws SQLException {
        if (this.mTrace.mLevel >= 5) {
            this.mTrace.writeTrace("UniJDBCConnectionImpl#createStatement():leave");
        }
        if (!this.mIsOpen) {
            throw this.mMsgFactory.createException(930003);
        }
        UniJDBCStatementImpl stmt = new UniJDBCStatementImpl(this);
        this.addToStmtList(stmt);
        if (this.mTrace.mLevel >= 5) {
            this.mTrace.writeTrace("UniJDBCConnectionImpl#createStatement():leave");
        }
        return stmt;
    }

    public synchronized Statement createStatement(int rsType, int rsConcurrency) throws SQLException {
        if (this.mTrace.mLevel >= 5) {
            this.mTrace.writeTrace("UniJDBCConnectionImpl#createStatement(int,int):enter");
        }
        if (rsType != 1003) {
            throw this.mMsgFactory.createException(951012, new Object[]{new Integer(rsType)});
        }
        if (rsConcurrency != 1007) {
            throw this.mMsgFactory.createException(951013, new Object[]{new Integer(rsConcurrency)});
        }
        if (this.mTrace.mLevel >= 5) {
            this.mTrace.writeTrace("UniJDBCConnectionImpl#createStatement(int,int):leave");
        }
        return this.createStatement();
    }

    public boolean getAutoCommit() throws SQLException {
        return this.mProtocol.getAutoCommit();
    }

    public String getCatalog() throws SQLException {
        this.thowNotSupported();
        return null;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return new UniJDBCDatabaseMetaData(this);
    }

    public int getTransactionIsolation() throws SQLException {
        int l = this.mProtocol.getIsoLevel();
        this.mTrace.writeTrace("getTransactionIsolation returns:".concat(String.valueOf(String.valueOf(l))));
        return l;
    }

    public Map getTypeMap() throws SQLException {
        this.thowNotSupported();
        return null;
    }

    public SQLWarning getWarnings() throws SQLException {
        SQLWarning protWarn;
        if (this.mProtocol != null && (protWarn = this.mProtocol.getWarnings()) != null) {
            this.addWarning(protWarn);
            this.mProtocol.clearWarnings();
        }
        return this.mConnWarnings;
    }

    private void addWarning(SQLWarning warn) {
        if (this.mConnWarnings == null) {
            this.mConnWarnings = warn;
        } else {
            SQLWarning prev = this.mConnWarnings;
            while (prev.getNextWarning() != null) {
                prev = prev.getNextWarning();
            }
            prev.setNextWarning(warn);
        }
    }

    public boolean isClosed() throws SQLException {
        return !this.mIsOpen;
    }

    public boolean isReadOnly() throws SQLException {
        return this.mReadOnly;
    }

    public String nativeSQL(String sql) throws SQLException {
        UniJDBCNativeSQL translator = new UniJDBCNativeSQL(sql, this);
        return translator.getNewString();
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        if (this.mTrace.mLevel >= 5) {
            this.mTrace.writeTrace("UniJDBCConnectionImpl#pepareCall(String):enter");
        }
        if (!this.mIsOpen) {
            throw this.mMsgFactory.createException(930003);
        }
        UniJDBCCallableStatementImpl stmt = new UniJDBCCallableStatementImpl(this, sql);
        this.addToStmtList(stmt);
        if (this.mTrace.mLevel >= 5) {
            this.mTrace.writeTrace("UniJDBCConnectionImpl#pepareCall(String):leave");
        }
        return stmt;
    }

    public CallableStatement prepareCall(String sql, int rsType, int rsConcurrency) throws SQLException {
        if (this.mTrace.mLevel >= 5) {
            this.mTrace.writeTrace("UniJDBCConnectionImpl#pepareCall(String,int,int):enter");
        }
        this.checkTypeAndConcurrency(rsType, rsConcurrency);
        CallableStatement stmt = this.prepareCall(sql);
        if (this.mTrace.mLevel >= 5) {
            this.mTrace.writeTrace("UniJDBCConnectionImpl#pepareCall(String,int,int):leave");
        }
        return stmt;
    }

    public synchronized PreparedStatement prepareStatement(String sql) throws SQLException {
        if (this.mTrace.mLevel >= 5) {
            this.mTrace.writeTrace("UniJDBCConnectionImpl#pepareStatement(String):enter");
        }
        if (!this.mIsOpen) {
            throw this.mMsgFactory.createException(930003);
        }
        UniJDBCPreparedStatementImpl stmt = new UniJDBCPreparedStatementImpl(this, sql);
        this.addToStmtList(stmt);
        if (this.mTrace.mLevel >= 5) {
            this.mTrace.writeTrace("UniJDBCConnectionImpl#pepareStatement(String):leave");
        }
        return stmt;
    }

    public synchronized PreparedStatement prepareStatement(String sql, int rsType, int rsConcurrency) throws SQLException {
        if (this.mTrace.mLevel >= 5) {
            this.mTrace.writeTrace("UniJDBCConnectionImpl#pepareStatement(String,int,int):enter");
        }
        this.checkTypeAndConcurrency(rsType, rsConcurrency);
        PreparedStatement stmt = this.prepareStatement(sql);
        if (this.mTrace.mLevel >= 5) {
            this.mTrace.writeTrace("UniJDBCConnectionImpl#pepareStatement(String,int,int):leave");
        }
        return stmt;
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (this.mTrace.mLevel >= 5) {
            this.mTrace.writeTrace("UniJDBCConnectionImpl#setAutoCommit():enter");
        }
        this.mProtocol.setAutoCommit(autoCommit);
        if (this.mTrace.mLevel >= 5) {
            this.mTrace.writeTrace("UniJDBCConnectionImpl#setAutoCommit():leave");
        }
    }

    public void setCatalog(String catalog) throws SQLException {
        this.thowNotSupported();
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        this.mReadOnly = readOnly;
    }

    private void checkTypeAndConcurrency(int rsType, int rsConcurrency) throws SQLException {
        if (rsType != 1003) {
            throw this.mMsgFactory.createException(951012, new Object[]{new Integer(rsType)});
        }
        if (rsConcurrency != 1007) {
            throw this.mMsgFactory.createException(951013, new Object[]{new Integer(rsConcurrency)});
        }
    }

    public void rollback() throws SQLException {
        if (this.mTrace.mLevel >= 5) {
            this.mTrace.writeTrace("UniJDBCConnectionImpl#rollback():enter");
        }
        if (!this.mIsOpen) {
            throw this.mMsgFactory.createException(951040);
        }
        this.mProtocol.executeRollback();
        if (this.mTrace.mLevel >= 5) {
            this.mTrace.writeTrace("UniJDBCConnectionImpl#rollback():leave");
        }
    }

    public void setTransactionIsolation(int level) throws SQLException {
        if (this.mTrace.mLevel >= 5) {
            this.mTrace.writeTrace("UniJDBCConnectionImpl#setTransactionIsolation():enter");
        }
        this.mProtocol.setIsoLevel(level);
        if (this.mTrace.mLevel >= 5) {
            this.mTrace.writeTrace("UniJDBCConnectionImpl#setTransactionIsolation():leave");
        }
    }

    public void setTypeMap(Map map) throws SQLException {
        this.thowNotSupported();
    }
}

