/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.u2.jdbc;

import com.ibm.u2.jdbc.UniJDBCConnection;
import com.ibm.u2.jdbc.UniJDBCMsgFactory;
import com.ibm.u2.jdbc.UniJDBCProperties;
import com.ibm.u2.jdbc.UniJDBCTrace;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;

public class UniJDBCConnectionCfg {
    private String mConfigURL;
    private UniJDBCProperties mProps;
    private UniJDBCConnection mConnection;
    private UniJDBCTrace mTrace;
    private UniJDBCMsgFactory mMsgFactory;
    protected String hostName = null;
    protected int hostPort = 31438;
    protected String proxyHost = null;
    protected int proxyPort = 31448;
    protected String service = null;
    protected String network = null;
    protected String dbmsType = null;
    protected String userName = null;
    protected String password = null;
    protected String accountPath = null;
    boolean isToUDT = false;
    boolean euroEnabled = false;
    int isNF1 = 0;
    int txNestLevel;
    int procIsoLevel;
    int actIsoLevel;
    protected String NLSMap = "";
    protected String NLSLCTime = "";
    protected String NLSLCNumeric = "";
    protected String NLSLCMonetary = "";
    protected String NLSLCCtype = "";
    protected String NLSLCCollate = "";
    protected int euroCode = -1;
    boolean emptyNull;
    boolean autoCommit = true;
    boolean odbcPrecision = true;
    boolean truncRound = false;
    boolean sendTround = true;
    boolean sconTime;
    boolean sconNumeric;
    boolean sconMonetary;
    boolean sconCtype;
    boolean sconCollate;
    boolean scondateprec;
    boolean scondateform;
    UniJDBCProperties errorMap = null;
    int maxFetchBuff;
    int maxFetchCols;
    short maxChar;
    short maxVarChar;
    long maxLongVarChar;
    short smIntPrec;
    short intPrec;
    short floatPrec;
    short realPrec;
    short dblPrec;
    long bigIntPrec;
    short datePrec;
    short dateFetch;
    String txStart;
    String txRoll;
    String txCommit;
    String dateForm;
    int eodCode;
    boolean knowPrecision;
    boolean knowNullable;
    boolean knowScale;
    boolean knowDspSize;
    boolean knowUnsigned;
    boolean knowMoney;
    boolean knowUpdate;
    boolean knowAutoInc;
    boolean knowCase;
    boolean knowSearch;
    boolean knowTypeName;
    boolean markerName;
    boolean descB4Exec = true;
    boolean useTgiTx;
    boolean txBehavior;
    public static String OPT_MAXCHAR = "MAXCHAR";
    public static String OPT_MAXVARCHAR = "MAXVARCHAR";
    public static String OPT_SMINTPREC = "SMINTPREC";
    public static String OPT_INTPREC = "INTPREC";
    public static String OPT_FLOATPREC = "FLOATPREC";
    public static String OPT_DBLPREC = "DBLPREC";
    public static String OPT_DBMSTYPE = "DBMSTYPE";
    public static String OPT_DATEFORM = "DATEFORM";
    public static String OPT_PRECISION = "PRECISION";
    public static String OPT_SCALE = "SCALE";
    public static String OPT_NULLABLE = "NULLABLE";
    public static String OPT_DSPSIZE = "DSPSIZE";
    public static String OPT_UNSIGNED = "UNSIGNED";
    public static String OPT_MONEY = "MONEY";
    public static String OPT_UPDATE = "UPDATE";
    public static String OPT_AUTOINC = "AUTOINC";
    public static String OPT_CASE = "CASE";
    public static String OPT_SEARCH = "SEARCH";
    public static String OPT_TYPENAME = "TYPENAME";
    public static String OPT_MARKERNAME = "MARKERNAME";
    public static String OPT_TXSTART = "TXSTART";
    public static String OPT_TXROLL = "TXROLL";
    public static String OPT_TXCOMMIT = "TXCOMMIT";
    public static String OPT_DESCB4EXEC = "DESCB4EXEC";
    public static String OPT_EODCODE = "EODCODE";
    public static String OPT_DATEPREC = "DATEPREC";
    public static String OPT_REALPREC = "REALPREC";
    public static String OPT_USETGITX = "USETGITX";
    public static String OPT_TXBEHAVIOR = "TXBEHAVIOR";
    public static String OPT_DATEFETCH = "DATEFETCH";
    public static String OPT_MAXFETCHBUFF = "MAXFETCHBUFF";
    public static String OPT_MAXFETCHCOLS = "MAXFETCHCOLS";
    public static String OPT_MAXLONGVARCHAR = "MAXLONGVARCHAR";
    public static String OPT_BIGINTPREC = "BIGINTPREC";
    public static String OPT_NLSMAP = "NLSMAP";
    public static String OPT_NLSLOCALE = "NLSLOCALE";
    public static String OPT_NLSLC_TIME = "NLSLCTIME";
    public static String OPT_NLSLC_NUMERIC = "NLSLCNUMERIC";
    public static String OPT_NLSLC_MONETARY = "NLSLCMONETARY";
    public static String OPT_NLSLC_CTYPE = "NLSLCCTYPE";
    public static String OPT_NLSLC_COLLATE = "NLSLCCOLLATE";
    public static String OPT_ACCOUNT = "ACCOUNT";
    public static String OPT_USERNAME = "USERNAME";
    public static String OPT_NETWTYPE = "NETWORK";
    public static String OPT_TCPIP = "TCP/IP";
    public static String OPT_HOST = "HOST";
    public static String OPT_SERVICE = "SERVICE";
    public static String OPT_LAN = "LAN";
    public static String LOCALHOSTNAME = "localhost";
    public static String LOCALHOSTADDR = "127.0.0.1";
    private static final String[] GENERICopts = new String[]{"MAXCHAR =255", "MAXVARCHAR =255", "MAXLONGVARCHAR =4096", "SMINTPREC =5", "INTPREC =10", "BIGINTPREC =20", "FLOATPREC =15", "REALPREC =7", "DBLPREC =15", "DATEFORM =D2", "PRECISION =YES", "SCALE =NO", "NULLABLE =NO", "DSPSIZE =NO", "UNSIGNED =NO", "MONEY =NO", "UPDATE =NO", "AUTOINC =NO", "CASE =NO", "SEARCH =NO", "TYPENAME =NO", "MARKERNAME =NO", "TXSTART =NONE", "TXROLL =NONE", "TXCOMMIT =NONE", "TXBEHAVIOR =0", "USETGITX =YES", "DESCB4EXEC =YES", "EODCODE =-1", "DATEPREC =10", "DATEFETCH =10"};
    private static final String[] UNIVERSEopts = new String[]{"MAXFETCHBUFF =8192", "MAXFETCHCOLS =400", "DATEFORM =D-YMD[4,2,2]", "EODCODE =930115", "PRECISION =YES", "SCALE =YES", "NULLABLE =YES", "DSPSIZE =YES", "UNSIGNED =YES", "MONEY =YES", "UPDATE =YES", "AUTOINC =NO", "CASE =YES", "SEARCH =YES", "TXBEHAVIOR =1", "TYPENAME =YES"};
    private static final String[] UNIVERSEerrormap = new String[]{"08001 =930129", "08004 =930133", "08004 =930127", "08004 =930137", "21S01 =950059", "21S02 =950415", "21S02 =950417", "22005 =950043", "22005 =950121", "22005 =950122", "22005 =950169", "22005 =950617", "23000 =923012", "23000 =923013", "23000 =950136", "23000 =950568", "23000 =950645", "40000 =040065", "40000 =909046", "40000 =950604", "40001 =930157", "40001 =950251", "40001 =950259", "40001 =950260", "40001 =950261", "42000 =001397", "42000 =001422", "42000 =001423", "42000 =001424", "42000 =020142", "42000 =036010", "42000 =950072", "42000 =950076", "42000 =950078", "42000 =950131", "42000 =950303", "42000 =950304", "42000 =950305", "42000 =950306", "42000 =950338", "42000 =950343", "42000 =950350", "42000 =950352", "42000 =950361", "42000 =950362", "42000 =950365", "42000 =950391", "42000 =950392", "42000 =950393", "42000 =950394", "42000 =950395", "42000 =950398", "42000 =950405", "42000 =950406", "42000 =950407", "42000 =950408", "42000 =950409", "42000 =950534", "42000 =950538", "42000 =950539", "42000 =950540", "42000 =950541", "42000 =950546", "42000 =950548", "42000 =950563", "42000 =950588", "42000 =950590", "42000 =950607", "42000 =950609", "S0001 =950458", "S0001 =950459", "S0001 =950528", "S0001 =950529", "S0002 =950311", "S0002 =950313", "S0002 =950316", "S0002 =950390", "S0002 =950455", "S0002 =950545", "S0002 =950596", "S0002 =950597", "S0002 =950598", "S0002 =950599", "S0021 =950416", "S0021 =950570", "S0022 =950418", "S0022 =950425", "S0022 =950428", "S0022 =950522", "S0022 =950523", "S1008 =50003", "S0011 =950663", "S0012 =950664", "S0022 =950667", "IA000 =950051"};
    private static final String[] UNIDATAopts = new String[]{"MAXFETCHBUFF =8192", "MAXFETCHCOLS =400", "DATEFORM =D-YMD[4,2,2]", "EODCODE =-1", "PRECISION =YES", "SCALE =YES", "NULLABLE =YES", "DSPSIZE =YES", "UNSIGNED =YES", "MONEY =YES", "UPDATE =YES", "AUTOINC =NO", "CASE =YES", "SEARCH =YES", "TXBEHAVIOR =1", "TYPENAME =YES"};
    private static final String[] UNIDATA_DefaultNLS = new String[]{"NLSMAP =WIN:1252", "NLSLCTIME =WIN:0409", "NLSLCNUMERIC =WIN:0409", "NLSLCMONETARY =WIN:0409", "NLSLCCTYPE =WIN:0409", "NLSLCCOLLATE =WIN:0409"};
    private static final String[] UNIVERSE_DefaultNLS = new String[]{"NLSMAP =WIN:1252", "NLSLCTIME =WIN:0409", "NLSLCNUMERIC =WIN:0409", "NLSLCMONETARY =WIN:0409", "NLSLCCTYPE =WIN:0409", "NLSLCCOLLATE =WIN:0409"};

    public UniJDBCConnectionCfg(UniJDBCConnection connection, UniJDBCProperties props) throws SQLException {
        String encoding;
        String proxyPortString;
        this.mProps = props;
        this.mConfigURL = this.mProps.getProperty("configurl");
        this.mConnection = connection;
        this.mTrace = connection.getTrace();
        this.mMsgFactory = connection.getMsgFactory();
        String hostname = this.mProps.getProperty("host");
        String dsname = this.mProps.getProperty("odbcdsn");
        String portStr = this.mProps.getProperty("port");
        if (portStr != null) {
            try {
                this.hostPort = Integer.parseInt(portStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.proxyHost = this.mProps.getProperty("proxyhost");
        if (this.proxyHost != null && (proxyPortString = this.mProps.getProperty("proxyport")) != null) {
            try {
                this.proxyPort = Integer.parseInt(proxyPortString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.accountPath = this.mProps.getProperty("account");
        String euroCodeStr = this.mProps.getProperty("eurocode");
        if (euroCodeStr != null && euroCodeStr.length() > 0) {
            try {
                this.euroCode = Integer.decode(euroCodeStr);
            }
            catch (NumberFormatException nfe) {
                throw this.mMsgFactory.createException(951029);
            }
        }
        if ((encoding = this.mProps.getProperty("clientencoding")) != null && encoding.length() > 0) {
            this.mConnection.setClientEncoding(encoding);
        }
        if (hostname != null) {
            this.configByHostname(hostname);
        } else if (dsname != null) {
            this.configByDataSource(dsname);
        }
    }

    private void configByHostname(String hostname) throws SQLException {
        if (this.mTrace.mLevel >= 5) {
            this.mTrace.writeTrace("UniJDBCConnectionCfg#configByHostname:enter");
        }
        if (this.mTrace.mLevel >= 2) {
            this.mTrace.writeTrace(String.valueOf(String.valueOf(new StringBuffer(" hostname ='").append(hostname).append("'"))));
        }
        this.dbmsType = this.mProps.getProperty("dbmstype");
        if (this.dbmsType == null) {
            this.dbmsType = "UNIVERSE";
        }
        this.network = this.mProps.getProperty("network");
        if (this.network == null) {
            this.network = "TCP/IP";
        }
        this.service = this.mProps.getProperty("service");
        if (this.service == null) {
            this.service = this.dbmsType.equals("UNIVERSE") ? "uvserver" : "udserver";
        }
        this.hostName = hostname;
        try {
            UniJDBCProperties p = this.loadDefaultProperties(GENERICopts);
            this.applyCfg(p);
            if (this.dbmsType.equals("UNIVERSE")) {
                p = this.loadDefaultProperties(UNIVERSEopts);
                this.applyCfg(p);
                this.errorMap = this.loadDefaultProperties(UNIVERSEerrormap);
                p = this.loadDefaultProperties(UNIVERSE_DefaultNLS);
                if (p != null) {
                    this.applyCfg(p);
                }
            } else if (this.dbmsType.equals("UNIDATA")) {
                p = this.loadDefaultProperties(UNIDATAopts);
                this.applyCfg(p);
                p = this.loadDefaultProperties(UNIDATA_DefaultNLS);
                if (p != null) {
                    this.applyCfg(p);
                }
                this.isToUDT = true;
                this.isNF1 = 1;
            } else {
                throw this.mMsgFactory.createException(930019);
            }
            this.applyCfg(this.mProps);
        }
        catch (IOException ioe) {
            if (this.mTrace.mLevel >= 1) {
                this.mTrace.writeTrace("UniJDBCConnectionCfg#configByHostname:ioe=".concat(String.valueOf(String.valueOf(ioe))));
            }
            throw this.mMsgFactory.createException(930019);
        }
        if (this.mTrace.mLevel >= 5) {
            this.mTrace.writeTrace("UniJDBCConnectionCfg#configByHostname:leave");
        }
    }

    private void configByDataSource(String dataSourceName) throws SQLException {
        if (this.mTrace.mLevel >= 5) {
            this.mTrace.writeTrace("UniJDBCConnectionCfg#configByDataSource:enter");
        }
        if (this.mTrace.mLevel >= 2) {
            this.mTrace.writeTrace(String.valueOf(String.valueOf(new StringBuffer(" dataSourceName ='").append(dataSourceName).append("'"))));
        }
        this.isToUDT = false;
        try {
            Vector cfgVector = this.buildCfgVector();
            if (cfgVector.size() == 0) {
                throw this.mMsgFactory.createException(930019);
            }
            UniJDBCProperties p = this.loadSectionProperties(cfgVector, String.valueOf(String.valueOf(new StringBuffer("<").append(dataSourceName).append(">"))));
            this.applyCfg(p);
            p = this.loadDefaultProperties(GENERICopts);
            this.applyCfg(p);
            if (this.dbmsType.equals("UNIVERSE")) {
                p = this.loadDefaultProperties(UNIVERSEopts);
                this.applyCfg(p);
                this.errorMap = this.loadDefaultProperties(UNIVERSEerrormap);
                p = this.loadSectionProperties(cfgVector, "[UNIVERSE]");
                if (p != null) {
                    this.applyCfg(p);
                }
            } else if (this.dbmsType.equals("UNIDATA")) {
                p = this.loadDefaultProperties(UNIDATAopts);
                this.applyCfg(p);
                p = this.loadSectionProperties(cfgVector, "[UNIDATA]");
                if (p != null) {
                    this.applyCfg(p);
                }
                this.isToUDT = true;
            } else {
                throw this.mMsgFactory.createException(930019);
            }
            this.applyCfg(this.mProps);
        }
        catch (IOException ioe) {
            if (this.mTrace.mLevel >= 1) {
                this.mTrace.writeTrace("UniJDBCConnectionCfg#configByDataSource:ioe=".concat(String.valueOf(String.valueOf(ioe))));
            }
            throw this.mMsgFactory.createException(930019);
        }
        if (this.mTrace.mLevel >= 5) {
            this.mTrace.writeTrace("UniJDBCConnectionCfg#configByDataSource:leave");
        }
    }

    private Vector buildCfgVector() throws IOException {
        String tmps;
        String urlString;
        Vector<String> vs = new Vector<String>();
        if (this.mTrace.mLevel >= 2) {
            this.mTrace.writeTrace("mConfigURL:".concat(String.valueOf(String.valueOf(this.mConfigURL))));
        }
        if (this.mConfigURL == null || this.mConfigURL.length() == 0) {
            String fileSeparator = System.getProperty("file.separator");
            String workDirectory = System.getProperty("user.dir");
            if (!workDirectory.startsWith(fileSeparator)) {
                workDirectory = String.valueOf(String.valueOf(fileSeparator)).concat(String.valueOf(String.valueOf(workDirectory)));
            }
            urlString = String.valueOf(String.valueOf(new StringBuffer("file:").append(fileSeparator).append(fileSeparator).append(workDirectory).append(fileSeparator).append("uci.config")));
            if (this.mTrace.mLevel >= 2) {
                this.mTrace.writeTrace("Default-configURL:".concat(String.valueOf(String.valueOf(urlString))));
            }
        } else {
            urlString = this.mConfigURL;
            if (this.mTrace.mLevel >= 2) {
                this.mTrace.writeTrace("Property-configURL:".concat(String.valueOf(String.valueOf(urlString))));
            }
        }
        URL url = new URL(urlString);
        BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream()));
        while ((tmps = br.readLine()) != null) {
            if (tmps.length() <= 0 || tmps.substring(0, 1).equals("*")) continue;
            vs.addElement(tmps);
        }
        return vs;
    }

    private UniJDBCProperties loadDefaultProperties(String[] propTable) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        UniJDBCProperties p = null;
        for (int i = 0; i < propTable.length; ++i) {
            String tmps = propTable[i];
            baos.write(tmps.getBytes(), 0, tmps.length());
            tmps = "\n";
            baos.write(tmps.getBytes(), 0, 1);
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        p = new UniJDBCProperties();
        p.load(bais);
        return p;
    }

    private UniJDBCProperties loadSectionProperties(Vector vs, String name) throws SQLException, IOException {
        ByteArrayOutputStream baos = null;
        UniJDBCProperties p = null;
        String delimiter = name.substring(0, 1);
        Enumeration e = vs.elements();
        while (e.hasMoreElements()) {
            String tmps = (String)e.nextElement();
            if (tmps.indexOf(name) == -1) continue;
            baos = new ByteArrayOutputStream();
            while (e.hasMoreElements() && (tmps = (String)e.nextElement()).indexOf(delimiter) == -1) {
                baos.write(tmps.getBytes(), 0, tmps.length());
                tmps = "\n";
                baos.write(tmps.getBytes(), 0, 1);
            }
        }
        if (baos != null) {
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            p = new UniJDBCProperties();
            p.load(bais);
        }
        return p;
    }

    private void applyCfg(UniJDBCProperties prop) throws SQLException {
        String value = null;
        value = prop.getProperty(OPT_MAXCHAR);
        if (value != null) {
            this.maxChar = Short.parseShort(value);
        }
        if ((value = prop.getProperty(OPT_MAXVARCHAR)) != null) {
            this.maxVarChar = Short.parseShort(value);
        }
        if ((value = prop.getProperty(OPT_MAXLONGVARCHAR)) != null) {
            this.maxLongVarChar = Short.parseShort(value);
        }
        if ((value = prop.getProperty(OPT_SMINTPREC)) != null) {
            this.smIntPrec = Short.parseShort(value);
        }
        if ((value = prop.getProperty(OPT_INTPREC)) != null) {
            this.intPrec = Short.parseShort(value);
        }
        if ((value = prop.getProperty(OPT_BIGINTPREC)) != null) {
            this.bigIntPrec = Integer.parseInt(value);
        }
        if ((value = prop.getProperty(OPT_FLOATPREC)) != null) {
            this.floatPrec = Short.parseShort(value);
        }
        if ((value = prop.getProperty(OPT_REALPREC)) != null) {
            this.realPrec = Short.parseShort(value);
        }
        if ((value = prop.getProperty(OPT_DBLPREC)) != null) {
            this.dblPrec = Short.parseShort(value);
        }
        if ((value = prop.getProperty(OPT_DATEPREC)) != null) {
            this.datePrec = Short.parseShort(value);
        }
        if ((value = prop.getProperty(OPT_DATEFETCH)) != null) {
            this.dateFetch = Short.parseShort(value);
        }
        if ((value = prop.getProperty(OPT_MAXFETCHCOLS)) != null) {
            this.maxFetchCols = Integer.parseInt(value);
        }
        if ((value = prop.getProperty(OPT_MAXFETCHBUFF)) != null) {
            this.maxFetchBuff = Integer.parseInt(value);
        }
        if ((value = prop.getProperty(OPT_DATEFORM)) != null) {
            this.dateForm = value;
        }
        if ((value = prop.getProperty(OPT_PRECISION)) != null) {
            this.knowPrecision = value.toUpperCase().equals("YES");
        }
        if ((value = prop.getProperty(OPT_SCALE)) != null) {
            this.knowScale = value.toUpperCase().equals("YES");
        }
        if ((value = prop.getProperty(OPT_TXSTART)) != null) {
            this.txStart = value.equals("NONE") ? null : value;
        }
        if ((value = prop.getProperty(OPT_TXROLL)) != null) {
            this.txRoll = value.equals("NONE") ? null : value;
        }
        if ((value = prop.getProperty(OPT_TXCOMMIT)) != null) {
            this.txCommit = value.equals("NONE") ? null : value;
        }
        if ((value = prop.getProperty(OPT_NULLABLE)) != null) {
            this.knowNullable = value.toUpperCase().equals("YES");
        }
        if ((value = prop.getProperty(OPT_DSPSIZE)) != null) {
            this.knowDspSize = value.toUpperCase().equals("YES");
        }
        if ((value = prop.getProperty(OPT_UNSIGNED)) != null) {
            this.knowUnsigned = value.toUpperCase().equals("YES");
        }
        if ((value = prop.getProperty(OPT_MONEY)) != null) {
            this.knowMoney = value.toUpperCase().equals("YES");
        }
        if ((value = prop.getProperty(OPT_UPDATE)) != null) {
            this.knowUpdate = value.toUpperCase().equals("YES");
        }
        if ((value = prop.getProperty(OPT_AUTOINC)) != null) {
            this.knowAutoInc = value.toUpperCase().equals("YES");
        }
        if ((value = prop.getProperty(OPT_CASE)) != null) {
            this.knowCase = value.toUpperCase().equals("YES");
        }
        if ((value = prop.getProperty(OPT_SEARCH)) != null) {
            this.knowSearch = value.toUpperCase().equals("YES");
        }
        if ((value = prop.getProperty(OPT_TYPENAME)) != null) {
            this.knowTypeName = value.toUpperCase().equals("YES");
        }
        if ((value = prop.getProperty(OPT_TXBEHAVIOR)) != null) {
            this.txBehavior = value.toUpperCase().equals("YES");
        }
        if ((value = prop.getProperty(OPT_USETGITX)) != null) {
            this.useTgiTx = value.toUpperCase().equals("YES");
        }
        if ((value = prop.getProperty(OPT_MARKERNAME)) != null) {
            this.markerName = value.toUpperCase().equals("YES");
        }
        if ((value = prop.getProperty(OPT_DESCB4EXEC)) != null) {
            this.descB4Exec = value.toUpperCase().equals("YES");
        }
        if ((value = prop.getProperty(OPT_DBMSTYPE)) != null) {
            this.dbmsType = value;
            if (!this.dbmsType.equals("UNIVERSE") && !this.dbmsType.equals("UNIDATA")) {
                throw this.mMsgFactory.createException(930020);
            }
        }
        if ((value = prop.getProperty(OPT_NETWTYPE)) != null) {
            if (!value.toUpperCase().equals("TCP/IP")) {
                throw this.mMsgFactory.createException(930018);
            }
            this.network = "TCP/IP";
        }
        if ((value = prop.getProperty(OPT_HOST)) != null) {
            this.hostName = value;
        }
        if ((value = prop.getProperty(OPT_SERVICE)) != null) {
            this.service = value;
        }
        if ((value = prop.getProperty(OPT_EODCODE)) != null) {
            this.eodCode = Integer.parseInt(value);
        }
        if ((value = prop.getProperty(OPT_NLSMAP)) != null) {
            this.NLSMap = value;
        }
        if ((value = prop.getProperty(OPT_NLSLOCALE)) != null) {
            this.NLSLCTime = value;
            this.NLSLCNumeric = value;
            this.NLSLCCtype = value;
            this.NLSLCCollate = value;
            this.NLSLCMonetary = value;
        }
        if ((value = prop.getProperty(OPT_NLSLC_TIME)) != null) {
            this.NLSLCTime = value;
        }
        if ((value = prop.getProperty(OPT_NLSLC_NUMERIC)) != null) {
            this.NLSLCNumeric = value;
        }
        if ((value = prop.getProperty(OPT_NLSLC_MONETARY)) != null) {
            this.NLSLCMonetary = value;
        }
        if ((value = prop.getProperty(OPT_NLSLC_CTYPE)) != null) {
            this.NLSLCCtype = value;
        }
        if ((value = prop.getProperty(OPT_NLSLC_COLLATE)) != null) {
            this.NLSLCCollate = value;
        }
        if ((value = prop.getProperty(OPT_ACCOUNT)) != null) {
            this.accountPath = value;
        }
        if ((value = prop.getProperty(OPT_USERNAME)) != null) {
            this.userName = value;
        }
    }
}

