/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.u2.jdbc;

import com.ibm.u2.jdbc.UniJDBCConnection;
import com.ibm.u2.jdbc.UniJDBCObject;
import com.ibm.u2.jdbc.UniJDBCResultSetImpl;
import com.ibm.u2.jdbc.UniJDBCResultSetMetaData;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Vector;

public class UniJDBCClientResultSet
extends UniJDBCResultSetImpl {
    private UniJDBCResultSetMetaData mRsMetaData;
    private Vector mRows;
    private int mColumnCount;
    private int mCurrentIndex;
    private UniJDBCObject[] mCurrentRow;

    public UniJDBCClientResultSet(UniJDBCConnection connection, UniJDBCResultSetMetaData rsMetaData) throws SQLException {
        super(connection);
        this.mRsMetaData = rsMetaData;
        this.mRows = new Vector();
        this.mColumnCount = this.mRsMetaData.getColumnCount();
        this.mCurrentIndex = -1;
        this.mCurrentRow = null;
    }

    public UniJDBCObject[] createRow() {
        UniJDBCObject[] row = new UniJDBCObject[this.mColumnCount];
        this.mRows.addElement(row);
        return row;
    }

    public void reset() {
        super.reset();
        this.mCurrentRow = null;
        this.mCurrentIndex = -1;
    }

    public boolean next() throws SQLException {
        if (this.mCurrentIndex + 1 >= this.mRows.size()) {
            this.mCurrentRow = null;
            return false;
        }
        ++this.mCurrentIndex;
        this.mCurrentRow = (UniJDBCObject[])this.mRows.elementAt(this.mCurrentIndex);
        return true;
    }

    protected void getColumnValue(int columnIndex) throws SQLException {
        if (this.mCurrentRow == null) {
            throw this.mMsgFactory.createException(951050);
        }
        if (columnIndex < 1 || columnIndex > this.mColumnCount) {
            throw this.mMsgFactory.createException(951052);
        }
        this.mLastColumn = this.mCurrentRow[columnIndex - 1];
    }

    protected void getColumnValue(String columnName) throws SQLException {
        int columnIndex = this.mRsMetaData.getColumnIndex(columnName);
        this.getColumnValue(columnIndex);
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.mRsMetaData;
    }
}

