/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.u2.jdbc;

import com.ibm.u2.jdbc.UniJDBCCallableStatement;
import com.ibm.u2.jdbc.UniJDBCConnection;
import com.ibm.u2.jdbc.UniJDBCObject;
import com.ibm.u2.jdbc.UniJDBCObjectBuilder;
import com.ibm.u2.jdbc.UniJDBCParaMarker;
import com.ibm.u2.jdbc.UniJDBCPreparedStatementImpl;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.Vector;

public class UniJDBCCallableStatementImpl
extends UniJDBCPreparedStatementImpl
implements UniJDBCCallableStatement {
    private UniJDBCObject mLastValue = null;

    public UniJDBCCallableStatementImpl(UniJDBCConnection conn, String sql) throws SQLException {
        super(conn, sql);
    }

    public void UniRegisterOutParameter(int parameterIndex, int ifxType) throws SQLException {
    }

    public void UniRegisterOutParameter(int parameterIndex, int ifxType, String name) throws SQLException {
    }

    public void UniRegisterOutParameter(int parameterIndex, int ifxType, int scale) throws SQLException {
    }

    public boolean hasOutParameter() {
        return false;
    }

    public Vector getOutParameters() {
        return null;
    }

    public void UniSetNull(int i, int ifxType) throws SQLException {
    }

    public void UniSetNull(int i, int ifxType, String name) throws SQLException {
    }

    private UniJDBCObject getParamValue(int paramIndex) throws SQLException {
        this.mLastValue = null;
        UniJDBCParaMarker param = this.getParaMarker(paramIndex);
        if (!param.isOutput()) {
            throw this.mMsgFactory.createException(951003);
        }
        UniJDBCObject value = param.getValue();
        if (value == null) {
            throw this.mMsgFactory.createException(950004);
        }
        this.mLastValue = value;
        return value;
    }

    public void registerOutParameter(int paramIndex, int sqlType) throws SQLException {
        this.registerOutParameter(paramIndex, sqlType, -1);
    }

    public void registerOutParameter(int paramIndex, int sqlType, int scale) throws SQLException {
        UniJDBCObjectBuilder builder = this.mConnection.getObjectBuilder();
        int u2SqlType = builder.toLocalType(sqlType);
        UniJDBCParaMarker param = this.getParaMarker(paramIndex);
        param.setParaType(2);
        if (param.getValue() == null) {
            param.setValue(builder.createObject(u2SqlType));
        }
        param.setRegSQLType(u2SqlType);
        param.setRegScale(scale);
    }

    public boolean wasNull() throws SQLException {
        if (this.mLastValue == null) {
            throw this.mMsgFactory.createException(951005);
        }
        return this.mLastValue.isNull();
    }

    public String getString(int paramIndex) throws SQLException {
        UniJDBCObject value = this.getParamValue(paramIndex);
        return value.toString();
    }

    public boolean getBoolean(int paramIndex) throws SQLException {
        UniJDBCObject value = this.getParamValue(paramIndex);
        return value.toBoolean();
    }

    public byte getByte(int paramIndex) throws SQLException {
        UniJDBCObject value = this.getParamValue(paramIndex);
        return value.toByte();
    }

    public short getShort(int paramIndex) throws SQLException {
        UniJDBCObject value = this.getParamValue(paramIndex);
        return value.toShort();
    }

    public int getInt(int paramIndex) throws SQLException {
        UniJDBCObject value = this.getParamValue(paramIndex);
        return value.toInt();
    }

    public long getLong(int paramIndex) throws SQLException {
        UniJDBCObject value = this.getParamValue(paramIndex);
        return value.toLong();
    }

    public float getFloat(int paramIndex) throws SQLException {
        UniJDBCObject value = this.getParamValue(paramIndex);
        return value.toFloat();
    }

    public double getDouble(int paramIndex) throws SQLException {
        UniJDBCObject value = this.getParamValue(paramIndex);
        return value.toDouble();
    }

    public BigDecimal getBigDecimal(int paramIndex, int scale) throws SQLException {
        UniJDBCObject value = this.getParamValue(paramIndex);
        return value.toDecimal(scale);
    }

    public byte[] getBytes(int paramIndex) throws SQLException {
        UniJDBCObject value = this.getParamValue(paramIndex);
        return value.toBytes();
    }

    public Date getDate(int paramIndex) throws SQLException {
        UniJDBCObject value = this.getParamValue(paramIndex);
        return value.toDate();
    }

    public Time getTime(int paramIndex) throws SQLException {
        UniJDBCObject value = this.getParamValue(paramIndex);
        return value.toTime();
    }

    public Timestamp getTimestamp(int paramIndex) throws SQLException {
        UniJDBCObject value = this.getParamValue(paramIndex);
        return value.toTimestamp();
    }

    public Object getObject(int paramIndex) throws SQLException {
        UniJDBCObject value = this.getParamValue(paramIndex);
        UniJDBCParaMarker param = this.getParaMarker(paramIndex);
        int u2type = param.getRegSQLType();
        int scale = param.getRegScale();
        UniJDBCObjectBuilder builder = this.mConnection.getObjectBuilder();
        Object object = builder.toJAVAObject(value, u2type, scale);
        return object;
    }

    public BigDecimal getBigDecimal(int paramIndex) throws SQLException {
        UniJDBCObject value = this.getParamValue(paramIndex);
        return value.toDecimal();
    }

    public Object getObject(int i, Map map) throws SQLException {
        this.notSupport();
        return null;
    }

    public Ref getRef(int i) throws SQLException {
        this.notSupport();
        return null;
    }

    public Blob getBlob(int i) throws SQLException {
        this.notSupport();
        return null;
    }

    public Clob getClob(int i) throws SQLException {
        this.notSupport();
        return null;
    }

    public Array getArray(int i) throws SQLException {
        this.notSupport();
        return null;
    }

    public Date getDate(int paramIndex, Calendar cal) throws SQLException {
        UniJDBCObject value = this.getParamValue(paramIndex);
        return value.toDate(cal);
    }

    public Time getTime(int paramIndex, Calendar cal) throws SQLException {
        UniJDBCObject value = this.getParamValue(paramIndex);
        return value.toTime(cal);
    }

    public Timestamp getTimestamp(int paramIndex, Calendar cal) throws SQLException {
        UniJDBCObject value = this.getParamValue(paramIndex);
        return value.toTimestamp(cal);
    }

    public void registerOutParameter(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.notSupport();
    }
}

