/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.u2.jdbc;

import com.ibm.u2.jdbc.UniJDBCConnection;
import com.ibm.u2.jdbc.UniJDBCObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Vector;

public class UniJDBCBaseString
extends UniJDBCObject {
    private static final String ENCODE_NAME = "UTF-16BE";
    private static final int BUFSIZE = 512;
    protected String mValue;

    public UniJDBCBaseString(UniJDBCConnection conn, int ifxType) {
        this.initialize(conn, ifxType);
        this.mValue = null;
        this.nullify();
    }

    public UniJDBCBaseString(UniJDBCConnection conn, int ifxType, String value) {
        this.initialize(conn, ifxType);
        if (value == null) {
            this.mValue = null;
            this.nullify();
        } else {
            this.mValue = value;
            this.unnullify();
        }
    }

    public void fromDatabase(byte[] dbValue) {
        String s;
        if (!this.mConnection.isNullValue(dbValue) && (s = this.mConnection.decodeBytes(dbValue)) != null) {
            this.unnullify();
            this.mValue = s;
            return;
        }
        this.nullify();
        this.mValue = null;
    }

    public byte[] toDatabase() {
        if (this.isNull()) {
            return this.mConnection.getNullDatabaseValue();
        }
        return this.mConnection.encodeString(this.mValue);
    }

    public String toString() {
        if (this.isNull()) {
            return this.mConnection.getNullDisplay();
        }
        return this.mValue;
    }

    public int toInt() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        try {
            int k;
            int n = k = Integer.parseInt(this.mValue);
            return n;
        }
        catch (NumberFormatException nfe) {
            throw this.mMsgFactory.createException(951020, new Object[]{"int"});
        }
    }

    public byte[] toBytes() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.mValue.getBytes();
    }

    public boolean toBoolean() throws SQLException {
        int k = this.toInt();
        if (k == 0) {
            return false;
        }
        if (k == 1) {
            return true;
        }
        throw this.mMsgFactory.createException(951020, new Object[]{"boolean"});
    }

    public Date toDate() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        Date dt = Date.valueOf(this.mValue);
        return dt;
    }

    public float toFloat() throws SQLException {
        if (this.isNull()) {
            return 0.0f;
        }
        try {
            float f;
            float f2 = f = Float.parseFloat(this.mValue);
            return f2;
        }
        catch (NumberFormatException nfe) {
            throw this.mMsgFactory.createException(951020, new Object[]{"float"});
        }
    }

    public short toShort() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        try {
            short sint;
            short s = sint = Short.parseShort(this.mValue);
            return s;
        }
        catch (NumberFormatException nfe) {
            throw this.mMsgFactory.createException(951020, new Object[]{"short"});
        }
    }

    public long toLong() throws SQLException {
        if (this.isNull()) {
            return 0L;
        }
        try {
            long l;
            long l2 = l = Long.parseLong(this.mValue);
            return l2;
        }
        catch (NumberFormatException nfe) {
            throw this.mMsgFactory.createException(951020, new Object[]{"long"});
        }
    }

    public Time toTime() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        Time tm = Time.valueOf(this.mValue);
        return tm;
    }

    public Object toObject() {
        if (this.isNull()) {
            return null;
        }
        return this.toString();
    }

    public BigDecimal toDecimal() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        try {
            BigDecimal d;
            BigDecimal bigDecimal = d = new BigDecimal(this.mValue);
            return bigDecimal;
        }
        catch (NumberFormatException nfe) {
            throw this.mMsgFactory.createException(951023);
        }
    }

    public BigDecimal toDecimal(int scale) throws SQLException {
        if (this.isNull()) {
            return null;
        }
        try {
            BigDecimal d = new BigDecimal(this.mValue);
            d.setScale(scale, 4);
            BigDecimal bigDecimal = d;
            return bigDecimal;
        }
        catch (NumberFormatException nfe) {
            throw this.mMsgFactory.createException(951023);
        }
    }

    public double toDouble() throws SQLException {
        if (this.isNull()) {
            return 0.0;
        }
        try {
            double d;
            double d2 = d = Double.parseDouble(this.mValue);
            return d2;
        }
        catch (NumberFormatException nfe) {
            throw this.mMsgFactory.createException(951020, new Object[]{"double"});
        }
    }

    public Timestamp toTimestamp() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        Timestamp ts = Timestamp.valueOf(this.mValue);
        return ts;
    }

    public InputStream toBinaryStream() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.stringToInputStream(this.mValue, null);
    }

    public InputStream toAsciiStream() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.stringToInputStream(this.toString(), null);
    }

    public InputStream toUnicodeStream() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.stringToInputStream(this.toString(), ENCODE_NAME);
    }

    public void fromInt(int i) throws SQLException {
        this.mValue = new Integer(i).toString();
        this.unnullify();
    }

    public void fromInt(Integer I) throws SQLException {
        if (I == null) {
            this.mValue = null;
            this.nullify();
        } else {
            this.mValue = I.toString();
            this.unnullify();
        }
    }

    public void fromString(String s) throws SQLException {
        if (s == null) {
            this.mValue = null;
            this.nullify();
        } else {
            this.mValue = s;
            this.unnullify();
        }
    }

    public void fromDecimal(BigDecimal b) throws SQLException {
        if (b == null) {
            this.mValue = null;
            this.nullify();
        } else {
            this.mValue = b.toString();
            this.unnullify();
        }
    }

    public void fromDecimal(BigDecimal b, int scale) throws SQLException {
        if (b == null) {
            this.mValue = null;
            this.nullify();
        } else {
            this.mValue = b.toString();
            this.unnullify();
        }
    }

    public void fromByte(byte b) throws SQLException {
        this.mValue = new Byte(b).toString();
        this.unnullify();
    }

    public void fromByte(Byte B) throws SQLException {
        if (B == null) {
            this.mValue = null;
            this.nullify();
        } else {
            this.mValue = B.toString();
            this.unnullify();
        }
    }

    public void fromBoolean(boolean b) throws SQLException {
        this.mValue = new Boolean(b).toString();
        this.unnullify();
    }

    public void fromBoolean(Boolean B) throws SQLException {
        if (B == null) {
            this.mValue = null;
            this.nullify();
        } else {
            this.mValue = B.toString();
            this.unnullify();
        }
    }

    public void fromDate(Date D) throws SQLException {
        if (D == null) {
            this.mValue = null;
            this.nullify();
        } else {
            this.mValue = D.toString();
            this.unnullify();
        }
    }

    public void fromFloat(float f) throws SQLException {
        this.mValue = new Float(f).toString();
        this.unnullify();
    }

    public void fromFloat(Float F) throws SQLException {
        if (F == null) {
            this.mValue = null;
            this.nullify();
        } else {
            this.mValue = F.toString();
            this.unnullify();
        }
    }

    public void fromLong(long l) throws SQLException {
        this.mValue = new Long(l).toString();
        this.unnullify();
    }

    public void fromLong(Long L) throws SQLException {
        if (L == null) {
            this.mValue = null;
            this.nullify();
        } else {
            this.mValue = L.toString();
            this.unnullify();
        }
    }

    public void fromShort(short s) throws SQLException {
        this.mValue = new Short(s).toString();
        this.unnullify();
    }

    public void fromShort(Short S) throws SQLException {
        if (S == null) {
            this.mValue = null;
            this.nullify();
        } else {
            this.mValue = S.toString();
            this.unnullify();
        }
    }

    public void fromTime(Time T) throws SQLException {
        if (T == null) {
            this.mValue = null;
            this.nullify();
        } else {
            this.mValue = T.toString();
            this.unnullify();
        }
    }

    public void fromDouble(double d) throws SQLException {
        this.mValue = new Double(d).toString();
        this.unnullify();
    }

    public void fromDouble(Double D) throws SQLException {
        if (D == null) {
            this.mValue = null;
            this.nullify();
        } else {
            this.mValue = D.toString();
            this.unnullify();
        }
    }

    public void fromTimestamp(Timestamp TS) throws SQLException {
        if (TS == null) {
            this.mValue = null;
            this.nullify();
        } else {
            this.mValue = TS.toString();
            this.unnullify();
        }
    }

    public void fromAsciiStream(InputStream fin, int length) throws SQLException {
        if (fin == null) {
            this.mValue = null;
            this.nullify();
        } else {
            this.mValue = this.inputStreamToString(fin, length, null);
            this.unnullify();
        }
    }

    public void fromBinaryStream(InputStream fin, int length) throws SQLException {
        if (fin == null) {
            this.mValue = null;
            this.nullify();
        } else {
            this.mValue = this.inputStreamToString(fin, length, null);
            this.unnullify();
        }
    }

    public void fromUnicodeStream(InputStream fin, int length) throws SQLException {
        if (fin == null) {
            this.mValue = null;
            this.nullify();
        } else {
            this.mValue = this.inputStreamToString(fin, length, ENCODE_NAME);
            this.unnullify();
        }
    }

    private InputStream stringToInputStream(String in, String encode) throws SQLException {
        byte[] ba;
        if (encode == null) {
            ba = in.getBytes();
        } else {
            try {
                ba = in.getBytes(encode);
            }
            catch (UnsupportedEncodingException ex) {
                throw this.mMsgFactory.createException(951010, new Object[]{encode});
            }
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(ba);
        return bais;
    }

    private String inputStreamToString(InputStream is, int length, String encode) throws SQLException {
        try {
            byte[] fullbuf;
            int left;
            int trylen;
            int readlen;
            Vector<byte[]> vec = null;
            byte[] buffer = new byte[512];
            int offset = 0;
            int fullsize = 0;
            while (fullsize < length && (readlen = is.read(buffer, offset, trylen = (left = length - fullsize) > 512 - offset ? 512 - offset : left)) != -1) {
                if (readlen <= 0) continue;
                if ((offset += readlen) >= 512) {
                    if (vec == null) {
                        vec = new Vector<byte[]>();
                    }
                    vec.addElement(buffer);
                    buffer = new byte[512];
                    offset = 0;
                }
                fullsize += readlen;
            }
            if (vec == null) {
                fullbuf = buffer;
            } else {
                fullbuf = new byte[fullsize];
                int k = 0;
                for (int i = 0; i < vec.size(); ++i) {
                    byte[] ba = (byte[])vec.elementAt(i);
                    for (int j = 0; j < 512; ++j) {
                        fullbuf[k++] = ba[j];
                    }
                }
                for (int j = 0; j < offset; ++j) {
                    fullbuf[k++] = buffer[j];
                }
            }
            if (encode == null) {
                String string = new String(fullbuf, 0, fullsize);
                return string;
            }
            String string = new String(fullbuf, 0, fullsize, encode);
            return string;
        }
        catch (IOException ex) {
            throw this.mMsgFactory.createException(951074);
        }
    }

    static {
        ENCODE_NAME = ENCODE_NAME;
        BUFSIZE = 512;
    }
}

