/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.u2.jdbc;

import com.ibm.u2.jdbc.UniJDBCConnection;
import com.ibm.u2.jdbc.UniJDBCObject;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DecimalFormat;

public class UniJDBCBaseDouble
extends UniJDBCObject {
    private static final String DoubleFormat = "#.################";
    private static DecimalFormat _doubleFormat;
    protected double mValue;

    public UniJDBCBaseDouble(UniJDBCConnection conn, int ifxType) {
        this.initialize(conn, ifxType);
        this.mValue = 0.0;
    }

    public UniJDBCBaseDouble(UniJDBCConnection conn, int ifxType, double value) {
        this.initialize(conn, ifxType);
        this.mValue = value;
        this.unnullify();
    }

    public void fromDatabase(byte[] dbValue) {
        String s;
        if (!this.mConnection.isNullValue(dbValue) && (s = this.mConnection.decodeBytes(dbValue)) != null) {
            try {
                this.mValue = Double.parseDouble(s);
                this.unnullify();
                return;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.mValue = 0.0;
        this.nullify();
    }

    public byte[] toDatabase() {
        if (this.isNull()) {
            return this.mConnection.getNullDatabaseValue();
        }
        return this.mConnection.encodeString(_doubleFormat.format(this.mValue));
    }

    public String toString() {
        if (this.isNull()) {
            return this.mConnection.getNullDisplay();
        }
        return _doubleFormat.format(this.mValue);
    }

    public int toInt() throws SQLException {
        return (int)this.mValue;
    }

    public boolean toBoolean() throws SQLException {
        return this.mValue != 0.0;
    }

    public float toFloat() throws SQLException {
        return (float)this.mValue;
    }

    public short toShort() throws SQLException {
        return (short)this.mValue;
    }

    public long toLong() throws SQLException {
        return (long)this.mValue;
    }

    public double toDouble() throws SQLException {
        return this.mValue;
    }

    public BigDecimal toDecimal() {
        if (this.isNull()) {
            return null;
        }
        BigDecimal d = new BigDecimal(this.mValue);
        return d;
    }

    public BigDecimal toDecimal(int scale) {
        if (this.isNull()) {
            return null;
        }
        BigDecimal d = new BigDecimal(this.mValue);
        d.setScale(scale, 4);
        return d;
    }

    public Object toObject() {
        if (this.isNull()) {
            return null;
        }
        return new Double(this.mValue);
    }

    public void fromInt(int i) throws SQLException {
        this.mValue = i;
        this.unnullify();
    }

    public void fromInt(Integer I) throws SQLException {
        if (I == null) {
            this.mValue = 0.0;
            this.nullify();
        } else {
            this.mValue = I.intValue();
            this.unnullify();
        }
    }

    public void fromString(String s) throws SQLException {
        if (s == null) {
            this.mValue = 0.0;
            this.nullify();
        } else {
            try {
                this.mValue = Double.parseDouble(s);
            }
            catch (NumberFormatException nfe) {
                throw this.mMsgFactory.createException(951022);
            }
            this.unnullify();
        }
    }

    public void fromDecimal(BigDecimal b) throws SQLException {
        if (b == null) {
            this.mValue = 0.0;
            this.nullify();
        } else {
            this.mValue = b.doubleValue();
            this.unnullify();
        }
    }

    public void fromDecimal(BigDecimal b, int scale) throws SQLException {
        if (b == null) {
            this.mValue = 0.0;
            this.nullify();
        } else {
            this.mValue = b.doubleValue();
            this.unnullify();
        }
    }

    public void fromByte(byte b) throws SQLException {
        this.mValue = b;
        this.unnullify();
    }

    public void fromByte(Byte B) throws SQLException {
        if (B == null) {
            this.mValue = 0.0;
            this.nullify();
        } else {
            this.mValue = B.byteValue();
            this.unnullify();
        }
    }

    public void fromBoolean(boolean b) throws SQLException {
        this.mValue = b ? 0.0 : 1.0;
        this.unnullify();
    }

    public void fromBoolean(Boolean B) throws SQLException {
        if (B == null) {
            this.mValue = 0.0;
            this.nullify();
        } else {
            this.mValue = B != false ? 0.0 : 1.0;
            this.unnullify();
        }
    }

    public void fromFloat(float f) throws SQLException {
        this.mValue = f;
        this.unnullify();
    }

    public void fromFloat(Float F) throws SQLException {
        if (F == null) {
            this.mValue = 0.0;
            this.nullify();
        } else {
            this.mValue = F.floatValue();
            this.unnullify();
        }
    }

    public void fromLong(long l) throws SQLException {
        this.mValue = l;
        this.unnullify();
    }

    public void fromLong(Long L) throws SQLException {
        if (L == null) {
            this.mValue = 0.0;
            this.nullify();
        } else {
            this.mValue = L.longValue();
            this.unnullify();
        }
    }

    public void fromShort(short s) throws SQLException {
        this.mValue = s;
        this.unnullify();
    }

    public void fromShort(Short S) throws SQLException {
        if (S == null) {
            this.mValue = 0.0;
            this.nullify();
        } else {
            this.mValue = S.shortValue();
            this.unnullify();
        }
    }

    public void fromDouble(double d) throws SQLException {
        this.mValue = d;
        this.unnullify();
    }

    public void fromDouble(Double D) throws SQLException {
        if (D == null) {
            this.mValue = 0.0;
            this.nullify();
        } else {
            this.mValue = D;
            this.unnullify();
        }
    }

    static {
        DoubleFormat = DoubleFormat;
        _doubleFormat = new DecimalFormat(DoubleFormat);
    }
}

