/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.u2.jdbc;

import com.ibm.u2.jdbc.UniJDBCConnection;
import com.ibm.u2.jdbc.UniJDBCObject;
import java.math.BigDecimal;
import java.sql.SQLException;

public class UniJDBCBaseDecimal
extends UniJDBCObject {
    protected BigDecimal mValue;

    public UniJDBCBaseDecimal(UniJDBCConnection conn, int ifxType) {
        this.initialize(conn, ifxType);
        this.mValue = null;
    }

    public UniJDBCBaseDecimal(UniJDBCConnection conn, int ifxType, BigDecimal value) {
        this.initialize(conn, ifxType);
        if (value != null) {
            this.mValue = this.cloneBigDecimal(value);
            this.unnullify();
        } else {
            this.mValue = null;
            this.nullify();
        }
    }

    public void fromDatabase(byte[] dbValue) {
        String s;
        if (!this.mConnection.isNullValue(dbValue) && (s = this.mConnection.decodeBytes(dbValue)) != null) {
            try {
                this.mValue = new BigDecimal(s);
                this.unnullify();
                return;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.mValue = null;
        this.nullify();
    }

    public byte[] toDatabase() {
        if (this.isNull()) {
            return this.mConnection.getNullDatabaseValue();
        }
        return this.mConnection.encodeString(this.mValue.toString());
    }

    public String toString() {
        if (this.isNull()) {
            return this.mConnection.getNullDisplay();
        }
        return this.mValue.toString();
    }

    public int toInt() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        return this.mValue.intValue();
    }

    public boolean toBoolean() throws SQLException {
        if (this.isNull()) {
            return false;
        }
        return this.mValue.intValue() != 0;
    }

    public float toFloat() throws SQLException {
        if (this.isNull()) {
            return 0.0f;
        }
        return this.mValue.floatValue();
    }

    public short toShort() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        return (short)this.mValue.intValue();
    }

    public long toLong() throws SQLException {
        if (this.isNull()) {
            return 0L;
        }
        return this.mValue.longValue();
    }

    public double toDouble() throws SQLException {
        if (this.isNull()) {
            return 0.0;
        }
        return this.mValue.doubleValue();
    }

    public BigDecimal toDecimal() {
        if (this.isNull()) {
            return null;
        }
        BigDecimal d = this.cloneBigDecimal(this.mValue);
        return d;
    }

    public BigDecimal toDecimal(int scale) {
        if (this.isNull()) {
            return null;
        }
        BigDecimal d = this.cloneBigDecimal(this.mValue);
        d.setScale(scale, 4);
        return d;
    }

    public Object toObject() {
        if (this.isNull()) {
            return null;
        }
        return this.mValue;
    }

    public void fromInt(int i) throws SQLException {
        this.mValue = new BigDecimal((double)i);
        this.unnullify();
    }

    public void fromInt(Integer I) throws SQLException {
        if (I == null) {
            this.mValue = null;
            this.nullify();
        } else {
            this.mValue = new BigDecimal((double)I.intValue());
            this.unnullify();
        }
    }

    public void fromString(String s) throws SQLException {
        if (s == null) {
            this.mValue = null;
            this.nullify();
        } else {
            try {
                this.mValue = new BigDecimal(s);
            }
            catch (NumberFormatException nfe) {
                throw this.mMsgFactory.createException(951022);
            }
            this.unnullify();
        }
    }

    public void fromDecimal(BigDecimal b) throws SQLException {
        if (b == null) {
            this.mValue = null;
            this.nullify();
        } else {
            this.mValue = this.cloneBigDecimal(b);
            this.unnullify();
        }
    }

    public void fromDecimal(BigDecimal b, int scale) throws SQLException {
        if (b == null) {
            this.mValue = null;
            this.nullify();
        } else {
            this.mValue = this.cloneBigDecimal(b);
            this.mValue.setScale(scale, 4);
            this.unnullify();
        }
    }

    public void fromByte(byte b) throws SQLException {
        this.mValue = new BigDecimal((double)b);
        this.unnullify();
    }

    public void fromByte(Byte B) throws SQLException {
        if (B == null) {
            this.mValue = null;
            this.nullify();
        } else {
            this.mValue = new BigDecimal((double)B.byteValue());
            this.unnullify();
        }
    }

    public void fromBoolean(boolean b) throws SQLException {
        this.mValue = b ? new BigDecimal(0.0) : new BigDecimal(1.0);
        this.unnullify();
    }

    public void fromBoolean(Boolean B) throws SQLException {
        if (B == null) {
            this.mValue = null;
            this.nullify();
        } else {
            this.mValue = B != false ? new BigDecimal(0.0) : new BigDecimal(1.0);
            this.unnullify();
        }
    }

    public void fromFloat(float f) throws SQLException {
        this.mValue = new BigDecimal(f);
        this.unnullify();
    }

    public void fromFloat(Float F) throws SQLException {
        if (F == null) {
            this.mValue = null;
            this.nullify();
        } else {
            this.mValue = new BigDecimal(F.floatValue());
            this.unnullify();
        }
    }

    public void fromLong(long l) throws SQLException {
        this.mValue = new BigDecimal((double)l);
        this.unnullify();
    }

    public void fromLong(Long L) throws SQLException {
        if (L == null) {
            this.mValue = null;
            this.nullify();
        } else {
            this.mValue = new BigDecimal((double)L.longValue());
            this.unnullify();
        }
    }

    public void fromShort(short s) throws SQLException {
        this.mValue = new BigDecimal((double)s);
        this.unnullify();
    }

    public void fromShort(Short S) throws SQLException {
        if (S == null) {
            this.mValue = null;
            this.nullify();
        } else {
            this.mValue = new BigDecimal((double)S.shortValue());
            this.unnullify();
        }
    }

    public void fromDouble(double d) throws SQLException {
        this.mValue = new BigDecimal(d);
        this.unnullify();
    }

    public void fromDouble(Double D) throws SQLException {
        if (D == null) {
            this.mValue = null;
            this.nullify();
        } else {
            this.mValue = new BigDecimal(D);
            this.unnullify();
        }
    }
}

