/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.util;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import sun.tools.java.BinaryClass;
import sun.tools.java.ClassDeclaration;
import sun.tools.java.ClassDefinition;
import sun.tools.java.ClassFile;
import sun.tools.java.ClassPath;
import sun.tools.java.Constants;
import sun.tools.java.Environment;
import sun.tools.java.Identifier;
import sun.tools.java.Package;
import sun.tools.java.Type;

public class LoadEnvironment
extends Environment
implements Constants {
    public int flags = 0;
    public ClassPath path;
    Hashtable packages = new Hashtable(31);
    Hashtable classes = new Hashtable(351);

    public LoadEnvironment() {
    }

    public LoadEnvironment(ClassPath classPath) {
        this.path = classPath;
    }

    protected int loadFileFlags() {
        return -1;
    }

    public int getFlags() {
        return this.flags;
    }

    public boolean classExists(Identifier identifier) {
        if (identifier.isInner()) {
            identifier = identifier.getTopName();
        }
        Type type = Type.tClass((Identifier)identifier);
        try {
            ClassDeclaration classDeclaration = (ClassDeclaration)this.classes.get(type);
            if (classDeclaration == null) {
                Identifier identifier2;
                Package package_ = this.getPackage(identifier.getQualifier());
                ClassFile classFile = package_.getBinaryFile(identifier2 = identifier.getName());
                return classFile != null;
            }
            return classDeclaration.getName().equals(identifier);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public ClassDeclaration getClassDeclaration(Identifier identifier) {
        return this.getClassDeclaration(Type.tClass((Identifier)identifier));
    }

    public ClassDeclaration getClassDeclaration(Type type) {
        ClassDeclaration classDeclaration = (ClassDeclaration)this.classes.get(type);
        if (classDeclaration == null) {
            classDeclaration = new ClassDeclaration(type.getClassName());
            this.classes.put(type, classDeclaration);
        }
        return classDeclaration;
    }

    public Package getPackage(Identifier identifier) throws IOException {
        Package package_ = (Package)this.packages.get(identifier);
        if (package_ == null) {
            package_ = new Package(this.path, identifier);
            this.packages.put(identifier, package_);
        }
        return package_;
    }

    BinaryClass loadFile(ClassFile classFile) throws IOException {
        long l = System.currentTimeMillis();
        InputStream inputStream = classFile.getInputStream();
        BinaryClass binaryClass = null;
        try {
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(inputStream));
            binaryClass = BinaryClass.load((Environment)new Environment((Environment)this, (Object)classFile), (DataInputStream)dataInputStream, (int)this.loadFileFlags());
        }
        catch (ClassFormatError classFormatError) {
            throw new IllegalArgumentException("Error: bad class format" + classFile.getPath() + classFormatError.getMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        inputStream.close();
        return binaryClass;
    }

    public void loadDefinition(ClassDeclaration classDeclaration) {
        switch (classDeclaration.getStatus()) {
            case 0: {
                Package package_;
                Identifier identifier = classDeclaration.getName();
                try {
                    package_ = this.getPackage(identifier.getQualifier());
                }
                catch (IOException iOException) {
                    throw new IllegalArgumentException("Error: I/O Exception - " + iOException.getMessage());
                }
                ClassFile classFile = package_.getBinaryFile(identifier.getName());
                if (classFile == null) {
                    throw new IllegalArgumentException("Error: No binary file '" + identifier.getName() + "'");
                }
                BinaryClass binaryClass = null;
                try {
                    binaryClass = this.loadFile(classFile);
                }
                catch (IOException iOException) {
                    throw new IllegalArgumentException("Error: I/O Exception - " + iOException.getMessage() + " in " + classFile);
                }
                if (binaryClass == null) {
                    throw new IllegalArgumentException("Error: Class not found in '" + classFile + "'");
                }
                if (!binaryClass.getName().equals(identifier)) {
                    throw new IllegalArgumentException("Error: Binary file '" + identifier.getName() + "'  contains " + binaryClass.getName());
                }
                classDeclaration.setDefinition((ClassDefinition)binaryClass, 2);
                binaryClass.loadNested((Environment)this);
                return;
            }
        }
        throw new IllegalArgumentException("Error: No binary file");
    }
}

