/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import com.ibm.jvm.ExtendedSystem;
import java.io.IOException;
import java.util.Enumeration;
import sun.security.util.BitArray;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AttributeNameEnumeration;

public class ReasonFlags {
    public static final String UNUSED = "unused";
    public static final String KEY_COMPROMISE = "key_compromise";
    public static final String CA_COMPROMISE = "ca_compromise";
    public static final String AFFLIATION_CHANGED = "affliation_changed";
    public static final String SUPERSEDED = "superseded";
    public static final String CESSATION_OF_OPERATION = "cessation_of_operation";
    public static final String CERTIFICATE_HOLD = "certificate_hold";
    private boolean[] bitString;

    private boolean isSet(int n) {
        return this.bitString[n];
    }

    private void set(int n, boolean bl) {
        if (n >= this.bitString.length) {
            this.bitString = (boolean[])ExtendedSystem.resizeArray(n + 1, this.bitString, 0, this.bitString.length);
        }
        this.bitString[n] = bl;
    }

    public ReasonFlags(byte[] byArray) {
        this.bitString = new BitArray(byArray.length * 8, byArray).toBooleanArray();
    }

    public ReasonFlags(boolean[] blArray) {
        this.bitString = blArray;
    }

    public ReasonFlags(BitArray bitArray) {
        this.bitString = bitArray.toBooleanArray();
    }

    public ReasonFlags(DerInputStream derInputStream) throws IOException {
        DerValue derValue = derInputStream.getDerValue();
        this.bitString = derValue.getUnalignedBitString(true).toBooleanArray();
    }

    public ReasonFlags(DerValue derValue) throws IOException {
        this.bitString = derValue.getUnalignedBitString(true).toBooleanArray();
    }

    public void set(String string, Object object) throws IOException {
        if (!(object instanceof Boolean)) {
            throw new IOException("Attribute must be of type Boolean.");
        }
        boolean bl = (Boolean)object;
        if (string.equalsIgnoreCase(UNUSED)) {
            this.set(0, bl);
        } else if (string.equalsIgnoreCase(KEY_COMPROMISE)) {
            this.set(1, bl);
        } else if (string.equalsIgnoreCase(CA_COMPROMISE)) {
            this.set(2, bl);
        } else if (string.equalsIgnoreCase(AFFLIATION_CHANGED)) {
            this.set(3, bl);
        } else if (string.equalsIgnoreCase(SUPERSEDED)) {
            this.set(4, bl);
        } else if (string.equalsIgnoreCase(CESSATION_OF_OPERATION)) {
            this.set(5, bl);
        } else if (string.equalsIgnoreCase(CERTIFICATE_HOLD)) {
            this.set(6, bl);
        } else {
            throw new IOException("Name not recognized by ReasonFlags");
        }
    }

    public Object get(String string) throws IOException {
        if (string.equalsIgnoreCase(UNUSED)) {
            return new Boolean(this.isSet(0));
        }
        if (string.equalsIgnoreCase(KEY_COMPROMISE)) {
            return new Boolean(this.isSet(1));
        }
        if (string.equalsIgnoreCase(CA_COMPROMISE)) {
            return new Boolean(this.isSet(2));
        }
        if (string.equalsIgnoreCase(AFFLIATION_CHANGED)) {
            return new Boolean(this.isSet(3));
        }
        if (string.equalsIgnoreCase(SUPERSEDED)) {
            return new Boolean(this.isSet(4));
        }
        if (string.equalsIgnoreCase(CESSATION_OF_OPERATION)) {
            return new Boolean(this.isSet(5));
        }
        if (string.equalsIgnoreCase(CERTIFICATE_HOLD)) {
            return new Boolean(this.isSet(6));
        }
        throw new IOException("Name not recognized by ReasonFlags");
    }

    public void delete(String string) throws IOException {
        if (string.equalsIgnoreCase(UNUSED)) {
            this.set(0, false);
        } else if (string.equalsIgnoreCase(KEY_COMPROMISE)) {
            this.set(1, false);
        } else if (string.equalsIgnoreCase(CA_COMPROMISE)) {
            this.set(2, false);
        } else if (string.equalsIgnoreCase(AFFLIATION_CHANGED)) {
            this.set(3, false);
        } else if (string.equalsIgnoreCase(SUPERSEDED)) {
            this.set(4, false);
        } else if (string.equalsIgnoreCase(CESSATION_OF_OPERATION)) {
            this.set(5, false);
        } else if (string.equalsIgnoreCase(CERTIFICATE_HOLD)) {
            this.set(6, false);
        } else {
            throw new IOException("Name not recognized by ReasonFlags");
        }
    }

    public String toString() {
        String string = "Reason Flags [\n";
        try {
            if (this.isSet(0)) {
                string = string + "  Unused\n";
            }
            if (this.isSet(1)) {
                string = string + "  Key Compromise\n";
            }
            if (this.isSet(2)) {
                string = string + "  CA_Compromise\n";
            }
            if (this.isSet(3)) {
                string = string + "  Affiliation_Changed\n";
            }
            if (this.isSet(4)) {
                string = string + "  Superseded\n";
            }
            if (this.isSet(5)) {
                string = string + "  Cessation Of Operation\n";
            }
            if (this.isSet(6)) {
                string = string + "  Certificate Hold\n";
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        string = string + "]\n";
        return string;
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        derOutputStream.putUnalignedBitString(new BitArray(this.bitString));
    }

    public Enumeration getElements() {
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement(UNUSED);
        attributeNameEnumeration.addElement(KEY_COMPROMISE);
        attributeNameEnumeration.addElement(CA_COMPROMISE);
        attributeNameEnumeration.addElement(AFFLIATION_CHANGED);
        attributeNameEnumeration.addElement(SUPERSEDED);
        attributeNameEnumeration.addElement(CESSATION_OF_OPERATION);
        attributeNameEnumeration.addElement(CERTIFICATE_HOLD);
        return attributeNameEnumeration.elements();
    }
}

