/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarException;
import java.util.jar.Manifest;
import sun.misc.BASE64Decoder;
import sun.security.pkcs.PKCS7;
import sun.security.pkcs.SignerInfo;
import sun.security.util.Debug;
import sun.security.util.ManifestDigester;

public class SignatureFileVerifier {
    private static final Debug debug = Debug.getInstance("jar");
    private ArrayList certCache;
    private PKCS7 block;
    private byte[] sfBytes;
    private String name;
    private ManifestDigester md;
    private HashMap createdDigests;
    private boolean workaround = false;
    private static final char[] hexc = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public SignatureFileVerifier(ArrayList arrayList, ManifestDigester manifestDigester, String string, byte[] byArray) throws IOException {
        this.block = new PKCS7(byArray);
        this.sfBytes = this.block.getContentInfo().getData();
        this.name = string.substring(0, string.lastIndexOf(".")).toUpperCase();
        this.md = manifestDigester;
        this.certCache = arrayList;
    }

    public boolean needSignatureFileBytes() {
        return this.sfBytes == null;
    }

    public boolean needSignatureFile(String string) {
        return this.name.equalsIgnoreCase(string);
    }

    public void setSignatureFile(byte[] byArray) {
        this.sfBytes = byArray;
    }

    private MessageDigest getDigest(String string) {
        MessageDigest messageDigest;
        if (this.createdDigests == null) {
            this.createdDigests = new HashMap();
        }
        if ((messageDigest = (MessageDigest)this.createdDigests.get(string)) == null) {
            try {
                messageDigest = MessageDigest.getInstance(string);
                this.createdDigests.put(string, messageDigest);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        return messageDigest;
    }

    public void process(Hashtable hashtable) throws IOException, SignatureException, NoSuchAlgorithmException, JarException {
        Manifest manifest = new Manifest();
        manifest.read(new ByteArrayInputStream(this.sfBytes));
        String string = manifest.getMainAttributes().getValue(Attributes.Name.SIGNATURE_VERSION);
        if (string == null || !string.equalsIgnoreCase("1.0")) {
            return;
        }
        SignerInfo[] signerInfoArray = this.block.verify(this.sfBytes);
        if (signerInfoArray == null) {
            throw new SecurityException("cannot verify signature block file " + this.name);
        }
        BASE64Decoder bASE64Decoder = new BASE64Decoder();
        Certificate[] certificateArray = this.getCertificates(signerInfoArray, this.block);
        if (certificateArray == null) {
            return;
        }
        Iterator iterator = manifest.getEntries().entrySet().iterator();
        boolean bl = this.verifyManifestHash(manifest, this.md, bASE64Decoder);
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            String string2 = (String)entry.getKey();
            if (bl || this.verifySection((Attributes)entry.getValue(), string2, this.md, bASE64Decoder)) {
                if (string2.startsWith("./")) {
                    string2 = string2.substring(2);
                }
                if (string2.startsWith("/")) {
                    string2 = string2.substring(1);
                }
                this.updateCerts(certificateArray, hashtable, string2);
                if (debug == null) continue;
                debug.println("processSignature signed name = " + string2);
                continue;
            }
            if (debug == null) continue;
            debug.println("processSignature unsigned name = " + string2);
        }
    }

    private boolean verifyManifestHash(Manifest manifest, ManifestDigester manifestDigester, BASE64Decoder bASE64Decoder) throws IOException {
        Attributes attributes = manifest.getMainAttributes();
        boolean bl = false;
        Iterator iterator = attributes.entrySet().iterator();
        while (iterator.hasNext()) {
            String string;
            MessageDigest messageDigest;
            Map.Entry entry = (Map.Entry)iterator.next();
            String string2 = entry.getKey().toString();
            if (!string2.toUpperCase(Locale.US).endsWith("-DIGEST-MANIFEST") || (messageDigest = this.getDigest(string = string2.substring(0, string2.length() - 16))) == null) continue;
            byte[] byArray = manifestDigester.manifestDigest(messageDigest);
            byte[] byArray2 = bASE64Decoder.decodeBuffer((String)entry.getValue());
            if (debug != null) {
                debug.println("Signature File: Manifest digest " + messageDigest.getAlgorithm());
                debug.println("  sigfile  " + SignatureFileVerifier.toHex(byArray2));
                debug.println("  computed " + SignatureFileVerifier.toHex(byArray));
                debug.println();
            }
            if (!MessageDigest.isEqual(byArray, byArray2)) continue;
            bl = true;
        }
        return bl;
    }

    private boolean verifySection(Attributes attributes, String string, ManifestDigester manifestDigester, BASE64Decoder bASE64Decoder) throws IOException {
        boolean bl = false;
        ManifestDigester.Entry entry = manifestDigester.get(string, this.block.isOldStyle());
        if (entry == null) {
            throw new SecurityException("no manifiest section for signature file entry " + string);
        }
        if (attributes != null) {
            Iterator iterator = attributes.entrySet().iterator();
            while (iterator.hasNext()) {
                String string2;
                MessageDigest messageDigest;
                Map.Entry entry2 = (Map.Entry)iterator.next();
                String string3 = entry2.getKey().toString();
                if (!string3.toUpperCase(Locale.US).endsWith("-DIGEST") || (messageDigest = this.getDigest(string2 = string3.substring(0, string3.length() - 7))) == null) continue;
                boolean bl2 = false;
                byte[] byArray = bASE64Decoder.decodeBuffer((String)entry2.getValue());
                byte[] byArray2 = this.workaround ? entry.digestWorkaround(messageDigest) : entry.digest(messageDigest);
                if (debug != null) {
                    debug.println("Signature Block File: " + string + " digest=" + messageDigest.getAlgorithm());
                    debug.println("  expected " + SignatureFileVerifier.toHex(byArray));
                    debug.println("  computed " + SignatureFileVerifier.toHex(byArray2));
                    debug.println();
                }
                if (MessageDigest.isEqual(byArray2, byArray)) {
                    bl = true;
                    bl2 = true;
                } else if (!this.workaround && MessageDigest.isEqual(byArray2 = entry.digestWorkaround(messageDigest), byArray)) {
                    if (debug != null) {
                        debug.println("  re-computed " + SignatureFileVerifier.toHex(byArray2));
                        debug.println();
                    }
                    this.workaround = true;
                    bl = true;
                    bl2 = true;
                }
                if (bl2) continue;
                throw new SecurityException("invalid " + messageDigest.getAlgorithm() + " signature file digest for " + string);
            }
        }
        return bl;
    }

    private Certificate[] getCertificates(SignerInfo[] signerInfoArray, PKCS7 pKCS7) {
        Certificate[] certificateArray;
        ArrayList arrayList = null;
        int n = 0;
        while (n < signerInfoArray.length) {
            certificateArray = signerInfoArray[n];
            try {
                ArrayList arrayList2 = certificateArray.getCertificateChain(pKCS7);
                if (arrayList == null) {
                    arrayList = new ArrayList();
                }
                arrayList.addAll(arrayList2);
                if (debug != null) {
                    debug.println("Signature Block Certificate: " + (X509Certificate)arrayList2.get(0));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ++n;
        }
        if (arrayList != null) {
            certificateArray = new Certificate[arrayList.size()];
            System.arraycopy(arrayList.toArray(), 0, certificateArray, 0, arrayList.size());
            return certificateArray;
        }
        return null;
    }

    static String toHex(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        int n = 0;
        while (n < byArray.length) {
            stringBuffer.append(hexc[byArray[n] >> 4 & 0xF]);
            stringBuffer.append(hexc[byArray[n] & 0xF]);
            ++n;
        }
        return stringBuffer.toString();
    }

    static boolean contains(Certificate[] certificateArray, Certificate certificate) {
        int n = 0;
        while (n < certificateArray.length) {
            if (certificateArray[n].equals(certificate)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    static boolean isSubSet(Certificate[] certificateArray, Certificate[] certificateArray2) {
        if (certificateArray2 == certificateArray) {
            return true;
        }
        int n = 0;
        while (n < certificateArray.length) {
            if (!SignatureFileVerifier.contains(certificateArray2, certificateArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    static boolean matches(Certificate[] certificateArray, Certificate[] certificateArray2, Certificate[] certificateArray3) {
        if (certificateArray2 == null && certificateArray == certificateArray3) {
            return true;
        }
        if (certificateArray2 != null && !SignatureFileVerifier.isSubSet(certificateArray2, certificateArray)) {
            return false;
        }
        if (!SignatureFileVerifier.isSubSet(certificateArray3, certificateArray)) {
            return false;
        }
        int n = 0;
        while (n < certificateArray.length) {
            boolean bl;
            boolean bl2 = bl = certificateArray2 != null && SignatureFileVerifier.contains(certificateArray2, certificateArray[n]) || SignatureFileVerifier.contains(certificateArray3, certificateArray[n]);
            if (!bl) {
                return false;
            }
            ++n;
        }
        return true;
    }

    void updateCerts(Certificate[] certificateArray, Hashtable hashtable, String string) {
        Certificate[] certificateArray2;
        Certificate[] certificateArray3 = (Certificate[])hashtable.get(string);
        int n = this.certCache.size() - 1;
        while (n != -1) {
            certificateArray2 = (Certificate[])this.certCache.get(n);
            if (SignatureFileVerifier.matches(certificateArray2, certificateArray3, certificateArray)) {
                hashtable.put(string, certificateArray2);
                return;
            }
            --n;
        }
        if (certificateArray3 == null) {
            certificateArray2 = certificateArray;
        } else {
            certificateArray2 = new Certificate[certificateArray3.length + certificateArray.length];
            System.arraycopy(certificateArray3, 0, certificateArray2, 0, certificateArray3.length);
            System.arraycopy(certificateArray, 0, certificateArray2, certificateArray3.length, certificateArray.length);
        }
        this.certCache.add(certificateArray2);
        hashtable.put(string, certificateArray2);
    }
}

