/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import com.ibm.jvm.ExtendedSystem;
import com.ibm.jvm.NamespaceException;
import com.ibm.jvm.classloader.Middleware;
import com.ibm.jvm.classloader.Shareable;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.StringTokenizer;
import java.util.Vector;
import sun.misc.JarFilter;
import sun.misc.PathPermissions;
import sun.misc.URLClassPath;
import sun.net.www.ParseUtil;
import sun.security.action.GetPropertyAction;

public class Launcher {
    private static Launcher launcher;
    private static URLStreamHandlerFactory factory;
    private ClassLoader loader;
    private ClassLoader extLoader;
    private ClassLoader parentLoader;
    private String sacPath;
    private URL[] sacURLs = null;
    private String appPath = null;
    private URL[] appURLs = null;
    private static URLStreamHandler fileHandler;

    public static Launcher getLauncher() {
        return launcher;
    }

    private static ClassLoader getExtClassLoader() {
        if (null != launcher) {
            return Launcher.launcher.extLoader;
        }
        return null;
    }

    private static void removeSystemClassLoader() {
        if (null != launcher) {
            Launcher.launcher.loader = null;
            Thread.currentThread().setContextClassLoader(null);
        }
    }

    private static void reinitializeSystemClassLoader() {
        if (null != launcher) {
            launcher.createApplicationClassLoaders(Launcher.launcher.parentLoader);
        }
    }

    public Launcher() {
        String string;
        launcher = this;
        this.parentLoader = this.extLoader = ExtClassLoader.getExtClassLoader();
        try {
            string = System.getProperty("ibm.jvm.trusted.middleware.class.path");
            if (null != string) {
                this.parentLoader = MiddlewareClassLoader.getMiddlewareClassLoader(string, this.extLoader);
            }
        }
        catch (IOException iOException) {
            throw new InternalError("Could not create trusted middleware class loader");
        }
        this.sacPath = System.getProperty("ibm.jvm.shareable.application.class.path");
        this.createApplicationClassLoaders(this.parentLoader);
        string = System.getProperty("java.security.manager");
        if (string != null) {
            SecurityManager securityManager = null;
            if ("".equals(string) || "default".equals(string)) {
                securityManager = new SecurityManager();
            } else {
                try {
                    securityManager = (SecurityManager)this.loader.loadClass(string).newInstance();
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            if (securityManager != null) {
                System.setSecurityManager(securityManager);
                ClassLoader classLoader = securityManager.getClass().getClassLoader();
                if (!(classLoader instanceof Middleware) && classLoader != null && classLoader != this.extLoader) {
                    ExtendedSystem.setJVMUnresettableConditionally(65563, new String("Security manager is not primordial or middleware in launcher()"));
                }
            } else {
                throw new InternalError("Could not create SecurityManager: " + string);
            }
        }
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    private void createApplicationClassLoaders(ClassLoader classLoader) {
        try {
            if (null != this.sacPath) {
                classLoader = ShareableClassLoader.getShareableClassLoader(this.sacPath, this.sacURLs, classLoader);
                if (null == this.sacURLs) {
                    this.sacURLs = ((URLClassLoader)classLoader).getURLs();
                }
            }
        }
        catch (IOException iOException) {
            throw new InternalError("Could not create shareable application class loader");
        }
        try {
            String string = System.getProperty("java.class.path");
            if (null == this.appPath || !this.appPath.equals(string)) {
                this.appPath = string;
                this.appURLs = null;
            }
            this.loader = AppClassLoader.getAppClassLoader(this.appPath, this.appURLs, classLoader);
            if (null == this.appURLs) {
                this.appURLs = ((URLClassLoader)this.loader).getURLs();
            }
        }
        catch (IOException iOException) {
            throw new InternalError("Could not create application class loader");
        }
        Thread.currentThread().setContextClassLoader(this.loader);
    }

    public static URLClassPath getBootstrapClassPath() {
        URL[] uRLArray;
        String string = (String)AccessController.doPrivileged(new GetPropertyAction("sun.boot.class.path"));
        if (string == null) {
            string = (String)AccessController.doPrivileged(new GetPropertyAction("java.class.path"));
        }
        if (string != null) {
            final String string2 = string;
            uRLArray = (URL[])AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Launcher.pathToURLs(Launcher.getClassPath(string2));
                }
            });
        } else {
            uRLArray = new URL[]{};
        }
        return new URLClassPath(uRLArray, factory);
    }

    private static URL[] pathToURLs(File[] fileArray) {
        URL[] uRLArray = new URL[fileArray.length];
        int n = 0;
        while (n < fileArray.length) {
            uRLArray[n] = Launcher.getFileURL(fileArray[n]);
            ++n;
        }
        return uRLArray;
    }

    private static File[] getClassPath(String string) {
        File[] fileArray;
        if (string != null) {
            int n = 0;
            int n2 = 1;
            int n3 = 0;
            int n4 = 0;
            while ((n3 = string.indexOf(File.pathSeparator, n4)) != -1) {
                ++n2;
                n4 = n3 + 1;
            }
            fileArray = new File[n2];
            n3 = 0;
            n4 = 0;
            while ((n3 = string.indexOf(File.pathSeparator, n4)) != -1) {
                fileArray[n++] = n3 - n4 > 0 ? new File(string.substring(n4, n3)) : new File(".");
                n4 = n3 + 1;
            }
            fileArray[n++] = n4 < string.length() ? new File(string.substring(n4)) : new File(".");
            if (n != n2) {
                File[] fileArray2 = new File[n];
                System.arraycopy(fileArray, 0, fileArray2, 0, n);
                fileArray = fileArray2;
            }
        } else {
            fileArray = new File[]{};
        }
        return fileArray;
    }

    static URL getFileURL(File file) {
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            return ParseUtil.fileToEncodedURL(file);
        }
        catch (MalformedURLException malformedURLException) {
            throw new InternalError();
        }
    }

    static {
        factory = new Factory();
        launcher = (Launcher)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string = System.getProperty("sun.boot.class.path");
                if (string != null) {
                    return new Launcher();
                }
                return null;
            }
        });
    }

    private static class Factory
    implements URLStreamHandlerFactory {
        private static String PREFIX = "sun.net.www.protocol";

        private Factory() {
        }

        public URLStreamHandler createURLStreamHandler(String string) {
            String string2 = PREFIX + "." + string + ".Handler";
            try {
                Class clazz = Class.forName(string2);
                return (URLStreamHandler)clazz.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
            catch (InstantiationException instantiationException) {
                instantiationException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            throw new InternalError("could not load " + string + "system protocol handler");
        }
    }

    static class ShareableClassLoader
    extends AppClassLoader
    implements Shareable {
        public static ClassLoader getShareableClassLoader(String string, URL[] uRLArray, ClassLoader classLoader) throws IOException {
            try {
                return (ShareableClassLoader)AccessController.doPrivileged(new PrivilegedExceptionAction(uRLArray, string, classLoader){
                    private final /* synthetic */ URL[] val$prevURLs;
                    private final /* synthetic */ String val$s;
                    private final /* synthetic */ ClassLoader val$parent;
                    {
                        this.val$prevURLs = uRLArray;
                        this.val$s = string;
                        this.val$parent = classLoader;
                    }

                    public Object run() throws NamespaceException {
                        URL[] uRLArray;
                        if (null == this.val$prevURLs) {
                            File[] fileArray = Launcher.access$200(this.val$s);
                            uRLArray = this.val$s == null ? new URL[]{} : Launcher.access$300(fileArray);
                        } else {
                            uRLArray = this.val$prevURLs;
                        }
                        return new ShareableClassLoader(uRLArray, this.val$parent);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw new InternalError("Could not create shareable application class loader, " + privilegedActionException.getException());
            }
        }

        ShareableClassLoader(URL[] uRLArray, ClassLoader classLoader) throws NamespaceException {
            super(uRLArray, classLoader);
            ExtendedSystem.registerShareableClassLoader(this, null);
        }
    }

    static class MiddlewareClassLoader
    extends AppClassLoader
    implements Middleware,
    Shareable {
        public static ClassLoader getMiddlewareClassLoader(String string, ClassLoader classLoader) throws IOException {
            File[] fileArray = Launcher.getClassPath(string);
            try {
                return (MiddlewareClassLoader)AccessController.doPrivileged(new PrivilegedExceptionAction(string, fileArray, classLoader){
                    private final /* synthetic */ String val$s;
                    private final /* synthetic */ File[] val$path;
                    private final /* synthetic */ ClassLoader val$parent;
                    {
                        this.val$s = string;
                        this.val$path = fileArray;
                        this.val$parent = classLoader;
                    }

                    public Object run() throws NamespaceException {
                        URL[] uRLArray = this.val$s == null ? new URL[]{} : Launcher.access$300(this.val$path);
                        return new MiddlewareClassLoader(uRLArray, this.val$parent);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw new InternalError("Could not create trusted middleware class loader, " + privilegedActionException.getException());
            }
        }

        MiddlewareClassLoader(URL[] uRLArray, ClassLoader classLoader) throws NamespaceException {
            super(uRLArray, classLoader);
            ExtendedSystem.registerShareableClassLoader(this, null);
        }
    }

    static class AppClassLoader
    extends URLClassLoader {
        public static ClassLoader getAppClassLoader(String string, URL[] uRLArray, ClassLoader classLoader) throws IOException {
            return (AppClassLoader)AccessController.doPrivileged(new PrivilegedAction(uRLArray, string, classLoader){
                private final /* synthetic */ URL[] val$prevURLs;
                private final /* synthetic */ String val$s;
                private final /* synthetic */ ClassLoader val$parent;
                {
                    this.val$prevURLs = uRLArray;
                    this.val$s = string;
                    this.val$parent = classLoader;
                }

                public Object run() {
                    URL[] uRLArray;
                    if (null == this.val$prevURLs) {
                        File[] fileArray = this.val$s == null ? new File[]{} : Launcher.access$200(this.val$s);
                        uRLArray = this.val$s == null ? new URL[]{} : Launcher.access$300(fileArray);
                    } else {
                        uRLArray = this.val$prevURLs;
                    }
                    return new AppClassLoader(uRLArray, this.val$parent);
                }
            });
        }

        AppClassLoader(URL[] uRLArray, ClassLoader classLoader) {
            super(uRLArray, classLoader, factory);
        }

        public synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
            SecurityManager securityManager;
            int n = string.lastIndexOf(46);
            if (n != -1 && (securityManager = System.getSecurityManager()) != null) {
                securityManager.checkPackageAccess(string.substring(0, n));
            }
            return super.loadClass(string, bl);
        }

        protected PermissionCollection getPermissions(CodeSource codeSource) {
            PermissionCollection permissionCollection = super.getPermissions(codeSource);
            permissionCollection.add(new RuntimePermission("exitVM"));
            return permissionCollection;
        }

        private static AccessControlContext getContext(File[] fileArray) throws MalformedURLException {
            PathPermissions pathPermissions = new PathPermissions(fileArray);
            ProtectionDomain protectionDomain = new ProtectionDomain(new CodeSource(pathPermissions.getCodeBase(), null), pathPermissions);
            AccessControlContext accessControlContext = new AccessControlContext(new ProtectionDomain[]{protectionDomain});
            return accessControlContext;
        }
    }

    static class ExtClassLoader
    extends URLClassLoader
    implements Shareable {
        private File[] dirs;

        public static ExtClassLoader getExtClassLoader() {
            File[] fileArray = ExtClassLoader.getExtDirs();
            try {
                return (ExtClassLoader)AccessController.doPrivileged(new PrivilegedExceptionAction(fileArray){
                    private final /* synthetic */ File[] val$dirs;
                    {
                        this.val$dirs = fileArray;
                    }

                    public Object run() throws IOException, NamespaceException {
                        return new ExtClassLoader(this.val$dirs);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw new InternalError("Could not create extension class loader, " + privilegedActionException.getException());
            }
        }

        void addExtURL(URL uRL) {
            super.addURL(uRL);
        }

        public ExtClassLoader(File[] fileArray) throws IOException, NamespaceException {
            super(ExtClassLoader.getExtURLs(fileArray), null, factory);
            this.dirs = fileArray;
            ExtendedSystem.registerShareableClassLoader(this, null);
        }

        private static File[] getExtDirs() {
            File[] fileArray;
            String string = System.getProperty("java.ext.dirs");
            if (string != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
                int n = stringTokenizer.countTokens();
                fileArray = new File[n];
                int n2 = 0;
                while (n2 < n) {
                    fileArray[n2] = new File(stringTokenizer.nextToken());
                    ++n2;
                }
            } else {
                fileArray = new File[]{};
            }
            return fileArray;
        }

        private static URL[] getExtURLs(File[] fileArray) throws IOException {
            Object[] objectArray;
            Vector vector = new Vector();
            int n = 0;
            while (n < fileArray.length) {
                objectArray = fileArray[n].list(new JarFilter());
                if (objectArray != null) {
                    int n2 = 0;
                    while (n2 < objectArray.length) {
                        File file = new File(fileArray[n], (String)objectArray[n2]);
                        vector.add(Launcher.getFileURL(file));
                        ++n2;
                    }
                }
                ++n;
            }
            objectArray = new URL[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }

        public String findLibrary(String string) {
            string = System.mapLibraryName(string);
            int n = 0;
            while (n < this.dirs.length) {
                File file;
                String string2 = System.getProperty("os.arch");
                if (string2 != null && (file = new File(new File(this.dirs[n], string2), string)).exists()) {
                    return file.getAbsolutePath();
                }
                file = new File(this.dirs[n], string);
                if (file.exists()) {
                    return file.getAbsolutePath();
                }
                ++n;
            }
            return null;
        }

        private static AccessControlContext getContext(File[] fileArray) throws IOException {
            PathPermissions pathPermissions = new PathPermissions(fileArray);
            ProtectionDomain protectionDomain = new ProtectionDomain(new CodeSource(pathPermissions.getCodeBase(), null), pathPermissions);
            AccessControlContext accessControlContext = new AccessControlContext(new ProtectionDomain[]{protectionDomain});
            return accessControlContext;
        }
    }
}

