/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.os2;

import java.awt.Adjustable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.ScrollPane;
import java.awt.peer.ScrollPanePeer;
import sun.awt.DebugHelper;
import sun.awt.PeerEvent;
import sun.awt.SunToolkit;
import sun.awt.os2.WComponentPeer;
import sun.awt.os2.WPanelPeer;

class WScrollPanePeer
extends WPanelPeer
implements ScrollPanePeer {
    private static final DebugHelper dbg = DebugHelper.create(class$sun$awt$os2$WScrollPanePeer == null ? (class$sun$awt$os2$WScrollPanePeer = WScrollPanePeer.class$("sun.awt.os2.WScrollPanePeer")) : class$sun$awt$os2$WScrollPanePeer);
    static final int SCROLL_UP = 0;
    static final int SCROLL_DOWN = 1;
    static final int SCROLL_BLOCK_UP = 2;
    static final int SCROLL_BLOCK_DOWN = 3;
    static final int SCROLL_ABSOLUTE = 4;
    static final int ORIENT_VERT = 0;
    static final int ORIENT_HORZ = 1;
    int scrollbarWidth = this._getVScrollbarWidth();
    int scrollbarHeight = this._getHScrollbarHeight();
    int prevx;
    int prevy;
    static /* synthetic */ Class class$sun$awt$os2$WScrollPanePeer;

    static native void initIDs();

    native void create(WComponentPeer var1);

    native int getOffset(int var1);

    WScrollPanePeer(Component component) {
        super(component);
    }

    void initialize() {
        super.initialize();
        this.setInsets();
        Insets insets = this.getInsets();
        this.setScrollPosition(-insets.left, -insets.top);
    }

    public void setUnitIncrement(Adjustable adjustable, int n) {
    }

    public Insets insets() {
        return this.getInsets();
    }

    private native void setInsets();

    public synchronized native void setScrollPosition(int var1, int var2);

    public int getHScrollbarHeight() {
        return this.scrollbarHeight;
    }

    private native int _getHScrollbarHeight();

    public int getVScrollbarWidth() {
        return this.scrollbarWidth;
    }

    private native int _getVScrollbarWidth();

    public Point getScrollOffset() {
        int n = this.getOffset(0);
        int n2 = this.getOffset(1);
        return new Point(n, n2);
    }

    public void childResized(int n, int n2) {
        ScrollPane scrollPane = (ScrollPane)this.target;
        Dimension dimension = scrollPane.getSize();
        this.setSpans(dimension.width, dimension.height, n, n2);
        this.setInsets();
    }

    synchronized native void setSpans(int var1, int var2, int var3, int var4);

    public void setValue(Adjustable adjustable, int n) {
        Component component = this.getScrollChild();
        Point point = component.getLocation();
        switch (adjustable.getOrientation()) {
            case 1: {
                this.setScrollPosition(-point.x, n);
                break;
            }
            case 0: {
                this.setScrollPosition(n, -point.y);
            }
        }
    }

    private native Component getScrollChild();

    private void postScrollEvent(int n, int n2, int n3) {
        ScrollEventRunnable scrollEventRunnable = new ScrollEventRunnable(n, n2, n3);
        SunToolkit.executeOnEventHandlerThread(new ScrollEvent(this.target, scrollEventRunnable));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        WScrollPanePeer.initIDs();
    }

    class ScrollEventRunnable
    implements Runnable {
        int orient;
        int scrollType;
        int pos;

        ScrollEventRunnable(int n, int n2, int n3) {
            this.orient = n;
            this.scrollType = n2;
            this.pos = n3;
        }

        public void run() {
            Component component;
            Adjustable adjustable = null;
            ScrollPane scrollPane = (ScrollPane)WScrollPanePeer.this.target;
            if (this.orient == 0) {
                adjustable = scrollPane.getVAdjustable();
            } else if (this.orient == 1) {
                adjustable = scrollPane.getHAdjustable();
            } else {
                dbg;
            }
            if (adjustable == null) {
                return;
            }
            int n = adjustable.getUnitIncrement();
            int n2 = adjustable.getBlockIncrement();
            int n3 = adjustable.getValue();
            switch (this.scrollType) {
                case 0: {
                    n3 -= n;
                    break;
                }
                case 1: {
                    n3 += n;
                    break;
                }
                case 2: {
                    n3 -= n2;
                    break;
                }
                case 3: {
                    n3 += n2;
                    break;
                }
                case 4: {
                    n3 = this.pos;
                    break;
                }
                default: {
                    dbg;
                }
            }
            n3 = Math.max(adjustable.getMinimum(), n3);
            n3 = Math.min(adjustable.getMaximum(), n3);
            adjustable.setValue(n3);
            Component component2 = component = WScrollPanePeer.this.getScrollChild();
            while (!(component2.getPeer() instanceof WComponentPeer)) {
                component2 = component2.getParent();
            }
            dbg;
            WComponentPeer wComponentPeer = (WComponentPeer)component2.getPeer();
            wComponentPeer.paintDamagedAreaImmediately();
        }
    }

    class ScrollEvent
    extends PeerEvent {
        ScrollEvent(Object object, Runnable runnable) {
            super(object, runnable, 0L);
        }

        public PeerEvent coalesceEvents(PeerEvent peerEvent) {
            dbg;
            if (peerEvent instanceof ScrollEvent) {
                return peerEvent;
            }
            return null;
        }
    }
}

