/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.os2;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.PrintJob;
import sun.awt.os2.WPrintControl;
import sun.awt.os2.WPrintGraphics;
import sun.awt.os2.WPrintGraphicsWrapper;

public class WPrintJob
extends PrintJob {
    private Dimension pageDimension = new Dimension(612, 792);
    int pageResolution = 72;
    int truePageXResolution = 300;
    int truePageYResolution = 300;
    private boolean lastFirst = false;
    private int pageCount = 0;
    private WPrintGraphics graphics = null;
    private WPrintGraphicsWrapper gw = null;

    static WPrintJob createPrintJob(WPrintControl wPrintControl) {
        WPrintJob wPrintJob = new WPrintJob(wPrintControl);
        if (wPrintJob.cancelled()) {
            return null;
        }
        return wPrintJob;
    }

    private WPrintJob(WPrintControl wPrintControl) {
        this.graphics = new WPrintGraphics(wPrintControl, this);
        if (this.graphics.pData != 0) {
            this.gw = this.graphics.wrapper = new WPrintGraphicsWrapper(this.graphics, this);
        } else {
            this.graphics.dispose();
            this.graphics = null;
        }
    }

    private boolean cancelled() {
        return this.graphics == null;
    }

    private native void newPage();

    protected native boolean setLogicalFont(Font var1);

    public synchronized Graphics getGraphics() {
        if (this.graphics == null) {
            return null;
        }
        this.newPage();
        Graphics graphics = this.gw.create(++this.pageCount);
        graphics.setFont(new Font("Dialog", 0, 12));
        graphics.setColor(Color.black);
        return graphics;
    }

    public Dimension getPageDimension() {
        return this.pageDimension;
    }

    public int getPageResolution() {
        return this.pageResolution;
    }

    public boolean lastPageFirst() {
        return this.lastFirst;
    }

    private native void flushPageImpl();

    synchronized void flushPage(int n) {
        if (n == this.pageCount && this.graphics != null) {
            this.flushPageImpl();
        }
    }

    private native void endImpl();

    public synchronized void end() {
        if (this.graphics != null) {
            this.endImpl();
            this.graphics.dispose();
            this.graphics = null;
        }
    }

    private static native void initIDs();

    static {
        WPrintJob.initIDs();
    }
}

