/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.os2;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.List;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.peer.ListPeer;
import sun.awt.SunToolkit;
import sun.awt.os2.WComponentPeer;

class WListPeer
extends WComponentPeer
implements ListPeer {
    private FontMetrics fm;

    public Dimension minimumSize() {
        return this.minimumSize(4);
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public int[] getSelectedIndexes() {
        List list = (List)this.target;
        int n = list.countItems();
        int[] nArray = new int[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (this.isSelected(n3)) {
                nArray[n2++] = n3;
            }
            ++n3;
        }
        int[] nArray2 = new int[n2];
        System.arraycopy(nArray, 0, nArray2, 0, n2);
        return nArray2;
    }

    public void add(String string, int n) {
        this.addItem(string, n);
    }

    public void removeAll() {
        this.clear();
    }

    public void setMultipleMode(boolean bl) {
        this.setMultipleSelections(bl);
    }

    public Dimension getPreferredSize(int n) {
        return this.preferredSize(n);
    }

    public Dimension getMinimumSize(int n) {
        return this.minimumSize(n);
    }

    public void addItem(String string, int n) {
        this.addItems(new String[]{string}, n, this.fm.stringWidth(string));
    }

    native void addItems(String[] var1, int var2, int var3);

    public native void delItems(int var1, int var2);

    public void clear() {
        List list = (List)this.target;
        this.delItems(0, list.countItems());
    }

    public native void select(int var1);

    public native void deselect(int var1);

    public native void makeVisible(int var1);

    public native void setMultipleSelections(boolean var1);

    public Dimension preferredSize(int n) {
        Dimension dimension = this.minimumSize(n);
        dimension.width = Math.max(dimension.width, this.getMaxItemWidth() + 28);
        return dimension;
    }

    public Dimension minimumSize(int n) {
        return new Dimension(28 + this.fm.stringWidth("0123456789abcde"), this.fm.getHeight() * n + 4);
    }

    WListPeer(List list) {
        super(list);
    }

    native void create(WComponentPeer var1);

    void initialize() {
        int n;
        List list = (List)this.target;
        this.fm = this.getFontMetrics(list.getFont());
        int n2 = list.countItems();
        if (n2 > 0) {
            String[] stringArray = new String[n2];
            int n3 = 0;
            n = 0;
            int n4 = 0;
            while (n4 < n2) {
                stringArray[n4] = list.getItem(n4);
                n = this.fm.stringWidth(stringArray[n4]);
                if (n > n3) {
                    n3 = n;
                }
                ++n4;
            }
            this.addItems(stringArray, 0, n3);
        }
        this.setMultipleSelections(list.allowsMultipleSelections());
        int n5 = list.getVisibleIndex();
        if (n5 >= 0) {
            this.makeVisible(n5);
        }
        int[] nArray = list.getSelectedIndexes();
        n = 0;
        while (n < nArray.length) {
            this.select(nArray[n]);
            ++n;
        }
        super.initialize();
    }

    native boolean isSelected(int var1);

    public synchronized void setFont(Font font) {
        super.setFont(font);
        this.fm = this.getFontMetrics(((List)this.target).getFont());
    }

    public boolean shouldClearRectBeforePaint() {
        return false;
    }

    int getMaxItemWidth() {
        List list = (List)this.target;
        FontMetrics fontMetrics = this.getFontMetrics(list.getFont());
        int n = 0;
        int n2 = list.countItems();
        int n3 = 0;
        while (n3 < n2) {
            String string = list.getItem(n3);
            n = Math.max(n, fontMetrics.stringWidth(string));
            ++n3;
        }
        return n;
    }

    void handleAction(final int n) {
        final List list = (List)this.target;
        SunToolkit.executeOnEventHandlerThread(list, new Runnable(){

            public void run() {
                list.select(n);
                WListPeer.this.postEvent(new ActionEvent(WListPeer.this.target, 1001, list.getItem(n)));
            }
        });
    }

    void handleListChanged(final int n) {
        final List list = (List)this.target;
        SunToolkit.executeOnEventHandlerThread(list, new Runnable(){

            public void run() {
                WListPeer.this.postEvent(new ItemEvent(list, 701, new Integer(n), WListPeer.this.isSelected(n) ? 1 : 2));
            }
        });
    }
}

