/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.os2;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.InputMethodEvent;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.im.InputMethodHighlight;
import java.awt.im.InputSubset;
import java.awt.im.spi.InputMethodContext;
import java.awt.peer.LightweightPeer;
import java.text.Annotation;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import sun.awt.SunToolkit;
import sun.awt.im.InputMethodAdapter;
import sun.awt.os2.WComponentPeer;
import sun.awt.os2.WInputMethodDescriptor;

public class WInputMethod
extends InputMethodAdapter {
    private InputMethodContext inputContext;
    private Component awtFocussedComponent;
    private WComponentPeer awtFocussedComponentPeer;
    private boolean isActive;
    private int context = this.createNativeContext();
    private boolean open;
    private int cmode = this.getConversionStatus(this.context);
    private Locale currentLocale;
    public static final byte ATTR_INPUT = 0;
    public static final byte ATTR_TARGET_CONVERTED = 1;
    public static final byte ATTR_CONVERTED = 2;
    public static final byte ATTR_TARGET_NOTCONVERTED = 3;
    public static final byte ATTR_INPUT_ERROR = 4;
    public static final int IME_CMODE_ALPHANUMERIC = 0;
    public static final int IME_CMODE_NATIVE = 1;
    public static final int IME_CMODE_KATAKANA = 2;
    public static final int IME_CMODE_LANGUAGE = 3;
    public static final int IME_CMODE_FULLSHAPE = 32;
    public static final int IME_CMODE_ROMAN = 64;
    private static final boolean COMMIT_INPUT = true;
    private static final boolean DISCARD_INPUT = false;
    private static Map[] highlightStyles;

    public WInputMethod() {
        this.open = this.getOpenStatus(this.context);
        this.currentLocale = this.getNativeLocale();
        if (this.currentLocale == null) {
            this.currentLocale = Locale.getDefault();
        }
    }

    protected void finalize() throws Throwable {
        WInputMethod wInputMethod = this;
        synchronized (wInputMethod) {
            if (this.context != 0) {
                this.destroyNativeContext(this.context);
                this.context = 0;
            }
        }
        super.finalize();
    }

    public synchronized void setInputMethodContext(InputMethodContext inputMethodContext) {
        this.inputContext = inputMethodContext;
    }

    public final void dispose() {
    }

    public Object getControlObject() {
        return null;
    }

    public boolean setLocale(Locale locale) {
        return this.setLocale(locale, false);
    }

    private boolean setLocale(Locale locale, boolean bl) {
        Locale[] localeArray = WInputMethodDescriptor.getAvailableLocalesInternal();
        int n = 0;
        while (n < localeArray.length) {
            Locale locale2 = localeArray[n];
            if (locale.equals(locale2) || locale2.equals(Locale.JAPAN) && locale.equals(Locale.JAPANESE) || locale2.equals(Locale.KOREA) && locale.equals(Locale.KOREAN)) {
                if (this.isActive) {
                    this.setNativeLocale(locale2.toString(), bl);
                }
                this.currentLocale = locale2;
                return true;
            }
            ++n;
        }
        return false;
    }

    public Locale getLocale() {
        if (this.isActive) {
            this.currentLocale = this.getNativeLocale();
            if (this.currentLocale == null) {
                this.currentLocale = Locale.getDefault();
            }
        }
        return this.currentLocale;
    }

    public void setCharacterSubsets(Character.Subset[] subsetArray) {
        if (subsetArray == null) {
            this.setConversionStatus(this.context, this.cmode);
            this.setOpenStatus(this.context, this.open);
            return;
        }
        Character.Subset subset = subsetArray[0];
        Locale locale = this.getNativeLocale();
        if (locale == null) {
            return;
        }
        if (locale.getLanguage().equals(Locale.JAPANESE.getLanguage())) {
            if (subset == Character.UnicodeBlock.BASIC_LATIN || subset == InputSubset.LATIN_DIGITS) {
                this.setOpenStatus(this.context, false);
            } else {
                int n;
                if (subset == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || subset == InputSubset.KANJI || subset == Character.UnicodeBlock.HIRAGANA) {
                    n = 33;
                } else if (subset == Character.UnicodeBlock.KATAKANA) {
                    n = 35;
                } else if (subset == InputSubset.HALFWIDTH_KATAKANA) {
                    n = 3;
                } else if (subset == InputSubset.FULLWIDTH_LATIN) {
                    n = 32;
                } else {
                    return;
                }
                this.setOpenStatus(this.context, true);
                this.setConversionStatus(this.context, n |= this.getConversionStatus(this.context) & 0x40);
            }
        } else if (locale.getLanguage().equals(Locale.KOREAN.getLanguage())) {
            if (subset == Character.UnicodeBlock.BASIC_LATIN || subset == InputSubset.LATIN_DIGITS) {
                this.setOpenStatus(this.context, false);
            } else {
                int n;
                if (subset == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || subset == InputSubset.HANJA || subset == Character.UnicodeBlock.HANGUL_SYLLABLES || subset == Character.UnicodeBlock.HANGUL_JAMO || subset == Character.UnicodeBlock.HANGUL_COMPATIBILITY_JAMO) {
                    n = 1;
                } else if (subset == InputSubset.FULLWIDTH_LATIN) {
                    n = 32;
                } else {
                    return;
                }
                this.setOpenStatus(this.context, true);
                this.setConversionStatus(this.context, n);
            }
        } else if (locale.getLanguage().equals(Locale.CHINESE.getLanguage())) {
            if (subset == Character.UnicodeBlock.BASIC_LATIN || subset == InputSubset.LATIN_DIGITS) {
                this.setOpenStatus(this.context, false);
            } else {
                int n;
                if (subset == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || subset == InputSubset.TRADITIONAL_HANZI || subset == InputSubset.SIMPLIFIED_HANZI) {
                    n = 1;
                } else if (subset == InputSubset.FULLWIDTH_LATIN) {
                    n = 32;
                } else {
                    return;
                }
                this.setOpenStatus(this.context, true);
                this.setConversionStatus(this.context, n);
            }
        }
    }

    public void dispatchEvent(AWTEvent aWTEvent) {
        Component component;
        if (aWTEvent instanceof ComponentEvent && (component = ((ComponentEvent)aWTEvent).getComponent()) == this.awtFocussedComponent) {
            if (this.awtFocussedComponentPeer.isDisposed()) {
                this.awtFocussedComponentPeer = this.getNearestNativePeer(component);
            }
            if (this.awtFocussedComponentPeer != null && this.isActive) {
                this.handleNativeIMEEvent(this.awtFocussedComponentPeer, aWTEvent);
            }
        }
    }

    public void activate() {
        if (this.awtFocussedComponentPeer != null) {
            this.enableNativeIME(this.awtFocussedComponentPeer, this.context, !this.haveActiveClient());
        }
        this.isActive = true;
        if (this.currentLocale != null) {
            this.setLocale(this.currentLocale, true);
        }
    }

    public void deactivate(boolean bl) {
        this.getLocale();
        if (this.awtFocussedComponentPeer != null) {
            this.disableNativeIME(this.awtFocussedComponentPeer);
        }
        this.isActive = false;
    }

    protected void setAWTFocussedComponent(Component component) {
        if (component == null) {
            return;
        }
        WComponentPeer wComponentPeer = this.getNearestNativePeer(component);
        if (this.isActive) {
            if (this.awtFocussedComponentPeer != null) {
                this.disableNativeIME(this.awtFocussedComponentPeer);
            }
            if (wComponentPeer != null) {
                this.enableNativeIME(wComponentPeer, this.context, !this.haveActiveClient());
            }
        }
        this.awtFocussedComponent = component;
        this.awtFocussedComponentPeer = wComponentPeer;
    }

    public void hideWindows() {
        if (this.awtFocussedComponentPeer != null) {
            this.hideWindowsNative(this.awtFocussedComponentPeer);
        }
    }

    public void removeNotify() {
        this.endCompositionNative(this.context, false);
    }

    static Map mapInputMethodHighlight(InputMethodHighlight inputMethodHighlight) {
        int n;
        int n2 = inputMethodHighlight.getState();
        if (n2 == 0) {
            n = 0;
        } else if (n2 == 1) {
            n = 2;
        } else {
            return null;
        }
        if (inputMethodHighlight.isSelected()) {
            ++n;
        }
        return highlightStyles[n];
    }

    protected boolean supportsBelowTheSpot() {
        return true;
    }

    public void endComposition() {
        this.endCompositionNative(this.context, this.haveActiveClient());
    }

    public void setCompositionEnabled(boolean bl) {
        this.setOpenStatus(this.context, bl);
    }

    public boolean isCompositionEnabled() {
        return this.getOpenStatus(this.context);
    }

    public void sendInputMethodEvent(int n, String string, int[] nArray, String[] stringArray, int[] nArray2, byte[] byArray, int n2, int n3, int n4) {
        Object object;
        AttributedCharacterIterator attributedCharacterIterator = null;
        if (string != null) {
            int n5;
            object = new AttributedString(string);
            ((AttributedString)object).addAttribute(AttributedCharacterIterator.Attribute.LANGUAGE, Locale.getDefault(), 0, string.length());
            if (nArray != null && stringArray != null && stringArray.length != 0 && nArray.length == stringArray.length + 1 && nArray[0] == 0 && nArray[stringArray.length] == string.length()) {
                n5 = 0;
                while (n5 < nArray.length - 1) {
                    ((AttributedString)object).addAttribute(AttributedCharacterIterator.Attribute.INPUT_METHOD_SEGMENT, new Annotation(null), nArray[n5], nArray[n5 + 1]);
                    ((AttributedString)object).addAttribute(AttributedCharacterIterator.Attribute.READING, new Annotation(stringArray[n5]), nArray[n5], nArray[n5 + 1]);
                    ++n5;
                }
            } else {
                ((AttributedString)object).addAttribute(AttributedCharacterIterator.Attribute.INPUT_METHOD_SEGMENT, new Annotation(null), 0, string.length());
                ((AttributedString)object).addAttribute(AttributedCharacterIterator.Attribute.READING, new Annotation(new String("")), 0, string.length());
            }
            if (nArray2 != null && byArray != null && byArray.length != 0 && nArray2.length == byArray.length + 1 && nArray2[0] == 0 && nArray2[byArray.length] == string.length()) {
                n5 = 0;
                while (n5 < nArray2.length - 1) {
                    InputMethodHighlight inputMethodHighlight;
                    switch (byArray[n5]) {
                        default: {
                            inputMethodHighlight = InputMethodHighlight.UNSELECTED_RAW_TEXT_HIGHLIGHT;
                            break;
                        }
                        case 1: {
                            inputMethodHighlight = InputMethodHighlight.SELECTED_CONVERTED_TEXT_HIGHLIGHT;
                            break;
                        }
                        case 2: {
                            inputMethodHighlight = InputMethodHighlight.UNSELECTED_CONVERTED_TEXT_HIGHLIGHT;
                            break;
                        }
                        case 3: {
                            inputMethodHighlight = InputMethodHighlight.SELECTED_RAW_TEXT_HIGHLIGHT;
                        }
                    }
                    ((AttributedString)object).addAttribute(TextAttribute.INPUT_METHOD_HIGHLIGHT, inputMethodHighlight, nArray2[n5], nArray2[n5 + 1]);
                    ++n5;
                }
            } else {
                ((AttributedString)object).addAttribute(TextAttribute.INPUT_METHOD_HIGHLIGHT, InputMethodHighlight.UNSELECTED_CONVERTED_TEXT_HIGHLIGHT, 0, string.length());
            }
            attributedCharacterIterator = ((AttributedString)object).getIterator();
        }
        if ((object = this.getClientComponent()) == null) {
            return;
        }
        InputMethodEvent inputMethodEvent = new InputMethodEvent((Component)object, n, attributedCharacterIterator, n2, TextHitInfo.leading(n3), TextHitInfo.leading(n4));
        SunToolkit.postEvent(SunToolkit.targetToAppContext(object), inputMethodEvent);
    }

    public Point inquireCandidatePosition() {
        Component component = this.getClientComponent();
        if (component == null) {
            return new Point(0, 0);
        }
        if (this.haveActiveClient()) {
            Rectangle rectangle = this.inputContext.getTextLocation(TextHitInfo.leading(0));
            return new Point(rectangle.x, rectangle.y + rectangle.height);
        }
        Point point = component.getLocationOnScreen();
        Dimension dimension = component.getSize();
        return new Point(point.x, point.y + dimension.height);
    }

    /*
     * Unable to fully structure code
     */
    private WComponentPeer getNearestNativePeer(Component var1_1) {
        if (var1_1 == null) {
            return null;
        }
        var2_2 = var1_1.getPeer();
        if (var2_2 != null) ** GOTO lbl11
        return null;
lbl-1000:
        // 1 sources

        {
            if ((var1_1 = var1_1.getParent()) == null) {
                return null;
            }
            var2_2 = var1_1.getPeer();
            if (var2_2 != null) continue;
            return null;
lbl11:
            // 2 sources

            ** while (var2_2 instanceof LightweightPeer)
        }
lbl12:
        // 1 sources

        if (var2_2 instanceof WComponentPeer) {
            return (WComponentPeer)var2_2;
        }
        return null;
    }

    private native int createNativeContext();

    private native void destroyNativeContext(int var1);

    private native void enableNativeIME(WComponentPeer var1, int var2, boolean var3);

    private native void disableNativeIME(WComponentPeer var1);

    private native void handleNativeIMEEvent(WComponentPeer var1, AWTEvent var2);

    private native void endCompositionNative(int var1, boolean var2);

    private native void setConversionStatus(int var1, int var2);

    private native int getConversionStatus(int var1);

    private native void setOpenStatus(int var1, boolean var2);

    private native boolean getOpenStatus(int var1);

    private native Locale getNativeLocale();

    private native boolean setNativeLocale(String var1, boolean var2);

    private native void hideWindowsNative(WComponentPeer var1);

    static {
        Map[] mapArray = new Map[4];
        HashMap hashMap = new HashMap(1);
        hashMap.put(TextAttribute.INPUT_METHOD_UNDERLINE, TextAttribute.UNDERLINE_LOW_DOTTED);
        mapArray[0] = Collections.unmodifiableMap(hashMap);
        hashMap = new HashMap(1);
        hashMap.put(TextAttribute.INPUT_METHOD_UNDERLINE, TextAttribute.UNDERLINE_LOW_GRAY);
        mapArray[1] = Collections.unmodifiableMap(hashMap);
        hashMap = new HashMap(1);
        hashMap.put(TextAttribute.INPUT_METHOD_UNDERLINE, TextAttribute.UNDERLINE_LOW_DOTTED);
        mapArray[2] = Collections.unmodifiableMap(hashMap);
        hashMap = new HashMap(4);
        Color color = new Color(0, 0, 128);
        hashMap.put(TextAttribute.FOREGROUND, color);
        hashMap.put(TextAttribute.BACKGROUND, Color.white);
        hashMap.put(TextAttribute.SWAP_COLORS, TextAttribute.SWAP_COLORS_ON);
        hashMap.put(TextAttribute.INPUT_METHOD_UNDERLINE, TextAttribute.UNDERLINE_LOW_ONE_PIXEL);
        mapArray[3] = Collections.unmodifiableMap(hashMap);
        highlightStyles = mapArray;
    }
}

