/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.os2;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import sun.io.CharToByteConverter;

final class ReencodingInputStream
extends InputStream {
    private Reader wrapped;
    private CharToByteConverter converter;
    private boolean eos;
    private byte[] cached;
    private int index;
    private int limit;

    public ReencodingInputStream(InputStream inputStream, String string, String string2) throws IOException {
        this.wrapped = new BufferedReader(new InputStreamReader(inputStream, string));
        this.converter = CharToByteConverter.getConverter(string2);
        this.cached = new byte[this.converter.getMaxBytesPerChar()];
    }

    public int read() throws IOException {
        if (this.eos) {
            return -1;
        }
        if (this.index >= this.limit) {
            int n;
            while ((char)(n = this.wrapped.read()) == '\r') {
            }
            if (n == -1 || n == 0) {
                this.eos = true;
                return -1;
            }
            this.limit = this.converter.convert(new char[]{(char)n}, 0, 1, this.cached, 0, this.cached.length);
            this.index = 0;
        }
        return 0xFF & this.cached[this.index++];
    }

    public int available() throws IOException {
        return this.eos ? 0 : this.limit - this.index;
    }

    public void close() throws IOException {
        this.wrapped.close();
    }
}

