/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.os2;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Panel;

public class GroupBox
extends Panel {
    String title;

    public GroupBox(String string) {
        this.setTitle(string);
        this.setLayout(new GridBagLayout());
    }

    public GroupBox(String string, LayoutManager layoutManager) {
        this.setTitle(string);
        this.setLayout(layoutManager);
    }

    public void setTitle(String string) {
        this.title = string == null ? "" : string;
        this.repaint();
    }

    public String getTitle() {
        return this.title;
    }

    public Insets getInsets() {
        Font font = this.getFont();
        Insets insets = new Insets(5, 5, 5, 5);
        if (font != null && !this.title.equals("")) {
            FontMetrics fontMetrics = this.getFontMetrics(font);
            insets.top = fontMetrics.getHeight() + 4;
        }
        return insets;
    }

    public void paint(Graphics graphics) {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n = 2;
        if (!this.title.equals("")) {
            n = fontMetrics.getHeight() / 2 + 2;
        }
        Dimension dimension = this.getSize();
        graphics.setColor(this.getBackground().brighter().brighter());
        graphics.drawRect(1, n + 1, dimension.width - 2, dimension.height - n - 2);
        graphics.setColor(this.getBackground().darker().darker());
        graphics.drawRect(0, n, dimension.width - 2, dimension.height - n - 2);
        if (!this.title.equals("")) {
            Insets insets = this.getInsets();
            int n2 = dimension.width - insets.left - insets.right - 4;
            String string = this.title;
            while (!string.equals("") && fontMetrics.stringWidth(string) > n2) {
                string = string.substring(0, string.length() - 1);
            }
            graphics.setColor(this.getBackground());
            graphics.fillRect(n, 0, fontMetrics.stringWidth(string) + 4, fontMetrics.getHeight());
            if (this.isEnabled()) {
                graphics.setColor(this.getForeground());
            } else {
                graphics.setColor(Color.white);
                graphics.drawString(string, n + 3, fontMetrics.getHeight() - fontMetrics.getMaxDescent() + 3);
                graphics.setColor(Color.gray);
            }
            graphics.drawString(string, n + 2, fontMetrics.getHeight() - fontMetrics.getMaxDescent() + 2);
        }
    }
}

