/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.dnd;

import java.awt.AWTPermission;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.dnd.peer.DropTargetContextPeer;
import java.io.IOException;
import java.security.AccessControlContext;
import java.security.AccessController;
import sun.awt.Mutex;
import sun.awt.SunToolkit;

public abstract class SunDropTargetContextPeer
implements DropTargetContextPeer,
Transferable,
Runnable {
    protected Component currentC;
    protected DropTarget currentDT;
    protected DropTargetContext currentDTC;
    protected long[] currentT;
    protected int currentA;
    protected int currentDA;
    protected int prevDA;
    protected long nativeDragContext;
    protected Transferable local;
    protected int messagePending = 0;
    protected Component currentNC;
    protected int currentX;
    protected int currentY;
    protected int currentSA;
    protected int dropStatus = 0;
    protected boolean dropComplete = false;
    protected Object lock = new Object();
    protected Mutex syncLock = new Mutex();
    static final int DISPATCH_NONE = 0;
    static final int DISPATCH_ENTER = 1;
    static final int DISPATCH_MOTION = 2;
    static final int DISPATCH_CHANGED = 3;
    static final int DISPATCH_EXIT = 4;
    static final int DISPATCH_DROP = 5;
    protected static final Object _globalLock = new Object();
    protected static Transferable currentJVMLocalSourceTransferable = null;
    protected static AccessControlContext currentJVMLocalSourceACtxt = null;
    protected static final int STATUS_NONE = 0;
    protected static final int STATUS_WAIT = 1;
    protected static final int STATUS_ACCEPT = 2;
    protected static final int STATUS_REJECT = -1;

    public static void setCurrentJVMLocalSourceTransferable(Transferable transferable) throws InvalidDnDOperationException {
        Object object = _globalLock;
        synchronized (object) {
            if (transferable != null && currentJVMLocalSourceTransferable != null) {
                throw new InvalidDnDOperationException();
            }
            currentJVMLocalSourceTransferable = transferable;
            currentJVMLocalSourceACtxt = transferable != null ? AccessController.getContext() : null;
        }
    }

    private static Transferable getJVMLocalSourceTransferable() {
        Transferable transferable = null;
        Object object = _globalLock;
        synchronized (object) {
            if (currentJVMLocalSourceTransferable != null && !currentJVMLocalSourceACtxt.equals(AccessController.getContext())) {
                AccessController.checkPermission(new AWTPermission("acceptDropBetweenAccessControlContexts"));
            }
            transferable = currentJVMLocalSourceTransferable;
        }
        return transferable;
    }

    public DropTarget getDropTarget() {
        return this.currentDT;
    }

    public void setTargetActions(int n) {
        Object object = this.lock;
        synchronized (object) {
            this.currentA = n & 0x40000003;
        }
    }

    public int getTargetActions() {
        Object object = this.lock;
        synchronized (object) {
            int n = this.currentA;
            return n;
        }
    }

    public Transferable getTransferable() {
        return this;
    }

    public abstract DataFlavor[] getTransferDataFlavors();

    public abstract boolean isDataFlavorSupported(DataFlavor var1);

    public abstract Object getTransferData(DataFlavor var1) throws UnsupportedFlavorException, IOException, InvalidDnDOperationException;

    public boolean isTransferableJVMLocal() {
        return this.local != null || SunDropTargetContextPeer.getJVMLocalSourceTransferable() != null;
    }

    public void run() {
        this.syncLock.lock();
        int n = this.messagePending;
        this.syncLock.unlock();
        switch (n) {
            case 1: {
                this.processEnterMessage();
                break;
            }
            case 2: 
            case 3: {
                this.processMotionMessage(n);
                break;
            }
            case 4: {
                this.processExitMessage();
                break;
            }
            case 5: {
                this.messagePending = 0;
                this.processDropMessage();
                return;
            }
        }
        this.syncLock.lock();
        if (this.messagePending != 0) {
            this.messagePending = 0;
            this.quitSecondaryDispatch();
        }
        this.syncLock.unlock();
    }

    private int handleEnterMessage(Component component, int n, int n2, int n3, int n4, long[] lArray, long l) {
        this.syncLock.lock();
        while (this.messagePending != 0) {
            this.syncLock.unlock();
            this.startSecondaryDispatch();
            this.syncLock.lock();
        }
        this.nativeDragContext = l;
        this.currentNC = component;
        this.currentT = lArray;
        this.currentX = n;
        this.currentY = n2;
        this.currentSA = n4;
        this.currentDA = n3;
        this.prevDA = n3;
        this.messagePending = 1;
        SunToolkit.executeOnEventHandlerThread(component, this);
        while (this.messagePending != 0) {
            this.syncLock.unlock();
            this.startSecondaryDispatch();
            this.syncLock.lock();
        }
        int n5 = this.currentDA;
        this.syncLock.unlock();
        return n5;
    }

    private void processEnterMessage() {
        boolean bl;
        DropTarget dropTarget = null;
        Point point = null;
        this.local = SunDropTargetContextPeer.getJVMLocalSourceTransferable();
        Component component = this.currentNC instanceof Container ? this.findComponentAt((Container)this.currentNC, this.currentX, this.currentY) : this.currentNC.locate(this.currentX, this.currentY);
        boolean bl2 = bl = component != null && component.isShowing() && (dropTarget = component.getDropTarget()) != null && dropTarget.isActive();
        if (bl) {
            point = this.translate(this.currentNC, this.currentX, this.currentY, component);
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.currentDTC != null) {
                this.currentDTC.removeNotify();
                this.currentDTC = null;
            }
        }
        if (bl) {
            Object object2 = this.lock;
            synchronized (object2) {
                this.currentC = component;
                this.currentDT = dropTarget;
                this.currentDTC = this.currentDT.getDropTargetContext();
                this.currentDTC.addNotify(this);
                this.currentA = dropTarget.getDefaultActions();
            }
            try {
                if (this.currentDA == 0) {
                    this.currentDA = this.mapOperation(this.currentDT, this.currentA & this.currentSA);
                }
                dropTarget.dragEnter(new DropTargetDragEvent(this.currentDTC, point, this.currentDA, this.currentSA));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Object object3 = this.lock;
                synchronized (object3) {
                    this.currentDA = 0;
                }
            }
        } else {
            Object object4 = this.lock;
            synchronized (object4) {
                this.currentDT = null;
                this.currentDTC = null;
                this.currentDA = 0;
                this.currentSA = 0;
                this.currentA = 0;
            }
        }
    }

    private synchronized void handleExitMessage(Component component, long l) {
        this.syncLock.lock();
        while (this.messagePending != 0) {
            this.syncLock.unlock();
            this.startSecondaryDispatch();
            this.syncLock.lock();
        }
        this.nativeDragContext = l;
        this.messagePending = 4;
        SunToolkit.executeOnEventHandlerThread(component, this);
        while (this.messagePending != 0) {
            this.syncLock.unlock();
            this.startSecondaryDispatch();
            this.syncLock.lock();
        }
        this.syncLock.unlock();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processExitMessage() {
        Object object;
        DropTarget dropTarget = null;
        DropTargetContext dropTargetContext = null;
        Object object2 = this.lock;
        synchronized (object2) {
            if (this.currentC != null) {
                DropTarget dropTarget2 = this.currentC.getDropTarget();
                if (dropTarget2 == null) {
                    this.currentC = null;
                    this.currentDT = null;
                    this.currentT = null;
                    if (this.currentDTC != null) {
                        this.currentDTC.removeNotify();
                    }
                    this.currentDTC = null;
                    return;
                }
                if (dropTarget2 != this.currentDT) {
                    if (this.currentDTC != null) {
                        this.currentDTC.removeNotify();
                    }
                    dropTarget = this.currentDT = dropTarget2;
                    dropTargetContext = this.currentDTC = dropTarget2.getDropTargetContext();
                    this.currentDTC.addNotify(this);
                } else {
                    dropTarget = this.currentDT;
                    dropTargetContext = this.currentDTC;
                }
            }
        }
        if (dropTarget == null) return;
        if (!dropTarget.isActive()) return;
        try {
            try {
                dropTarget.dragExit(new DropTargetEvent(dropTargetContext));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Object var7_7 = null;
                Object object22 = this.lock;
                synchronized (object22) {
                    this.currentA = 0;
                    this.currentSA = 0;
                    this.currentDA = 0;
                    this.currentC = null;
                    this.currentDT = null;
                    this.currentT = null;
                    this.currentDTC.removeNotify();
                    this.currentDTC = null;
                    this.local = null;
                    return;
                }
            }
            Object var7_6 = null;
            object = this.lock;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            Object object4 = this.lock;
            synchronized (object4) {
                this.currentA = 0;
                this.currentSA = 0;
                this.currentDA = 0;
                this.currentC = null;
                this.currentDT = null;
                this.currentT = null;
                this.currentDTC.removeNotify();
                this.currentDTC = null;
                this.local = null;
                throw throwable;
            }
        }
        synchronized (object) {
            this.currentA = 0;
            this.currentSA = 0;
            this.currentDA = 0;
            this.currentC = null;
            this.currentDT = null;
            this.currentT = null;
            this.currentDTC.removeNotify();
            this.currentDTC = null;
            this.local = null;
            return;
        }
    }

    private int handleMotionMessage(Component component, int n, int n2, int n3, int n4, long[] lArray, long l) {
        boolean bl = false;
        this.syncLock.lock();
        while (this.messagePending != 0) {
            this.syncLock.unlock();
            this.startSecondaryDispatch();
            this.syncLock.lock();
        }
        this.nativeDragContext = l;
        this.currentNC = component;
        this.currentT = lArray;
        this.currentX = n;
        this.currentY = n2;
        this.currentSA = n4;
        this.currentDA = n3;
        bl = this.prevDA != this.currentDA;
        this.prevDA = this.currentDA;
        this.messagePending = bl ? 3 : 2;
        SunToolkit.executeOnEventHandlerThread(component, this);
        while (this.messagePending != 0) {
            this.syncLock.unlock();
            this.startSecondaryDispatch();
            this.syncLock.lock();
        }
        int n5 = this.currentDA;
        this.syncLock.unlock();
        return n5;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processMotionMessage(int n) {
        DropTarget dropTarget2;
        DropTargetContext dropTargetContext;
        DropTarget dropTarget;
        boolean bl2;
        Point point2;
        Component component;
        block46: {
            block47: {
                component = null;
                Point point = null;
                point2 = null;
                boolean bl = false;
                bl2 = false;
                dropTarget = null;
                dropTargetContext = null;
                dropTarget2 = null;
                if (this.currentC == null) break block46;
                boolean bl3 = false;
                try {
                    component = this.findComponentAt((Container)this.currentNC, this.currentX, this.currentY);
                }
                catch (ClassCastException classCastException) {
                    component = this.currentNC.locate(this.currentX, this.currentY);
                }
                point = this.translate(this.currentNC, this.currentX, this.currentY, this.currentC);
                bl3 = this.currentC.equals(component);
                if (!bl3 && component != null) {
                    point2 = this.translate(this.currentNC, this.currentX, this.currentY, component);
                    bl2 = component.isShowing() && (dropTarget2 = component.getDropTarget()) != null && dropTarget2.isActive();
                }
                Object object = this.lock;
                synchronized (object) {
                    dropTarget = this.currentC.getDropTarget();
                    if (dropTarget == null) {
                        this.currentDTC.removeNotify();
                        this.currentC = null;
                        this.currentDTC = null;
                        this.currentT = null;
                    } else {
                        if (this.currentDT != dropTarget) {
                            if (this.currentDTC != null) {
                                this.currentDTC.removeNotify();
                            }
                            this.currentDT = dropTarget;
                            this.currentDTC = null;
                        }
                        if ((dropTargetContext = this.currentDT.getDropTargetContext()) != this.currentDTC) {
                            if (this.currentDTC != null) {
                                this.currentDTC.removeNotify();
                            }
                            this.currentDTC = dropTargetContext;
                            this.currentDTC.addNotify(this);
                        }
                        bl = this.currentC.isShowing() && dropTarget.isActive();
                    }
                    if (!bl) break block47;
                }
                if (!bl3) {
                    Object object2;
                    try {
                        try {
                            dropTarget.dragExit(new DropTargetEvent(dropTargetContext));
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            Object var14_17 = null;
                            Object object3 = this.lock;
                            synchronized (object3) {
                                this.currentDTC.removeNotify();
                                this.currentDTC = null;
                                this.currentC = null;
                                this.currentT = null;
                                this.currentDA = 0;
                                break block46;
                            }
                        }
                        Object var14_16 = null;
                        object2 = this.lock;
                    }
                    catch (Throwable throwable) {
                        Object var14_18 = null;
                        Object object4 = this.lock;
                        synchronized (object4) {
                            this.currentDTC.removeNotify();
                            this.currentDTC = null;
                            this.currentC = null;
                            this.currentT = null;
                            this.currentDA = 0;
                            throw throwable;
                        }
                    }
                    synchronized (object2) {
                        this.currentDTC.removeNotify();
                        this.currentDTC = null;
                        this.currentC = null;
                        this.currentT = null;
                        this.currentDA = 0;
                        break block46;
                    }
                } else {
                    try {
                        try {
                            if (this.currentDA == 0) {
                                this.currentDA = this.mapOperation(this.currentDT, this.currentA & this.currentSA);
                            }
                            if (n == 2) {
                                dropTarget.dragOver(new DropTargetDragEvent(dropTargetContext, point, this.currentDA, this.currentSA));
                                return;
                            } else {
                                dropTarget.dropActionChanged(new DropTargetDragEvent(dropTargetContext, point, this.currentDA, this.currentSA));
                            }
                            return;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            Object object5 = this.lock;
                            synchronized (object5) {
                                this.currentDA = 0;
                            }
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        return;
                    }
                }
            }
            Object object = this.lock;
            synchronized (object) {
                this.currentDA = 0;
            }
        }
        if (component == null) {
            try {
                component = this.findComponentAt((Container)this.currentNC, this.currentX, this.currentY);
            }
            catch (ClassCastException classCastException) {
                component = this.currentNC.locate(this.currentX, this.currentY);
            }
            boolean bl = bl2 = component != null && component.isShowing() && (dropTarget2 = component.getDropTarget()) != null && dropTarget2.isActive();
            if (bl2) {
                point2 = this.translate(this.currentNC, this.currentX, this.currentY, component);
            }
        }
        if (!bl2) {
            Object object = this.lock;
            synchronized (object) {
                this.currentC = null;
                this.currentDT = null;
                this.currentDTC = null;
                this.currentDA = 0;
                return;
            }
        }
        Object object = this.lock;
        synchronized (object) {
            this.currentC = component;
            dropTarget = this.currentDT = dropTarget2;
            dropTargetContext = this.currentDTC = dropTarget2.getDropTargetContext();
            this.currentDTC.addNotify(this);
            this.currentA = dropTarget2.getDefaultActions();
        }
        try {
            if (this.currentDA == 0) {
                this.currentDA = this.mapOperation(this.currentDT, this.currentA & this.currentSA);
            }
            dropTarget.dragEnter(new DropTargetDragEvent(dropTargetContext, point2, this.currentDA, this.currentSA));
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Object object6 = this.lock;
            synchronized (object6) {
                this.currentDA = 0;
                return;
            }
        }
    }

    private void handleDropMessage(Component component, int n, int n2, int n3, int n4, long[] lArray, long l) {
        this.nativeDragContext = l;
        this.currentNC = component;
        this.currentT = lArray;
        this.currentX = n;
        this.currentY = n2;
        this.currentSA = n4;
        this.currentDA = n3;
        this.messagePending = 5;
        SunToolkit.executeOnEventHandlerThread(component, this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void processDropMessage() {
        Component component = null;
        Point point = null;
        boolean bl = false;
        DropTarget dropTarget = null;
        try {
            component = this.findComponentAt((Container)this.currentNC, this.currentX, this.currentY);
        }
        catch (ClassCastException classCastException) {
            component = this.currentNC.locate(this.currentX, this.currentY);
        }
        boolean bl2 = bl = component != null && component.isShowing() && (dropTarget = component.getDropTarget()) != null && dropTarget.isActive();
        if (bl) {
            point = this.translate(this.currentNC, this.currentX, this.currentY, component);
        }
        Object object = this.lock;
        // MONITORENTER : object
        this.dropStatus = 1;
        this.dropComplete = false;
        // MONITOREXIT : object
        if (!bl) {
            this.rejectDrop();
            return;
        }
        boolean bl3 = false;
        Object object2 = this.lock;
        // MONITORENTER : object2
        this.currentC = component;
        this.currentDT = dropTarget;
        DropTargetContext dropTargetContext = dropTarget.getDropTargetContext();
        if (this.currentDTC != null) {
            this.currentDTC.removeNotify();
        }
        this.currentDTC = dropTargetContext;
        this.currentDTC.addNotify(this);
        // MONITOREXIT : object2
        Object object3 = _globalLock;
        // MONITORENTER : object3
        this.local = SunDropTargetContextPeer.getJVMLocalSourceTransferable();
        if (this.local != null) {
            SunDropTargetContextPeer.setCurrentJVMLocalSourceTransferable(null);
        }
        // MONITOREXIT : object3
        try {
            try {
                dropTarget.dragExit(new DropTargetEvent(dropTargetContext));
                if (this.currentDA == 0) {
                    this.currentDA = this.mapOperation(this.currentDT, this.currentA & this.currentSA);
                }
                dropTarget.drop(new DropTargetDropEvent(dropTargetContext, point, this.currentDA, this.currentSA, this.local != null));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                bl3 = true;
                Object var12_12 = null;
                Object object4 = this.lock;
                // MONITORENTER : object4
                if (this.dropStatus == 1 || bl3) {
                    this.rejectDrop();
                }
                // MONITOREXIT : object4
                return;
            }
            Object var12_11 = null;
            Object object5 = this.lock;
            // MONITORENTER : object5
            if (this.dropStatus == 1 || bl3) {
                this.rejectDrop();
            }
            // MONITOREXIT : object5
            return;
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            Object object6 = this.lock;
            // MONITORENTER : object6
            if (this.dropStatus == 1 || bl3) {
                this.rejectDrop();
            }
            // MONITOREXIT : object6
            throw throwable;
        }
    }

    public void acceptDrag(int n) {
        Object object = this.lock;
        synchronized (object) {
            if (this.currentDT == null) {
                throw new InvalidDnDOperationException("No Drag pending");
            }
            this.currentDA = this.mapOperation(this.currentDT, n);
        }
    }

    public void rejectDrag() {
        Object object = this.lock;
        synchronized (object) {
            if (this.currentDT == null) {
                throw new InvalidDnDOperationException("No Drag pending");
            }
            this.currentDA = 0;
        }
    }

    public void acceptDrop(int n) {
        if (n == 0) {
            throw new IllegalArgumentException("invalid acceptDrop() action");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.dropStatus != 1) {
                throw new InvalidDnDOperationException("invalid acceptDrop()");
            }
            this.currentDA = this.currentA = this.mapOperation(this.currentDT, n & this.currentSA);
            this.dropStatus = 2;
            this.dropComplete = false;
        }
    }

    public void rejectDrop() {
        Object object = this.lock;
        synchronized (object) {
            if (this.dropStatus != 1) {
                throw new InvalidDnDOperationException("invalid rejectDrop()");
            }
            this.dropStatus = -1;
        }
        this.dropComplete(false);
    }

    private int mapOperation(DropTarget dropTarget, int n) {
        int[] nArray = new int[]{2, 1, 0x40000000};
        int n2 = 0;
        int n3 = 0;
        while (n3 < nArray.length) {
            if ((n & nArray[n3]) == nArray[n3]) {
                n2 = nArray[n3];
                break;
            }
            ++n3;
        }
        return n2;
    }

    public abstract void dropComplete(boolean var1);

    int getDropStatus() {
        Object object = this.lock;
        synchronized (object) {
            int n = this.dropStatus;
            return n;
        }
    }

    private Point translate(Component component, int n, int n2, Component component2) {
        Component component3 = component2;
        int n3 = 0;
        int n4 = 0;
        while (!component3.equals(component)) {
            Point point = component3.getLocation();
            n3 += point.x;
            n4 += point.y;
            component3 = component3.getParent();
        }
        return new Point(n - n3, n2 - n4);
    }

    protected void startSecondaryDispatch() {
        Thread.yield();
    }

    protected void quitSecondaryDispatch() {
    }

    private native Component findComponentAt(Container var1, int var2, int var3);
}

