/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GraphicsDevice;
import java.awt.Image;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.im.spi.InputMethodDescriptor;
import java.awt.peer.RobotPeer;
import java.io.FilePermission;
import java.io.IOException;
import java.net.SocketPermission;
import java.net.URL;
import java.security.Permission;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import java.util.WeakHashMap;
import sun.awt.AppContext;
import sun.awt.DebugHelper;
import sun.awt.GlobalCursorManager;
import sun.awt.PeerEvent;
import sun.awt.PostEventQueue;
import sun.awt.WindowClosingListener;
import sun.awt.WindowClosingSupport;
import sun.awt.font.FontDesignMetrics;
import sun.awt.im.InputContext;
import sun.awt.im.SimpleInputMethodWindow;
import sun.awt.image.ByteArrayImageSource;
import sun.awt.image.FileImageSource;
import sun.awt.image.URLImageSource;
import sun.misc.SoftCache;

public abstract class SunToolkit
extends Toolkit
implements WindowClosingSupport,
WindowClosingListener {
    private static boolean hotjavaUrlCache = false;
    private static final String POST_EVENT_QUEUE_KEY = "PostEventQueue";
    protected static final Hashtable peerMap = new Hashtable();
    private static final Map appContextMap = Collections.synchronizedMap(new WeakHashMap());
    public static FontMetrics[] lastMetrics = new FontMetrics[5];
    static SoftCache imgCache = new SoftCache();
    private transient WindowClosingListener windowClosingListener;

    public SunToolkit() {
        EventQueue eventQueue;
        DebugHelper.init();
        this.windowClosingListener = null;
        String string = Toolkit.getProperty("AWT.EventQueueClass", "java.awt.EventQueue");
        try {
            eventQueue = (EventQueue)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            System.err.println("Failed loading " + string + ": " + exception);
            eventQueue = new EventQueue();
        }
        AppContext appContext = AppContext.getAppContext();
        appContext.put(AppContext.EVENT_QUEUE_KEY, eventQueue);
        PostEventQueue postEventQueue = new PostEventQueue(eventQueue);
        appContext.put(POST_EVENT_QUEUE_KEY, postEventQueue);
    }

    public static AppContext createNewAppContext() {
        EventQueue eventQueue;
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        String string = Toolkit.getProperty("AWT.EventQueueClass", "java.awt.EventQueue");
        try {
            eventQueue = (EventQueue)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            System.err.println("Failed loading " + string + ": " + exception);
            eventQueue = new EventQueue();
        }
        AppContext appContext = new AppContext(threadGroup);
        appContext.put(AppContext.EVENT_QUEUE_KEY, eventQueue);
        PostEventQueue postEventQueue = new PostEventQueue(eventQueue);
        appContext.put(POST_EVENT_QUEUE_KEY, postEventQueue);
        return appContext;
    }

    protected static native Object getPrivateKey(Object var0);

    protected static Object targetToPeer(Object object) {
        if (object != null) {
            return peerMap.get(SunToolkit.getPrivateKey(object));
        }
        return null;
    }

    protected static void targetCreatedPeer(Object object, Object object2) {
        if (object != null && object2 != null) {
            peerMap.put(SunToolkit.getPrivateKey(object), object2);
        }
    }

    protected static void targetDisposedPeer(Object object, Object object2) {
        Object object3;
        if (object != null && object2 != null && peerMap.get(object3 = SunToolkit.getPrivateKey(object)) == object2) {
            peerMap.remove(object3);
        }
    }

    public static AppContext targetToAppContext(Object object) {
        if (object != null) {
            return (AppContext)appContextMap.get(SunToolkit.getPrivateKey(object));
        }
        return null;
    }

    public static void insertTargetMapping(Object object, AppContext appContext) {
        appContextMap.put(SunToolkit.getPrivateKey(object), appContext);
    }

    public static void postEvent(AppContext appContext, AWTEvent aWTEvent) {
        PostEventQueue postEventQueue = (PostEventQueue)appContext.get(POST_EVENT_QUEUE_KEY);
        postEventQueue.postEvent(aWTEvent);
    }

    public void flushPendingEvents() {
        AppContext appContext = AppContext.getAppContext();
        PostEventQueue postEventQueue = (PostEventQueue)appContext.get(POST_EVENT_QUEUE_KEY);
        postEventQueue.flush();
    }

    public static void executeOnEventHandlerThread(Object object, Runnable runnable) {
        SunToolkit.executeOnEventHandlerThread(new PeerEvent(object, runnable, 1L));
    }

    public static void executeOnEventHandlerThread(PeerEvent peerEvent) {
        SunToolkit.postEvent(SunToolkit.targetToAppContext(peerEvent.getSource()), peerEvent);
    }

    public Dimension getScreenSize() {
        return new Dimension(this.getScreenWidth(), this.getScreenHeight());
    }

    protected abstract int getScreenWidth();

    protected abstract int getScreenHeight();

    public FontMetrics getFontMetrics(Font font) {
        FontMetrics fontMetrics;
        int n = 0;
        while (n < lastMetrics.length) {
            fontMetrics = lastMetrics[n];
            if (fontMetrics == null) break;
            if (fontMetrics.getFont() == font) {
                return fontMetrics;
            }
            ++n;
        }
        fontMetrics = new FontDesignMetrics(font);
        System.arraycopy(lastMetrics, 0, lastMetrics, 1, lastMetrics.length - 1);
        SunToolkit.lastMetrics[0] = fontMetrics;
        return fontMetrics;
    }

    public String[] getFontList() {
        String[] stringArray = new String[]{"Dialog", "SansSerif", "Serif", "Monospaced", "DialogInput"};
        return stringArray;
    }

    static synchronized Image getImageFromHash(Toolkit toolkit, URL uRL) {
        Object object;
        block10: {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                try {
                    object = uRL.openConnection().getPermission();
                    if (object == null) break block10;
                    try {
                        securityManager.checkPermission((Permission)object);
                    }
                    catch (SecurityException securityException) {
                        if (object instanceof FilePermission && ((Permission)object).getActions().indexOf("read") != -1) {
                            securityManager.checkRead(((Permission)object).getName());
                            break block10;
                        }
                        if (object instanceof SocketPermission && ((Permission)object).getActions().indexOf("connect") != -1) {
                            securityManager.checkConnect(uRL.getHost(), uRL.getPort());
                            break block10;
                        }
                        throw securityException;
                    }
                }
                catch (IOException iOException) {
                    securityManager.checkConnect(uRL.getHost(), uRL.getPort());
                }
            }
        }
        if ((object = (Image)imgCache.get(uRL)) == null) {
            try {
                object = toolkit.createImage(new URLImageSource(uRL));
                imgCache.put(uRL, object);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return object;
    }

    static synchronized Image getImageFromHash(Toolkit toolkit, String string) {
        Image image;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(string);
        }
        if ((image = (Image)imgCache.get(string)) == null) {
            try {
                image = toolkit.createImage(new FileImageSource(string));
                imgCache.put(string, image);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return image;
    }

    public Image getImage(String string) {
        return SunToolkit.getImageFromHash((Toolkit)this, string);
    }

    public Image getImage(URL uRL) {
        return SunToolkit.getImageFromHash((Toolkit)this, uRL);
    }

    public Image createImage(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(string);
        }
        return this.createImage(new FileImageSource(string));
    }

    public Image createImage(URL uRL) {
        block7: {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                try {
                    Permission permission = uRL.openConnection().getPermission();
                    if (permission == null) break block7;
                    try {
                        securityManager.checkPermission(permission);
                    }
                    catch (SecurityException securityException) {
                        if (permission instanceof FilePermission && permission.getActions().indexOf("read") != -1) {
                            securityManager.checkRead(permission.getName());
                            break block7;
                        }
                        if (permission instanceof SocketPermission && permission.getActions().indexOf("connect") != -1) {
                            securityManager.checkConnect(uRL.getHost(), uRL.getPort());
                            break block7;
                        }
                        throw securityException;
                    }
                }
                catch (IOException iOException) {
                    securityManager.checkConnect(uRL.getHost(), uRL.getPort());
                }
            }
        }
        return this.createImage(new URLImageSource(uRL));
    }

    public Image createImage(byte[] byArray, int n, int n2) {
        return this.createImage(new ByteArrayImageSource(byArray, n, n2));
    }

    protected EventQueue getSystemEventQueueImpl() {
        AppContext appContext = AppContext.getAppContext();
        EventQueue eventQueue = (EventQueue)appContext.get(AppContext.EVENT_QUEUE_KEY);
        return eventQueue;
    }

    public abstract RobotPeer createRobot(Robot var1, GraphicsDevice var2) throws AWTException;

    public static Container getNativeContainer(Component component) {
        return Toolkit.getNativeContainer(component);
    }

    public abstract InputMethodDescriptor getInputMethodAdapterDescriptor() throws AWTException;

    public Window createInputMethodWindow(String string, InputContext inputContext) {
        return new SimpleInputMethodWindow(string, inputContext, false);
    }

    public boolean enableInputMethodsForTextComponent() {
        return false;
    }

    public Component getComponentFromNativeWindowHandle(int n) {
        return null;
    }

    public int getNativeWindowHandleFromComponent(Component component) {
        return 0;
    }

    public abstract String getDefaultUnicodeEncoding();

    public WindowClosingListener getWindowClosingListener() {
        return this.windowClosingListener;
    }

    public void setWindowClosingListener(WindowClosingListener windowClosingListener) {
        this.windowClosingListener = windowClosingListener;
    }

    public RuntimeException windowClosingNotify(WindowEvent windowEvent) {
        if (this.windowClosingListener != null) {
            return this.windowClosingListener.windowClosingNotify(windowEvent);
        }
        return null;
    }

    public RuntimeException windowClosingDelivered(WindowEvent windowEvent) {
        if (this.windowClosingListener != null) {
            return this.windowClosingListener.windowClosingDelivered(windowEvent);
        }
        return null;
    }

    public abstract GlobalCursorManager getGlobalCursorManager();
}

