/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.WritableRaster;
import sun.awt.OS2GraphicsDevice;

public class OS2GraphicsConfig
extends GraphicsConfiguration {
    OS2GraphicsDevice screen;
    int visual;
    ColorModel colorModel;

    private static native void initIDs();

    public static OS2GraphicsConfig getConfig(OS2GraphicsDevice oS2GraphicsDevice, int n) {
        return new OS2GraphicsConfig(oS2GraphicsDevice, n);
    }

    public OS2GraphicsConfig(GraphicsDevice graphicsDevice, int n) {
        this.screen = (OS2GraphicsDevice)graphicsDevice;
        this.visual = n;
    }

    public GraphicsDevice getDevice() {
        return this.screen;
    }

    public int getVisual() {
        return this.visual;
    }

    public BufferedImage createCompatibleImage(int n, int n2) {
        ColorModel colorModel = this.getColorModel();
        WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(n, n2);
        return new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), null);
    }

    public BufferedImage createCompatibleImage(int n, int n2, int n3) {
        switch (n3) {
            case 1: {
                return this.createCompatibleImage(n, n2);
            }
            case 2: 
            case 3: {
                ColorModel colorModel = this.getColorModel(n3);
                WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(n, n2);
                return new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), null);
            }
        }
        throw new IllegalArgumentException("Unknown transparency type " + n3);
    }

    public synchronized ColorModel getColorModel() {
        if (this.colorModel == null) {
            this.colorModel = this.makeColorModel(this.screen.getScreen());
        }
        return this.colorModel;
    }

    private native ColorModel makeColorModel(int var1);

    public ColorModel getColorModel(int n) {
        if (n == 1) {
            return this.getColorModel();
        }
        if (n == 2) {
            return new DirectColorModel(25, 0xFF0000, 65280, 255, 0x1000000);
        }
        if (n == 3) {
            return ColorModel.getRGBdefault();
        }
        return null;
    }

    public AffineTransform getDefaultTransform() {
        return new AffineTransform();
    }

    public AffineTransform getNormalizingTransform() {
        double d = this.getXResolution() / 72.0;
        double d2 = this.getYResolution() / 72.0;
        return new AffineTransform(d, 0.0, 0.0, d2, 0.0, 0.0);
    }

    private double getXResolution() {
        return 72.0;
    }

    private double getYResolution() {
        return 72.0;
    }

    public String toString() {
        return "OS2GraphicsConfig[dev=" + this.screen + ",pixfmt=" + this.visual + "]";
    }

    private native Rectangle getBounds(int var1);

    public Rectangle getBounds() {
        return this.getBounds(this.screen.getScreen());
    }

    static {
        OS2GraphicsConfig.initIDs();
    }
}

