/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import com.ibm.jvm.io.LocalizedInputStream;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import sun.io.CharacterEncoding;
import sun.java2d.loops.RasterOutputManager;

public class FontProperties
extends Properties {
    protected static String osVersion;
    private static boolean usesPlatformFont;

    public FontProperties(String string) {
        super(FontProperties.getDefaultFontProperties());
        osVersion = string;
        this.initializeProperties();
    }

    private void initializeProperties() {
        Object object;
        try {
            usesPlatformFont = RasterOutputManager.usesPlatformFont();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string = System.getProperty("user.home");
        String string2 = System.getProperty("java.home");
        if (string2 == null) {
            throw new Error("java.home property not set");
        }
        String string3 = System.getProperty("user.language", "en");
        string3 = string3.toLowerCase();
        String string4 = System.getProperty("user.region");
        String string5 = System.getProperty("file.encoding");
        String string6 = CharacterEncoding.aliasName(string5);
        if (string6 == null) {
            string6 = string5;
        }
        if (osVersion == null) {
            osVersion = System.getProperty("os.version");
        }
        String string7 = usesPlatformFont ? "native" + File.separator : "";
        String string8 = string2 + File.separator + "lib" + File.separator + string7 + "fprop.dir";
        File file = new File(string8);
        Properties properties = null;
        if (file.exists()) {
            properties = new Properties();
            try {
                object = new BufferedInputStream(LocalizedInputStream.localize(new FileInputStream(file.getPath())));
                properties.load((InputStream)object);
                ((InputStream)object).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            object = null;
            object = this.tryOpeningFontProp((File)object, properties, string2, string3, string4, string6, osVersion);
            object = this.tryOpeningFontProp((File)object, properties, string2, string3, string4, string6, null);
            object = this.tryOpeningFontProp((File)object, properties, string2, string3, string4, null, osVersion);
            object = this.tryOpeningFontProp((File)object, properties, string2, string3, null, string6, osVersion);
            object = this.tryOpeningFontProp((File)object, properties, string2, string3, string4, null, null);
            object = this.tryOpeningFontProp((File)object, properties, string2, null, string4, null, null);
            object = this.tryOpeningFontProp((File)object, properties, string2, string3, null, string6, null);
            object = this.tryOpeningFontProp((File)object, properties, string2, string3, null, null, osVersion);
            object = this.tryOpeningFontProp((File)object, properties, string2, null, null, string6, osVersion);
            object = this.tryOpeningFontProp((File)object, properties, string2, string3, null, null, null);
            object = this.tryOpeningFontProp((File)object, properties, string2, null, null, string6, null);
            object = this.tryOpeningFontProp((File)object, properties, string2, null, null, null, osVersion);
            object = this.tryOpeningFontProp((File)object, properties, string2, null, null, null, null);
            if (object != null) {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(LocalizedInputStream.localize(new FileInputStream(((File)object).getPath())));
                this.load(bufferedInputStream);
                ((InputStream)bufferedInputStream).close();
                this.verifyProperties((File)object);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private File tryOpeningFontProp(File file, Properties properties, String string, String string2, String string3, String string4, String string5) {
        if (file != null) {
            return file;
        }
        String string6 = usesPlatformFont ? "native" + File.separator : "";
        String string7 = "font.properties";
        String string8 = null;
        string8 = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("ibm.jvm.fontproperties.dir");
            }
        });
        String string9 = string8 != null ? string8 + File.separator : string + File.separator + "lib" + File.separator + string6;
        string7 = this.getPropsFilename(string7, string2, string3, string4, string5);
        if (properties != null) {
            string7 = properties.getProperty(string7);
        }
        if (string7 != null && (file = new File(string9 + string7)).canRead()) {
            return file;
        }
        return null;
    }

    protected void verifyProperties(File file) {
    }

    private static Properties getDefaultFontProperties() {
        Properties properties = new Properties();
        properties.put("serif.0", "unknown");
        properties.put("sansserif.0", "unknown");
        properties.put("monospaced.0", "unknown");
        properties.put("dialog.0", "unknown");
        properties.put("dialoginput.0", "unknown");
        properties.put("default.0", "sansserif");
        properties.put("timesroman.0", "serif");
        properties.put("helvetica.0", "sansserif");
        properties.put("courier.0", "monospaced");
        properties.put("zapfdingbats.0", "unknown");
        return properties;
    }

    private String getPropsFilename(String string, String string2, String string3, String string4, String string5) {
        if (string2 != null) {
            string = string + "." + string2;
            if (string3 != null) {
                string = string + "_" + string3;
                if (string4 != null) {
                    string = string + "_" + string4;
                    if (string5 != null) {
                        string = string + "." + string5;
                    }
                } else if (string5 != null) {
                    string = string + "." + string5;
                }
            } else if (string4 != null) {
                string = string + "_" + string4;
                if (string5 != null) {
                    string = string + "." + string5;
                }
            } else if (string5 != null) {
                string = string + "." + string5;
            }
        } else {
            if (string3 != null) {
                string = string + "." + string3;
            }
            if (string4 != null) {
                string = string + "." + string4;
                if (string5 != null) {
                    string = string + "." + string5;
                }
            } else if (string5 != null) {
                string = string + "." + string5;
            }
        }
        return string;
    }

    static {
        usesPlatformFont = false;
    }
}

